/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.enums.c_jba;
import com.inscada.mono.communication.base.enums.c_tba;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.expression.model.Expression;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Objects;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Where;

@Entity
@Table(name="variable")
@Inheritance(strategy=InheritanceType.JOINED)
@AttributeOverride(name="id", column=@Column(name="variable_id"))
@Where(clause="project_id is null")
@CheckAtLeastOneNotNull(fieldNames={"frameId", "frame"})
public class VariableTemplate<TFrameTemplate extends FrameTemplate<?, ?>, TDeviceTemplate extends DeviceTemplate<?>>
extends SpaceBaseModel {
    @Size(max=4000)
    @Column(name="value_expression")
    protected String valueExpressionCode;
    @Size(max=255)
    protected String dsc;
    @NotNull
    @Column(name="pulse_off_flag")
    protected Boolean isPulseOff;
    @Column(name="eng_full_scale")
    protected Double engFullScale;
    @Column(name="raw_zero_scale")
    protected Double rawZeroScale;
    @Column(name="fractional_digit_count")
    protected Short fractionalDigitCount;
    @Min(value=1L)
    @Column(name="log_period")
    protected Integer logPeriod;
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @Column(name="raw_full_scale")
    protected Double rawFullScale;
    @JsonIgnore
    @ManyToOne(optional=false, targetEntity=FrameTemplate.class)
    @JoinColumn(name="frame_id")
    protected TFrameTemplate frame;
    protected String unit;
    @Column(name="value_expression_id", insertable=false, updatable=false)
    protected Integer valueExpressionId;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="log_expression_id")
    protected Expression logExpression;
    @Column(name="frame_id", insertable=false, updatable=false)
    protected Integer frameId;
    @PositiveOrZero
    @Column(name="pulse_on_duration")
    protected Integer pulseOnDuration;
    @Id
    @Column(name="variable_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="variableTemplateSeq")
    @GenericGenerator(name="variableTemplateSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="variable_seq"), @Parameter(name="increment_size", value="100")})
    protected Integer id;
    @Column(name="log_threshold")
    protected Double logThreshold;
    @Size(max=20)
    protected String code;
    @NotNull
    @Column(name="keep_last_values")
    protected Boolean keepLastValues;
    @Column(name="log_max_value")
    protected Double logMaxValue;
    @Column(name="log_min_value")
    protected Double logMinValue;
    @Column(name="eng_zero_scale")
    protected Double engZeroScale;
    @Column(name="log_type")
    protected c_jba logType;
    @Column(name="log_expression_id", insertable=false, updatable=false)
    protected Integer logExpressionId;
    @Column(name="set_min_value")
    protected Double setMinValue;
    @Column(name="value_expression_type")
    protected c_tba valueExpressionType;
    @Size(max=4000)
    @Column(name="log_expression")
    protected String logExpressionCode;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="value_expression_id")
    protected Expression valueExpression;
    @NotBlank
    @Size(max=100)
    protected String name;
    @NotNull
    @Column(name="pulse_on_flag")
    protected Boolean isPulseOn;
    @Column(name="set_max_value")
    protected Double setMaxValue;
    @PositiveOrZero
    @Column(name="pulse_off_duration")
    protected Integer pulseOffDuration;

    public void setId(Integer a) {
        a.id = a;
    }

    public Integer getLogPeriod() {
        VariableTemplate a;
        return a.logPeriod;
    }

    public void setIsActive(Boolean a) {
        a.isActive = a;
    }

    public void setKeepLastValues(Boolean a) {
        a.keepLastValues = a;
    }

    public void setLogThreshold(Double a) {
        a.logThreshold = a;
    }

    public boolean equals(Object a) {
        VariableTemplate a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof VariableTemplate)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (VariableTemplate)a;
        return a2.getFrameId().equals(a.getFrameId()) && a2.getName().equals(a.getName());
    }

    public void setRawFullScale(Double a) {
        a.rawFullScale = a;
    }

    public void setEngZeroScale(Double a) {
        a.engZeroScale = a;
    }

    public void setIsPulseOff(Boolean a) {
        a.isPulseOff = a;
    }

    public void setIsPulseOn(Boolean a) {
        a.isPulseOn = a;
    }

    public void setLogMinValue(Double a) {
        a.logMinValue = a;
    }

    public Expression getValueExpression() {
        VariableTemplate a;
        return a.valueExpression;
    }

    public void setLogMaxValue(Double a) {
        a.logMaxValue = a;
    }

    public void setFractionalDigitCount(Short a) {
        a.fractionalDigitCount = a;
    }

    public void setCode(String a) {
        a.code = a;
    }

    public Integer getId() {
        VariableTemplate a;
        return a.id;
    }

    public void setValueExpressionId(Integer a) {
        a.valueExpressionId = a;
    }

    @JsonIgnore
    public TDeviceTemplate getDevice() {
        VariableTemplate a;
        return (TDeviceTemplate)a.frame.getDevice();
    }

    public void setLogType(c_jba a) {
        a.logType = a;
    }

    public Integer getPulseOffDuration() {
        VariableTemplate a;
        return a.pulseOffDuration;
    }

    public String getLogExpressionCode() {
        VariableTemplate a;
        return a.logExpressionCode;
    }

    public Integer getPulseOnDuration() {
        VariableTemplate a;
        return a.pulseOnDuration;
    }

    public void setLogPeriod(Integer a) {
        a.logPeriod = a;
    }

    public Double getLogThreshold() {
        VariableTemplate a;
        return a.logThreshold;
    }

    public Expression getLogExpression() {
        VariableTemplate a;
        return a.logExpression;
    }

    public VariableTemplate() {
        VariableTemplate a;
    }

    public TFrameTemplate getFrame() {
        VariableTemplate a;
        return (TFrameTemplate)a.frame;
    }

    public String getValueExpressionCode() {
        VariableTemplate a;
        return a.valueExpressionCode;
    }

    public String getUnit() {
        VariableTemplate a;
        return a.unit;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setSetMinValue(Double a) {
        a.setMinValue = a;
    }

    public Short getFractionalDigitCount() {
        VariableTemplate a;
        return a.fractionalDigitCount;
    }

    public Boolean getIsPulseOff() {
        VariableTemplate a;
        return a.isPulseOff;
    }

    public void setUnit(String a) {
        a.unit = a;
    }

    public Integer getDeviceId() {
        VariableTemplate a;
        return a.frame.getDeviceId();
    }

    public void setEngFullScale(Double a) {
        a.engFullScale = a;
    }

    public Boolean getKeepLastValues() {
        VariableTemplate a;
        return a.keepLastValues;
    }

    public c_jba getLogType() {
        VariableTemplate a;
        return a.logType;
    }

    public void setValueExpressionType(c_tba a) {
        a.valueExpressionType = a;
    }

    public void setPulseOnDuration(Integer a) {
        a.pulseOnDuration = a;
    }

    public c_tba getValueExpressionType() {
        VariableTemplate a;
        return a.valueExpressionType;
    }

    public Double getEngZeroScale() {
        VariableTemplate a;
        return a.engZeroScale;
    }

    public Boolean getIsPulseOn() {
        VariableTemplate a;
        return a.isPulseOn;
    }

    public void setValueExpressionCode(String a) {
        a.valueExpressionCode = a;
    }

    public Double getSetMinValue() {
        VariableTemplate a;
        return a.setMinValue;
    }

    public String getDsc() {
        VariableTemplate a;
        return a.dsc;
    }

    public String getName() {
        VariableTemplate a;
        return a.name;
    }

    public void setLogExpression(Expression a) {
        a.logExpression = a;
    }

    public void setLogExpressionCode(String a) {
        a.logExpressionCode = a;
    }

    public Integer getFrameId() {
        VariableTemplate a;
        return a.frameId;
    }

    public String getCode() {
        VariableTemplate a;
        return a.code;
    }

    public Integer getLogExpressionId() {
        VariableTemplate a;
        return a.logExpressionId;
    }

    public Double getLogMinValue() {
        VariableTemplate a;
        return a.logMinValue;
    }

    public Double getSetMaxValue() {
        VariableTemplate a;
        return a.setMaxValue;
    }

    public void setFrame(TFrameTemplate a) {
        VariableTemplate a2;
        VariableTemplate variableTemplate = a2;
        variableTemplate.frame = a;
        variableTemplate.frameId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setLogExpressionId(Integer a) {
        a.logExpressionId = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public Double getEngFullScale() {
        VariableTemplate a;
        return a.engFullScale;
    }

    public void setPulseOffDuration(Integer a) {
        a.pulseOffDuration = a;
    }

    public void setFrameId(Integer a) {
        a.frameId = a;
    }

    public Double getRawZeroScale() {
        VariableTemplate a;
        return a.rawZeroScale;
    }

    public Double getRawFullScale() {
        VariableTemplate a;
        return a.rawFullScale;
    }

    public Double getLogMaxValue() {
        VariableTemplate a;
        return a.logMaxValue;
    }

    public void setRawZeroScale(Double a) {
        a.rawZeroScale = a;
    }

    public int hashCode() {
        VariableTemplate a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getFrameId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setSetMaxValue(Double a) {
        a.setMaxValue = a;
    }

    public void setValueExpression(Expression a) {
        a.valueExpression = a;
    }

    public Integer getValueExpressionId() {
        VariableTemplate a;
        return a.valueExpressionId;
    }

    public Boolean getIsActive() {
        VariableTemplate a;
        return a.isActive;
    }
}

