/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.inscada.mono.communication.base.enums.c_uia;
import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.model.VariableIdentity;
import com.inscada.mono.communication.base.model.VariableJson;
import com.inscada.mono.communication.base.repositories.VariableRepository;
import com.inscada.mono.communication.base.services.c_jg;
import com.inscada.mono.communication.base.services.c_kla;
import com.inscada.mono.communication.protocols.dnp3.j.c_eha;
import com.inscada.mono.communication.protocols.dnp3.model.Dnp3Variable;
import com.inscada.mono.communication.protocols.ethernet_ip.j.c_jea;
import com.inscada.mono.communication.protocols.ethernet_ip.model.EthernetIpVariable;
import com.inscada.mono.communication.protocols.fatek.j.c_eda;
import com.inscada.mono.communication.protocols.fatek.model.FatekVariable;
import com.inscada.mono.communication.protocols.iec104.j.c_ju;
import com.inscada.mono.communication.protocols.iec104.model.Iec104Variable;
import com.inscada.mono.communication.protocols.iec61850.j.c_vt;
import com.inscada.mono.communication.protocols.iec61850.model.Iec61850Variable;
import com.inscada.mono.communication.protocols.local.j.c_iz;
import com.inscada.mono.communication.protocols.local.model.LocalVariable;
import com.inscada.mono.communication.protocols.modbus.j.c_yt;
import com.inscada.mono.communication.protocols.modbus.model.ModbusVariable;
import com.inscada.mono.communication.protocols.mqtt.j.c_vz;
import com.inscada.mono.communication.protocols.mqtt.model.MqttVariable;
import com.inscada.mono.communication.protocols.opcda.j.c_vs;
import com.inscada.mono.communication.protocols.opcda.model.OpcDaVariable;
import com.inscada.mono.communication.protocols.opcua.j.c_uu;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaVariable;
import com.inscada.mono.communication.protocols.s7.j.c_dj;
import com.inscada.mono.communication.protocols.s7.model.S7Variable;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.c.c_qc;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_mc;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@EnableSpaceFilter
public class c_oca {
    private final List<c_jg<?, ?, ?, ?>> H;
    private final c_kla m;
    private final VariableRepository<Variable<?, ?, ?>> E;
    private final ObjectMapper K;
    private final ApplicationEventPublisher l;

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<VariableIdentity> m_otb() {
        c_oca a;
        return a.E.findAllIdentities();
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_uc(List<Integer> a2) {
        c_oca a3;
        c_oca c_oca2 = a3;
        a2 = c_oca2.m_owa(a2);
        c_oca2.E.deleteInBatch(a2);
        a2.stream().map(Variable::getConnection).distinct().forEach(a -> {
            c_oca a2;
            a2.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_xsb(VariableFilter a2) {
        c_oca a3;
        c_oca c_oca2 = a3;
        c_oca2.E.deleteAllByFilter(a2);
        c_oca2.m.m_ra(a2.getProjectId()).forEach(a -> {
            c_oca a2;
            a2.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Variable<?, ?, ?> m_ha(Integer a, String a2) {
        c_oca a3;
        return a3.E.findOneByProjectIdAndName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<Variable<?, ?, ?>> m_sra(Integer a, String a2, String a3, String a4) {
        c_oca a5;
        if ((a = a5.E.findVariablesByFrameName((Integer)a, a2, a3, a4)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<Variable<?, ?, ?>> m_sna(Integer a, Pageable a2) {
        c_oca a3;
        return a3.E.findByProjectId(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Variable<?, ?, ?> m_la(Integer a) {
        c_oca a2;
        return a2.E.findById((Object)a).orElse(null);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Variable<?, ?, ?> m_yb(Integer a) {
        c_oca a2;
        Variable variable = a2.m_la(a);
        if (variable == null) {
            throw new c_ac("Variable not found with id of " + a);
        }
        return variable;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public VariableIdentity m_qrb(Integer a, String a2) {
        c_oca a3;
        return a3.E.findIdentityByProjectIdAndName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<Variable<?, ?, ?>> m_vua(VariableFilter a, Pageable a2) {
        c_oca a3;
        return a3.E.findVariablesByFilter(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Variable<?, ?, ?> m_vva(Integer a, String a2) {
        c_oca a3;
        Variable variable = a3.m_ha(a, a2);
        if (variable == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_ac(String.format(c_qc.m_rl((Object)"9\u0006\u001d\u000e\u000e\u0005\u0003\u0002O\t\u0000\u0013O\u0001\u0000\u0012\u0001\u0003UG\u001f\u0015\u0000\r\n\u0004\u001bG\u0006\u0003UGJ\u0003CG\u0001\u0006\u0002\u0002UGJ\u0014"), objectArray));
        }
        return variable;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Map<String, Variable<?, ?, ?>> m_of(Integer a2, Set<String> a3) {
        c_oca a4;
        return a4.E.findByProjectIdAndNameIn(a2, (String[])a3.toArray(String[]::new)).stream().collect(Collectors.toMap(Variable::getName, a -> a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<Variable<?, ?, ?>> m_hwa(Integer a) {
        c_oca a2;
        if ((a = a2.E.findByFrameId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<Variable<?, ?, ?>> m_ra(Integer a) {
        c_oca a2;
        if ((a = a2.E.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<Variable<?, ?, ?>> m_owa(List<Integer> a) {
        c_oca a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyList();
        }
        return a2.E.findAllById(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<Variable<?, ?, ?>> m_vra(Integer a, String[] a2) {
        c_oca a3;
        if (a2 == null || a2.length == 0) {
            return Collections.emptyList();
        }
        if ((a = a3.E.findByProjectIdAndNameIn((Integer)a, a2)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    public c_oca(VariableRepository<Variable<?, ?, ?>> a, c_kla a2, ApplicationEventPublisher a3, List<c_jg<?, ?, ?, ?>> a4, ObjectMapper a5) {
        c_oca a6;
        c_oca c_oca2 = a6;
        c_oca c_oca3 = a6;
        a6.E = a;
        c_oca3.m = a2;
        c_oca3.l = a3;
        c_oca2.H = a4;
        c_oca2.K = a5;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<Variable<?, ?, ?>> m_unb(Integer a, String a2) {
        c_oca a3;
        if ((a = a3.E.findVariablesByConnectionName((Integer)a, a2)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @DisableSpaceFilter
    public long m_ekb() {
        c_oca a;
        return a.E.ioCount();
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<String> m_gjb(Integer a) {
        c_oca a2;
        return a2.E.findLoggedVariableNames(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<Variable<?, ?, ?>> m_ta() {
        c_oca a;
        return a.E.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<VariableIdentity> m_fkb(Integer a, String[] a2) {
        c_oca a3;
        if (a2 == null || a2.length == 0) {
            return Collections.emptyList();
        }
        if ((a = a3.E.findIdentitiesByProjectIdAndNameIn((Integer)a, a2)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<Variable<?, ?, ?>> m_ymb(Integer a, String a2, String a3) {
        c_oca a4;
        if ((a = a4.E.findVariablesByDeviceName((Integer)a, a2, a3)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<VariableJson> m_vrb(VariableFilter a, Pageable a2) {
        c_oca a3;
        return a3.E.findVariablesByFilterAndStartAddressSort(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<Variable<?, ?, ?>> m_qga(Pageable a) {
        c_oca a2;
        return a2.E.findAll(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_ma(Integer a) {
        c_oca a2;
        if ((a = a2.m_la(a)) != null) {
            if (a.getSourceVariableDataTransferDetails() != null && !a.getSourceVariableDataTransferDetails().isEmpty()) {
                throw new c_mc(ExceptionDetails.m_rl((Object)"U\u0018q\u0010b\u001bo\u001c#\u001df\u0015f\rj\u0016mYe\u0018j\u0015f\u001d-YG\u0018w\u0018#\rq\u0018m\ne\u001cqYg\u001cw\u0018j\u0015#\u001c{\u0010p\rp"));
            }
            if (a.getTargetVariableDataTransferDetails() != null && !a.getTargetVariableDataTransferDetails().isEmpty()) {
                throw new c_mc(c_qc.m_rl((Object)"1\u000e\u0015\u0006\u0006\r\u000b\nG\u000b\u0002\u0003\u0002\u001b\u000e\u0000\tO\u0001\u000e\u000e\u0003\u0002\u000bIO#\u000e\u0013\u000eG\u001b\u0015\u000e\t\u001c\u0001\n\u0015O\u0003\n\u0013\u000e\u000e\u0003G\n\u001f\u0006\u0014\u001b\u0014"));
            }
            c_oca c_oca2 = a2;
            c_oca2.E.delete((Object)a);
            c_oca2.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a.getConnection()));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<VariableIdentity> m_hob(Integer a) {
        c_oca a2;
        if ((a = a2.E.findIdentitiesByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<VariableIdentity> m_qib(Integer a) {
        c_oca a2;
        if ((a = a2.E.findIdentitiesByFrameId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    public long m_qma() {
        c_oca a;
        return a.E.count();
    }

    public static String m_rl(Object a) {
        a = (String)a;
        int n = ((String)a).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 5 << 4 ^ 5 << 1;
        int cfr_ignored_0 = (3 ^ 5) << 3 ^ (3 ^ 5);
        int n4 = n2;
        int n5 = 1 << 3 ^ (3 ^ 5);
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_VARIABLE')")
    public void m_etb(Integer a2, String a3, Map<String, Object> a4) {
        c_oca a5;
        if ((a3 = (a2 = a5.m_vva(a2, a3)).getConnection().getProtocol()).equals((Object)c_uia.m)) {
            S7Variable s7Variable = (S7Variable)a5.K.convertValue(a4, S7Variable.class);
            BeanUtils.copyProperties((Object)a2, (Object)s7Variable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg2 = a5.H.stream().filter(a -> a instanceof c_dj).findAny().orElseThrow();
            ((c_dj)c_jg2).m_ova(a2.getId(), (Variable)s7Variable);
            return;
        }
        if (a3.equals((Object)c_uia.h)) {
            EthernetIpVariable ethernetIpVariable = (EthernetIpVariable)a5.K.convertValue(a4, EthernetIpVariable.class);
            BeanUtils.copyProperties((Object)a2, (Object)ethernetIpVariable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg3 = a5.H.stream().filter(a -> a instanceof c_jea).findAny().orElseThrow();
            ((c_jea)c_jg3).m_ova(a2.getId(), (Variable)ethernetIpVariable);
            return;
        }
        if (a3.m_f().contains(ExceptionDetails.m_rl((Object)"J<@Y5I;N3T6T2I7"))) {
            Iec104Variable iec104Variable = (Iec104Variable)a5.K.convertValue(a4, Iec104Variable.class);
            BeanUtils.copyProperties((Object)a2, (Object)iec104Variable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg4 = a5.H.stream().filter(a -> a instanceof c_ju).findAny().orElseThrow();
            ((c_ju)c_jg4).m_ova(a2.getId(), (Variable)iec104Variable);
            return;
        }
        if (a3.equals((Object)c_uia.j)) {
            LocalVariable localVariable = (LocalVariable)a5.K.convertValue(a4, LocalVariable.class);
            BeanUtils.copyProperties((Object)a2, (Object)localVariable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg5 = a5.H.stream().filter(a -> a instanceof c_iz).findAny().orElseThrow();
            ((c_iz)c_jg5).m_ova(a2.getId(), (Variable)localVariable);
            return;
        }
        if (a3.equals((Object)c_uia.l)) {
            MqttVariable mqttVariable = (MqttVariable)a5.K.convertValue(a4, MqttVariable.class);
            BeanUtils.copyProperties((Object)a2, (Object)mqttVariable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg6 = a5.H.stream().filter(a -> a instanceof c_vz).findAny().orElseThrow();
            ((c_vz)c_jg6).m_ova(a2.getId(), (Variable)mqttVariable);
            return;
        }
        if (a3.equals((Object)c_uia.C)) {
            OpcDaVariable opcDaVariable = (OpcDaVariable)a5.K.convertValue(a4, OpcDaVariable.class);
            BeanUtils.copyProperties((Object)a2, (Object)opcDaVariable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg7 = a5.H.stream().filter(a -> a instanceof c_vs).findAny().orElseThrow();
            ((c_vs)c_jg7).m_ova(a2.getId(), (Variable)opcDaVariable);
            return;
        }
        if (a3.equals((Object)c_uia.I)) {
            OpcUaVariable opcUaVariable = (OpcUaVariable)a5.K.convertValue(a4, OpcUaVariable.class);
            BeanUtils.copyProperties((Object)a2, (Object)opcUaVariable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg8 = a5.H.stream().filter(a -> a instanceof c_uu).findAny().orElseThrow();
            ((c_uu)c_jg8).m_ova(a2.getId(), (Variable)opcUaVariable);
            return;
        }
        if (a3.m_f().contains(c_qc.m_rl((Object)"\"\b\u000b\u0005\u001a\u0014"))) {
            ModbusVariable modbusVariable = (ModbusVariable)a5.K.convertValue(a4, ModbusVariable.class);
            BeanUtils.copyProperties((Object)a2, (Object)modbusVariable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg9 = a5.H.stream().filter(a -> a instanceof c_yt).findAny().orElseThrow();
            ((c_yt)c_jg9).m_ova(a2.getId(), (Variable)modbusVariable);
            return;
        }
        if (a3.m_f().contains(ExceptionDetails.m_rl((Object)"=M)0"))) {
            Dnp3Variable dnp3Variable = (Dnp3Variable)a5.K.convertValue(a4, Dnp3Variable.class);
            BeanUtils.copyProperties((Object)a2, (Object)dnp3Variable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg10 = a5.H.stream().filter(a -> a instanceof c_eha).findAny().orElseThrow();
            ((c_eha)c_jg10).m_ova(a2.getId(), (Variable)dnp3Variable);
            return;
        }
        if (a3.m_f().contains(c_qc.m_rl((Object)"!\u000e\u0013\n\f"))) {
            FatekVariable fatekVariable = (FatekVariable)a5.K.convertValue(a4, FatekVariable.class);
            BeanUtils.copyProperties((Object)a2, (Object)fatekVariable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg11 = a5.H.stream().filter(a -> a instanceof c_eda).findAny().orElseThrow();
            ((c_eda)c_jg11).m_ova(a2.getId(), (Variable)fatekVariable);
            return;
        }
        if (a3.m_f().contains(ExceptionDetails.m_rl((Object)"J<@Y5H;L3"))) {
            Iec61850Variable iec61850Variable = (Iec61850Variable)a5.K.convertValue(a4, Iec61850Variable.class);
            BeanUtils.copyProperties((Object)a2, (Object)iec61850Variable, (String[])((String[])a4.keySet().toArray(String[]::new)));
            c_jg c_jg12 = a5.H.stream().filter(a -> a instanceof c_vt).findAny().orElseThrow();
            ((c_vt)c_jg12).m_ova(a2.getId(), (Variable)iec61850Variable);
        }
    }
}

