/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.model.AuthToken;
import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.repositories.VariableRepository;
import com.inscada.mono.communication.base.services.c_pg;
import com.inscada.mono.expression.j.c_ai;
import com.inscada.mono.log.model.LogEntryDto;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_lf;
import com.inscada.mono.shared.exceptions.c_mc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@EnableSpaceFilter
public abstract class c_jg<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>> {
    protected final c_pg<TConnection, TDevice, TFrame> D;
    protected final c_ai H;
    protected final c_tm m;
    protected static final String[] E;
    protected final VariableRepository<TVariable> K;
    protected final ApplicationEventPublisher l;

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_yb(Integer a) {
        c_jg a2;
        Variable variable = a2.m_la(a);
        if (variable == null) {
            throw new c_ac("Variable not found with id of " + a);
        }
        return (TVariable)variable;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_vra(Integer a, String[] a2) {
        c_jg a3;
        if (a2 == null || a2.length == 0) {
            return Collections.emptyList();
        }
        if ((a = a3.K.findByProjectIdAndNameIn((Integer)a, a2)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    public c_jg(c_tm a, c_pg<TConnection, TDevice, TFrame> a2, c_ai a3, VariableRepository<TVariable> a4, ApplicationEventPublisher a5) {
        c_jg a6;
        c_jg c_jg2 = a6;
        c_jg c_jg3 = a6;
        a6.m = a;
        c_jg3.D = a2;
        c_jg3.H = a3;
        c_jg2.K = a4;
        c_jg2.l = a5;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_la(Integer a) {
        c_jg a2;
        return (TVariable)((Variable)a2.K.findById((Object)a).orElse(null));
    }

    public Long m_qma() {
        c_jg a;
        return a.K.count();
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_vua(VariableFilter a, Pageable a2) {
        c_jg a3;
        return a3.K.findVariablesByFilter(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_VARIABLE')")
    public void m_ova(Integer a, TVariable a2) {
        c_jg a3;
        c_jg c_jg2 = a3;
        a = c_jg2.m_yb(a);
        c_jg2.m_nta(a2, (Variable)a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_hwa(Integer a) {
        c_jg a2;
        if ((a = a2.K.findByFrameId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_ma(Integer a) {
        c_jg a2;
        if ((a = a2.m_la(a)) != null) {
            if (a.getSourceVariableDataTransferDetails() != null && !a.getSourceVariableDataTransferDetails().isEmpty()) {
                throw new c_mc(AuthToken.m_rl((Object)"~\u0018Z\u0010I\u001bD\u001c\b\u001dM\u0015M\rA\u0016FYN\u0018A\u0015M\u001d\u0006Yl\u0018\\\u0018\b\rZ\u0018F\nN\u001cZYL\u001c\\\u0018A\u0015\b\u001cP\u0010[\r["));
            }
            if (a.getTargetVariableDataTransferDetails() != null && !a.getTargetVariableDataTransferDetails().isEmpty()) {
                throw new c_mc(LogEntryDto.m_rl((Object)"sbWjDaIf\u0005g@o@wLlK#CbLo@g\u000b#abQb\u0005wWbKpCfW#AfQbLo\u0005f]jVwV"));
            }
            c_jg c_jg2 = a2;
            c_jg2.K.delete((Object)a);
            c_jg2.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a.getConnection()));
        }
    }

    private /* synthetic */ void m_nta(TVariable a, TVariable a2, boolean a3) {
        c_jg a4;
        TVariable TVariable = a2;
        c_jg c_jg2 = a4;
        c_jg2.m_zta(a);
        Connection connection = TVariable.getConnection();
        BeanUtils.copyProperties(a, a2, (String[])E);
        c_jg2.m_ina(TVariable);
        a = a2.getConnection();
        if (a3) {
            a4.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a4, connection));
            if (!a.getId().equals(connection.getId())) {
                a4.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a4, a));
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_sna(Integer a, Pageable a2) {
        c_jg a3;
        return a3.K.findByProjectId(a, a2);
    }

    static {
        String[] stringArray = new String[7];
        stringArray[0] = AuthToken.m_rl((Object)"\u0010L");
        stringArray[1] = LogEntryDto.m_rl((Object)"VsD`@");
        stringArray[2] = AuthToken.m_rl((Object)"X\u000bG\u0013M\u001a\\");
        stringArray[3] = LogEntryDto.m_rl((Object)"Fq@bQfAA\\");
        stringArray[4] = AuthToken.m_rl((Object)"\u001aZ\u001cI\rA\u0016F=I\rM");
        stringArray[5] = LogEntryDto.m_rl((Object)"oDpQNJgLeLfAA\\");
        stringArray[6] = AuthToken.m_rl((Object)"\u0015I\n\\4G\u001dA\u001fA\u001cL=I\rM");
        E = stringArray;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE') and hasAuthority('UPDATE_VARIABLE')")
    public void m_oua(TVariable a, boolean a2) {
        Variable variable;
        c_jg a3;
        TVariable TVariable = a;
        a3.m_zta(TVariable);
        if ((TVariable.getId() != null ? (variable = a3.m_la(a.getId())) : (variable = a3.m_ha(a.getProjectId(), a.getName()))) != null) {
            a3.m_nta(a, variable, a2);
            return;
        }
        a3.m_cma(a, a2);
    }

    protected void m_zta(TVariable a) {
        c_jg a2;
        if (a.getProject() == null) {
            TVariable TVariable = a;
            TVariable.setProject(a2.m.m_yb(TVariable.getProjectId()));
        }
        if (a.getFrame() == null) {
            TVariable TVariable = a;
            TVariable.setFrame(a2.D.m_loa(TVariable.getFrameId()));
        }
        if (a.getValueExpression() == null && a.getValueExpressionId() != null) {
            TVariable TVariable = a;
            TVariable.setValueExpression(a2.H.m_yb(TVariable.getValueExpressionId()));
        }
        if (a.getLogExpression() == null && a.getLogExpressionId() != null) {
            TVariable TVariable = a;
            TVariable.setLogExpression(a2.H.m_yb(TVariable.getLogExpressionId()));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_ta() {
        c_jg a;
        return a.K.findAll();
    }

    @Order(value=5)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_hi(ProjectDeleteEvent a) {
        c_jg a2;
        a2.m_qa(a.getProject().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_qga(Pageable a) {
        c_jg a2;
        return a2.K.findAll(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_pma(VariableFilter a2) {
        c_jg a3;
        c_jg c_jg2 = a3;
        c_jg2.K.deleteAllByFilter(a2);
        c_jg2.D.m_ra(a2.getProjectId()).forEach(a -> {
            c_jg a2;
            a2.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_owa(List<Integer> a) {
        c_jg a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyList();
        }
        return a2.K.findAllById(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_ra(Integer a) {
        c_jg a2;
        if ((a = a2.K.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    private /* synthetic */ TVariable m_cma(TVariable a, boolean a2) {
        c_jg a3;
        c_jg c_jg2 = a3;
        c_jg2.m_vpa(a);
        Variable variable = (Variable)c_jg2.K.save(a);
        if (a2) {
            a3.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a3, a.getConnection()));
        }
        return (TVariable)variable;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE')")
    public TVariable m_nva(TVariable a) {
        c_jg a2;
        return (TVariable)a2.m_cma(a, true);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_jna(List<Integer> a2) {
        c_jg a3;
        c_jg c_jg2 = a3;
        a2 = c_jg2.m_owa(a2);
        c_jg2.K.deleteInBatch(a2);
        a2.stream().map(Variable::getConnection).distinct().forEach(a -> {
            c_jg a2;
            a2.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_ha(Integer a, String a2) {
        c_jg a3;
        return (TVariable)a3.K.findOneByProjectIdAndName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_sra(Integer a, String a2, String a3, String a4) {
        c_jg a5;
        if ((a = a5.K.findVariablesByFrameName((Integer)a, a2, a3, a4)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    public void m_vpa(TVariable a) {
        c_jg a2;
        c_jg c_jg2 = a2;
        c_jg2.m_zta(a);
        c_jg2.m_ina(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_vva(Integer a, String a2) {
        c_jg a3;
        Variable variable = a3.m_ha(a, a2);
        if (variable == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_ac(String.format(LogEntryDto.m_rl((Object)"UDqLbGo@#KlQ#ClPmA9\u0005sWlOfFw\u0005jA9\u0005&A/\u0005mDn@9\u0005&V"), objectArray));
        }
        return (TVariable)variable;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_qa(Integer a2) {
        if (a2 != null) {
            c_jg a3;
            c_jg c_jg2 = a3;
            c_jg2.K.deleteByProjectId(a2);
            c_jg2.D.m_ra(a2).forEach(a -> {
                c_jg a2;
                a2.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
            });
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE') and hasAuthority('UPDATE_VARIABLE')")
    public void m_mo(Collection<TVariable> a2, boolean a3) {
        c_jg a4;
        a2.forEach(arg_0 -> a4.m_zta(arg_0));
        Object object = a2.stream().map(Variable::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.K.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(Variable::getProjectId, Collectors.mapping(Variable::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_jg a2;
            return a2.K.findByProjectIdAndNameIn((Integer)a.getKey(), (String[])((Set)a.getValue()).stream().toArray(String[]::new)).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        HashSet<Connection> hashSet = new HashSet<Connection>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Variable variable = (Variable)a2.next();
            if ((variable.getId() != null ? (Variable)map.get(variable.getId()) : (Variable)object.get(ImmutablePair.of((Object)variable.getProjectId(), (Object)variable.getName()))) != null) {
                Variable variable2;
                Variable variable3 = variable2;
                Connection connection = variable3.getConnection();
                Variable variable4 = variable;
                BeanUtils.copyProperties((Object)variable4, (Object)variable2, (String[])E);
                a4.m_ina(variable4);
                Connection connection2 = variable3.getConnection();
                if (connection.getId() != null) {
                    hashSet.add(connection);
                }
                if (connection2.getId() != null && !connection2.getId().equals(connection.getId())) {
                    hashSet.add(connection2);
                }
                arrayList.add(variable2);
                continue;
            }
            a4.m_ina(variable);
            arrayList.add(variable);
            hashSet.add(variable.getConnection());
        }
        a4.K.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_jg a2;
                a2.l.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
            });
        }
    }

    protected void m_ina(TVariable a) {
        if (!a.getConnection().getProject().equals((Object)a.getProject())) {
            throw new c_lf(AuthToken.m_rl((Object)"?Z\u0018E\u001c\b\u001bM\u0015G\u0017O\n\b\rGYI\u0017G\r@\u001cZYX\u000bG\u0013M\u001a\\"));
        }
    }
}

