/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_zia;
import com.inscada.mono.cluster.j.c_ska;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.communication.base.enums.c_dja;
import com.inscada.mono.communication.base.events.DeleteEvent;
import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.ConnectorFactory;
import com.inscada.mono.communication.base.services.c_hn;
import com.inscada.mono.communication.base.services.c_k;
import com.inscada.mono.communication.base.services.c_kla;
import com.inscada.mono.config.c_uj;
import com.inscada.mono.license.services.c_zi;
import com.inscada.mono.log.services.c_bd;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.report.model.ReportDataItem;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_sk;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener {
    private final JedisPooled G;
    public static final short h = 209;
    public static final short f = 206;
    private final c_zi J;
    private static final Logger b = LoggerFactory.getLogger(ConnectionManager.class);
    private final c_bd C;
    private final ConnectorFactory<C, V> F;
    public static final short I = 203;
    public static final short M = 202;
    public static final short L = 204;
    public static final short i = 207;
    private final Lock d;
    private final c_kla c;
    private static final String D = "activeConnections";
    public static final short H = 210;
    public static final short m = 205;
    private final ClusterOperations E;
    public static final short K = 208;
    public static final short l = 201;

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> a22) {
        ConnectionManager a3;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, c_uj.m_rl((Object)"J\\moxUl\\K\\hL|Jm\u0019zXwWvM9[|\u0019wLuU")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), ReportDataItem.m_rl((Object)"I\u0003d\u0002o\u000f~\u0005e\u0002C\b*\u0005dLY\t~:k\u0000\u007f\tX\t{\u0019o\u001f~Li\rd\u0002e\u0018*\u000eoLd\u0019f\u0000")));
        if (a3.E.isLeader()) {
            b.debug(ReportDataItem.m_rl((Object)" O-N)XV*?o\u0018~\u0005d\u000b*\u0017wL|\rx\u0005k\u000ef\t*\u001ak\u0000\u007f\tyLf\u0003i\rf\u0000sB"), (Object)a22.size());
            a3.setVariableValuesInternal(a22);
            return;
        }
        b.debug(c_uj.m_rl((Object)"WvW\u0014U|X}\\k#\u0019K\\hL|JmPw^9U|X}\\k\u0019mV9J|M9Bd\u0019oXkPx[u\\9OxUl\\j\u0017"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<SetValueRequest<V>>(a22);
            a3.E.callLeaderMethod(Short.valueOf((short)205), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new c_ska(ReportDataItem.m_rl((Object)"*k\u0005f\tnL~\u0003*>Z/*\u001fo\u0018*\u001ak\u001ec\rh\u0000oL|\rf\u0019o\u001f"), (Throwable)a22);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        String string = connectionManager.E.getCurrentNode().getNodeId();
        b.info(c_uj.m_rl((Object)"ZVwW|ZmPvWTXwX~\\k\u00039mqPj\u0019wV}\\9\u0011bD0\u0019qXj\u0019{\\zVt\\9Mq\\9u\\x]|K\u00179k|JmVkPw^9XzMpO|\u0019zVwW|ZmPvWj\u00177\u0017"), (Object)string);
        connectionManager.d.lock();
        try {
            Set set = a2.G.smembers(D).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                b.info(ReportDataItem.m_rl((Object)"/e\u0002d\ti\u0018c\u0003d!k\u0002k\u000bo\u001e*DF\tk\bo\u001e*\u0017wE0LD\u0003*\ri\u0018c\u001aoLi\u0003d\u0002o\u000f~\u0005e\u0002yLl\u0003\u007f\u0002nLc\u0002*>o\bc\u001f*\u0018eLx\ty\u0018e\u001eoB"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            b.info(c_uj.m_rl((Object)"zvWw\\zMpVwtxWx^|K9\u0011U\\x]|K9Bd\u0010#\u0019_VlW}\u0019bD9XzMpO|\u0019zVwW|ZmPvW9p]J9Pw\u0019K\\}Pj\u0019mV9K|JmVk\\#\u0019bD"), objectArray);
            ArrayList arrayList = new ArrayList(a2.c.m_hwb(set));
            b.info(ReportDataItem.m_rl((Object)"I\u0003d\u0002o\u000f~\u0005e\u0002G\rd\rm\txL\" o\rn\txLq\u0011#V*-~\u0018o\u0001z\u0018c\u0002mL~\u0003*\u001eo\u001f~\u0003x\t*\u0017wLi\u0003d\u0002o\u000f~\u0005e\u0002yB"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ConnectionManager a2;
                String string = a2.E.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    b.info(c_uj.m_rl((Object)"ZVwW|ZmPvWTXwX~\\k\u00191u|X}\\k\u0019bD0\u00039k|JmVkPw^9ZvWw\\zMpVw\u00039Bd\u00191p]\u00039Bd\u0010"), objectArray);
                    a2.startConnectionInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.C.m_efa(a.getProject()).m_q("Connection Restore (Leader " + string + ")", String.format(ReportDataItem.m_rl((Object)"/\u001f*DC(0L/\b#Ll\rc\u0000o\b*\u0018eLx\ty\u0018e\u001eoB*/k\u0019y\t0L/\u001f"), objectArray));
                    try {
                        b.warn(c_uj.m_rl((Object)"ZVwW|ZmPvWTXwX~\\k\u00191u|X}\\k\u0019bD0\u00039xmM|TiMpW~\u0019mV9JmVi\u0019zVwW|ZmPvW9Bd\u0019x_m\\k\u0019k\\jMvKxMpVw\u0019\u007fXpUlK|\u0017"), (Object)string, (Object)a.getId());
                        a2.stopConnectionInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        b.error(ReportDataItem.m_rl((Object)"/e\u0002d\ti\u0018c\u0003d!k\u0002k\u000bo\u001e*DF\tk\bo\u001e*\u0017wE0LL\rc\u0000o\b*\u0018eLy\u0018e\u001c*\u000fe\u0002d\ti\u0018c\u0003dLq\u0011*\rl\u0018o\u001e*\u001eo\u001f~\u0003x\r~\u0005e\u0002*\nk\u0005f\u0019x\t0Lq\u0011"), objectArray2);
                        return;
                    }
                }
            });
            b.info(c_uj.m_rl((Object)"zvWw\\zMpVwtxWx^|K9\u0011U\\x]|K9Bd\u0010#\u0019_PwPjQ|]9ZvWw\\zMpVw\u0019k\\jMvKxMpVw\u0019iKvZ|Jj\u0017"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            b.error(ReportDataItem.m_rl((Object)"I\u0003d\u0002o\u000f~\u0005e\u0002G\rd\rm\txL\" o\rn\txLq\u0011#V*)x\u001ee\u001e*\b\u007f\u001ec\u0002mLi\u0003d\u0002o\u000f~\u0005e\u0002*\u001eo\u001f~\u0003x\r~\u0005e\u0002*\u001cx\u0003i\ty\u001f0Lq\u0011"), objectArray);
            return;
        }
        finally {
            a2.d.unlock();
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.E.addListener((ClusterNodeListener)a);
        b.info(c_uj.m_rl((Object)"ZVwW|ZmPvWTXwX~\\k\u0019pWpMpXuPc\\}\u0019xW}\u0019k\\~PjM|K|]9Xj\u0019ZUlJm\\kwv]|upJm\\w\\k\u0017"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_dja getConnectionStatus(Integer a, String a2) {
        ConnectionManager a3;
        if ((a = a3.c.m_jk(a, a2)) == null) {
            return c_dja.l;
        }
        return a3.getConnectionStatus(a.getId());
    }

    protected Object browseConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        Connection connection = connectionManager.c.m_wl(a);
        return c_zia.m_zac(() -> {
            ConnectionManager a2;
            if ((a = a2.F.getConnector(a)) instanceof c_k) {
                return ((c_k)a).m_va();
            }
            throw new RuntimeException(ReportDataItem.m_rl((Object)"H\u001ee\u001by\t*\u0003z\tx\r~\u0005e\u0002*\u0002e\u0018*\u001f\u007f\u001cz\u0003x\u0018o\b"));
        }, (OwnedSpaceBaseModel)connection);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_dja> getConnectionStatuses(Integer[] a) {
        ConnectionManager a2;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.E.isLeader()) {
            b.debug(ReportDataItem.m_rl((Object)" O-N)XV*+o\u0018~\u0005d\u000b*\u000fe\u0002d\ti\u0018c\u0003dLy\u0018k\u0018\u007f\u001fo\u001f*\ne\u001e*\u0017wLC(yLf\u0003i\rf\u0000sB"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal(a);
        }
        b.debug(c_uj.m_rl((Object)"wVw4u\\x]|K\u00039k|Hl\\jMpW~\u0019u\\x]|K9_vK9ZvWw\\zMpVw\u0019jMxMlJ|J9_vK9Bd\u0019P}j\u0017"), (Object)a.length);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.E.callLeaderMethod(Short.valueOf((short)209), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get connection statuses for IDs " + Arrays.toString((Object[])a), (Throwable)exception);
        }
    }

    public void notLeader() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        String string = connectionManager.E.getCurrentNode().getNodeId();
        b.info(ReportDataItem.m_rl((Object)"/e\u0002d\ti\u0018c\u0003d!k\u0002k\u000bo\u001e0L^\u0004c\u001f*\u0002e\boL\"\u0017wE*\u0005yLD#* E\"M)XL^$OLF)K(O>$LY\u0018e\u001cz\u0005d\u000b*\rf\u0000*\u0000e\u000fk\u0000*\u000fe\u0002d\ti\u0018e\u001eyB$B"), (Object)string);
        connectionManager.d.lock();
        try {
            a.F.stopAllLocalConnectors();
            b.info(c_uj.m_rl((Object)"ZVwW|ZmPvWTXwX~\\k\u00191wvM9u|X}\\k\u0019bD0\u00039xuU9UvZxU9ZvWw\\zMvKj\u0019qXo\\9[|\\w\u0019k\\hL|Jm\\}\u0019mV9JmVi\u0019xW}\u0019zU|Xk\\}\u0019\u007fKvT9UvZxU9MkXzRpW~\u0017"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            b.error(ReportDataItem.m_rl((Object)"I\u0003d\u0002o\u000f~\u0005e\u0002G\rd\rm\txL\"\"e\u0018* o\rn\txLq\u0011#V*)x\u001ee\u001e*\b\u007f\u001ec\u0002mLz\u001ee\u000fo\u001fyLe\n*\u001f~\u0003z\u001cc\u0002mLf\u0003i\rfLi\u0003d\u0002o\u000f~\u0003x\u001f0Lq\u0011"), objectArray);
            return;
        }
        finally {
            a.d.unlock();
        }
    }

    protected Map<Integer, c_dja> getConnectionStatusesByIdsInternal(Integer[] a2) {
        ConnectionManager a3;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> a3.getConnectionStatusInternal(arg_0)));
    }

    public ConnectionManager(c_kla a, c_zi a2, c_bd a3, ConnectorFactory<C, V> a4, JedisPooled a5, ClusterOperations a6) {
        ConnectionManager a7;
        ConnectionManager connectionManager = a7;
        ConnectionManager connectionManager2 = a7;
        ConnectionManager connectionManager3 = a7;
        ConnectionManager connectionManager4 = a7;
        connectionManager4.d = new ReentrantLock();
        connectionManager3.c = a;
        connectionManager3.J = a2;
        connectionManager2.C = a3;
        connectionManager2.F = a4;
        connectionManager.G = a5;
        connectionManager.E = a6;
    }

    protected void stopConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.c.m_nf((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(Integer a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            b.debug(ReportDataItem.m_rl((Object)"F)K(O>0LZ\tx\ne\u001eg\u0005d\u000b*\u000ex\u0003}\u001foLe\u001co\u001ek\u0018c\u0003dLl\u0003xLi\u0003d\u0002o\u000f~\u0005e\u0002*\u0017wLf\u0003i\rf\u0000sB"), (Object)a);
            return a2.browseConnectionInternal(a);
        }
        b.debug(c_uj.m_rl((Object)"WvW\u0014U|X}\\k#\u0019K\\hL|JmPw^9U|X}\\k\u0019mV9I|K\u007fVkT9[kVnJ|\u0019vI|KxMpVw\u0019\u007fVk\u0019zVwW|ZmPvW9Bd\u0017"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return a2.E.callLeaderMethod(Short.valueOf((short)210), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC browse connection " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(Integer a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            b.debug(c_uj.m_rl((Object)"U|X}\\k#\u0019JMvIiPw^9XuU9ZvWw\\zMpVwJ9_vK9IkVs\\zM9Bd\u0019uVzXuU`\u0017"), (Object)a);
            a2.stopConnectionsByProjectIdInternal(a);
            return;
        }
        b.debug(ReportDataItem.m_rl((Object)"\"E\"' O-N)XV*>o\u001d\u007f\ty\u0018c\u0002mLf\tk\bo\u001e*\u0018eLy\u0018e\u001c*\rf\u0000*\u000fe\u0002d\ti\u0018c\u0003d\u001f*\ne\u001e*\u001cx\u0003`\ti\u0018*\u0017wB"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.E.callLeaderMethod(Short.valueOf((short)207), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC stop connections for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ConnectionManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.E.addRemoteCall((short)201, (Object)a, ConnectionManager.class.getDeclaredMethod(c_uj.m_rl((Object)"JmXkMZVwW|ZmPvWPWm\\kWxU"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.E.addRemoteCall((short)202, (Object)a, ConnectionManager.class.getDeclaredMethod(ReportDataItem.m_rl((Object)"y\u0018e\u001cI\u0003d\u0002o\u000f~\u0005e\u0002C\u0002~\tx\u0002k\u0000"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.E.addRemoteCall((short)203, (Object)a, ConnectionManager.class.getDeclaredMethod(c_uj.m_rl((Object)"^|MZVwW|ZmPvWJMxMlJPWm\\kWxU"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = SetValueRequest.class;
            a.E.addRemoteCall((short)204, (Object)a, ConnectionManager.class.getDeclaredMethod(ReportDataItem.m_rl((Object)"y\t~:k\u001ec\rh\u0000o:k\u0000\u007f\tC\u0002~\tx\u0002k\u0000"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Collection.class;
            a.E.addRemoteCall((short)205, (Object)a, ConnectionManager.class.getDeclaredMethod(c_uj.m_rl((Object)"J|MOXkPx[u\\OXuL|JPWm\\kWxU"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.E.addRemoteCall((short)206, (Object)a, ConnectionManager.class.getDeclaredMethod(ReportDataItem.m_rl((Object)"\u001f~\rx\u0018I\u0003d\u0002o\u000f~\u0005e\u0002y.s<x\u0003`\ti\u0018C\bC\u0002~\tx\u0002k\u0000"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.E.addRemoteCall((short)207, (Object)a, ConnectionManager.class.getDeclaredMethod(c_uj.m_rl((Object)"jMvIZVwW|ZmPvWj{`ikVs\\zMP]PWm\\kWxU"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.E.addRemoteCall((short)208, (Object)a, ConnectionManager.class.getDeclaredMethod(ReportDataItem.m_rl((Object)"m\t~/e\u0002d\ti\u0018c\u0003d?~\r~\u0019y\ty.s<x\u0003`\ti\u0018C\bC\u0002~\tx\u0002k\u0000"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer[].class;
            a.E.addRemoteCall((short)209, (Object)a, ConnectionManager.class.getDeclaredMethod(c_uj.m_rl((Object)"~\\mzvWw\\zMpVwjmXmLj\\j{`p}JPWm\\kWxU"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = Integer.class;
            a.E.addRemoteCall((short)210, (Object)a, ConnectionManager.class.getDeclaredMethod(ReportDataItem.m_rl((Object)"h\u001ee\u001by\tI\u0003d\u0002o\u000f~\u0005e\u0002C\u0002~\tx\u0002k\u0000"), classArray10));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(c_uj.m_rl((Object)"_XpU|]9Mv\u0019k\\~PjM|K9zvWw\\zMpVwtxWx^|K9kIz9T|MqV}J"), noSuchMethodException);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            b.debug(ReportDataItem.m_rl((Object)" O-N)XV*?~\u0003z\u001cc\u0002mLi\u0003d\u0002o\u000f~\u0005e\u0002*\u0017wLf\u0003i\rf\u0000sB"), (Object)a);
            a2.stopConnectionInternal(a);
            return;
        }
        b.debug(c_uj.m_rl((Object)"WvW\u0014U|X}\\k#\u0019K\\hL|JmPw^9U|X}\\k\u0019mV9JmVi\u0019zVwW|ZmPvW9Bd\u0017"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.E.callLeaderMethod(Short.valueOf((short)202), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC stop connection " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={RestartEvent.class})
    public void handleRestartEvent(RestartEvent a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            Connection connection = a.getConnection();
            b.info(ReportDataItem.m_rl((Object)" O-N)XV*$k\u0002n\u0000c\u0002mLX\ty\u0018k\u001e~)|\td\u0018*\ne\u001e*\u000fe\u0002d\ti\u0018c\u0003dV*\u0017wL\"%NV*\u0017wE"), (Object)connection.getName(), (Object)connection.getId());
            a2.d.lock();
            try {
                if (a2.getConnectionStatusInternal(connection.getId()) == c_dja.m) {
                    a2.startConnectionInternal(connection.getId());
                }
                return;
            }
            finally {
                a2.d.unlock();
            }
        }
        b.debug(c_uj.m_rl((Object)"WvW\u0014U|X}\\k#\u0019P^wVkPw^9k|JmXkM\\O|Wm\u0019\u007fVk\u0019zVwW|ZmPvW#\u0019bD"), (Object)a.getConnection().getId());
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.startConnection(connectionManager.c.m_vbc(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_dja getConnectionStatus(Integer a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            b.debug(ReportDataItem.m_rl((Object)" O-N)XV*+o\u0018~\u0005d\u000b*\u000fe\u0002d\ti\u0018c\u0003dLy\u0018k\u0018\u007f\u001f*\ne\u001e*\u0017wLf\u0003i\rf\u0000sB"), (Object)a);
            return a2.getConnectionStatusInternal(a);
        }
        b.debug(c_uj.m_rl((Object)"wVw4u\\x]|K\u00039k|Hl\\jMpW~\u0019u\\x]|K9_vK9ZvWw\\zMpVw\u0019jMxMlJ9_vK9Bd\u0017"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_dja)a2.E.callLeaderMethod(Short.valueOf((short)203), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get connection status for " + a, (Throwable)exception);
        }
    }

    protected void startConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_zia.m_iec(() -> {
            ConnectionManager a2;
            a2.d.lock();
            try {
                a2.stopConnectionInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_sk("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.J.m_aha();
                connectionManager.F.provideConnector(a).m_nhb();
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                connectionManager.G.sadd(D, stringArray);
                return;
            }
            finally {
                a2.d.unlock();
            }
        }, a);
    }

    protected void startConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.startConnectionInternal(connectionManager.c.m_kba(a));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.stopConnection(connectionManager.c.m_vbc(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            b.debug(c_uj.m_rl((Object)"u\\x]|K\u00039jmXkMpW~\u0019zVwW|ZmPvW9Bd\u0019uVzXuU`\u0017"), (Object)a);
            a2.startConnectionInternal(a);
            return;
        }
        b.debug(ReportDataItem.m_rl((Object)"\"E\"' O-N)XV*>o\u001d\u007f\ty\u0018c\u0002mLf\tk\bo\u001e*\u0018eLy\u0018k\u001e~Li\u0003d\u0002o\u000f~\u0005e\u0002*\u0017wB"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.E.callLeaderMethod(Short.valueOf((short)201), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC start connection " + a, (Throwable)exception);
        }
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            Integer n = a.getProject().getId();
            b.info(c_uj.m_rl((Object)"U|X}\\k#\u0019QXw]uPw^9ikVs\\zM]\\xZmPoXm\\\\O|Wm\u0019\u007fVk\u0019iKvS|Zm\u0019P}#\u0019bD"), (Object)n);
            a2.stopConnectionsByProjectIdInternal(n);
            return;
        }
        b.debug(ReportDataItem.m_rl((Object)"D#DAF)K(O>0LC\u000bd\u0003x\u0005d\u000b*<x\u0003`\ti\u0018N\tk\u000f~\u0005|\r~\tO\u001ao\u0002~Ll\u0003xLz\u001ee\u0006o\u000f~LC(0Lq\u0011"), (Object)a.getProject().getId());
    }

    protected void setVariableValueInternal(SetValueRequest<V> a) {
        ConnectionManager a2;
        c_hn c_hn2 = a2.F.getConnector(a.getConnectionId());
        if (c_hn2 == null) {
            throw new c_ac("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_hn2.m_kfb(a);
    }

    protected void stopConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_zia.m_iec(() -> {
            ConnectionManager a2;
            a2.d.lock();
            try {
                c_hn c_hn2 = a2.F.getConnector(a.getId());
                if (c_hn2 != null) {
                    c_hn2.m_tbb();
                    a2.F.removeConnector(a.getId(), c_hn2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.G.srem(D, stringArray);
                return;
            }
            finally {
                a2.d.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_dja> getConnectionStatuses(Integer a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            b.debug(c_uj.m_rl((Object)"u\\x]|K\u00039~|MmPw^9XuU9ZvWw\\zMpVw\u0019jMxMlJ|J9_vK9IkVs\\zM9Bd\u0019uVzXuU`\u0017"), (Object)a);
            return a2.getConnectionStatusesByProjectIdInternal(a);
        }
        b.debug(ReportDataItem.m_rl((Object)"\"E\"' O-N)XV*>o\u001d\u007f\ty\u0018c\u0002mLf\tk\bo\u001e*\ne\u001e*\rf\u0000*\u000fe\u0002d\ti\u0018c\u0003dLy\u0018k\u0018\u007f\u001fo\u001f*\ne\u001e*\u001cx\u0003`\ti\u0018*\u0017wB"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.E.callLeaderMethod(Short.valueOf((short)208), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get connection statuses for project " + a, (Throwable)exception);
        }
    }

    protected void startConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.c.m_cda((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.startConnectionInternal(arg_0));
    }

    protected void stopConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.stopConnectionInternal(connectionManager.c.m_wl(a));
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> a) {
        ConnectionManager a2;
        Objects.requireNonNull(a, c_uj.m_rl((Object)"J\\moxUl\\K\\hL|Jm\u0019zXwWvM9[|\u0019wLuU"));
        Objects.requireNonNull(a.getConnectionId(), ReportDataItem.m_rl((Object)"I\u0003d\u0002o\u000f~\u0005e\u0002C\b*\u0005dLY\t~:k\u0000\u007f\tX\t{\u0019o\u001f~Li\rd\u0002e\u0018*\u000eoLd\u0019f\u0000"));
        if (a2.E.isLeader()) {
            b.debug(c_uj.m_rl((Object)"U|X}\\k#\u0019J\\mMpW~\u0019oXkPx[u\\9OxUl\\9_vK9ZvWw\\zMpVw\u0019bD9UvZxUu@#\u0019bD"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        b.debug(ReportDataItem.m_rl((Object)"\"E\"' O-N)XV*>o\u001d\u007f\ty\u0018c\u0002mLf\tk\bo\u001e*\u0018eLy\t~L|\rx\u0005k\u000ef\t*\u001ak\u0000\u007f\t*\ne\u001e*\u000fe\u0002d\ti\u0018c\u0003dLq\u00110Lq\u0011"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.E.callLeaderMethod(Short.valueOf((short)204), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> a3) {
        ConnectionManager a4;
        a3.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((a, a2) -> {
            ConnectionManager a3;
            if ((a = a3.F.getConnector(a)) != null) {
                a.m_nbb(a2);
            }
        });
    }

    protected Map<Integer, c_dja> getConnectionStatusesByProjectIdInternal(Integer a2) {
        ConnectionManager a3;
        if ((a2 = a3.c.m_nf((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(Connection::getId, a -> {
            ConnectionManager a2;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    @TransactionalEventListener(value={DeleteEvent.class})
    public void handleDeleteEvent(DeleteEvent a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            Connection connection = a.getConnection();
            b.info(c_uj.m_rl((Object)"U|X}\\k#\u0019QXw]uPw^9}|U|M||o\\wM9_vK9ZvWw\\zMpVw\u00039Bd\u00191p]\u00039Bd\u0010"), (Object)connection.getName(), (Object)connection.getId());
            a2.stopConnectionInternal(connection);
            return;
        }
        b.debug(ReportDataItem.m_rl((Object)"\"E\"' O-N)XV*%m\u0002e\u001ec\u0002mLN\tf\t~\tO\u001ao\u0002~Ll\u0003xLi\u0003d\u0002o\u000f~\u0005e\u00020Lq\u0011"), (Object)a.getConnection().getId());
    }

    protected c_dja getConnectionStatusInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.F.getConnector(a)) != null && a.m_gza()) {
            return c_dja.m;
        }
        return c_dja.l;
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(Integer a) {
        ConnectionManager a2;
        if (a2.E.isLeader()) {
            b.debug(c_uj.m_rl((Object)"U|X}\\k#\u0019JMxKmPw^9XuU9ZvWw\\zMpVwJ9_vK9IkVs\\zM9Bd\u0019uVzXuU`\u0017"), (Object)a);
            a2.startConnectionsByProjectIdInternal(a);
            return;
        }
        b.debug(ReportDataItem.m_rl((Object)"D#DAF)K(O>0LX\t{\u0019o\u001f~\u0005d\u000b*\u0000o\rn\txL~\u0003*\u001f~\rx\u0018*\rf\u0000*\u000fe\u0002d\ti\u0018c\u0003d\u001f*\ne\u001e*\u001cx\u0003`\ti\u0018*\u0017wB"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.E.callLeaderMethod(Short.valueOf((short)206), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC start connections for project " + a, (Throwable)exception);
        }
    }
}

