/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.services.c_jg;
import com.inscada.mono.system.restcontrollers.SystemController;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class VariableController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>> {
    private final c_jg<TConnection, TDevice, TFrame, TVariable> l;

    @GetMapping(value={"/{variableId}"})
    public TVariable getVariable(@PathVariable(value="variableId") Integer a) {
        return (TVariable)this.l.m_la(a);
    }

    @GetMapping(params={"projectId", "name"})
    public TVariable getVariableByName(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return (TVariable)this.l.m_vva(projectId, a);
    }

    @GetMapping(params={"variableIds"})
    public Collection<TVariable> getVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        return this.l.m_owa(Arrays.asList(a));
    }

    @PostMapping
    public ResponseEntity<TVariable> createVariable(@Valid @RequestBody TVariable variable, UriComponentsBuilder a) {
        variable = this.l.m_nva(variable);
        Object[] objectArray = new Object[1];
        objectArray[0] = variable.getId();
        return ResponseEntity.created((URI)a.path(SystemController.m_rl((Object)"[N\u0002T\u0006\\\u0015W\u0018P=Q\t")).buildAndExpand(objectArray).toUri()).body(variable);
    }

    @PutMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void upsertVariables(@Valid @RequestBody Collection<TVariable> a) {
        this.l.m_mo(a, true);
    }

    @DeleteMapping(value={"/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariable(@PathVariable(value="variableId") Integer a) {
        this.l.m_ma(a);
    }

    @GetMapping(params={"projectId"})
    public Collection<TVariable> getVariables(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_ta();
        }
        return this.l.m_ra(a);
    }

    @GetMapping(params={"frameId"})
    public Collection<TVariable> getVariablesByFrameId(@RequestParam(name="frameId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_ta();
        }
        return this.l.m_hwa(a);
    }

    @DeleteMapping(value={""}, params={"variableIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        this.l.m_jna(List.of(a));
    }

    @DeleteMapping(value={"/filter"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariablesByFilter(@Valid @RequestBody VariableFilter a) {
        this.l.m_pma(a);
    }

    @GetMapping(value={"/pages"}, params={"projectId"})
    public Page<TVariable> getVariablesByPages(@RequestParam(name="projectId") Integer projectId, Pageable a) {
        return this.l.m_sna(projectId, a);
    }

    public VariableController(c_jg<TConnection, TDevice, TFrame, TVariable> a) {
        VariableController a2;
        a2.l = a;
    }

    @PutMapping(value={"/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateVariable(@PathVariable(value="variableId") Integer variableId, @Valid @RequestBody TVariable a) {
        this.l.m_ova(variableId, a);
    }
}

