/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_fha;
import com.inscada.mono.communication.base.services.c_pg;
import com.inscada.mono.communication.base.template.j.c_zf;
import com.inscada.mono.communication.base.template.model.DeviceGenerationRequest;
import com.inscada.mono.config.c_hi;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ConnectionController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TConnectionService extends c_pg<TConnection, TDevice, TFrame>, TTemplateService extends c_zf> {
    protected final TTemplateService K;
    protected final TConnectionService l;

    @DeleteMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnection(@PathVariable(value="connectionId") Integer a) {
        this.l.m_ma(a);
    }

    @PostMapping(value={"/{connectionId}/devices"})
    public ResponseEntity<TDevice> createDevice(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TDevice device, UriComponentsBuilder a) {
        device = this.l.m_yqa(connectionId, device, Boolean.valueOf(true));
        Object[] objectArray = new Object[2];
        objectArray[0] = connectionId;
        objectArray[1] = device.getId();
        return ResponseEntity.created((URI)a.path(c_hi.m_rl((Object)"M\u0010\u0001\u0004\f\u0005\u0007\b\u0016\u0002\r\u0005+\u000f\u001fD\u0006\u000e\u0014\u0002\u0001\u000e\u0011D\u0019\u000f\u0007\u001d\u000b\b\u0007\"\u0006\u0016")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @GetMapping(value={"/{connectionId}"})
    public TConnection getConnection(@PathVariable(value="connectionId") Integer a) {
        return (TConnection)this.l.m_la(a);
    }

    @GetMapping(value={"/frames"})
    public Collection<TFrame> getFrames(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_gma();
        }
        return this.l.m_noa(a);
    }

    @DeleteMapping(value={"/devices"}, params={"deviceIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevicesByIds(@RequestParam(value="deviceIds") Integer[] a) {
        this.l.m_jua(List.of(a));
    }

    @GetMapping(value={"/devices"})
    public Collection<TDevice> getDevicesByProjectId(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_rsa();
        }
        return this.l.m_epa(a);
    }

    @DeleteMapping(value={"/frames"}, params={"frameIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFramesByIds(@RequestParam(value="frameIds") Integer[] a) {
        this.l.m_wwa(List.of(a));
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    public TFrame getFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrame)this.l.m_ooa(connectionId, deviceId, a);
    }

    public static String m_rl(Object a) {
        a = (String)a;
        int n = ((String)a).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 3 << 3 ^ 4;
        int cfr_ignored_0 = 5 << 3 ^ 4;
        int n4 = n2;
        int n5 = (2 ^ 5) << 4 ^ (2 << 2 ^ 3);
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @PostMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public ResponseEntity<TFrame> createFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrame frame, UriComponentsBuilder a) {
        frame = this.l.m_mma(connectionId, deviceId, frame, Boolean.valueOf(true));
        Object[] objectArray = new Object[3];
        objectArray[0] = connectionId;
        objectArray[1] = deviceId;
        objectArray[2] = frame.getId();
        return ResponseEntity.created((URI)a.path(c_fha.m_rl((Object)"oT#@.A%L4F/A\tK=\u0000$J6F#J3\u0000;K%Y)L%f$RoI2N-J3\u0000;I2N-J\tK=")).buildAndExpand(objectArray).toUri()).body(frame);
    }

    @GetMapping(value={"/device/{deviceId}"})
    public TDevice getDeviceById(@PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.l.m_oqa(a);
    }

    @DeleteMapping(value={""}, params={"connectionIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnectionsByIds(@RequestParam(value="connectionIds") Integer[] a) {
        this.l.m_ima(List.of(a));
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}"})
    public TDevice getDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.l.m_ioa(connectionId, a);
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDevice a) {
        this.l.m_cna(connectionId, deviceId, a, Boolean.valueOf(true));
    }

    @GetMapping(value={"/{connectionId}/devices"})
    public Collection<TDevice> getDevices(@PathVariable(value="connectionId") Integer a) {
        return this.l.m_mpa(a);
    }

    @GetMapping
    public Collection<TConnection> getConnections(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_ta();
        }
        return this.l.m_ra(a);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public Collection<TFrame> getFrames(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return this.l.m_dna(connectionId, a);
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        this.l.m_ena(connectionId, a);
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.l.m_dta(connectionId, deviceId, a);
    }

    @GetMapping(value={"/frame/{frameId}"})
    public TFrame getFrameById(@PathVariable(value="frameId") Integer a) {
        return (TFrame)this.l.m_zpa(a);
    }

    @PostMapping
    public ResponseEntity<TConnection> createConnection(@Valid @RequestBody TConnection connection, UriComponentsBuilder a) {
        connection = this.l.m_sma(connection);
        Object[] objectArray = new Object[1];
        objectArray[0] = connection.getId();
        return ResponseEntity.created((URI)a.path(c_hi.m_rl((Object)"D\u0019\b\r\u0005\f\u000e\u0001\u001f\u000b\u0004\f\"\u0006\u0016")).buildAndExpand(objectArray).toUri()).body(connection);
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrame a) {
        this.l.m_cra(connectionId, deviceId, frameId, a, Boolean.valueOf(true));
    }

    protected ConnectionController(TConnectionService a, TTemplateService a2) {
        ConnectionController a3;
        ConnectionController connectionController = a3;
        connectionController.l = a;
        connectionController.K = a2;
    }

    @PostMapping(value={"/{connectionId}/devices/generate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void generateFromTemplate(@PathVariable(value="connectionId") Integer connectionId, @RequestBody DeviceGenerationRequest a) {
        this.K.m_mna(connectionId, a);
    }

    @PutMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConnection(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TConnection a) {
        this.l.m_uua(connectionId, a);
    }
}

