/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.repositories;

import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.model.VariableIdentity;
import com.inscada.mono.communication.base.model.VariableJson;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.Collection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface VariableRepository<TVariable extends Variable<?, ?, ?>>
extends BaseJpaRepository<TVariable, Integer> {
    public Collection<TVariable> findByFrameId(Integer var1);

    @Query(value="select new com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) from Variable v where v.projectId = ?1 and v.name in (?2)")
    public Collection<VariableIdentity> findIdentitiesByProjectIdAndNameIn(Integer var1, String[] var2);

    @Query(value="select variable_id as id, name, dsc, code, unit, type, frame_id as \"frameId\", project_id as \"projectId\", value_expression as \"valueExpressionCode\",\nfractional_digit_count as \"fractionalDigitCount\", raw_zero_scale as \"rawZeroScale\", raw_full_scale as \"rawFullScale\",\neng_zero_scale as \"engZeroScale\",eng_full_scale as \"engFullScale\", log_type as \"logType\", log_period as \"logPeriod\", log_threshold as \"logThreshold\", log_expression as \"logExpressionCode\",\nlog_expression_id as \"logExpressionId\", value_expression_type as \"valueExpressionType\", value_expression_id as \"valueExpressionId\", active_flag as \"isActive\",\ndead_band as \"deadband\", event_variation as \"eventVariation\", point_class as \"pointClass\", static_variation as \"staticVariation\", byte_swap_flag as \"byteSwapFlag\",\nword_swap_flag as \"wordSwapFlag\", max_len as \"maxLen\", device_id as \"deviceId\", conn_id as \"connectionId\", start_address as \"startAddress\", bit_offset as \"bitOffset\",\n log_min_value as \"logMinValue\", log_max_value as \"logMaxValue\", set_min_value as \"setMinValue\", set_max_value as \"setMaxValue\", pulse_on_flag as \"isPulseOn\", pulse_on_duration as \"pulseOnDuration\",\n pulse_off_flag as \"isPulseOff\", pulse_off_duration as \"pulseOffDuration\",\n  read_address as \"readAddress\", write_address as \"writeAddress\" from (select v.*, dv.dead_band, dv.event_variation, dv.point_class, dv.static_variation, mv.byte_swap_flag, mv.word_swap_flag, sv.max_len, f.device_id, d.conn_id, iv.read_address, iv.write_address, coalesce(mv.start_address, dv.start_address, sv.start_address, fv.start_address, iv.read_address, iv.write_address, iv.read_ioa_address_1, iv.read_ioa_address_2, iv.read_ioa_address_3, iv.write_ioa_address_1, iv.write_ioa_address_2, iv.write_ioa_address_3) as start_address, coalesce(mv.type, sv.type, odv.type, mqv.type, lv.type, enipv.type, ouv.type, fv.type) as type, coalesce(mv.bit_offset, sv.bit_offset) as bit_offset from (inscada.variable v left join inscada.modbus_variable mv on v.variable_id = mv.variable_id left join inscada.dnp3_variable dv on v.variable_id = dv.variable_id left join inscada.s7_variable sv on v.variable_id = sv.variable_id left join inscada.iec104_variable iv on v.variable_id = iv.variable_id left join inscada.opc_da_variable odv on v.variable_id = odv.variable_id left join inscada.mqtt_variable mqv on v.variable_id = mqv.variable_id left join inscada.local_variable lv on v.variable_id = lv.variable_id left join inscada.ethernet_ip_variable enipv on v.variable_id = enipv.variable_id left join inscada.opc_ua_variable ouv on v.variable_id = ouv.variable_id left join inscada.fatek_variable fv on v.variable_id = fv.variable_id left join inscada.frame f on v.frame_id = f.frame_id  left join inscada.device d on f.device_id = d.device_id )) as var where var.space_id = ?#{authentication.activeSpace.id} and (?#{#variableFilter.projectId == null} or var.project_id = ?#{T(Integer).valueOf(#variableFilter.projectId)}) and (?#{#variableFilter.connectionId == null} or var.conn_id = ?#{T(Integer).valueOf(#variableFilter.connectionId)}) and (?#{#variableFilter.deviceId == null} or var.device_id = ?#{T(Integer).valueOf(#variableFilter.deviceId)}) and (?#{#variableFilter.frameId == null} or var.frame_id = ?#{T(Integer).valueOf(#variableFilter.frameId)}) and (?#{#variableFilter.nameIn} = '' or upper(var.name) like concat('%', ?#{#variableFilter.nameIn}, '%')) and (?#{#variableFilter.dscIn} = '' or upper(var.dsc) like concat('%', ?#{#variableFilter.dscIn}, '%')) ", nativeQuery=true)
    public Page<VariableJson> findVariablesByFilterAndStartAddressSort(@Param(value="variableFilter") VariableFilter var1, @Param(value="pageable") Pageable var2);

    @Query(value="select var.name from #{#entityName} var where var.projectId = :projectId and var.logType is not null and var.logType <> 'No Log'")
    public Collection<String> findLoggedVariableNames(@Param(value="projectId") Integer var1);

    @Query(value="select new com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) from Variable v")
    public Collection<VariableIdentity> findAllIdentities();

    @Query(value="select var from #{#entityName} var join var.frame fra join fra.device dev join dev.connection conn where var.projectId = ?1 and conn.name = ?2 and dev.name = ?3")
    public Collection<TVariable> findVariablesByDeviceName(Integer var1, String var2, String var3);

    public Page<TVariable> findByProjectId(Integer var1, Pageable var2);

    public Collection<TVariable> findByProjectId(Integer var1);

    @Query(value="select new com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) from Variable v where v.projectId = ?1")
    public Collection<VariableIdentity> findIdentitiesByProjectId(Integer var1);

    @Query(value="select var from #{#entityName} var join var.frame fra join fra.device dev join dev.connection conn where var.projectId = ?1 and conn.name = ?2 and dev.name = ?3 and fra.name = ?4")
    public Collection<TVariable> findVariablesByFrameName(Integer var1, String var2, String var3, String var4);

    public Page<TVariable> findAll(Pageable var1);

    @Query(value="select --total_variable_count - local_variable_count\n (select count(1) from inscada.variable where project_id is not null) - \n (select count(1) from inscada.local_variable lv join inscada.variable v on lv.variable_id=v.variable_id where v.project_id is not null)", nativeQuery=true)
    public long ioCount();

    public void deleteByProjectId(Integer var1);

    @Query(value="select var from #{#entityName} var join var.frame fra join fra.device dev join dev.connection conn where var.projectId = ?1 and conn.name = ?2")
    public Collection<TVariable> findVariablesByConnectionName(Integer var1, String var2);

    @Modifying
    @Query(value="delete from #{#entityName} var where var in (select varDel from #{#entityName} varDel join varDel.frame fra join fra.device dev join dev.connection conn where (varDel.projectId = ?#{#variableFilter.projectId} or ?#{#variableFilter.projectId} is null) and (conn.id = ?#{#variableFilter.connectionId} or ?#{#variableFilter.connectionId} is null) and (dev.id = ?#{#variableFilter.deviceId} or ?#{#variableFilter.deviceId} is null) and (fra.id = ?#{#variableFilter.frameId} or ?#{#variableFilter.frameId} is null))")
    public void deleteAllByFilter(@Param(value="variableFilter") VariableFilter var1);

    @Query(value="select new com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) from Variable v where v.projectId = ?1 and v.name = ?2")
    public VariableIdentity findIdentityByProjectIdAndName(Integer var1, String var2);

    @Query(value="select var from #{#entityName} var join var.frame fra join fra.device dev join dev.connection conn where (var.projectId = ?#{#variableFilter.projectId} or ?#{#variableFilter.projectId} is null) and (conn.id = ?#{#variableFilter.connectionId} or ?#{#variableFilter.connectionId} is null) and (dev.id = ?#{#variableFilter.deviceId} or ?#{#variableFilter.deviceId} is null) and (fra.id = ?#{#variableFilter.frameId} or ?#{#variableFilter.frameId} is null) and (var.name = ?#{#variableFilter.name} or ?#{#variableFilter.name} is null) and(?#{#variableFilter.nameIn} = '' or upper(var.name) like %?#{#variableFilter.nameIn}% ) and(?#{#variableFilter.dscIn} = '' or upper(var.dsc) like %?#{#variableFilter.dscIn}%)")
    public Page<TVariable> findVariablesByFilter(@Param(value="variableFilter") VariableFilter var1, @Param(value="pageable") Pageable var2);

    @Query(value="select new com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) from Variable v join v.frame f where f.id = ?1")
    public Collection<VariableIdentity> findIdentitiesByFrameId(Integer var1);

    public TVariable findOneByProjectIdAndName(Integer var1, String var2);

    public Collection<TVariable> findByProjectIdAndNameIn(Integer var1, String[] var2);
}

