/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Where;

@Entity
@Table(name="device")
@Inheritance(strategy=InheritanceType.JOINED)
@Where(clause="conn_id is not null")
@CheckAtLeastOneNotNull(fieldNames={"connectionId", "connection"})
public class Device<TConnection extends Connection<?>, TFrame extends Frame<?, ?>>
extends SpaceBaseModel {
    @Size(max=255)
    protected String dsc;
    @Id
    @Column(name="device_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="deviceSeq")
    @GenericGenerator(name="deviceSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="device_seq"), @Parameter(name="increment_size", value="100")})
    protected Integer id;
    @JsonIgnore
    @ManyToOne(optional=false, targetEntity=Connection.class)
    @JoinColumn(name="conn_id")
    protected TConnection connection;
    @JsonIgnore
    @OneToMany(mappedBy="device", orphanRemoval=true, targetEntity=Frame.class)
    protected Set<TFrame> frames;
    @Column(name="conn_id", insertable=false, updatable=false)
    protected Integer connectionId;
    @NotBlank
    @Size(max=100)
    protected String name;

    public boolean equals(Object a) {
        Device a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Device)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Device)a;
        return a2.getConnectionId().equals(a.getConnectionId()) && a2.getName().equals(a.getName());
    }

    public void setName(String a) {
        a.name = a;
    }

    public int hashCode() {
        Device a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getConnectionId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setConnectionId(Integer a) {
        a.connectionId = a;
    }

    public Integer getId() {
        Device a;
        return a.id;
    }

    public Integer getConnectionId() {
        Device a;
        return a.connectionId;
    }

    public TConnection getConnection() {
        Device a;
        return (TConnection)a.connection;
    }

    public String getDsc() {
        Device a;
        return a.dsc;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public Device() {
        Device a;
        Device device = a;
        device.frames = new HashSet();
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setFrames(Set<TFrame> a) {
        a.frames = a;
    }

    public String getName() {
        Device a;
        return a.name;
    }

    public void setConnection(TConnection a) {
        Device a2;
        Device device = a2;
        device.connection = a;
        device.connectionId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Set<TFrame> getFrames() {
        Device a;
        return a.frames;
    }
}

