/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.cluster.services;

import com.inscada.mono.cluster.j.c_kba;
import com.inscada.mono.cluster.j.c_ska;
import com.inscada.mono.cluster.model.ClusterNodeInfo;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.cluster.services.JGroupsClusterNode;
import com.inscada.mono.settings.restcontrollers.MapSettingsController;
import com.inscada.mono.shared.aspects.SetSpaceIdAspect;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class JGroupsClusterNode
implements ClusterOperations {
    private static final short I = 1;
    private static final Logger M = LoggerFactory.getLogger(JGroupsClusterNode.class);
    private final Set<ClusterNodeListener> L;
    private final Map<Short, Pair<Object, Method>> i;
    private View d;
    private final RpcDispatcher c;
    private final ThreadPoolTaskExecutor D;
    private final ReadWriteLock H;
    private final JChannel m;
    private final Environment E;
    private static final String K = "inscada-cluster";
    private final String l;

    @EventListener(value={ContextRefreshedEvent.class})
    public void start() {
        try {
            JGroupsClusterNode a;
            M.info(SetSpaceIdAspect.m_rl((Object)"\u0018\"91\"$.\t$#.g0:k&?3.*;3\"),g?(k$$)%\"(3k3$g(+>4?\"9gl<6`k28.% k\r\f5$2;4k$#&%).+eie"), (Object)a.l, (Object)K);
            a.m.connect(K);
            Object[] objectArray = new Object[3];
            objectArray[0] = a.l;
            objectArray[1] = K;
            objectArray[2] = a.m.getAddressAsString();
            M.info(MapSettingsController.m_rl((Object)":\r\u001b\u001e\u0000\u000b\f&\u0006\f\fH\u0012\u0015I\u001b\u001c\u000b\n\r\u001a\u001b\u000f\u001d\u0005\u0004\u0010H\n\u0007\u0007\u0006\f\u000b\u001d\r\rH\u001d\u0007I\u000b\u0005\u001d\u001a\u001c\f\u001aIO\u0012\u0015NFI\".\u001a\u0006\u001d\u0019\u001bI)\r\f\u001b\r\u001a\u001bSH\u0012\u0015"), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_kba(SetSpaceIdAspect.m_rl((Object)"\u0001*.'\"/g?(k4?&93k\u0014.5=.(\"\u0005(/\"k&%#k$$)%\"(3k3$g(+>4?\"9"), (Throwable)exception);
        }
    }

    public boolean isLeader() {
        JGroupsClusterNode a;
        a.H.readLock().lock();
        try {
            boolean bl = a.m != null && a.m.isConnected() && a.d != null && Util.isCoordinator((JChannel)a.m);
            return bl;
        }
        finally {
            a.H.readLock().unlock();
        }
    }

    public void addListener(ClusterNodeListener a) {
        JGroupsClusterNode a2;
        JGroupsClusterNode jGroupsClusterNode = a2;
        jGroupsClusterNode.L.add(a);
        if (jGroupsClusterNode.isLeader()) {
            try {
                a2.D.execute(() -> ((ClusterNodeListener)a).leader());
                return;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[4];
                objectArray[0] = a2.l;
                objectArray[1] = a.getClass().getName();
                objectArray[2] = exception.getMessage();
                objectArray[3] = exception;
                M.error(MapSettingsController.m_rl((Object)"&\u0006\f\fH\u0012\u0015SH:\r\u001b\u001e\u0000\u000b\fH\u0007\u0007\r\rI\u0004\u0000\u001b\u001d\r\u0007\r\u001bH\u0012\u0015I\u000e\b\u0001\u0005\r\rH\r\u001d\u001b\u0001\u0007\u000fI\u0001\u0007\u0001\u001d\u0001\b\u0004I\u0004\f\t\r\r\u001bH\u0007\u0007\u001d\u0001\u000f\u0001\n\t\u001d\u0001\u0006\u0006SH\u0012\u0015"), objectArray);
            }
        }
    }

    public List<ClusterNodeInfo> getAllNodes() {
        JGroupsClusterNode a;
        JGroupsClusterNode jGroupsClusterNode = a;
        jGroupsClusterNode.H.readLock().lock();
        Object object = jGroupsClusterNode.d;
        try {
            if (object == null || object.getMembers() == null || object.getMembers().isEmpty()) {
                M.warn(SetSpaceIdAspect.m_rl((Object)"\u0005(/\"k<6}k\u0006?3.*;3.#k3$g,\"?g*+'g%(/\"8kk%>3k$>59\"%3k1\"\"<g\"4k)>+'g$5k\"&7?>eg\u0019\"?29)\"),g.*;32g'.83e"), (Object)a.l);
                List<ClusterNodeInfo> list = List.of();
                return list;
            }
            MethodCall methodCall = new MethodCall(1, new Object[0]);
            RequestOptions requestOptions = new RequestOptions(ResponseMode.GET_ALL, ((Long)a.E.getProperty(MapSettingsController.m_rl((Object)"\u0000\u0006\u001aF\n\u0004\u001c\u001b\u001d\r\u001bF\u001b\u0018\nF\u000e\r\u001dE\b\u0004\u0005E\u0007\u0007\r\r\u001aF\u001d\u0001\u0004\r\u0006\u001d\u001dE\u0004\u001b"), Long.class, (Object)10000L)).longValue(), true, null);
            M.debug(SetSpaceIdAspect.m_rl((Object)"\t$#.g0:qg\u0019\":2.4?.% k)$#.g\")-(k!9(&g*+'gc<6nk$'283.5k*.*)\"94e"), (Object)a.l, (Object)object.getMembers().size());
            object = a.c.callRemoteMethods(null, methodCall, requestOptions).getResults().stream().filter(Objects::nonNull).collect(Collectors.toList());
            Object[] objectArray = new Object[3];
            objectArray[0] = a.l;
            objectArray[1] = object.size();
            objectArray[2] = object;
            M.debug(MapSettingsController.m_rl((Object)"'\u0007\r\rI\u0013\u0014RI:\f\u000b\f\u0001\u001f\r\rH\u0012\u0015I\u001a\f\u001b\u0019\u0007\u0007\u001b\f\u001bI\u000e\u0006\u001aI\t\u0005\u0004I\u0006\u0006\f\fH\u0000\u0006\u000f\u0007SH\u0012\u0015"), objectArray);
            return object;
        }
        catch (Exception exception) {
            throw new c_ska("Node " + a.l + ": Failed to get all service node info", (Throwable)exception);
        }
        finally {
            a.H.readLock().unlock();
        }
    }

    public JGroupsClusterNode(Environment a42) throws Exception {
        JGroupsClusterNode a5;
        JGroupsClusterNode jGroupsClusterNode = a5;
        JGroupsClusterNode jGroupsClusterNode2 = a5;
        a5.H = new ReentrantReadWriteLock();
        jGroupsClusterNode2.L = ConcurrentHashMap.newKeySet();
        a5.i = new ConcurrentHashMap();
        jGroupsClusterNode.E = a42;
        Object[] objectArray = new Object[1];
        objectArray[0] = RandomStringUtils.randomAlphanumeric((int)6).toLowerCase();
        jGroupsClusterNode.l = a42.getProperty(MapSettingsController.m_rl((Object)"\u0001\u0007\u001bG\u0006\u0006\f\fF\u0000\f"), String.format(SetSpaceIdAspect.m_rl((Object)"\")8j%(/\"fb8"), objectArray));
        a5.m = new JChannel(MapSettingsController.m_rl((Object)"\u001c\n\u0018G\u0010\u0004\u0004"));
        a5.m.name(a5.l);
        a5.D = new ThreadPoolTaskExecutor();
        a5.D.setCorePoolSize(((Integer)a42.getProperty(SetSpaceIdAspect.m_rl((Object)"\")8i(+>4?\"9i97(i.?.$>3$5e$$5.j;($+f4\"=."), Integer.class, (Object)4)).intValue());
        a5.D.setMaxPoolSize(((Integer)a42.getProperty(MapSettingsController.m_rl((Object)"\u0000\u0006\u001aF\n\u0004\u001c\u001b\u001d\r\u001bF\u001b\u0018\nF\f\u0010\f\u000b\u001c\u001c\u0006\u001aG\u0005\b\u0010D\u0018\u0006\u0007\u0005E\u001a\u0001\u0013\r"), Integer.class, (Object)20)).intValue());
        a5.D.setQueueCapacity(((Integer)a42.getProperty(SetSpaceIdAspect.m_rl((Object)"\")8i(+>4?\"9i97(i.?.$>3$5e6>\">\"f$*7*$\"32"), Integer.class, (Object)1000)).intValue());
        JGroupsClusterNode jGroupsClusterNode3 = a5;
        jGroupsClusterNode3.D.setThreadNamePrefix(MapSettingsController.m_rl((Object)"\u0003\u000f\u001b\u0007\u001c\u0018\u001aE\u001b\u0018\nE\u0001\t\u0007\f\u0005\r\u001bE"));
        jGroupsClusterNode3.D.setWaitForTasksToCompleteOnShutdown(true);
        jGroupsClusterNode3.D.setAwaitTerminationSeconds(((Integer)a42.getProperty(SetSpaceIdAspect.m_rl((Object)".%4e$'283.5e5;$e\"3\"(2?(9i*0*.?j?\"9*\")*3\"(%j8\"((%#8"), Integer.class, (Object)10)).intValue());
        JGroupsClusterNode jGroupsClusterNode4 = a5;
        jGroupsClusterNode4.D.initialize();
        a5.c = new 1(a5, a5.m, (Object)a5);
        jGroupsClusterNode4.c.setMethodInvoker((a, a2, a3) -> {
            JGroupsClusterNode a4;
            a = (Pair)a4.i.get(a2);
            if (a == null) {
                throw new NoSuchMethodException("Method with id " + a2 + " not found on node " + a4.l);
            }
            Object object = a;
            a = object.getKey();
            return ((Method)object.getValue()).invoke(a, a3);
        });
        a5.c.setReceiver((Receiver)new 2(a5));
        try {
            a5.addRemoteCall((short)1, (Object)a5, JGroupsClusterNode.class.getDeclaredMethod(MapSettingsController.m_rl((Object)"\u000e\r\u001d+\u001c\u001a\u001b\r\u0007\u001c'\u0007\r\r \u0006\u000f\u0007 \u0006\u001d\r\u001b\u0006\b\u0004"), new Class[0]));
            return;
        }
        catch (NoSuchMethodException a42) {
            throw new IllegalStateException(SetSpaceIdAspect.m_rl((Object)"\r&\"+.#k3$g9\",.83.5k.%3.5%&'g,\"?\u0004>59\"%3\u0005(/\"\u0002)-(\u0002)?\"9)*+k*.3#(/g-(9g\u0019\u0017\b"), a42);
        }
    }

    public void removeRemoteCall(short a, Object a2, Method a3) {
        JGroupsClusterNode a4;
        if (a4.i.remove(a, ImmutablePair.of((Object)a2, (Object)a3))) {
            M.debug(MapSettingsController.m_rl((Object)"&\u0006\f\fH\u0012\u0015SH;\r\u0004\u0007\u001f\r\rH\u001b\r\u0004\u0007\u001d\rI\u000b\b\u0004\u0005H\u000f\u0007\u001bH\u0004\r\u001d\u0000\u0006\fI!-H\u0012\u0015"), (Object)a4.l, (Object)a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClusterNodeInfo getCurrentNodeInfoInternal() {
        JGroupsClusterNode a;
        a.H.readLock().lock();
        try {
            JGroupsClusterNode jGroupsClusterNode = a;
            String string = jGroupsClusterNode.E.getProperty(SetSpaceIdAspect.m_rl((Object)"! 9(>78i).%#\u0014&/#9"), MapSettingsController.m_rl((Object)"Y[_GXGXGY"));
            Integer n = (Integer)jGroupsClusterNode.E.getProperty(SetSpaceIdAspect.m_rl((Object)"'((&'i8\"91.5e7$5?"), Integer.class, (Object)0);
            boolean bl = a.m != null && a.m.isConnected() && a.d != null && Util.isCoordinator((JChannel)a.m);
            JGroupsClusterNode jGroupsClusterNode2 = a;
            String string2 = jGroupsClusterNode2.E.getProperty(MapSettingsController.m_rl((Object)"\u001b\u0019\u001a\u0000\u0006\u000eF\u001b\r\r\u0001\u001aF\u0001\u0007\u001a\u001c"), SetSpaceIdAspect.m_rl((Object)"'((&'/$4?"));
            Integer n2 = (Integer)jGroupsClusterNode2.E.getProperty(MapSettingsController.m_rl((Object)"\u001b\u0019\u001a\u0000\u0006\u000eF\u001b\r\r\u0001\u001aF\u0019\u0007\u001b\u001c"), Integer.class, (Object)6379);
            string = ClusterNodeInfo.builder().clusterName(K).nodeId(a.l).host(string).port(n).isLeader(Boolean.valueOf(bl)).redisHost(string2).redisPort(n2).build();
            return string;
        }
        finally {
            a.H.readLock().unlock();
        }
    }

    public void addRemoteCall(short a, Object a2, Method a5) {
        JGroupsClusterNode a6;
        a6.i.compute(a, (a3, a4) -> {
            if (a4 != null) {
                JGroupsClusterNode a5;
                Object[] objectArray = new Object[6];
                objectArray[0] = a5.l;
                objectArray[1] = a3;
                objectArray[2] = a4.getKey().getClass().getName();
                objectArray[3] = ((Method)a4.getValue()).getName();
                objectArray[4] = a2.getClass().getName();
                objectArray[5] = a5.getName();
                throw new IllegalStateException(String.format(SetSpaceIdAspect.m_rl((Object)"\t$#.gn4qg\u0006\"?/$#k\u000e\u000fgn#k.8g*+9\"*#2g9\",.83.5.#k!$5kb8in4eg\b&%)$3k5.j9\",.83.5k!$5kb8in4e"), objectArray));
            }
            a5.setAccessible(true);
            return ImmutablePair.of((Object)a2, (Object)a5);
        });
        Object[] objectArray = new Object[4];
        objectArray[0] = a6.l;
        objectArray[1] = a;
        objectArray[2] = a2.getClass().getSimpleName();
        objectArray[3] = a5.getName();
        M.debug(SetSpaceIdAspect.m_rl((Object)"\u0005(/\"k<6}k\u0015. \"4?\"9\"/g9\"&(?\"k$*+'g-(9g&\"?/$#k\u000e\u000fg0:kjug0:e<6"), objectArray);
    }

    public void removeListener(ClusterNodeListener a) {
        JGroupsClusterNode a2;
        a2.L.remove(a);
    }

    public ClusterNodeInfo getCurrentNode() {
        JGroupsClusterNode a;
        return a.getCurrentNodeInfoInternal();
    }

    private /* synthetic */ void callListeners(boolean a) {
        JGroupsClusterNode a2;
        for (ClusterNodeListener clusterNodeListener : a2.L) {
            block4: {
                if (!a) break block4;
                clusterNodeListener.leader();
            }
            try {
                clusterNodeListener.notLeader();
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[4];
                objectArray[0] = a2.l;
                objectArray[1] = clusterNodeListener.getClass().getName();
                objectArray[2] = exception.getMessage();
                objectArray[3] = exception;
                M.error(MapSettingsController.m_rl((Object)"'\u0007\r\rI\u0013\u0014RI;\f\u001a\u001f\u0001\n\rI\u0006\u0006\f\fH\u0005\u0001\u001a\u001c\f\u0006\f\u001aI\u0013\u0014H\u000f\t\u0000\u0004\f\fSH\u0012\u0015"), objectArray);
            }
        }
    }

    public <T> T callLeaderMethod(Short a, Object ... a2) {
        JGroupsClusterNode a3;
        JGroupsClusterNode jGroupsClusterNode = a3;
        jGroupsClusterNode.H.readLock().lock();
        View view = jGroupsClusterNode.d;
        try {
            if (view == null || view.getCoord() == null) {
                throw new c_kba("Node " + a3.l + ": Cannot call leader method ID " + a + ". Cluster view or coordinator is not yet available.");
            }
            MethodCall methodCall = new MethodCall(a.shortValue(), a2);
            RequestOptions requestOptions = new RequestOptions(ResponseMode.GET_FIRST, ((Long)a3.E.getProperty(SetSpaceIdAspect.m_rl((Object)".%4e$'283.5e5;$e+.&/\"9j(&'+e3\"*.(>3f*8"), Long.class, (Object)10000L)).longValue(), true, null);
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.l;
            objectArray[1] = a;
            objectArray[2] = view.getCoord();
            objectArray[3] = a2;
            M.debug(MapSettingsController.m_rl((Object)"'\u0007\r\rI\u0013\u0014RI+\b\u0004\u0005\u0001\u0007\u000fI\u0004\f\t\r\r\u001bH\u0004\r\u001d\u0000\u0006\fI!-H\u0012\u0015I\u0007\u0007H\n\u0007\u0006\u001a\r\u0001\u0007\t\u001d\u0007\u001bH\u0012\u0015I\u001f\u0000\u001c\u0001H\b\u001a\u000e\u001bSH\u0012\u0015"), objectArray);
            a2 = a3.c.callRemoteMethod(view.getCoord(), methodCall, requestOptions);
            return (T)a2;
        }
        catch (Exception exception) {
            throw new c_ska("Node " + a3.l + ": Error calling leader method ID " + a, (Throwable)exception);
        }
        finally {
            a3.H.readLock().unlock();
        }
    }

    @PreDestroy
    public void close() {
        JGroupsClusterNode a;
        M.info(SetSpaceIdAspect.m_rl((Object)"\u0018/>3?.% k#$0%g\u0018\"91\"$.\t$#.g0:eie"), (Object)a.l);
        Closeable[] closeableArray = new Closeable[2];
        closeableArray[0] = a.c;
        closeableArray[1] = a.m;
        Util.close((Closeable[])closeableArray);
        if (a.D != null) {
            M.info(MapSettingsController.m_rl((Object)":\u0000\u001c\u001c\u001d\u0001\u0007\u000fI\f\u0006\u001f\u0007H;8*H!\t\u0007\f\u0005\r\u001bH,\u0010\f\u000b\u001c\u001c\u0006\u001a:\r\u001b\u001e\u0000\u000b\fH\u000f\u0007\u001bH\u0007\u0007\r\rI\u0013\u0014FGF"), (Object)a.l);
            a.D.shutdown();
        }
        M.info(SetSpaceIdAspect.m_rl((Object)"\u0014.5=.(\"\u0005(/\"k<6g#&8g)\".)k4#2?g/(<)e"), (Object)a.l);
    }
}

