/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.auth.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.inscada.mono.auth.enums.c_nga;
import com.inscada.mono.auth.events.RevokeEvent;
import com.inscada.mono.auth.model.AuthSecret;
import com.inscada.mono.auth.model.AuthToken;
import com.inscada.mono.auth.repositories.AuthSecretRepository;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.impexp.model.ExtractedItem;
import com.inscada.mono.script.services.c_rd;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.user.model.User;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.security.Key;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPooled;

@Service
public class AuthTokenService
implements ClusterNodeListener {
    private final AuthSecretRepository f;
    @Value(value="${ins.accessToken.duration}")
    private long J;
    private static final long b = 5L;
    private final ScheduledExecutorService C;
    public static final short F = 10;
    private final ApplicationEventPublisher I;
    private static final long M = 15L;
    private static final Logger L = LoggerFactory.getLogger(AuthTokenService.class);
    private static final String i = "user_tokens:";
    private final ClusterOperations d;
    private final ObjectMapper c;
    @Value(value="${ins.jwt.secret}")
    private String D;
    private final SecretKey H;
    private volatile ScheduledFuture<?> m;
    private final JedisPooled E;
    @Value(value="${ins.refreshToken.duration}")
    private long K;
    private static final String l = "authtoken:";

    private /* synthetic */ Date toDate(LocalDateTime a) {
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        return Date.from(a.toInstant(zoneOffset));
    }

    private /* synthetic */ void expireTokenInRedis(String a, long a2) {
        AuthTokenService a3;
        if (a == null) {
            return;
        }
        a = l + (String)a;
        a3.E.expire((String)a, a2);
    }

    @PostConstruct
    public void initialize() throws NoSuchMethodException {
        AuthTokenService a;
        Class[] classArray = new Class[2];
        classArray[0] = Integer.class;
        classArray[1] = String.class;
        a.d.addRemoteCall((short)10, (Object)a, AuthTokenService.class.getDeclaredMethod(ExtractedItem.m_rl((Object)"`Mf^wZWPhZmLLQOZb[fM"), classArray));
        a.d.addListener((ClusterNodeListener)a);
    }

    public Map<c_nga, AuthToken> refresh(String a) {
        EnumMap<c_nga, AuthToken> enumMap;
        AuthTokenService a2;
        AuthToken authToken = a2.validate(a);
        if (authToken.getType() != c_nga.l) {
            throw new IllegalArgumentException(c_rd.m_rl((Object)"\u0000??0%8-q=>\"4'q=(94i7&#i#,7;4:9i>94;0=8&?g"));
        }
        AuthTokenService authTokenService = a2;
        authTokenService.expireTokenInRedis(a, 15L);
        a = authTokenService.generateAndStoreToken(authToken.getUserId(), authToken.getUsername(), c_nga.E);
        authToken = a2.generateAndStoreToken(authToken.getUserId(), authToken.getUsername(), c_nga.l);
        EnumMap<c_nga, AuthToken> enumMap2 = enumMap = new EnumMap<c_nga, AuthToken>(c_nga.class);
        enumMap.put(c_nga.E, (AuthToken)a);
        enumMap2.put(c_nga.l, authToken);
        return enumMap2;
    }

    public AuthToken validate(String a) {
        AuthTokenService a2;
        String string = l + a;
        String string2 = a2.E.get(string);
        if (string2 == null) {
            throw new c_ac(ExtractedItem.m_rl((Object)"WPhZm\u001fmPw\u001fePvQg\u001flM#Z{OjMf["));
        }
        try {
            string2 = (AuthToken)a2.c.readValue(string2, AuthToken.class);
        }
        catch (IOException iOException) {
            a2.E.del(string);
            throw new RuntimeException(c_rd.m_rl((Object)"\u0017(8%4-q=>i5,\",# 0%834i%&:,?i5(%("), iOException);
        }
        try {
            Jwts.parserBuilder().setSigningKey((Key)a2.H).build().parseClaimsJws(a);
            return string2;
        }
        catch (JwtException jwtException) {
            String string3 = string2;
            a2.deleteTokenFromRedis(a, string3.getUserId());
            if (string3.getType() == c_nga.l) {
                a2.revokeByTokenData((AuthToken)string2);
            }
            throw jwtException;
        }
    }

    private /* synthetic */ void startCleanupJob() {
        AuthTokenService a;
        if (a.m != null && !a.m.isDone()) {
            L.warn(ExtractedItem.m_rl((Object)"klTfQ#\\oZbQvO#Ul]#Vp\u001fbSqZb[z\u001fqJmQjQd\u0011#vdQlMjQd\u001fpKbMw\u001fqZrJfLw\u0011"));
            return;
        }
        L.info(c_rd.m_rl((Object)"\u0002=0;% ?.q=>\"4'q*=,0'$9q#>+q>8=9i0'q ?=4;'(=i>/q2,i< ?<%,\"g"), (Object)5L);
        a.m = a.C.scheduleWithFixedDelay(() -> {
            try {
                AuthTokenService a;
                Set set = a.E.keys(ExtractedItem.m_rl((Object)"JpZq`wPhZmL9\u0015"));
                for (String string : set) {
                    for (String string2 : a.E.smembers(string)) {
                        String string3 = l + string2;
                        if (a.E.exists(string3)) continue;
                        String[] stringArray = new String[1];
                        stringArray[0] = string2;
                        a.E.srem(string, stringArray);
                    }
                }
            }
            catch (Exception exception) {
                L.error(c_rd.m_rl((Object)"\u0005&:,?i2%4(?<!i;&3i7(8%4-"), (Throwable)exception);
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }

    private /* synthetic */ void revokeByTokenData(AuthToken a2) {
        AuthTokenService a3;
        if (a2 == null || a2.getUserId() == null) {
            return;
        }
        String string = i + a2.getUserId();
        Collection<Object> collection = a3.E.smembers(string);
        if (collection != null && !collection.isEmpty() && !(collection = collection.stream().map(a -> l + a).collect(Collectors.toList())).isEmpty()) {
            a3.E.del(collection.toArray(new String[0]));
        }
        a3.E.del(string);
        a3.I.publishEvent((ApplicationEvent)new RevokeEvent((Object)a3, a2.getUsername()));
    }

    private /* synthetic */ void deleteTokenFromRedis(String a, String a2) {
        AuthTokenService a3;
        if (a == null) {
            return;
        }
        String string = l + a;
        a3.E.del(string);
        if (a2 != null) {
            a2 = i + (String)a2;
            String[] stringArray = new String[1];
            stringArray[0] = a;
            a3.E.srem((String)a2, stringArray);
        }
    }

    public Map<c_nga, AuthToken> create(User a3) {
        AuthTokenService a2;
        if (a2.d.isLeader()) {
            return a2.createTokensOnLeader(a3.getId(), a3.getUsername());
        }
        L.debug(ExtractedItem.m_rl((Object)"EPoSlHfM#Ql[f\u001fgZoZd^wVmX#KlTfQ#\\qZbKjPm\u001fwP#Sf^gZq\u001fePq\u001fvLfM9\u001fxB"), (Object)a3.getUsername());
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3.getId();
            objectArray[1] = a3.getUsername();
            return (Map)a2.d.callLeaderMethod(Short.valueOf((short)10), objectArray);
        }
        catch (Exception a3) {
            throw new RuntimeException(c_rd.m_rl((Object)"\u000f0 =,5i%&q*#,0=4i%&:,?i' 0i\u0003\u0019\u0012i2(=%q=>i=,0-4;"), a3);
        }
    }

    public void notLeader() {
        AuthTokenService a;
        L.info(ExtractedItem.m_rl((Object)"WWjL#Ql[f\u001fjL#^#yLsOpTzQ\u0011#lwPsOjQd\u001fwPhZm\u001f`Sf^mJs\u001fiPa\u0011"));
        a.stopCleanupJob();
    }

    private /* synthetic */ AuthToken generateAndStoreToken(String a, String a2, c_nga a3) {
        LocalDateTime localDateTime;
        long l;
        AuthTokenService a4;
        Object object = LocalDateTime.now();
        if (a3 == c_nga.E) {
            l = TimeUnit.MINUTES.toSeconds(a4.J);
            localDateTime = object;
        } else {
            l = TimeUnit.DAYS.toSeconds(a4.K);
            localDateTime = object;
        }
        Object object2 = localDateTime.plusSeconds(l);
        object = Jwts.builder().setSubject(a2).setIssuedAt(a4.toDate((LocalDateTime)object)).setExpiration(a4.toDate((LocalDateTime)object2)).claim(c_rd.m_rl((Object)"<8-"), (Object)a).claim(ExtractedItem.m_rl((Object)"KzO"), (Object)a3.name()).signWith((Key)a4.H, SignatureAlgorithm.HS512).compact();
        object2 = l + (String)object;
        Object object3 = new AuthToken(a, a2, a3, Long.valueOf(l));
        try {
            AuthTokenService authTokenService = a4;
            object3 = authTokenService.c.writeValueAsString(object3);
            authTokenService.E.setex((String)object2, l, (String)object3);
            object2 = i + a;
            String[] stringArray = new String[1];
            stringArray[0] = object;
            a4.E.sadd((String)object2, stringArray);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException(c_rd.m_rl((Object)"\u0017(8%4-q=>i\"=>;4i%&:,?i5<4i%&q:4;8(= +(% >'q,#;>;"), jsonProcessingException);
        }
        object3 = new AuthToken(a, a2, a3, Long.valueOf(l));
        object3.setTokenValue((String)object);
        return object3;
    }

    private /* synthetic */ Map<c_nga, AuthToken> generateAndStoreTokens(String a, String a2) {
        AuthTokenService a3;
        AuthTokenService authTokenService = a3;
        AuthToken authToken = authTokenService.generateAndStoreToken(a, (String)a2, c_nga.E);
        a = authTokenService.generateAndStoreToken(a, (String)a2, c_nga.l);
        Object object = a2 = new EnumMap<c_nga, AuthToken>(c_nga.class);
        a2.put((c_nga)c_nga.E, authToken);
        object.put(c_nga.l, a);
        return object;
    }

    @PreDestroy
    public void shutdownCleanupJob() {
        AuthTokenService a;
        a.C.shutdown();
        try {
            if (!a.C.awaitTermination(10L, TimeUnit.SECONDS)) {
                a.C.shutdownNow();
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            a.C.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private /* synthetic */ void stopCleanupJob() {
        AuthTokenService a;
        if (a.m != null) {
            L.info(ExtractedItem.m_rl((Object)"lwPsOjQd\u001fwPhZm\u001f`Sf^mJs\u001fiPa\u0011"));
            a.m.cancel(false);
            a.m = null;
        }
    }

    public void leader() {
        AuthTokenService a;
        L.info(c_rd.m_rl((Object)"\u0005!8:q'>-4i9(\"i3,2&<,q=9,q\u0005\u0014\b\u0015\f\u0003gq\u001a%(#=8'6i%&:,?i2%4(?<!i;&3g"));
        a.startCleanupJob();
    }

    private /* synthetic */ SecretKey initSecretKey() {
        Object object;
        String string;
        AuthTokenService a;
        if (a.D != null && !a.D.isBlank()) {
            L.info(ExtractedItem.m_rl((Object)"VLjQd\u001fIhW\u001fBJwWfQwV`^wVlQ#lf\\qZw\u001feMlR#\\lQeVdJqZg\u001fsMlOfMwF,ZmIjMlQnZmK#IbMj^aSf\u0011"));
            string = a.D;
        } else {
            L.warn(c_rd.m_rl((Object)"\u0003\u0006\u001dq\b$=9,?=8*0=8&?i\u0002,2;4=qa4g6g}iv ?:\u007f#&=\u007f:4*#,%nq9#&!,#=(`q \"i?&%i2&?/8.$;4-\u007fi\u0017(=%8'6i3(2\"q=>i5(%(3(\",q%>&:<!g"));
            object = a.f.findFirstByOrderByIdAsc();
            if (object == null) {
                L.error(ExtractedItem.m_rl((Object)"|QvWv@~O\u0005#~vKk\u001fpZ`MfK#QlK#YlJm[#Vm\u001fg^w^a^pZ#ZjKkZq\u001e"));
                throw new c_ac(c_rd.m_rl((Object)"\b$=9i\",2;4=q'>=q/><?-q ?i4'' #&?$4'%i>;q-0=0+0:4g"));
            }
            string = object.getAuthSecretValue();
            L.info(ExtractedItem.m_rl((Object)"VLjQd\u001fIhW\u001fBJwWfQwV`^wVlQ#lf\\qZw\u001feMlR#[bKb]bLf\u0011"));
        }
        try {
            object = Base64.getDecoder().decode(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(c_rd.m_rl((Object)"\u001b\u001e\u0005i\u0010<%!4'% 2(% >'q\u001a4*#,%i8:q'>=q?0%8-q\u000b0:4\u007feg"), illegalArgumentException);
        }
        if (((AuthSecret)object).length < 64) {
            L.error(ExtractedItem.m_rl((Object)"@mJkJ|Bs9\u001fIhW\u001fBJwWfQwV`^wVlQ#lf\\qZw\u001fjL#KlP#LkPqK#YlM#wP\n2\r#\u0017nJpK#]f\u001f=\u0002#\t7\u001faFwZp\u001fbYwZq\u001fgZ`PgVmX*\u0011#{f\\l[f[#SfQdKk\u0005#D~\u001faFwZp\u0011"), (Object)((AuthSecret)object).length);
            throw new IllegalStateException(c_rd.m_rl((Object)"\u0003\u0006\u001dq\b$=9,?=8*0=8&?i\u0002,2;4=q \"i%&>i\"!>;%i7&#i\u0019\u001adxcg"));
        }
        Object object2 = object;
        return new SecretKeySpec((byte[])object2, 0, ((AuthSecret)object2).length, ExtractedItem.m_rl((Object)"KRb\\PwB\n2\r"));
    }

    public AuthTokenService(AuthSecretRepository a, JedisPooled a2, ObjectMapper a3, ApplicationEventPublisher a4, ClusterOperations a5) {
        AuthTokenService a6;
        AuthTokenService authTokenService = a6;
        AuthTokenService authTokenService2 = a6;
        a6.C = Executors.newSingleThreadScheduledExecutor();
        a6.f = a;
        authTokenService2.E = a2;
        authTokenService2.c = a3;
        a6.I = a4;
        authTokenService.d = a5;
        authTokenService.H = a6.initSecretKey();
    }

    public void revoke(User a2) {
        AuthTokenService a3;
        String string = i + a2.getId();
        Collection<Object> collection = a3.E.smembers(string);
        if (collection != null && !collection.isEmpty() && !(collection = collection.stream().map(a -> l + a).collect(Collectors.toList())).isEmpty()) {
            a3.E.del(collection.toArray(new String[0]));
        }
        a3.E.del(string);
        a3.I.publishEvent((ApplicationEvent)new RevokeEvent((Object)a3, a2.getUsername()));
    }

    protected Map<c_nga, AuthToken> createTokensOnLeader(Integer a, String a2) {
        AuthTokenService a3;
        return a3.generateAndStoreTokens(a.toString(), a2);
    }
}

