/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.restcontrollers;

import com.inscada.mono.animation.enums.c_nfa;
import com.inscada.mono.animation.j.c_jda;
import com.inscada.mono.animation.j.c_wea;
import com.inscada.mono.animation.messages.EvalAnimationMessage;
import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.animation.model.AnimationElement;
import com.inscada.mono.animation.model.AnimationScript;
import com.inscada.mono.animation.model.RunAnimScriptDto;
import com.inscada.mono.broadcast.model.BroadcastOperationResponse;
import com.inscada.mono.communication.protocols.mqtt.model.MqttMessage;
import com.inscada.mono.impexp.c.c_am;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.z.c_nn;
import com.inscada.mono.project.j.c_tm;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/animations"})
public class AnimationController
extends ProjectBasedImportExportController {
    private final c_jda K;
    private final c_wea l;

    @MessageMapping(value={"/run-animation-script"})
    public void runAnimationScript(@Payload RunAnimScriptDto runAnimScriptDto, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.K.m_wjc(runAnimScriptDto, a.getName(), sessionId);
    }

    @PutMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody AnimationElement a) {
        this.l.m_kfc(animationId, elementId, a);
    }

    @DeleteMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        this.l.m_bdc(animationId, a);
    }

    @MessageMapping(value={"/eval-animation"})
    public void animationResultMessage(@Payload EvalAnimationMessage evalAnimationMessage, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.K.m_dic(evalAnimationMessage, a.getName(), sessionId);
    }

    @GetMapping(value={"/name/elements"}, params={"name", "type"})
    public AnimationElement getAnimationElementByNameAndType(@RequestParam(name="name") String name, @RequestParam(name="type") c_nfa a) {
        return this.l.m_lcc(name, a);
    }

    @PutMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimation(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody Animation a) {
        this.l.m_vcc(animationId, a);
    }

    @DeleteMapping(value={"/{animationId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElementsByIds(@PathVariable(value="animationId") Integer animationId, @RequestParam(value="elementIds") Integer[] a) {
        this.l.m_lxb(animationId, a);
    }

    @GetMapping(value={"/{animationId}/elements/{elementId}"})
    public AnimationElement getAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        return this.l.m_eba(animationId, a);
    }

    @GetMapping(value={"/{animationId}/scripts/{scriptId}"})
    public AnimationScript getAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        return this.l.m_sbc(animationId, a);
    }

    @GetMapping(value={"/project/{projectId}"}, params={"name"})
    public Animation getAnimationByProjectId(@PathVariable(value="projectId") Integer projectId, @RequestParam(name="name") String a) {
        return this.l.m_jk(projectId, a);
    }

    @GetMapping(value={"/project"}, params={"projectName", "name"})
    public Animation getAnimationByProjectName(@RequestParam(name="projectName") String projectName, @RequestParam(name="name") String a) {
        return this.l.m_hbc(projectName, a);
    }

    @GetMapping(value={"/{animationId}/elements"})
    public Collection<AnimationElement> getAnimationElements(@PathVariable(value="animationId") Integer a) {
        return this.l.m_afa(a);
    }

    @PutMapping(value={"/{animationId}/placeholders"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updatePlaceholders(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.l.m_pac(animationId, a);
    }

    @PostMapping(value={"/{animationId}/clone"}, params={"name"})
    public ResponseEntity<Animation> cloneAnimation(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        animationId = this.l.m_fea(animationId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = animationId.getId();
        return ResponseEntity.created((URI)a.path(BroadcastOperationResponse.m_rl((Object)"4SzFrEz\\rGua\u007fU")).buildAndExpand(objectArray).toUri()).body((Object)animationId);
    }

    @PostMapping(value={"/{animationId}/elements"})
    public ResponseEntity<AnimationElement> createAnimationElement(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationElement animationElement, UriComponentsBuilder a) {
        animationElement = this.l.m_fub(animationId, animationElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationElement.getId();
        return ResponseEntity.created((URI)a.path(MqttMessage.m_rl((Object)"\u0014EZPRSZJRQUw_C\u0014[W[V[UJH\u0011@[W[V[UJrZF")).buildAndExpand(objectArray).toUri()).body((Object)animationElement);
    }

    @PostMapping(value={"/{animationId}/scripts"})
    public ResponseEntity<AnimationScript> createAnimationScript(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationScript animationScript, UriComponentsBuilder a) {
        animationScript = this.l.m_pec(animationId, animationScript);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationScript.getId();
        return ResponseEntity.created((URI)a.path(BroadcastOperationResponse.m_rl((Object)"\u0007`IuAvIoAtFRLf\u0007hKiAk\\h\u0007`[xZrXoa\u007fU")).buildAndExpand(objectArray).toUri()).body((Object)animationScript);
    }

    @PostMapping
    public ResponseEntity<Animation> createAnimation(@Valid @RequestBody Animation animation, UriComponentsBuilder a) {
        animation = this.l.m_iub(animation);
        Object[] objectArray = new Object[1];
        objectArray[0] = animation.getId();
        return ResponseEntity.created((URI)a.path(MqttMessage.m_rl((Object)"\u0011@_UWV_OWTPrZF")).buildAndExpand(objectArray).toUri()).body((Object)animation);
    }

    @GetMapping
    public Collection<Animation> getAnimations(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_ta();
        }
        return this.l.m_ra(a);
    }

    public AnimationController(c_wea a, c_jda a2, c_am a3, c_tm a4) {
        AnimationController a5;
        AnimationController animationController = a5;
        super(a3, EnumSet.of(c_nn.M), a4);
        animationController.l = a;
        animationController.K = a2;
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Animation> getAnimationsByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.l.m_kia(projectId, a);
    }

    @GetMapping(value={"/{animationId}"})
    public Animation getAnimation(@PathVariable(value="animationId") Integer a) {
        return this.l.m_la(a);
    }

    @GetMapping(value={"/{animationId}/scripts"})
    public Collection<AnimationScript> getAnimationScripts(@PathVariable(value="animationId") Integer a) {
        return this.l.m_cwb(a);
    }

    @DeleteMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimation(@PathVariable(value="animationId") Integer a) {
        this.l.m_ma(a);
    }

    @PutMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer scriptId, @Valid @RequestBody AnimationScript a) {
        this.l.m_uyb(animationId, scriptId, a);
    }

    @GetMapping(value={"/{animationId}/svg"})
    public ResponseEntity<InputStreamResource> getAnimationSvg(@PathVariable(value="animationId") Integer a) {
        a = this.l.m_yb(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(BroadcastOperationResponse.m_rl((Object)"ktFoMu\\6lr[kGhAoAtF"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)MqttMessage.m_rl((Object)"RSZY^\u0011HH\\\u0015CSW"))).body((Object)byteArrayInputStream);
    }

    @DeleteMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        this.l.m_pja(animationId, a);
    }

    @GetMapping(value={"/{animationId}/elements"}, params={"type"})
    public Collection<AnimationElement> getAnimationElementsByType(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="type") c_nfa a) {
        return this.l.m_lwb(animationId, a);
    }

    @PutMapping(value={"/{animationId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationSvg(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.l.m_sea(animationId, a);
    }

    @DeleteMapping(value={"/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="elementId") Integer a) {
        this.l.m_kec(a);
    }
}

