/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmGroupChangeEvent;
import com.inscada.mono.alarm.events.AlarmGroupDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.repositories.AlarmGroupRepository;
import com.inscada.mono.datasource.influxdb.restcontrollers.CustomInfluxDBDatabaseController;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.services.c_rd;
import com.inscada.mono.script.services.c_ti;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_lf;
import com.inscada.mono.shared.exceptions.c_mc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@EnableSpaceFilter
public class c_sha {
    private final c_tm H;
    private final AlarmGroupRepository m;
    private static final String[] E;
    private final c_ti K;
    private final ApplicationEventPublisher l;

    @Order(value=4)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_hi(ProjectDeleteEvent a) {
        c_sha a2;
        a2.m_qa(a.getProject().getId());
    }

    public void m_aoc(AlarmGroup a) {
        c_sha a2;
        c_sha c_sha2 = a2;
        c_sha2.m_inc(a);
        c_sha2.m_vkc(a);
    }

    @DisableSpaceFilter
    public AlarmGroup m_wl(Integer a) {
        c_sha a2;
        AlarmGroup alarmGroup = a2.m_la(a);
        if (alarmGroup == null) {
            throw new c_ac("Alarm group not found with id of " + a);
        }
        return alarmGroup;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_zmc(List<Integer> a2) {
        c_sha a3;
        if (!(a2 = a3.m.findAllById(a2)).isEmpty()) {
            c_sha c_sha2 = a3;
            List list = a2;
            c_sha2.m.deleteInBatch((Iterable)list);
            list.forEach(a -> {
                c_sha a2;
                Set set = a.getAlarms();
                if (!set.isEmpty()) {
                    throw new c_mc("Alarm group deletion failed. Alarm exists: " + ((Alarm)set.iterator().next()).getName());
                }
                a2.l.publishEvent((ApplicationEvent)new AlarmGroupDeleteEvent((Object)a2, a));
            });
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP') and hasAuthority('CREATE_ALARM_GROUP')")
    public void m_apc(AlarmGroup a, boolean a2) {
        AlarmGroup alarmGroup;
        c_sha a3;
        AlarmGroup alarmGroup2 = a;
        a3.m_inc(alarmGroup2);
        if ((alarmGroup2.getId() != null ? (alarmGroup = a3.m_la(a.getId())) : (alarmGroup = a3.m_jk(a.getProjectId(), a.getName()))) != null) {
            a3.m_gkc(a, alarmGroup, a2);
            return;
        }
        c_sha c_sha2 = a3;
        c_sha2.m_vkc(a);
        c_sha2.m.save((Object)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_yb(Integer a) {
        c_sha a2;
        AlarmGroup alarmGroup = a2.m_la(a);
        if (alarmGroup == null) {
            throw new c_ac("Alarm group not found with id of " + a);
        }
        return alarmGroup;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_la(Integer a) {
        c_sha a2;
        return a2.m.findById((Object)a).orElse(null);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_jk(Integer a, String a2) {
        c_sha a3;
        return a3.m.findOneByProjectIdAndName(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_qa(Integer a) {
        if (a != null) {
            c_sha a2;
            a2.m.deleteByProjectId(a);
        }
    }

    private /* synthetic */ void m_vkc(AlarmGroup a) {
        if (a.getOnScript() != null && !a.getOnScript().getProject().equals((Object)a.getProject())) {
            throw new c_lf(CustomInfluxDBDatabaseController.m_rl((Object)"1M\u0011S\u001d\u0001\u0017S\u001fT\u0000\u0001\u0000S\u001fK\u0015B\u0004\u0001\u0011O\u0014\u0001\u001fOPR\u0013S\u0019Q\u0004\u0001\u0000S\u001fK\u0015B\u0004\u0001\u001dT\u0003UPL\u0011U\u0013I"));
        }
        if (a.getOffScript() != null && !a.getOffScript().getProject().equals((Object)a.getProject())) {
            throw new c_lf(c_rd.m_rl((Object)"\b=(#$q.#&$9q9#&;,2=q(?-q&7/q:2;89%i!;>#4*%i<<\"=q$0=2!"));
        }
        if (a.getAckScript() != null && !a.getAckScript().getProject().equals((Object)a.getProject())) {
            throw new c_lf(CustomInfluxDBDatabaseController.m_rl((Object)"`\u001c@\u0002LPF\u0002N\u0005QPQ\u0002N\u001aD\u0013UP@\u001eEP@\u0013JPR\u0013S\u0019Q\u0004\u0001\u0000S\u001fK\u0015B\u0004\u0001\u001dT\u0003UPL\u0011U\u0013I"));
        }
    }

    @DisableSpaceFilter
    public Collection<AlarmGroup> m_nf(Integer a) {
        c_sha a2;
        if ((a = a2.m.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP') and hasAuthority('CREATE_ALARM_GROUP')")
    public void m_so(List<AlarmGroup> a2, boolean a3) {
        c_sha a4;
        a2.forEach(a -> {
            RepeatableScript repeatableScript;
            c_sha a2;
            if (a.getProject() == null) {
                AlarmGroup alarmGroup = a;
                alarmGroup.setProject(a2.H.m_yb(alarmGroup.getProjectId()));
            }
            if (a.getOnScript() == null && a.getOnScriptId() != null) {
                repeatableScript = a2.K.m_yb(a.getOnScriptId());
                a.setOnScript(repeatableScript);
            }
            if (a.getOffScript() == null && a.getOffScriptId() != null) {
                repeatableScript = a2.K.m_yb(a.getOffScriptId());
                a.setOffScript(repeatableScript);
            }
            if (a.getAckScript() == null && a.getAckScriptId() != null) {
                repeatableScript = a2.K.m_yb(a.getAckScriptId());
                a.setAckScript(repeatableScript);
            }
        });
        Object object = a2.stream().map(AlarmGroup::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.m.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(AlarmGroup::getProjectId, Collectors.mapping(AlarmGroup::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_sha a2;
            return a2.m.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(AlarmGroup::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<AlarmGroup> arrayList = new ArrayList<AlarmGroup>();
        HashSet<AlarmGroup> hashSet = new HashSet<AlarmGroup>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a2.next();
            if ((alarmGroup.getId() != null ? (AlarmGroup)map.get(alarmGroup.getId()) : (AlarmGroup)object.get(ImmutablePair.of((Object)alarmGroup.getProjectId(), (Object)alarmGroup.getName()))) != null) {
                AlarmGroup alarmGroup2;
                AlarmGroup alarmGroup3 = alarmGroup2;
                a4.m_gkc(alarmGroup, alarmGroup3, false);
                hashSet.add(alarmGroup3);
                arrayList.add(alarmGroup2);
                continue;
            }
            a4.m_vkc(alarmGroup);
            arrayList.add(alarmGroup);
        }
        a4.m.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_sha a2;
                a2.l.publishEvent((ApplicationEvent)new AlarmGroupChangeEvent((Object)a2, a));
            });
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_ta() {
        c_sha a;
        return a.m.findAll();
    }

    public c_sha(c_tm a, c_ti a2, AlarmGroupRepository a3, ApplicationEventPublisher a4) {
        c_sha a5;
        c_sha c_sha2 = a5;
        c_sha c_sha3 = a5;
        c_sha3.H = a;
        c_sha3.K = a2;
        c_sha2.m = a3;
        c_sha2.l = a4;
    }

    private /* synthetic */ void m_gkc(AlarmGroup a, AlarmGroup a2, boolean a3) {
        c_sha a4;
        AlarmGroup alarmGroup = a2;
        a4.m_inc(a);
        BeanUtils.copyProperties((Object)a, (Object)alarmGroup, (String[])E);
        a4.m_vkc(alarmGroup);
        if (a3) {
            a4.l.publishEvent((ApplicationEvent)new AlarmGroupChangeEvent((Object)a4, a2));
        }
    }

    @DisableSpaceFilter
    public Collection<AlarmGroup> m_dqc(Set<Integer> a) {
        c_sha a2;
        if ((a = a2.m.findAllById(a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_voc(Set<Integer> a) {
        c_sha a2;
        if ((a = a2.m.findAllById(a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = c_rd.m_rl((Object)"8-");
        stringArray[1] = CustomInfluxDBDatabaseController.m_rl((Object)"R\u0000@\u0013D");
        stringArray[2] = c_rd.m_rl((Object)"9#&;,2=");
        stringArray[3] = CustomInfluxDBDatabaseController.m_rl((Object)"\u0011M\u0011S\u001dR");
        stringArray[4] = c_rd.m_rl((Object)"*#,0=4-\u00130");
        stringArray[5] = CustomInfluxDBDatabaseController.m_rl((Object)"\u0013S\u0015@\u0004H\u001fO4@\u0004D");
        stringArray[6] = c_rd.m_rl((Object)"=(\"=\u001c&5 7 4-\u00130");
        stringArray[7] = CustomInfluxDBDatabaseController.m_rl((Object)"\u001c@\u0003U=N\u0014H\u0016H\u0015E4@\u0004D");
        E = stringArray;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_ma(Integer a) {
        c_sha a2;
        if ((a = a2.m_la(a)) != null) {
            Set set = a.getAlarms();
            if (!set.isEmpty()) {
                throw new c_mc("Alarm group deletion failed. Alarm exists: " + ((Alarm)set.iterator().next()).getName());
            }
            c_sha c_sha2 = a2;
            c_sha2.m.delete((Object)a);
            c_sha2.l.publishEvent((ApplicationEvent)new AlarmGroupDeleteEvent((Object)a2, (AlarmGroup)a));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_ALARM_GROUP')")
    public AlarmGroup m_dlc(AlarmGroup a) {
        c_sha a2;
        c_sha c_sha2 = a2;
        c_sha2.m_aoc(a);
        return (AlarmGroup)c_sha2.m.save((Object)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_ra(Integer a) {
        c_sha a2;
        if ((a = a2.m.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @DisableSpaceFilter
    public AlarmGroup m_jnc(Integer a) {
        c_sha a2;
        return a2.m.findById((Object)a).orElse(null);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_xk(Integer a, String a2) {
        c_sha a3;
        if ((a = a3.m_jk(a, a2)) == null) {
            throw new c_ac("Alarm group not found with name of " + a2);
        }
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP')")
    public void m_lqc(Integer a, AlarmGroup a2) {
        c_sha a3;
        c_sha c_sha2 = a3;
        a = c_sha2.m_yb(a);
        c_sha2.m_gkc(a2, (AlarmGroup)a, true);
    }
}

