/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.model.AnalogAlarm;
import com.inscada.mono.alarm.model.DigitalAlarm;
import com.inscada.mono.alarm.repositories.AlarmRepository;
import com.inscada.mono.alarm.services.c_sha;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_oca;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_lf;
import com.inscada.mono.user.j.c_ha;
import com.inscada.mono.user.j.c_na;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@EnableSpaceFilter
public abstract class c_rea<T extends Alarm> {
    protected final c_sha D;
    protected final c_oca H;
    protected final ApplicationEventPublisher m;
    protected final AlarmRepository<T> E;
    protected final c_tm K;
    protected static final String[] l;

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_so(List<T> a2, boolean a3) {
        c_rea a4;
        a2.forEach(arg_0 -> a4.m_vqc(arg_0));
        Object object = a2.stream().map(Alarm::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.E.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(Alarm::getProjectId, Collectors.mapping(Alarm::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_rea a2;
            return a2.E.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(Alarm::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<Alarm> arrayList = new ArrayList<Alarm>();
        HashSet<Alarm> hashSet = new HashSet<Alarm>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Alarm alarm = (Alarm)a2.next();
            if ((alarm.getId() != null ? (Alarm)map.get(alarm.getId()) : (Alarm)object.get(ImmutablePair.of((Object)alarm.getProjectId(), (Object)alarm.getName()))) != null) {
                Alarm alarm2;
                Alarm alarm3 = alarm2;
                a4.m_nnc(alarm, alarm3, false);
                hashSet.add(alarm3);
                arrayList.add(alarm2);
                continue;
            }
            a4.m_woc(alarm);
            arrayList.add(alarm);
        }
        a4.E.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_rea a2;
                a2.m.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a2, a));
            });
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_ALARM')")
    public T m_ihc(T a) {
        c_rea a2;
        c_rea c_rea2 = a2;
        c_rea2.m_ckc(a);
        a = (Alarm)c_rea2.E.save(a);
        a2.m.publishEvent((ApplicationEvent)new AlarmAddEvent((Object)a2, a));
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_rjc(Integer a, String a2) {
        c_rea a3;
        return a3.E.findByGroupName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_ra(Integer a) {
        c_rea a2;
        return a2.E.findByProjectId(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_zhc(Integer a) {
        c_rea a2;
        return a2.E.findByGroupIdAndIsActiveTrue(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_sna(Integer a, Pageable a2) {
        c_rea a3;
        return a3.E.findByProjectId(a, a2);
    }

    protected void m_vqc(T a) {
        Variable variable;
        c_rea a2;
        if (a.getProject() == null) {
            T t = a;
            t.setProject(a2.K.m_yb(t.getProjectId()));
        }
        if (a.getGroup() == null) {
            T t = a;
            t.setGroup(a2.D.m_yb(t.getGroupId()));
        }
        if (a.getOnTimeVariable() == null && a.getOnTimeVariableId() != null) {
            variable = a2.H.m_yb(a.getOnTimeVariableId());
            a.setOnTimeVariable(variable);
        }
        if (a.getOffTimeVariable() == null && a.getOffTimeVariableId() != null) {
            variable = a2.H.m_yb(a.getOffTimeVariableId());
            a.setOffTimeVariable(variable);
        }
        if (a instanceof DigitalAlarm) {
            Variable variable2;
            variable = (DigitalAlarm)a;
            if (variable.getVariableA() == null) {
                variable2 = a2.H.m_yb(variable.getVariableAId());
                variable.setVariableA(variable2);
            }
            if (variable.getVariableB() == null && variable.getVariableBId() != null) {
                variable2 = a2.H.m_yb(variable.getVariableBId());
                variable.setVariableB(variable2);
                return;
            }
        } else if (a instanceof AnalogAlarm && (variable = (AnalogAlarm)a).getVariable() == null) {
            Variable variable3 = a2.H.m_yb(variable.getVariableId());
            variable.setVariable(variable3);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_mhc(Integer a, String[] a2) {
        c_rea a3;
        return a3.E.findByProjectIdAndNameIn(a, Arrays.stream(a2).collect(Collectors.toSet()));
    }

    @DisableSpaceFilter
    public Collection<T> m_nf(Integer a) {
        c_rea a2;
        return a2.E.findByProjectId(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_pnc(AlarmFilter a, Pageable a2) {
        c_rea a3;
        return a3.E.findAlarmsByFilter(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_yb(Integer a) {
        c_rea a2;
        Alarm alarm = a2.m_la(a);
        if (alarm == null) {
            throw new c_ac("Alarm not found with id of " + a);
        }
        return (T)alarm;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_roc(List<Integer> a2) {
        c_rea a3;
        c_rea c_rea2 = a3;
        a2 = c_rea2.m_tic(a2);
        c_rea2.E.deleteInBatch(a2);
        a2.forEach(a -> {
            c_rea a2;
            a2.m.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_xk(Integer a, String a2) {
        c_rea a3;
        Alarm alarm = a3.m_jk(a, a2);
        if (alarm == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_ac(String.format(c_na.m_rl((Object)"=\n\u001d\u0014\u0011F\u0012\t\bF\u001a\t\t\b\u0018\\\\\u0016\u000e\t\u0016\u0003\u001f\u0012\\\u000f\u0018\\\\C\u0018J\\\b\u001d\u000b\u0019\\\\C\u000f"), objectArray));
        }
        return (T)alarm;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_tic(Collection<Integer> a) {
        c_rea a2;
        return a2.E.findAllById(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_ma(Integer a) {
        c_rea a2;
        if ((a = a2.m_la(a)) != null) {
            c_rea c_rea2 = a2;
            c_rea2.E.delete((Object)a);
            c_rea2.m.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, (Alarm)a));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_ahc(T a, boolean a2) {
        Alarm alarm;
        c_rea a3;
        T t = a;
        a3.m_vqc(t);
        if ((t.getId() != null ? (alarm = a3.m_la(a.getId())) : (alarm = a3.m_jk(a.getProjectId(), a.getName()))) != null) {
            a3.m_nnc(a, alarm, a2);
            return;
        }
        c_rea c_rea2 = a3;
        c_rea2.m_woc(a);
        c_rea2.E.save(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_ta() {
        c_rea a;
        return a.E.findAll();
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_qa(Integer a) {
        if (a != null) {
            c_rea a2;
            a2.E.deleteByProjectId(a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_qga(Pageable a) {
        c_rea a2;
        return a2.E.findAll(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_la(Integer a) {
        c_rea a2;
        return (T)((Alarm)a2.E.findById((Object)a).orElse(null));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<String> m_nhc(Integer a) {
        c_rea a2;
        return a2.E.findDistinctPartsByProjectId(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM')")
    public void m_tpc(Integer a, T a2) {
        c_rea a3;
        c_rea c_rea2 = a3;
        a = c_rea2.m_yb(a);
        c_rea2.m_nnc(a2, (Alarm)a, true);
    }

    @DisableSpaceFilter
    public T m_jnc(Integer a) {
        c_rea a2;
        return (T)((Alarm)a2.E.findById((Object)a).orElse(null));
    }

    protected void m_woc(T a) {
        AnalogAlarm analogAlarm;
        if (!a.getGroup().getProject().equals((Object)a.getProject())) {
            throw new c_lf(c_ha.m_rl((Object)"B1b/n}d/l(s}s/l7f>w}b3g}b1b/n}s/l7f>w}n(p)#0b)`5"));
        }
        if (a.getOnTimeVariable() != null && !a.getOnTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_lf(c_na.m_rl((Object)"=\n\u001d\u0014\u0011F\f\u0014\u0013\f\u0019\u0005\bF\u001d\b\u0018F\n\u0007\u000e\u000f\u001d\u0004\u0010\u0003\\\u0016\u000e\t\u0016\u0003\u001f\u0012\\\u000b\t\u0015\bF\u0011\u0007\b\u0005\u0014"));
        }
        if (a.getOffTimeVariable() != null && !a.getOffTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_lf(c_ha.m_rl((Object)"\u001co<q0#-q2i8`)#<m9#+b/j<a1f}s/l7f>w}n(p)#0b)`5"));
        }
        if (a instanceof DigitalAlarm) {
            DigitalAlarm digitalAlarm = (DigitalAlarm)a;
            if (!digitalAlarm.getVariableA().getProject().equals((Object)a.getProject())) {
                throw new c_lf(c_na.m_rl((Object)"=\n\u001d\u0014\u0011F\f\u0014\u0013\f\u0019\u0005\bF\u001d\b\u0018F\n\u0007\u000e\u000f\u001d\u0004\u0010\u0003\\\u0016\u000e\t\u0016\u0003\u001f\u0012\\\u000b\t\u0015\bF\u0011\u0007\b\u0005\u0014"));
            }
            if (digitalAlarm.getVariableB() != null && !digitalAlarm.getVariableB().getProject().equals((Object)a.getProject())) {
                throw new c_lf(c_ha.m_rl((Object)"\u001co<q0#-q2i8`)#<m9#+b/j<a1f}s/l7f>w}n(p)#0b)`5"));
            }
        } else if (a instanceof AnalogAlarm && !(analogAlarm = (AnalogAlarm)a).getVariable().getProject().equals((Object)a.getProject())) {
            throw new c_lf(c_na.m_rl((Object)"=\n\u001d\u0014\u0011F\f\u0014\u0013\f\u0019\u0005\bF\u001d\b\u0018F\n\u0007\u000e\u000f\u001d\u0004\u0010\u0003\\\u0016\u000e\t\u0016\u0003\u001f\u0012\\\u000b\t\u0015\bF\u0011\u0007\b\u0005\u0014"));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_jk(Integer a, String a2) {
        c_rea a3;
        return (T)a3.E.findOneByProjectIdAndName(a, a2);
    }

    private /* synthetic */ void m_nnc(T a, T a2, boolean a3) {
        c_rea a4;
        if (!a.getClass().equals(a2.getClass())) {
            throw new c_lf(c_ha.m_rl((Object)"B1b/n}w$s8p}p5l(o9#?f}p<n8"));
        }
        T t = a2;
        a4.m_vqc(a);
        BeanUtils.copyProperties(a, t, (String[])l);
        a4.m_woc(t);
        if (a3) {
            a4.m.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a4, a2));
        }
    }

    protected c_rea(c_tm a, c_sha a2, AlarmRepository<T> a3, c_oca a4, ApplicationEventPublisher a5) {
        c_rea a6;
        c_rea c_rea2 = a6;
        c_rea c_rea3 = a6;
        a6.K = a;
        c_rea3.D = a2;
        c_rea3.E = a3;
        c_rea2.H = a4;
        c_rea2.m = a5;
    }

    public void m_ckc(T a) {
        c_rea a2;
        c_rea c_rea2 = a2;
        c_rea2.m_vqc(a);
        c_rea2.m_woc(a);
    }

    @Order(value=3)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_hi(ProjectDeleteEvent a) {
        c_rea a2;
        a2.m_qa(a.getProject().getId());
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = c_na.m_rl((Object)"\u000f\u0018");
        stringArray[1] = c_ha.m_rl((Object)".s<`8");
        stringArray[2] = c_na.m_rl((Object)"\f\u0014\u0013\f\u0019\u0005\b");
        stringArray[3] = c_ha.m_rl((Object)":q2v-");
        stringArray[4] = c_na.m_rl((Object)"\u001f\u0014\u0019\u0007\b\u0003\u0018$\u0005");
        stringArray[5] = c_ha.m_rl((Object)"`/f<w4l3G<w8");
        stringArray[6] = c_na.m_rl((Object)"\n\u001d\u0015\b+\u0013\u0002\u0015\u0000\u0015\u0003\u0018$\u0005");
        stringArray[7] = c_ha.m_rl((Object)"o<p)N2g4e4f9G<w8");
        l = stringArray;
    }
}

