/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.events.AlarmGroupChangeEvent;
import com.inscada.mono.alarm.events.AlarmGroupDeleteEvent;
import com.inscada.mono.alarm.j.c_lga;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.services.c_bea;
import com.inscada.mono.alarm.services.c_faa;
import com.inscada.mono.alarm.services.c_gaa;
import com.inscada.mono.alarm.services.c_sha;
import com.inscada.mono.auth.c_zia;
import com.inscada.mono.cluster.j.c_ska;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.config.AuditConfig;
import com.inscada.mono.datasource.sql.model.metadata.FunctionMetadata;
import com.inscada.mono.log.services.c_bd;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_sk;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener {
    private final c_sha h;
    private final c_gaa f;
    public static final short J = 103;
    public static final short b = 107;
    private final JedisPooled C;
    public static final short F = 108;
    private final ClusterOperations I;
    public static final short M = 104;
    private static final String L = "activeAlarmGroups";
    private final c_bd i;
    private final Lock d;
    private static final Logger c = LoggerFactory.getLogger(AlarmManager.class);
    public static final short D = 102;
    public static final short H = 106;
    private final c_faa m;
    public static final short E = 105;
    public static final short K = 101;
    public static final short l = 109;

    protected Map<Integer, c_lga> getAlarmGroupStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.h.m_nf((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroup::getId, arg_0 -> a2.getAlarmGroupStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_lga getAlarmGroupStatus(Integer a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.debug(AuditConfig.m_rl((Object)"R9_8[.$\\Y\u0019j\bw\u0012y\\\u007f\u0010\u007f\u000es\\y\u000eq\tn\\m\b\u007f\bk\u000f>\u001aq\u000e>\u0007c\\r\u0013}\u001dr\u0010gR"), (Object)a);
            return a2.getAlarmGroupStatusInternal(a);
        }
        c.debug(FunctionMetadata.m_rl((Object)"u&uDw,z-~;\u0001Ii\fJ\u001c^\u001aO\u0000U\u000e\u001b\u0005^\b_\fII]\u0006IIZ\u0005Z\u001bVI\\\u001bT\u001cKIH\u001dZ\u001dN\u001a\u001b\u000fT\u001b\u001b\u0012FG"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_lga)a2.I.callLeaderMethod(Short.valueOf((short)104), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get alarm group status for " + a, (Throwable)exception);
        }
    }

    public AlarmManager(c_gaa a, c_sha a2, c_faa a3, c_bd a4, JedisPooled a5, ClusterOperations a6) {
        AlarmManager a7;
        AlarmManager alarmManager = a7;
        AlarmManager alarmManager2 = a7;
        AlarmManager alarmManager3 = a7;
        AlarmManager alarmManager4 = a7;
        alarmManager4.d = new ReentrantLock();
        alarmManager3.f = a;
        alarmManager3.h = a2;
        alarmManager2.m = a3;
        alarmManager2.i = a4;
        alarmManager.C = a5;
        alarmManager.I = a6;
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            AlarmManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.I.addRemoteCall((short)101, (Object)a, AlarmManager.class.getDeclaredMethod(AuditConfig.m_rl((Object)"\u007f\u001fj\u0015h\u001dj\u0019_\u0010\u007f\u000es;l\u0013k\fW\u0012j\u0019l\u0012\u007f\u0010"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.I.addRemoteCall((short)102, (Object)a, AlarmManager.class.getDeclaredMethod(FunctionMetadata.m_rl((Object)"_\fZ\nO\u0000M\bO\fz\u0005Z\u001bV.I\u0006N\u0019r\u0007O\fI\u0007Z\u0005"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.I.addRemoteCall((short)103, (Object)a, AlarmManager.class.getDeclaredMethod(AuditConfig.m_rl((Object)"y\u0019j=r\u001dl\u0011M\b\u007f\bk\u000fW\u0012j\u0019l\u0012\u007f\u0010"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.I.addRemoteCall((short)104, (Object)a, AlarmManager.class.getDeclaredMethod(FunctionMetadata.m_rl((Object)"\u000e^\u001dz\u0005Z\u001bV.I\u0006N\u0019h\u001dZ\u001dN\u001ar\u0007O\fI\u0007Z\u0005"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.I.addRemoteCall((short)105, (Object)a, AlarmManager.class.getDeclaredMethod(AuditConfig.m_rl((Object)"\u001b{\b_\u0010\u007f\u000es/j\u001dj\tm\u0019m>g,l\u0013t\u0019}\bW\u0018W\u0012j\u0019l\u0012\u007f\u0010"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.I.addRemoteCall((short)106, (Object)a, AlarmManager.class.getDeclaredMethod(FunctionMetadata.m_rl((Object)"\\\fO(W\bI\u0004|\u001bT\u001cK:O\bO\u001cH\fH+B9I\u0006Q\fX\u001dr\rr\u0007O\fI\u0007Z\u0005"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            a.I.addRemoteCall((short)107, (Object)a, AlarmManager.class.getDeclaredMethod(AuditConfig.m_rl((Object)"y\u0019j=r\u001dl\u0011M\b\u007f\bk\u000f{\u000fW\u0012j\u0019l\u0012\u007f\u0010"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.I.addRemoteCall((short)108, (Object)a, AlarmManager.class.getDeclaredMethod(FunctionMetadata.m_rl((Object)"Z\nO\u0000M\bO\fz\u0005Z\u001bV.I\u0006N\u0019H+B9I\u0006Q\fX\u001dr\rr\u0007O\fI\u0007Z\u0005"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer.class;
            a.I.addRemoteCall((short)109, (Object)a, AlarmManager.class.getDeclaredMethod(AuditConfig.m_rl((Object)"z\u0019\u007f\u001fj\u0015h\u001dj\u0019_\u0010\u007f\u000es;l\u0013k\fm>g,l\u0013t\u0019}\bW\u0018W\u0012j\u0019l\u0012\u007f\u0010"), classArray9));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(FunctionMetadata.m_rl((Object)"/Z\u0000W\f_IO\u0006\u001b\u001b^\u000eR\u001aO\fIIz\u0005Z\u001bV$Z\u0007Z\u000e^\u001b\u001b;k*\u001b\u0004^\u001dS\u0006_\u001a"), noSuchMethodException);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_lga> getAlarmStatuses(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.I.isLeader()) {
            c.debug(AuditConfig.m_rl((Object)"0[=Z9LF>;{\bj\u0015p\u001b>\u001dr\u001dl\u0011>\u000fj\u001dj\tm\u0019m\\x\u0013l\\e\u0001>5Z\u000f>\u0010q\u001f\u007f\u0010r\u0005$\\e\u0001"), (Object)a.size(), a);
            return a2.getAlarmStatusesInternal(a);
        }
        c.debug(FunctionMetadata.m_rl((Object)"'t'\u0016%~(\u007f,iS\u001b;^\u0018N\fH\u001dR\u0007\\IW\fZ\r^\u001b\u001b\u000fT\u001b\u001b\bW\bI\u0004\u001b\u001aO\bO\u001cH\fHI]\u0006II@\u0014\u001b \u007f\u001a\u0001I@\u0014"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.I.callLeaderMethod(Short.valueOf((short)107), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.I.addListener((ClusterNodeListener)a);
        c.info(AuditConfig.m_rl((Object)"=r\u001dl\u0011S\u001dp\u001dy\u0019l\\w\u0012w\bw\u001dr\u0015d\u0019z\\\u007f\u0012z\\l\u0019y\u0015m\b{\u000e{\u0018>\u001dm\\]\u0010k\u000fj\u0019l2q\u0018{0w\u000fj\u0019p\u0019lR"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        String string = alarmManager.I.getCurrentNode().getNodeId();
        c.info(FunctionMetadata.m_rl((Object)"z\u0005Z\u001bV$Z\u0007Z\u000e^\u001b\u0001Io\u0001R\u001a\u001b\u0007T\r^I\u0013\u0012F@\u001b\u0001Z\u001a\u001b\u000b^\nT\u0004^IO\u0001^Iw,z-~;\u0015Ii\fH\u001dT\u001bR\u0007\\IZ\nO\u0000M\f\u001b\bW\bI\u0004HG\u0015G"), (Object)string);
        alarmManager.d.lock();
        try {
            Set set = a2.C.smembers(L).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                c.info(AuditConfig.m_rl((Object)"=r\u001dl\u0011S\u001dp\u001dy\u0019l\\60{\u001dz\u0019l\\e\u00017F>2q\\\u007f\u001fj\u0015h\u0019>\u001dr\u001dl\u0011>\u001bl\u0013k\fm\\x\u0013k\u0012z\\w\u0012>.{\u0018w\u000f>\bq\\l\u0019m\bq\u000e{R"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            c.info(FunctionMetadata.m_rl((Object)"(W\bI\u0004v\bU\b\\\fII\u0013%^\b_\fII@\u0014\u0012S\u001b/T\u001cU\r\u001b\u0012FIZ\nO\u0000M\f\u001b\bW\bI\u0004\u001b\u000eI\u0006N\u0019\u001b \u007f\u001a\u001b\u0000UIi\f_\u0000HIO\u0006\u001b\u001b^\u001aO\u0006I\f\u0001I@\u0014"), objectArray);
            ArrayList arrayList = new ArrayList(a2.h.m_dqc(set));
            c.info(AuditConfig.m_rl((Object)"_\u0010\u007f\u000es1\u007f\u0012\u007f\u001b{\u000e>TR\u0019\u007f\u0018{\u000e>\u0007cU$\\_\bj\u0019s\fj\u0015p\u001b>\bq\\l\u0019m\bq\u000e{\\e\u0001>\u001dr\u001dl\u0011>\u001bl\u0013k\fmR"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                AlarmManager a2;
                String string = a2.I.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    c.info(FunctionMetadata.m_rl((Object)"z\u0005Z\u001bV$Z\u0007Z\u000e^\u001b\u001bAw\fZ\r^\u001b\u001b\u0012F@\u0001Ii\fH\u001dT\u001bR\u0007\\IZ\u0005Z\u001bVI\\\u001bT\u001cKS\u001b\u0012FI\u0013 \u007fS\u001b\u0012F@"), objectArray);
                    a2.activateAlarmGroupInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.i.m_efa(a.getProject()).m_q("Alarm Group Restore (Leader " + string + ")", String.format(AuditConfig.m_rl((Object)";\u000f>TW8$\\;\u00187\\x\u001dw\u0010{\u0018>\bq\\l\u0019m\bq\u000e{R>?\u007f\tm\u0019$\\;\u000f"), objectArray));
                    try {
                        c.warn(FunctionMetadata.m_rl((Object)"z\u0005Z\u001bV$Z\u0007Z\u000e^\u001b\u001bAw\fZ\r^\u001b\u001b\u0012F@\u0001Iz\u001dO\fV\u0019O\u0000U\u000e\u001b\u001dTI_\fZ\nO\u0000M\bO\f\u001b\bW\bI\u0004\u001b\u000eI\u0006N\u0019\u001b\u0012FIZ\u000fO\fIII\fH\u001dT\u001bZ\u001dR\u0006UI]\bR\u0005N\u001b^G"), (Object)string, (Object)a.getId());
                        a2.deactivateAlarmGroupInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        c.error(AuditConfig.m_rl((Object)"=r\u001dl\u0011S\u001dp\u001dy\u0019l\\60{\u001dz\u0019l\\e\u00017F>:\u007f\u0015r\u0019z\\j\u0013>\u0018{\u001d}\bw\n\u007f\b{\\\u007f\u0010\u007f\u000es\\y\u000eq\tn\\e\u0001>\u001dx\b{\u000e>\u000e{\u000fj\u0013l\u001dj\u0015q\u0012>\u001a\u007f\u0015r\tl\u0019$\\e\u0001"), objectArray2);
                        return;
                    }
                }
            });
            c.info(FunctionMetadata.m_rl((Object)"(W\bI\u0004v\bU\b\\\fII\u0013%^\b_\fII@\u0014\u0012S\u001b/R\u0007R\u001aS\f_IZ\u0005Z\u001bVII\fH\u001dT\u001bZ\u001dR\u0006UIK\u001bT\n^\u001aHG"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            c.error(AuditConfig.m_rl((Object)"_\u0010\u007f\u000es1\u007f\u0012\u007f\u001b{\u000e>TR\u0019\u007f\u0018{\u000e>\u0007cU$\\[\u000el\u0013l\\z\tl\u0015p\u001b>\u001dr\u001dl\u0011>\u000e{\u000fj\u0013l\u001dj\u0015q\u0012>\fl\u0013}\u0019m\u000f$\\e\u0001"), objectArray);
            return;
        }
        finally {
            a2.d.unlock();
        }
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.h.m_nf((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @TransactionalEventListener(value={AlarmDeleteEvent.class})
    public void handleAlarmDeleteEvent(AlarmDeleteEvent a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            Alarm alarm = a.getAlarm();
            c.info(FunctionMetadata.m_rl((Object)"w,z-~;\u0001Is\bU\rW\u0000U\u000e\u001b(W\bI\u0004\u007f\fW\fO\f~\u001f^\u0007OI]\u0006IIZ\u0005Z\u001bVIr-\u0001I@\u0014\u0017I|\u001bT\u001cKIr-\u0001I@\u0014"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_bea c_bea2 = a2.m.m_slc(alarm.getGroupId());
            if (c_bea2 != null && c_bea2.m_mmc()) {
                c_bea2.m_nkc(alarm);
                return;
            }
        } else {
            c.debug(AuditConfig.m_rl((Object)"P3PQR9_8[.$\\W\u001bp\u0013l\u0015p\u001b>=r\u001dl\u0011Z\u0019r\u0019j\u0019[\n{\u0012j\\x\u0013l\\\u007f\u0010\u007f\u000es\\W8$\\e\u0001"), (Object)a.getAlarm().getId());
        }
    }

    protected void activateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.h.m_nf((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    protected void deactivateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.h.m_wl(a));
    }

    @TransactionalEventListener(value={AlarmChangeEvent.class})
    public void handleAlarmChangeEvent(AlarmChangeEvent a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            Alarm alarm = a.getAlarm();
            c.info(FunctionMetadata.m_rl((Object)"w,z-~;\u0001Is\bU\rW\u0000U\u000e\u001b(W\bI\u0004x\u0001Z\u0007\\\f~\u001f^\u0007OI]\u0006IIZ\u0005Z\u001bVIr-\u0001I@\u0014\u0017I|\u001bT\u001cKIr-\u0001I@\u0014"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_bea c_bea2 = a2.m.m_slc(alarm.getGroupId());
            if (c_bea2 != null && c_bea2.m_mmc()) {
                if (Boolean.TRUE.equals(alarm.getIsActive())) {
                    c_bea2.m_agc(alarm);
                    return;
                }
                c_bea2.m_nkc(alarm);
                return;
            }
        } else {
            c.debug(AuditConfig.m_rl((Object)"P3PQR9_8[.$\\W\u001bp\u0013l\u0015p\u001b>=r\u001dl\u0011]\u0014\u007f\u0012y\u0019[\n{\u0012j\\x\u0013l\\\u007f\u0010\u007f\u000es\\W8$\\e\u0001"), (Object)a.getAlarm().getId());
        }
    }

    protected c_lga getAlarmStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmStatusInternal(alarmManager.f.m_jnc(a));
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.debug(FunctionMetadata.m_rl((Object)"%~(\u007f,iS\u001b(X\u001dR\u001fZ\u001dR\u0007\\IZ\u0005WIZ\u0005Z\u001bVI\\\u001bT\u001cK\u001a\u001b\u000fT\u001b\u001b\u0019I\u0006Q\fX\u001d\u001b\u0012FIW\u0006X\bW\u0005BG"), (Object)a);
            a2.activateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        c.debug(AuditConfig.m_rl((Object)"P3PQR9_8[.$\\L\u0019o\t{\u000fj\u0015p\u001b>\u0010{\u001dz\u0019l\\j\u0013>\u001d}\bw\n\u007f\b{\\\u007f\u0010r\\\u007f\u0010\u007f\u000es\\y\u000eq\tn\u000f>\u001aq\u000e>\fl\u0013t\u0019}\b>\u0007cR"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)108), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC activate alarm groups for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_lga> getAlarmStatuses(Integer a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.debug(FunctionMetadata.m_rl((Object)"w,z-~;\u0001I|\fO\u001dR\u0007\\IZ\u0005WIZ\u0005Z\u001bVIH\u001dZ\u001dN\u001a^\u001a\u001b\u000fT\u001b\u001b\u0019I\u0006Q\fX\u001d\u001b\u0012FIW\u0006X\bW\u0005BG"), (Object)a);
            return a2.getAlarmStatusesByProjectIdInternal(a);
        }
        c.debug(AuditConfig.m_rl((Object)"P3PQR9_8[.$\\L\u0019o\t{\u000fj\u0015p\u001b>\u0010{\u001dz\u0019l\\x\u0013l\\\u007f\u0010r\\\u007f\u0010\u007f\u000es\\m\b\u007f\bk\u000f{\u000f>\u001aq\u000e>\fl\u0013t\u0019}\b>\u0007cR"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.I.callLeaderMethod(Short.valueOf((short)105), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get alarm statuses for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_lga getAlarmGroupStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.h.m_jk(a, a2)) == null) {
            return c_lga.K;
        }
        return a3.getAlarmGroupStatus(a.getId());
    }

    protected void activateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.activateAlarmGroupInternal(alarmManager.h.m_wl(a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_lga getAlarmStatus(Integer a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.debug(FunctionMetadata.m_rl((Object)"w,z-~;\u0001I|\fO\u001dR\u0007\\IZ\u0005Z\u001bVIH\u001dZ\u001dN\u001a\u001b\u000fT\u001b\u001b\u0012FIW\u0006X\bW\u0005BG"), (Object)a);
            return a2.getAlarmStatusInternal(a);
        }
        c.debug(AuditConfig.m_rl((Object)"P3PQR9_8[.$\\L\u0019o\t{\u000fj\u0015p\u001b>\u0010{\u001dz\u0019l\\x\u0013l\\\u007f\u0010\u007f\u000es\\m\b\u007f\bk\u000f>\u001aq\u000e>\u0007cR"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_lga)a2.I.callLeaderMethod(Short.valueOf((short)103), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get alarm status for " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.debug(FunctionMetadata.m_rl((Object)"w,z-~;\u0001Iz\nO\u0000M\bO\u0000U\u000e\u001b\bW\bI\u0004\u001b\u000eI\u0006N\u0019\u001b\u0012FIW\u0006X\bW\u0005BG"), (Object)a);
            a2.activateAlarmGroupInternal(a);
            return;
        }
        c.debug(AuditConfig.m_rl((Object)"2Q230[=Z9LF>.{\rk\u0019m\bw\u0012y\\r\u0019\u007f\u0018{\u000e>\bq\\\u007f\u001fj\u0015h\u001dj\u0019>\u001dr\u001dl\u0011>\u001bl\u0013k\f>\u0007cR"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)101), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC activate alarm group " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmGroupDeleteEvent.class})
    public void handleAlarmGroupDeleteEvent(AlarmGroupDeleteEvent a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.info(FunctionMetadata.m_rl((Object)"%~(\u007f,iS\u001b!Z\u0007_\u0005R\u0007\\Iz\u0005Z\u001bV.I\u0006N\u0019\u007f\fW\fO\f~\u001f^\u0007OI]\u0006II\\\u001bT\u001cKIr-\u0001I@\u0014"), (Object)a.getAlarmGroup().getId());
            a2.deactivateAlarmGroupInternal(a.getAlarmGroup().getId());
            return;
        }
        c.debug(AuditConfig.m_rl((Object)"2Q230[=Z9LF>5y\u0012q\u000ew\u0012y\\_\u0010\u007f\u000es;l\u0013k\fZ\u0019r\u0019j\u0019[\n{\u0012j\\x\u0013l\\y\u000eq\tn\\W8$\\e\u0001"), (Object)a.getAlarmGroup().getId());
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.activateAlarmGroup(alarmManager.h.m_xk(a, a2).getId());
    }

    protected void activateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_zia.m_iec(() -> {
            AlarmManager a2;
            a2.d.lock();
            try {
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_sk("Project should be active to start alarm group " + a.getName());
                }
                c_bea c_bea2 = a2.m.m_akc(a);
                c_bea2.m_oza();
                if (c_bea2.m_mmc()) {
                    String[] stringArray = new String[1];
                    stringArray[0] = a.getId().toString();
                    a2.C.sadd(L, stringArray);
                }
                return;
            }
            finally {
                a2.d.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.deactivateAlarmGroup(alarmManager.h.m_xk(a, a2).getId());
    }

    protected c_lga getAlarmGroupStatusInternal(AlarmGroup a) {
        AlarmManager a2;
        if (a == null) {
            return c_lga.K;
        }
        if ((a = a2.m.m_slc(a.getId())) != null && a.m_mmc()) {
            return c_lga.m;
        }
        return c_lga.K;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_lga> getAlarmGroupStatuses(Integer a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.debug(FunctionMetadata.m_rl((Object)"w,z-~;\u0001I|\fO\u001dR\u0007\\IZ\u0005WIZ\u0005Z\u001bVI\\\u001bT\u001cKIH\u001dZ\u001dN\u001a^\u001a\u001b\u000fT\u001b\u001b\u0019I\u0006Q\fX\u001d\u001b\u0012FIW\u0006X\bW\u0005BG"), (Object)a);
            return a2.getAlarmGroupStatusesByProjectIdInternal(a);
        }
        c.debug(AuditConfig.m_rl((Object)"P3PQR9_8[.$\\L\u0019o\t{\u000fj\u0015p\u001b>\u0010{\u001dz\u0019l\\x\u0013l\\\u007f\u0010r\\\u007f\u0010\u007f\u000es\\y\u000eq\tn\\m\b\u007f\bk\u000f{\u000f>\u001aq\u000e>\fl\u0013t\u0019}\b>\u0007cR"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.I.callLeaderMethod(Short.valueOf((short)106), objectArray);
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC get alarm group statuses for project " + a, (Throwable)exception);
        }
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.info(FunctionMetadata.m_rl((Object)"w,z-~;\u0001Is\bU\rW\u0000U\u000e\u001b9I\u0006Q\fX\u001d\u007f\fZ\nO\u0000M\bO\f~\u001f^\u0007OI]\u0006IIK\u001bT\u0003^\nOIr-\u0001I@\u0014"), (Object)a.getProject().getId());
            a2.deactivateAlarmGroupsByProjectIdInternal(a.getProject().getId());
            return;
        }
        c.debug(AuditConfig.m_rl((Object)"P3PQR9_8[.$\\W\u001bp\u0013l\u0015p\u001b>,l\u0013t\u0019}\bZ\u0019\u007f\u001fj\u0015h\u001dj\u0019[\n{\u0012j\\x\u0013l\\n\u000eq\u0016{\u001fj\\W8$\\e\u0001"), (Object)a.getProject().getId());
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.debug(FunctionMetadata.m_rl((Object)"w,z-~;\u0001I\u007f\fZ\nO\u0000M\bO\u0000U\u000e\u001b\bW\bI\u0004\u001b\u000eI\u0006N\u0019\u001b\u0012FIW\u0006X\bW\u0005BG"), (Object)a);
            a2.deactivateAlarmGroupInternal(a);
            return;
        }
        c.debug(AuditConfig.m_rl((Object)"2Q230[=Z9LF>.{\rk\u0019m\bw\u0012y\\r\u0019\u007f\u0018{\u000e>\bq\\z\u0019\u007f\u001fj\u0015h\u001dj\u0019>\u001dr\u001dl\u0011>\u001bl\u0013k\f>\u0007cR"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)102), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC deactivate alarm group " + a, (Throwable)exception);
        }
    }

    protected Map<Integer, c_lga> getAlarmStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.f.m_nf((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Alarm::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    protected Map<Integer, c_lga> getAlarmStatusesInternal(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.debug(FunctionMetadata.m_rl((Object)"%~(\u007f,iS\u001b-^\bX\u001dR\u001fZ\u001dR\u0007\\IZ\u0005WIZ\u0005Z\u001bVI\\\u001bT\u001cK\u001a\u001b\u000fT\u001b\u001b\u0019I\u0006Q\fX\u001d\u001b\u0012FIW\u0006X\bW\u0005BG"), (Object)a);
            a2.deactivateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        c.debug(AuditConfig.m_rl((Object)"P3PQR9_8[.$\\L\u0019o\t{\u000fj\u0015p\u001b>\u0010{\u001dz\u0019l\\j\u0013>\u0018{\u001d}\bw\n\u007f\b{\\\u007f\u0010r\\\u007f\u0010\u007f\u000es\\y\u000eq\tn\u000f>\u001aq\u000e>\fl\u0013t\u0019}\b>\u0007cR"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.I.callLeaderMethod(Short.valueOf((short)109), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_ska("Failed to RPC deactivate alarm groups for project " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmGroupChangeEvent.class})
    public void handleAlarmGroupChangeEvent(AlarmGroupChangeEvent a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c.info(FunctionMetadata.m_rl((Object)"%~(\u007f,iS\u001b!Z\u0007_\u0005R\u0007\\Iz\u0005Z\u001bV.I\u0006N\u0019x\u0001Z\u0007\\\f~\u001f^\u0007OI]\u0006II\\\u001bT\u001cKIr-\u0001I@\u0014"), (Object)a.getAlarmGroup().getId());
            a2.d.lock();
            try {
                Integer n = a.getAlarmGroup().getId();
                if (a2.getAlarmGroupStatusInternal(n) == c_lga.m) {
                    AlarmManager alarmManager = a2;
                    alarmManager.deactivateAlarmGroupInternal(n);
                    alarmManager.activateAlarmGroupInternal(n);
                }
                return;
            }
            finally {
                a2.d.unlock();
            }
        }
        c.debug(AuditConfig.m_rl((Object)"2Q230[=Z9LF>5y\u0012q\u000ew\u0012y\\_\u0010\u007f\u000es;l\u0013k\f]\u0014\u007f\u0012y\u0019[\n{\u0012j\\x\u0013l\\y\u000eq\tn\\W8$\\e\u0001"), (Object)a.getAlarmGroup().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_lga getAlarmStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.f.m_jk(a, a2)) == null) {
            return c_lga.K;
        }
        return a3.getAlarmStatus(a.getId());
    }

    protected c_lga getAlarmGroupStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmGroupStatusInternal(alarmManager.h.m_jnc(a));
    }

    protected c_lga getAlarmStatusInternal(Alarm a) {
        AlarmManager a2;
        if (a == null) {
            return c_lga.K;
        }
        c_bea c_bea2 = a2.m.m_slc(a.getGroup().getId());
        if (c_bea2 != null && c_bea2.m_mmc() && c_bea2.m_rpc(a.getId())) {
            return c_lga.m;
        }
        return c_lga.K;
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_zia.m_iec(() -> {
            AlarmManager a2;
            a2.d.lock();
            try {
                c_bea c_bea2 = a2.m.m_slc(a.getId());
                if (c_bea2 != null) {
                    c_bea2.m_kgb();
                    a2.m.m_ufc(a.getId(), c_bea2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.C.srem(L, stringArray);
                return;
            }
            finally {
                a2.d.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    public void notLeader() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        String string = alarmManager.I.getCurrentNode().getNodeId();
        c.info(FunctionMetadata.m_rl((Object)"z\u0005Z\u001bV$Z\u0007Z\u000e^\u001b\u0001Io\u0001R\u001a\u001b\u0007T\r^I\u0013\u0012F@\u001b\u0000HIu&\u001b%t'|,iIo!~Iw,z-~;\u0015Ih\u001dT\u0019K\u0000U\u000e\u001b\bW\u0005\u001b\u0005T\nZ\u0005\u001b\bW\bI\u0004\u001b\u0000U\u001aK\fX\u001dT\u001bHG\u0015G"), (Object)string);
        alarmManager.d.lock();
        try {
            a.m.m_vmc();
            c.info(AuditConfig.m_rl((Object)"=r\u001dl\u0011S\u001dp\u001dy\u0019l\\62q\b>0{\u001dz\u0019l\\e\u00017F>=r\u0010>\u0010q\u001f\u007f\u0010>\u001dr\u001dl\u0011>\u0015p\u000fn\u0019}\bw\u0013p\\j\u001dm\u0017m\\v\u001dh\u0019>\u001e{\u0019p\\l\u0019o\t{\u000fj\u0019z\\j\u0013>\u000fj\u0013nR"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            c.error(FunctionMetadata.m_rl((Object)"(W\bI\u0004v\bU\b\\\fII\u0013'T\u001d\u001b%^\b_\fII@\u0014\u0012S\u001b,I\u001bT\u001b\u001b\rN\u001bR\u0007\\IK\u001bT\n^\u001aHIT\u000f\u001b\u001aO\u0006K\u0019R\u0007\\IW\u0006X\bWIZ\u0005Z\u001bVIR\u0007H\u0019^\nO\u0006I\u001a\u0001I@\u0014"), objectArray);
            return;
        }
        finally {
            a.d.unlock();
        }
    }

    @TransactionalEventListener(value={AlarmAddEvent.class})
    public void handleAlarmAddEvent(AlarmAddEvent a) {
        AlarmManager a2;
        if (a2.I.isLeader()) {
            c_bea c_bea2;
            Alarm alarm = a.getAlarm();
            c.info(AuditConfig.m_rl((Object)"0[=Z9LF>4\u007f\u0012z\u0010w\u0012y\\_\u0010\u007f\u000es=z\u0018[\n{\u0012j\\x\u0013l\\\u007f\u0010\u007f\u000es\\W8$\\e\u00012\\Y\u000eq\tn\\W8$\\e\u0001"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            if (Boolean.TRUE.equals(alarm.getIsActive()) && (c_bea2 = a2.m.m_slc(alarm.getGroupId())) != null && c_bea2.m_mmc()) {
                c_bea2.m_agc(alarm);
                return;
            }
        } else {
            c.debug(FunctionMetadata.m_rl((Object)"'t'\u0016%~(\u007f,iS\u001b \\\u0007T\u001bR\u0007\\Iz\u0005Z\u001bV(_\r~\u001f^\u0007OI]\u0006IIZ\u0005Z\u001bVIr-\u0001I@\u0014"), (Object)a.getAlarm().getId());
        }
    }
}

