/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.restcontrollers;

import com.inscada.mono.alarm.j.c_lga;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.services.AlarmManager;
import com.inscada.mono.alarm.services.c_sha;
import com.inscada.mono.impexp.c.c_am;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.z.c_nn;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.report.services.c_yf;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/alarms/groups"})
public class AlarmGroupController
extends ProjectBasedImportExportController {
    private final AlarmManager K;
    private final c_sha l;

    @GetMapping(value={"/status"}, params={"projectId"})
    public Map<Integer, c_lga> getAlarmGroupStatuses(@RequestParam(value="projectId") Integer a) {
        return this.K.getAlarmGroupStatuses(a);
    }

    @PostMapping(value={"/{groupId}/deactivate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.K.deactivateAlarmGroup(a);
    }

    public AlarmGroupController(c_sha a, AlarmManager a2, c_am a3, c_tm a4) {
        AlarmGroupController a5;
        AlarmGroupController alarmGroupController = a5;
        super(a3, EnumSet.of(c_nn.H), a4);
        alarmGroupController.l = a;
        alarmGroupController.K = a2;
    }

    @PostMapping(value={"/deactivate"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroups(@RequestParam(value="projectId") Integer a) {
        this.K.deactivateAlarmGroups(a);
    }

    @PostMapping
    public ResponseEntity<AlarmGroup> createAlarmGroup(@Valid @RequestBody AlarmGroup alarmGroup, UriComponentsBuilder a) {
        alarmGroup = this.l.m_dlc(alarmGroup);
        Object[] objectArray = new Object[1];
        objectArray[0] = alarmGroup.getId();
        return ResponseEntity.created((URI)a.path(c_yf.m_rl((Object)"%\nm\u0003e\u0004z8n\f")).buildAndExpand(objectArray).toUri()).body((Object)alarmGroup);
    }

    @PostMapping(value={"/{groupId}/activate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.K.activateAlarmGroup(a);
    }

    @GetMapping(value={"/status"}, params={"projectId", "name"})
    public c_lga getAlarmGroupStatus(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.K.getAlarmGroupStatus(projectId, a);
    }

    @GetMapping(value={"/{alarmGroupId}/status"})
    public c_lga getAlarmGroupStatus(@PathVariable(value="alarmGroupId") Integer a) {
        return this.K.getAlarmGroupStatus(a);
    }

    @DeleteMapping(value={"/multi"}, params={"groupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmGroupsByIds(@RequestParam(value="groupIds") Integer[] a) {
        this.l.m_zmc(List.of(a));
    }

    @GetMapping(value={"/{groupId}"})
    public AlarmGroup getAlarmGroup(@PathVariable(value="groupId") Integer a) {
        return this.l.m_la(a);
    }

    @DeleteMapping(value={"/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.l.m_ma(a);
    }

    @PostMapping(value={"/activate"}, params={"projectId", "name"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroup(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        this.K.activateAlarmGroup(projectId, a);
    }

    @GetMapping
    public Collection<AlarmGroup> getAlarmGroups(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_ta();
        }
        return this.l.m_ra(a);
    }

    @PostMapping(value={"/deactivate"}, params={"projectId", "name"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroup(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        this.K.deactivateAlarmGroup(projectId, a);
    }

    @PutMapping(value={"/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAlarmGroup(@PathVariable(value="groupId") Integer groupId, @Valid @RequestBody AlarmGroup a) {
        this.l.m_lqc(groupId, a);
    }

    @PostMapping(value={"/activate"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroups(@RequestParam(value="projectId") Integer a) {
        this.K.activateAlarmGroups(a);
    }
}

