/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.restcontrollers;

import com.inscada.mono.alarm.j.c_lga;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.services.AlarmManager;
import com.inscada.mono.alarm.services.c_rea;
import com.inscada.mono.impexp.c.c_am;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.z.c_nn;
import com.inscada.mono.project.j.c_tm;
import com.inscada.mono.report.model.DeviationReportVariable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AlarmController<T extends Alarm>
extends ProjectBasedImportExportController {
    protected final AlarmManager K;
    protected final c_rea<T> l;

    @GetMapping(value={"/name"})
    public T getAlarmByName(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="alarmName") String a) {
        return (T)this.l.m_xk(projectId, a);
    }

    @DeleteMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarm(@PathVariable(value="alarmId") Integer a) {
        this.l.m_ma(a);
    }

    @GetMapping(value={"/pages"})
    public Page<T> getAlarmsByProjectId(@RequestParam(name="projectId", required=false) Integer projectId, Pageable a) {
        if (projectId == null) {
            return this.l.m_qga(a);
        }
        return this.l.m_sna(projectId, a);
    }

    @GetMapping(value={"/status"}, params={"projectId"})
    public Map<Integer, c_lga> getAlarmStatuses(@RequestParam(value="projectId") Integer a) {
        return this.K.getAlarmStatuses(a);
    }

    @GetMapping(params={"projectId"})
    public Collection<T> getAlarms(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.l.m_ta();
        }
        return this.l.m_ra(a);
    }

    @GetMapping(params={"projectId", "groupName"})
    public Collection<T> getAlarmsByGroupId(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="groupName") String a) {
        return this.l.m_rjc(projectId, a);
    }

    @GetMapping(value={"/{alarmId}"})
    public T getAlarm(@PathVariable(value="alarmId") Integer a) {
        return (T)this.l.m_la(a);
    }

    @PutMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAlarm(@PathVariable(value="alarmId") Integer alarmId, @Valid @RequestBody T a) {
        this.l.m_tpc(alarmId, a);
    }

    @GetMapping(value={"/status"}, params={"alarmIds"})
    public Map<Integer, c_lga> getAlarmStatuses(@RequestParam(value="alarmIds") Integer[] a) {
        return this.K.getAlarmStatuses(Arrays.asList(a));
    }

    protected AlarmController(c_rea<T> a, AlarmManager a2, c_am a3, c_tm a4) {
        AlarmController a5;
        AlarmController alarmController = a5;
        super(a3, EnumSet.of(c_nn.E), a4);
        alarmController.l = a;
        alarmController.K = a2;
    }

    @PostMapping
    public ResponseEntity<T> createAlarm(@Valid @RequestBody T alarm, UriComponentsBuilder a) {
        alarm = this.l.m_ihc(alarm);
        Object[] objectArray = new Object[1];
        objectArray[0] = alarm.getId();
        return ResponseEntity.created((URI)a.path(DeviationReportVariable.m_rl((Object)"G\\\tK\tU\u0005n\fZ")).buildAndExpand(objectArray).toUri()).body(alarm);
    }

    @GetMapping(value={"/parts"})
    public Collection<String> getPartsByProjectId(@RequestParam(name="projectId") Integer a) {
        return this.l.m_nhc(a);
    }

    @GetMapping(value={"/status"}, params={"projectId", "name"})
    public c_lga getAlarmStatus(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.K.getAlarmStatus(projectId, a);
    }

    @DeleteMapping(value={"/multi"}, params={"alarmIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmsByIds(@RequestParam(value="alarmIds") Integer[] a) {
        this.l.m_roc(List.of(a));
    }

    @PostMapping(value={"/filter/pages"})
    public Page<T> getAlarmsByFilter(@Valid @RequestBody AlarmFilter alarmFilter, Pageable a) {
        return this.l.m_pnc(alarmFilter, a);
    }

    @GetMapping(value={"/{alarmId}/status"})
    public c_lga getAlarmStatus(@PathVariable(value="alarmId") Integer a) {
        return this.K.getAlarmStatus(a);
    }
}

