create table custom_report
(
    custom_report_id    serial       not null
        constraint custom_report_custom_report_id_pk
        primary key,
    project_id   integer      not null
        constraint custom_report_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    script       text,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index custom_report_project_id_name_uindex
    on custom_report (project_id, name)
;

INSERT INTO inscada.menus (menu_id, name)
VALUES (57, 'Dev Reports'), (58, 'Custom Reports');

INSERT INTO inscada.role_menus (role_id, menu_id)
VALUES (1, 57), (1, 58);

ALTER SEQUENCE custom_report_custom_report_id_seq INCREMENT 50;