/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.restcontrollers;

import com.inscada.mono.fs.model.FileResult;
import com.inscada.mono.search.repositories.SearchRepository;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.model.ResetPasswordToken;
import com.inscada.mono.user.model.Role;
import com.inscada.mono.user.model.User;
import com.inscada.mono.user.model.UserDto;
import com.inscada.mono.user.z.c_ka;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    private final c_ka L;

    @GetMapping
    public Collection<User> getUsers() {
        UserController a;
        return a.L.m_la();
    }

    @DeleteMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUser(@PathVariable(value="userId") Integer a) {
        this.L.m_ga(a);
    }

    @GetMapping(value={"/{userId}/spaces"})
    public Collection<Space> getSpaces(@PathVariable(value="userId") Integer a) {
        return this.L.m_lc(a);
    }

    @PutMapping(value={"/ui-configs"})
    public void setUIConfigs(@RequestBody String value, Principal a) {
        this.L.m_cb(value, a.getName());
    }

    @PostMapping(value={"/{userId}/roles"})
    public ResponseEntity<Role> addRole(@PathVariable(value="userId") Integer userId, @RequestBody Integer roleId, UriComponentsBuilder a) {
        Role role = this.L.m_mc(userId, roleId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = roleId;
        return ResponseEntity.created((URI)a.path(SearchRepository.m_le((Object)"\\c\u0006k\u0016j:|\u000e7\u0001w\u001f}\u00007\bj\u001ct\u0016Q\u0017e")).buildAndExpand(objectArray).toUri()).body((Object)role);
    }

    @GetMapping(value={"/active-space"})
    public String[] getAllSpaceUsers() {
        UserController a;
        return a.L.m_ec();
    }

    @DeleteMapping(value={"/{userId}/roles/{roleId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        this.L.m_rc(userId, a);
    }

    @DeleteMapping(value={""}, params={"userIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUsersByIds(@RequestParam(value="userIds") Integer[] a) {
        this.L.m_uc(List.of(a));
    }

    @GetMapping(value={"/{userId}/roles"})
    public Collection<Role> getRoles(@PathVariable(value="userId") Integer a) {
        return this.L.m_sc(a);
    }

    public UserController(c_ka a) {
        UserController a2;
        a2.L = a;
    }

    @PostMapping(value={"/{username}/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetPassword(@PathVariable(value="username") String username, @Valid @RequestBody ResetPasswordToken a) {
        this.L.m_oc(username, a);
    }

    @GetMapping(value={"/{userId}/spaces/{spaceId}"})
    public Space getSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        return this.L.m_vc(userId, a);
    }

    @DeleteMapping(value={"/{userId}/spaces/{spaceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeSpace(@PathVariable(value="userId") Integer userId, @PathVariable(value="spaceId") Integer a) {
        this.L.m_kb(userId, a);
    }

    @GetMapping(value={"/{userId}"})
    public User getUser(@PathVariable(value="userId") Integer a) {
        return this.L.m_ba(a);
    }

    @PostMapping(value={"/resetPassword"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetOwnPassword(@Valid @RequestBody ResetPasswordToken resetPasswordToken, Principal a) {
        this.L.m_tb(a.getName(), resetPasswordToken);
    }

    @PutMapping(value={"/agree"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void acceptEula(Principal a) {
        UserController a2;
        a2.L.m_tc(a.getName());
    }

    @PostMapping
    public ResponseEntity<User> createUser(@Valid @RequestBody UserDto userDto, UriComponentsBuilder a) {
        userDto = this.L.m_pc(userDto);
        Object[] objectArray = new Object[1];
        objectArray[0] = userDto.getId();
        return ResponseEntity.created((URI)a.path(FileResult.m_le((Object)"\f`VhFij\u007f^")).buildAndExpand(objectArray).toUri()).body((Object)userDto);
    }

    @GetMapping(value={"/{userId}/roles/{roleId}"})
    public Role getRole(@PathVariable(value="userId") Integer userId, @PathVariable(value="roleId") Integer a) {
        return this.L.m_hc(userId, a);
    }

    @PutMapping(value={"/{userId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateUser(@PathVariable(value="userId") Integer userId, @Valid @RequestBody User a) {
        this.L.m_ib(userId, a);
    }

    @PostMapping(value={"/{userId}/spaces"})
    public ResponseEntity<Space> addSpace(@PathVariable(value="userId") Integer userId, @RequestBody Integer spaceId, UriComponentsBuilder a) {
        Space space = this.L.m_cc(userId, spaceId);
        Object[] objectArray = new Object[2];
        objectArray[0] = userId;
        objectArray[1] = spaceId;
        return ResponseEntity.created((URI)a.path(SearchRepository.m_le((Object)"\\c\u0006k\u0016j:|\u000e7\u0000h\u0012{\u0016k\\c\u0000h\u0012{\u0016Q\u0017e")).buildAndExpand(objectArray).toUri()).body((Object)space);
    }

    @GetMapping(value={"/ui-configs"})
    public String getUIConfigs(Principal a) {
        UserController a2;
        return a2.L.m_nc(a.getName());
    }
}

