/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.enums.c_ua;
import com.inscada.mono.user.model.Menu;
import com.inscada.mono.user.model.Permission;
import com.inscada.mono.user.model.Role;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

@Entity
@Table(name="users")
public class User
extends BaseModel {
    @Column(name="eula_accepted")
    private Boolean eulaAccepted;
    @Column(name="otp_type")
    private c_ua otpType;
    @Email
    @Size(max=255)
    private String email;
    @Size(max=15)
    private String phone;
    @NotBlank
    @Size(max=50)
    @Column(updatable=false)
    private String username;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Size(max=60)
    @Column(name="passwd")
    private String password;
    @JsonIgnore
    @Fetch(value=FetchMode.SUBSELECT)
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="role_members", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private Set<Role> roles;
    @Id
    @Column(name="user_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="userSeq")
    @GenericGenerator(name="userSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="users_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @JsonIgnore
    @Fetch(value=FetchMode.SUBSELECT)
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="space_users", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="space_id")})
    private Set<Space> spaces;
    @NotNull
    @Column(name="require_password_reset")
    private Boolean requirePasswordReset;

    @JsonIgnore
    public List<String> getSpaceNames() {
        User a;
        return a.getSpaces().stream().map(Space::getName).collect(Collectors.toList());
    }

    public void addRole(Role a) {
        User a2;
        a2.roles.add(a);
        a.getUsers().add(a2);
    }

    public void removeRole(Integer a) {
        User a2;
        a = a2.roles.stream().filter(arg_0 -> User.lambda$removeRole$0((Integer)((Object)a), arg_0)).findFirst();
        if (a.isPresent()) {
            Optional<Role> optional = a;
            a2.roles.remove(optional.get());
            ((Role)optional.get()).getUsers().remove(a2);
        }
    }

    public void setEmail(String a) {
        a.email = a;
    }

    public String getEmail() {
        User a;
        return a.email;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setUsername(String a) {
        a.username = a;
    }

    @JsonIgnore
    public List<String> getMenus() {
        User a2;
        return a2.getRoles().stream().flatMap(a -> a.getMenus().stream()).map(Menu::getName).distinct().collect(Collectors.toList());
    }

    public User() {
        User a;
        User user = a;
        a.roles = new HashSet();
        user.spaces = new HashSet();
    }

    public Boolean getRequirePasswordReset() {
        User a;
        return a.requirePasswordReset;
    }

    public String getPassword() {
        User a;
        return a.password;
    }

    private static /* synthetic */ boolean lambda$removeSpace$1(Integer a, Space a2) {
        return a2.getId().equals(a);
    }

    public void removeSpace(Integer a) {
        User a2;
        a = a2.spaces.stream().filter(arg_0 -> User.lambda$removeSpace$1((Integer)((Object)a), arg_0)).findFirst();
        if (a.isPresent()) {
            Optional<Space> optional = a;
            a2.spaces.remove(optional.get());
            ((Space)optional.get()).getUsers().remove(a2);
        }
    }

    public Boolean getEulaAccepted() {
        User a;
        return a.eulaAccepted;
    }

    public void remove() {
        Role role;
        User a;
        Iterator iterator;
        Iterator iterator2 = iterator = new HashSet(a.roles).iterator();
        while (iterator2.hasNext()) {
            role = (Role)iterator.next();
            iterator2 = iterator;
            a.roles.remove(role);
            role.getUsers().remove(a);
        }
        iterator = new HashSet(a.spaces).iterator();
        Iterator iterator3 = iterator;
        while (iterator3.hasNext()) {
            role = (Space)iterator.next();
            iterator3 = iterator;
            a.spaces.remove(role);
            role.getUsers().remove(a);
        }
    }

    public void setPassword(String a) {
        a.password = a;
    }

    public void setSpaces(Set<Space> a) {
        a.spaces = a;
    }

    public String getUsername() {
        User a;
        return a.username;
    }

    public boolean equals(Object a) {
        User a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof User)) {
            return false;
        }
        a = (User)a;
        return a2.getUsername().equals(a.getUsername());
    }

    public Set<Space> getSpaces() {
        User a;
        return a.spaces;
    }

    public void addSpace(Space a) {
        User a2;
        a2.spaces.add(a);
        a.getUsers().add(a2);
    }

    public Integer getId() {
        User a;
        return a.id;
    }

    @JsonIgnore
    public List<GrantedAuthority> getAuthorities() {
        User a2;
        return AuthorityUtils.createAuthorityList((String[])((String[])a2.getRoles().stream().flatMap(a -> a.getPermissions().stream()).map(Permission::getName).distinct().toArray(String[]::new)));
    }

    public String getPhone() {
        User a;
        return a.phone;
    }

    public void setRoles(Set<Role> a) {
        a.roles = a;
    }

    @JsonIgnore
    public List<String> getRoleNames() {
        User a;
        return a.getRoles().stream().map(Role::getName).collect(Collectors.toList());
    }

    public void setOtpType(c_ua a) {
        a.otpType = a;
    }

    public void setEulaAccepted(Boolean a) {
        a.eulaAccepted = a;
    }

    public void setRequirePasswordReset(Boolean a) {
        a.requirePasswordReset = a;
    }

    public Set<Role> getRoles() {
        User a;
        return a.roles;
    }

    private static /* synthetic */ boolean lambda$removeRole$0(Integer a, Role a2) {
        return a2.getId().equals(a);
    }

    public c_ua getOtpType() {
        User a;
        return a.otpType;
    }

    public void setPhone(String a) {
        a.phone = a;
    }

    public int hashCode() {
        User a;
        Object[] objectArray = new Object[1];
        objectArray[0] = a.getUsername();
        return Objects.hash(objectArray);
    }
}

