/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.auth.security.model.AuthenticationResponseToken;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.sms.model.dataport.StringValueHolder;
import com.inscada.mono.user.model.User;
import java.util.Objects;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.springframework.security.core.context.SecurityContextHolder;

@MappedSuperclass
public abstract class OwnedSpaceBaseModel
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="owner_id")
    protected User user;

    public OwnedSpaceBaseModel() {
        OwnedSpaceBaseModel a;
    }

    public void setUser(User a) {
        a.user = a;
    }

    @PrePersist
    @PreUpdate
    void setOwner() {
        OwnedSpaceBaseModel a;
        AuthenticationResponseToken authenticationResponseToken = (AuthenticationResponseToken)SecurityContextHolder.getContext().getAuthentication();
        Objects.requireNonNull(authenticationResponseToken, StringValueHolder.m_le((Object)"6T\u0003I\u0012O\u0003H\u0014@\u0003H\u0018OWL\u0002R\u0003\u0001\u0019N\u0003\u0001\u0015DWO\u0002M\u001b"));
        a.setUser(authenticationResponseToken.getUser());
    }

    public String getOwner() {
        OwnedSpaceBaseModel a;
        return a.user.getUsername();
    }

    public User getUser() {
        OwnedSpaceBaseModel a;
        return a.user;
    }
}

