/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.animation.model.AnimationJoin;
import com.inscada.mono.auth.security.c_oka;
import com.inscada.mono.shared.exceptions.c_dl;
import com.inscada.mono.shared.exceptions.c_fc;
import com.inscada.mono.shared.exceptions.c_ig;
import com.inscada.mono.shared.exceptions.c_mc;
import com.inscada.mono.shared.exceptions.c_mf;
import com.inscada.mono.shared.exceptions.c_sa;
import com.inscada.mono.shared.exceptions.c_uj;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String h = "Relation Exists Error";
    private static final String G = "Validation Error";
    private static final String k = "Security Error";
    private static final Logger J = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String b = "Already Exists Error";
    private static final String m = "Unknown Error";
    private static final String i = "Mismatch Error";
    @Value(value="${spring.profiles.active}")
    private String g;
    private static final String K = "File Storage Error";
    private static final String A = "Constraint Violation";
    private static final String F = "Not Found Error";
    private static final String c = "Not Active Error";
    private static final String E = "Inscada Error";
    private static final String L = "Database Error";

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = ex.getParameterName();
        objectArray[1] = ex.getParameterType();
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, String.format(c_oka.m_le((Object)"aWBGZ@VV\u0013BR@R_VFV@\u0013\u0015\u0016A\u0014\u0012\\T\u0013FJBV\u0012\u0014\u0017@\u0015\u0013[@\u0012^[@AZ\\T"), objectArray), (Exception)ex, G);
        J.error(AnimationJoin.m_le((Object)"V)h3r.|`k!i!v%o%iz;;f"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    public GeneralExceptionHandler() {
        GeneralExceptionHandler a;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, G);
        J.error(c_oka.m_le((Object)"{_^VUR^\u0013SAUF_V\\G\b\u0013IN"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4, Map<String, List<String>> a5) {
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = a6;
        a2 = generalExceptionHandler.sanitizeMessage(a2, a3);
        String string = generalExceptionHandler.isDevelopment() ? a3.getClass().getName() : AnimationJoin.m_le((Object)"^8x%k4r/u");
        String string2 = a6.isDevelopment() ? a4 : c_oka.m_le((Object)"v@A]A");
        String string3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a3) : null;
        return new ExceptionDetails(a.value(), a2, string, string2, a5, a4 = string3, new Date(), a6.getCurrentPath());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException a2) {
        GeneralExceptionHandler a3;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails(HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, A, map);
        J.error(AnimationJoin.m_le((Object)"\u0003t.h4i!r.o`m)t,z4r/uz;;f"), (Object)a2);
        return new ResponseEntity((Object)a2, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    protected ResponseEntity<Object> handleSecurityExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.FORBIDDEN, a.getMessage(), a, k);
        J.error(c_oka.m_le((Object)"aVQF@ZFJ\u0012V@A]A\b\u0013IN"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={c_ig.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleAlreadyExists(c_ig a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, b);
        J.error(AnimationJoin.m_le((Object)"\u0001w2~!\u007f9;%c)h4h`~2i/iz;;f"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={c_uj.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleNotActive(c_uj a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, c);
        J.error(c_oka.m_le((Object)"|\\F\u0013SPFZDV\u0012V@A]A\b\u0013IN"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleAllExceptions(Exception a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), a, m);
        J.error(AnimationJoin.m_le((Object)"\u0015u%c0~#o%\u007f`~2i/iz;;f"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a2) {
        headers = new HashMap();
        status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return AnimationJoin.m_le((Object)"\u000et`v%h3z'~`z6z)w!y,~");
        }, Collectors.toList())));
        a2 = ex.getBindingResult().getGlobalErrors().stream().map(a -> {
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return AnimationJoin.m_le((Object)"\u000et`v%h3z'~`z6z)w!y,~");
        }).collect(Collectors.toList());
        headers.putAll(status);
        if (!a2.isEmpty()) {
            headers.put(c_oka.m_le((Object)"U_]QS_"), a2);
        }
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, this.formatErrorMessages((Map)headers), (Exception)ex, G, (Map)headers);
        J.error(AnimationJoin.m_le((Object)"\u0016z,r$z4r/u`~2i/iz;;f"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return c_oka.m_le((Object)"BRF[\u001dF\\X\\\\E]");
        }
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, E);
        J.error(AnimationJoin.m_le((Object)"R,w%|!w`h4z4~z;;f"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, L);
        J.error(c_oka.m_le((Object)"vRFR\u0012Z\\GWT@ZFJ\u0012E[\\^RFZ]]\b\u0013IN"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={c_mf.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMismatch(c_mf a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, a.getMessage(), (Exception)a, i);
        J.error(AnimationJoin.m_le((Object)"\rr3v!o#s`~2i/iz;;f"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={c_sa.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInscadaException(c_sa a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, E);
        J.error(AnimationJoin.m_le((Object)"R.h#z$z`~2i/iz;;f"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={c_dl.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleFileStorage(c_dl a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, K);
        J.error(c_oka.m_le((Object)"tZ^V\u0012@F\\@RUV\u0012V@A]A\b\u0013IN"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException a) {
        GeneralExceptionHandler a2;
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getName();
        objectArray[1] = a.getValue();
        objectArray[2] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : c_oka.m_le((Object)"F\\X\\\\E]");
        String string = String.format(AnimationJoin.m_le((Object)"\u0010z2z-~4~2;g>3<`l)o(;6z,n%;g>3<`x/n,\u007f`u/o`y%;#t.m%i4~$;4t`o9k%;g>3<"), objectArray);
        a = a2.createExceptionDetails(HttpStatus.BAD_REQUEST, string, (Exception)a, G);
        J.error(AnimationJoin.m_le((Object)"O9k%;-r3v!o#sz;;f"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> a2) {
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)c_oka.m_le((Object)"\u001e\u0013"), (Iterable)a.getValue())).collect(Collectors.joining(c_oka.m_le((Object)"\u0013N\u0013")));
    }

    @ExceptionHandler(value={TransactionSystemException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException a) {
        GeneralExceptionHandler a2;
        Throwable throwable = a.getRootCause();
        if (throwable instanceof ConstraintViolationException) {
            return a2.handleConstraintViolation((ConstraintViolationException)throwable);
        }
        throwable = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, ExceptionUtils.getRootCauseMessage((Throwable)a), (Exception)a, L);
        J.error(AnimationJoin.m_le((Object)"\u0014i!u3z#o)t.;3b3o%v`~2i/iz;;f"), (Object)throwable, (Object)a);
        return new ResponseEntity((Object)throwable, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private /* synthetic */ boolean isDevelopment() {
        GeneralExceptionHandler a;
        String[] stringArray = new String[2];
        stringArray[0] = c_oka.m_le((Object)"WWE");
        stringArray[1] = AnimationJoin.m_le((Object)"4~3o");
        return Arrays.asList(stringArray).contains(a.g);
    }

    @ExceptionHandler(value={c_mc.class, EntityNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    protected ResponseEntity<Object> handleEntityNotFound(Exception a) {
        GeneralExceptionHandler a2;
        a = a2.createExceptionDetails(HttpStatus.NOT_FOUND, a.getMessage(), a, F);
        J.error(c_oka.m_le((Object)"w]FZFJ\u0012]]G\u0012U]F\\W\b\u0013IN"), (Object)a);
        return new ResponseEntity((Object)a, HttpStatus.NOT_FOUND);
    }

    private /* synthetic */ String sanitizeMessage(String a, Exception a2) {
        GeneralExceptionHandler a3;
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof c_ig) {
            return AnimationJoin.m_le((Object)"I%h/n2x%;!w2~!\u007f9;%c)h4h");
        }
        if (a2 instanceof c_dl) {
            return c_oka.m_le((Object)"u[_W\u0013]CWASG[\\\\\u0013TR[_WW");
        }
        if (a2 instanceof c_mf) {
            return AnimationJoin.m_le((Object)"I%h/n2x%;-r3v!o#s");
        }
        if (a2 instanceof c_uj) {
            return c_oka.m_le((Object)"`VA\\GAQV\u0012ZA\u0013\\\\F\u0013SPFZDV");
        }
        if (a2 instanceof c_mc) {
            return AnimationJoin.m_le((Object)"\u0012~3t5i#~`u/o`}/n.\u007f");
        }
        if (a2 instanceof c_fc) {
            return c_oka.m_le((Object)"aW_SGWW\u0012AW@]F@PW\u0013WK[@F@");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return AnimationJoin.m_le((Object)"_!o!y!h%;#t.h4i!r.o`m)t,z4r/u");
        }
        if (a2 instanceof TransactionSystemException) {
            return c_oka.m_le((Object)"vRFRPRAV\u0012G@R\\@SPFZ]]\u0012V@A]A");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return AnimationJoin.m_le((Object)"\u0014r-~`h%i)~3;$z4z\"z3~`~2i/i");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return c_oka.m_le((Object)"rQPW@A\u0013VV\\ZWW");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return AnimationJoin.m_le((Object)"R.m!w)\u007f`r.k5o");
        }
        if (a2 instanceof ConstraintViolationException) {
            return c_oka.m_le((Object)"eS_[WSG[\\\\\u0013Q\\\\@FASZ\\G\u0012E[\\^RFZ]]");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return AnimationJoin.m_le((Object)"\tu6z,r$;2~1n%h4;&t2v!o");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return c_oka.m_le((Object)"\u007fZA@[]U\u0013@VCF[AWW\u0012CSAS^WGWA");
        }
        if (a2 instanceof IllegalStateException) {
            return AnimationJoin.m_le((Object)"R.m!w)\u007f`z0k,r#z4r/u`h4z4~");
        }
        return c_oka.m_le((Object)"s]\u0012F\\VJCWPFVV\u0013WA@\\@\u0013]PQF@AWW");
    }

    @ExceptionHandler(value={c_fc.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    protected ResponseEntity<Object> handleRelationExists(c_fc a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.CONFLICT, a.getMessage(), (Exception)a, h);
        J.error(AnimationJoin.m_le((Object)"I%w!o)t.;%c)h4h`~2i/iz;;f"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException a) {
        GeneralExceptionHandler a2;
        ExceptionDetails exceptionDetails = a2.createExceptionDetails(HttpStatus.INTERNAL_SERVER_ERROR, a.getMessage(), (Exception)a, L);
        J.error(c_oka.m_le((Object)"z\\U^FJwp\u0013_RBCWA\u0012V@A]A\b\u0013IN"), (Object)exceptionDetails, (Object)a);
        return new ResponseEntity((Object)exceptionDetails, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, G);
        J.error(AnimationJoin.m_le((Object)"\r~3h!|%;.t4;2~!\u007f!y,~z;;f"), (Object)ex);
        return new ResponseEntity((Object)ex, HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatus a, String a2, Exception a3, String a4) {
        GeneralExceptionHandler a5;
        return a5.createExceptionDetails(a, a2, a3, a4, null);
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest a) {
        ex = this.createExceptionDetails(status, ex.getMessage(), ex, m);
        J.error(c_oka.m_le((Object)"{]FV@]S_\u0012V@A]A\b\u0013IN"), (Object)ex);
        return new ResponseEntity((Object)ex, status);
    }
}

