/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.aspects;

import com.inscada.mono.fs.model.FileResult;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.space.c_ic;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SpaceFilterAspect {
    @PersistenceContext
    private EntityManager entityManager;

    public SpaceFilterAspect() {
        SpaceFilterAspect a;
    }

    @Pointcut(value="@within(com.inscada.mono.shared.aspects.DisableSpaceFilter) || @annotation(com.inscada.mono.shared.aspects.DisableSpaceFilter)")
    void hasDisableSpaceFilterAnnotation() {
    }

    @Around(value="execution(public * *(..)) && hasSpaceFilterAnnotation()")
    public Object aroundExecution(ProceedingJoinPoint a) throws Throwable {
        SpaceFilterAspect a2;
        ProceedingJoinPoint proceedingJoinPoint = a;
        Object object = proceedingJoinPoint.getSignature().getName();
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        if (method.getDeclaringClass().isInterface()) {
            method = a.getTarget().getClass().getDeclaredMethod((String)object, method.getParameterTypes());
        }
        if ((object = a2.getSpaceFilterAnnotation((AnnotatedElement)method)) == null) {
            object = a2.getSpaceFilterAnnotation(method.getDeclaringClass());
        }
        if (object instanceof DisableSpaceFilter) {
            ((Session)a2.entityManager.unwrap(Session.class)).disableFilter("spaceFilter");
        }
        if (object instanceof EnableSpaceFilter && (object = (Session)a2.entityManager.unwrap(Session.class)).getEnabledFilter("spaceFilter") == null) {
            object.enableFilter("spaceFilter").setParameter("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), FileResult.m_le((Object)"pkBxF;PsLnO\u007f\u0003yF;SiFhFuW")).getId()).validate();
        }
        return a.proceed();
    }

    @Pointcut(value="@within(com.inscada.mono.shared.aspects.EnableSpaceFilter) || @annotation(com.inscada.mono.shared.aspects.EnableSpaceFilter)")
    void hasEnableSpaceFilterAnnotation() {
    }

    public static String m_le(Object a) {
        a = (String)a;
        int n = ((String)a).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (2 ^ 5) << 4 ^ 3 << 1;
        int n4 = n2;
        int n5 = (2 ^ 5) << 4 ^ 1 << 1;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @Pointcut(value="hasEnableSpaceFilterAnnotation() || hasDisableSpaceFilterAnnotation()")
    void hasSpaceFilterAnnotation() {
    }

    private /* synthetic */ Annotation getSpaceFilterAnnotation(AnnotatedElement a) {
        EnableSpaceFilter enableSpaceFilter = a.getAnnotation(EnableSpaceFilter.class);
        if (enableSpaceFilter != null) {
            return enableSpaceFilter;
        }
        enableSpaceFilter = a.getAnnotation(DisableSpaceFilter.class);
        return enableSpaceFilter;
    }
}

