/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.auth.c_nga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.cluster.z.c_hla;
import com.inscada.mono.communication.base.services.c_yca;
import com.inscada.mono.job.b.c_yl;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.log.services.c_uh;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.script.enums.c_el;
import com.inscada.mono.script.enums.c_vj;
import com.inscada.mono.script.events.CancelEvent;
import com.inscada.mono.script.events.RescheduleEvent;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.services.c_dj;
import com.inscada.mono.script.services.c_kh;
import com.inscada.mono.script.services.c_yk;
import com.inscada.mono.shared.exceptions.c_sa;
import com.inscada.mono.shared.exceptions.c_uj;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
implements ClusterNodeListener {
    public static final short d = 306;
    private final ClusterOperations M;
    private final c_dj a;
    private final c_yl h;
    public static final short G = 307;
    private static final String k = "scheduled_scripts";
    private final JedisPooled J;
    private final c_uh b;
    public static final short m = 302;
    public static final short i = 304;
    public static final short g = 303;
    public static final short K = 301;
    private final Lock A;
    private final c_kh F;
    public static final short c = 305;
    private static final Logger E = LoggerFactory.getLogger(ScriptManager.class);
    private final Map<Integer, Job> L;

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_vj> getScriptStatuses(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.M.isLeader()) {
            E.debug(c_yca.m_le((Object)"\u001b+\u0016*\u0012<mN\u0010\u000b#\u001a>\u00000N$\r%\u0007'\u001aw\u001d#\u000f#\u001b$\u000b$N1\u0001%N,\u0013w'\u0013\u001dw\u00028\r6\u0002;\u0017mN,\u0013"), (Object)a.size(), a);
            return a2.getScriptStatusesByIdsInternal(a);
        }
        E.debug(c_sa.m_le((Object)"5+5I7!: >6AD)\u0001\n\u0011\u001e\u0017\u000f\r\u0015\u0003[\b\u001e\u0005\u001f\u0001\tD\u001d\u000b\tD\b\u0007\t\r\u000b\u0010[\u0017\u000f\u0005\u000f\u0011\b\u0001\bD\u001d\u000b\tD\u0000\u0019[-?\u0017AD\u0000\u0019"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.M.callLeaderMethod(Short.valueOf((short)306), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_yca.m_le((Object)"B"))), (Throwable)exception);
        }
    }

    protected void scheduleScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.scheduleScriptInternal(scriptManager.a.m_xh(a));
    }

    public void notLeader() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        String string = scriptManager.M.getCurrentNode().getNodeId();
        E.info(c_sa.m_le((Object)"(\u0007\t\r\u000b\u00106\u0005\u0015\u0005\u001c\u0001\t^[0\u0013\r\bD\u0015\u000b\u001f\u0001[L\u0000\u0019RD\u0012\u0017[*4D7+5#>6[03![(>%?!)J['\u001a\n\u0018\u0001\u0017\b\u0012\n\u001cD\u001a\b\u0017D\u0017\u000b\u0018\u0005\u0017D\b\u0007\t\r\u000b\u0010[\u000e\u0014\u0006\bJUJ"), (Object)string);
        scriptManager.A.lock();
        try {
            new ArrayList(a.L.keySet()).forEach(a2 -> {
                ScriptManager a3;
                Job job = (Job)a3.L.get(a2);
                if (job != null) {
                    try {
                        E.info(c_sa.m_le((Object)"7\u0018\u0016\u0012\u0014\u000f)\u001a\n\u001a\u0003\u001e\u0016[L5\u000b\u000fD7\u0001\u001a\u0000\u001e\u0016[\u001f\u0006MAD8\u0005\u0015\u0007\u001e\b\u0017\r\u0015\u0003[\b\u0014\u0007\u001a\b[\u000e\u0014\u0006[\u0002\u0014\u0016[\u0017\u0018\u0016\u0012\u0014\u000fD2 AD\u0000\u0019"), (Object)string, a2);
                        a3.h.m_wfa(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        E.error(c_yca.m_le((Object)"\u0004\r%\u0007'\u001a\u001a\u000f9\u000f0\u000b%N\u007f 8\u001aw\"2\u000f3\u000b%N,\u0013~Tw+%\u001c8\u001cw\r6\u00004\u000b;\u0002>\u00000N;\u00014\u000f;N=\u00015N1\u0001%N$\r%\u0007'\u001aw'\u0013N,\u0013mN,\u0013"), objectArray);
                    }
                }
            });
            a.L.clear();
            E.info(c_yca.m_le((Object)"=4\u001c>\u001e##6\u00006\t2\u001cwF\u0019\u0001#N\u001b\u000b6\n2\u001cw\u0015*GmN\u0016\u0002;N;\u00014\u000f;N$\r%\u0007'\u001aw\u00048\f$N?\u000f!\u000bw\f2\u000b9N%\u000b&\u001b2\u001d#\u000b3N#\u0001w\r6\u00004\u000b;N6\u00003N4\u00022\u000f%\u000b3N1\u001c8\u0003w\u00028\r6\u0002w\u001a%\u000f4\u0005>\u00000@"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            E.error(c_sa.m_le((Object)"7\u0018\u0016\u0012\u0014\u000f)\u001a\n\u001a\u0003\u001e\u0016[L5\u000b\u000fD7\u0001\u001a\u0000\u001e\u0016[\u001f\u0006MAD>\u0016\t\u000b\tD\u001f\u0011\t\r\u0015\u0003[\u0014\t\u000b\u0018\u0001\b\u0017[\u000b\u001dD\u0018\u0005\u0015\u0007\u001e\b\u0017\r\u0015\u0003[\b\u0014\u0007\u001a\b[\u0017\u0018\u0016\u0012\u0014\u000fD\u0011\u000b\u0019\u0017AD\u0000\u0019"), objectArray);
            return;
        }
        finally {
            a.A.unlock();
        }
    }

    protected void cancelScriptsByProjectIdInternal(Integer a) {
        ScriptManager a2;
        if ((a = a2.a.m_qj((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        String string = scriptManager.M.getCurrentNode().getNodeId();
        E.info(c_yca.m_le((Object)"=4\u001c>\u001e##6\u00006\t2\u001cmN\u0003\u0006>\u001dw\u00008\n2N\u007f\u0015*Gw\u00066\u001dw\f2\r8\u00032N#\u00062N\u001b+\u0016*\u0012<yN\u0005\u000b$\u001a8\u001c>\u00000N$\r?\u000b3\u001b;\u000b3N$\r%\u0007'\u001a$@y@"), (Object)string);
        scriptManager.A.lock();
        try {
            Set set = a2.J.smembers(k).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                E.info(c_sa.m_le((Object)"(\u0007\t\r\u000b\u00106\u0005\u0015\u0005\u001c\u0001\tDS(\u001e\u0005\u001f\u0001\tD\u0000\u0019R^[*\u0014D\b\u0007\u0013\u0001\u001f\u0011\u0017\u0001\u001fD\b\u0007\t\r\u000b\u0010\bD\u001d\u000b\u000e\n\u001fD\u0012\n[6\u001e\u0000\u0012\u0017[\u0010\u0014D\t\u0001\b\u0010\u0014\u0016\u001eJ"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            E.info(c_yca.m_le((Object)"\u0004\r%\u0007'\u001a\u001a\u000f9\u000f0\u000b%N\u007f\"2\u000f3\u000b%N,\u0013~Tw(8\u001b9\nw\u0015*N$\r?\u000b3\u001b;\u000b3N$\r%\u0007'\u001aw'\u0013\u001dw\u00079N\u0005\u000b3\u0007$N#\u0001w\u001c2\u001d#\u0001%\u000bmN,\u0013"), objectArray);
            ArrayList arrayList = new ArrayList(a2.a.m_xk(set));
            E.info(c_sa.m_le((Object)"(\u0007\t\r\u000b\u00106\u0005\u0015\u0005\u001c\u0001\tDS(\u001e\u0005\u001f\u0001\tD\u0000\u0019R^[%\u000f\u0010\u001e\t\u000b\u0010\u0012\n\u001cD\u000f\u000b[\u0016\u001e\u0017\u000f\u000b\t\u0001[\u001f\u0006D\b\u0007\t\r\u000b\u0010\bJ"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ScriptManager a2;
                String string = a2.M.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    E.info(c_sa.m_le((Object)"(\u0007\t\r\u000b\u00106\u0005\u0015\u0005\u001c\u0001\tDS(\u001e\u0005\u001f\u0001\tD\u0000\u0019R^[6\u001e\u0017\u000f\u000b\t\r\u0015\u0003[\u0017\u0018\u0016\u0012\u0014\u000f^[\u001f\u0006DS-?^[\u001f\u0006M"), objectArray);
                    a2.scheduleScriptInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.b.m_pga(a.getProject()).m_g("Script Restore (Leader " + string + ")", String.format(c_yca.m_le((Object)"r\u001dwF\u001e*mNr\n~N1\u000f>\u00022\nw\u001a8N%\u000b$\u001a8\u001c2@w-6\u001b$\u000bmNr\u001d"), objectArray));
                    try {
                        E.warn(c_sa.m_le((Object)"(\u0007\t\r\u000b\u00106\u0005\u0015\u0005\u001c\u0001\tDS(\u001e\u0005\u001f\u0001\tD\u0000\u0019R^[%\u000f\u0010\u001e\t\u000b\u0010\u0012\n\u001cD\u000f\u000b[\u0007\u001a\n\u0018\u0001\u0017D\b\u0007\t\r\u000b\u0010[\u001f\u0006D\u001a\u0002\u000f\u0001\tD\t\u0001\b\u0010\u0014\u0016\u001a\u0010\u0012\u000b\u0015D\u001d\u0005\u0012\b\u000e\u0016\u001eJ"), (Object)string, (Object)a.getId());
                        a2.cancelScriptInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        E.error(c_yca.m_le((Object)"=4\u001c>\u001e##6\u00006\t2\u001cwF\u001b\u000b6\n2\u001cw\u0015*GmN\u0011\u000f>\u00022\nw\u001a8N4\u000f9\r2\u0002w\u001d4\u001c>\u001e#N,\u0013w\u000f1\u001a2\u001cw\u001c2\u001d#\u0001%\u000f#\u00078\u0000w\b6\u0007;\u001b%\u000bmN,\u0013"), objectArray2);
                        return;
                    }
                }
            });
            E.info(c_yca.m_le((Object)"=4\u001c>\u001e##6\u00006\t2\u001cwF\u001b\u000b6\n2\u001cw\u0015*GmN\u0011\u00079\u0007$\u00062\nw\u001d4\u001c>\u001e#N%\u000b$\u001a8\u001c6\u001a>\u00019N'\u001c8\r2\u001d$@"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            E.error(c_sa.m_le((Object)"(\u0007\t\r\u000b\u00106\u0005\u0015\u0005\u001c\u0001\tDS(\u001e\u0005\u001f\u0001\tD\u0000\u0019R^[!\t\u0016\u0014\u0016[\u0000\u000e\u0016\u0012\n\u001cD\b\u0007\t\r\u000b\u0010[\u0016\u001e\u0017\u000f\u000b\t\u0005\u000f\r\u0014\n[\u0014\t\u000b\u0018\u0001\b\u0017AD\u0000\u0019"), objectArray);
            return;
        }
        finally {
            a2.A.unlock();
        }
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.h.m_nga(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            Script script = Script.newBuilder((RepeatableScript)a).build();
            a2.F.m_ll(script);
            a2.cancelScript(a.getId());
        }, Duration.ofMillis(a.getDelay().intValue()), false);
    }

    private /* synthetic */ String generateJobName(RepeatableScript a) {
        Object[] objectArray = new Object[2];
        objectArray[0] = a.getType().m_q();
        objectArray[1] = a.getName();
        return String.format(c_yca.m_le((Object)"r\u001dw=4\u001c>\u001e#NzNr\u001d"), objectArray);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a) {
        ScriptManager a2;
        if (a2.M.isLeader()) {
            E.debug(c_sa.m_le((Object)"(>%?!)^['\u001a\n\u0018\u0001\u0017\b\u0012\n\u001cD\b\u0007\t\r\u000b\u0010[\u001f\u0006D\u0017\u000b\u0018\u0005\u0017\b\u0002J"), (Object)a);
            a2.cancelScriptInternal(a);
            return;
        }
        E.debug(c_yca.m_le((Object)"\u0019!\u0019C\u001b+\u0016*\u0012<mN\u0005\u000b&\u001b2\u001d#\u00079\tw\u00022\u000f3\u000b%N#\u0001w\r6\u00004\u000b;N$\r%\u0007'\u001aw\u0015*@"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.M.callLeaderMethod(Short.valueOf((short)302), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC cancel script " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_vj getScriptStatus(Integer a, String a2) {
        ScriptManager a3;
        if ((a = a3.a.m_sf(a, a2)) == null) {
            return c_vj.F;
        }
        return a3.getScriptStatus(a.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_vj getScriptStatus(Integer a) {
        ScriptManager a2;
        if (a2.M.isLeader()) {
            E.debug(c_sa.m_le((Object)"(>%?!)^[#\u001e\u0010\u000f\r\u0015\u0003[\u0017\u0018\u0016\u0012\u0014\u000fD\b\u0010\u001a\u0010\u000e\u0017[\u0002\u0014\u0016[\u001f\u0006D\u0017\u000b\u0018\u0005\u0017\b\u0002J"), (Object)a);
            return a2.getScriptStatusInternal(a);
        }
        E.debug(c_yca.m_le((Object)" \u0018 z\"\u0012/\u0013+\u0005Tw<2\u001f\"\u000b$\u001a>\u00000N;\u000b6\n2\u001cw\b8\u001cw\u001d4\u001c>\u001e#N$\u001a6\u001a\"\u001dw\b8\u001cw\u0015*@"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_vj)a2.M.callLeaderMethod(Short.valueOf((short)303), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get script status for " + a, (Throwable)exception);
        }
    }

    protected c_vj getScriptStatusInternal(Integer a) {
        ScriptManager a2;
        if (a2.L.containsKey(a)) {
            return c_vj.L;
        }
        return c_vj.F;
    }

    public ScriptManager(c_dj a, c_yl a2, c_kh a3, c_uh a4, JedisPooled a5, ClusterOperations a6) {
        ScriptManager a7;
        ScriptManager scriptManager = a7;
        ScriptManager scriptManager2 = a7;
        ScriptManager scriptManager3 = a7;
        ScriptManager scriptManager4 = a7;
        a7.A = new ReentrantLock();
        scriptManager4.L = new ConcurrentHashMap();
        scriptManager3.a = a;
        scriptManager3.h = a2;
        scriptManager2.F = a3;
        scriptManager2.b = a4;
        scriptManager.J = a5;
        scriptManager.M = a6;
    }

    protected void scheduleScriptsByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.a.m_qj((Integer)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> a.getType() != c_el.E).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    protected Map<Integer, c_vj> getScriptStatusesByProjectIdInternal(Integer a2) {
        ScriptManager a3;
        if ((a2 = a3.a.m_yi((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, a -> {
            ScriptManager a2;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.scheduleScript(scriptManager.a.m_ph(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(Integer a) {
        ScriptManager a2;
        if (a2.M.isLeader()) {
            E.debug(c_sa.m_le((Object)"(>%?!)^[7\u0018\f\u001e\u0000\u000e\b\u0012\n\u001cD\b\u0007\t\r\u000b\u0010[\u001f\u0006D\u0017\u000b\u0018\u0005\u0017\b\u0002J"), (Object)a);
            a2.scheduleScriptInternal(a);
            return;
        }
        E.debug(c_yca.m_le((Object)"\u0019!\u0019C\u001b+\u0016*\u0012<mN\u0005\u000b&\u001b2\u001d#\u00079\tw\u00022\u000f3\u000b%N#\u0001w\u001d4\u00062\n\"\u00022N$\r%\u0007'\u001aw\u0015*@"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.M.callLeaderMethod(Short.valueOf((short)301), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC schedule script " + a, (Throwable)exception);
        }
    }

    protected void cancelScriptInternal(Integer a) {
        ScriptManager a2;
        ScriptManager scriptManager = a2;
        scriptManager.cancelScriptInternal(scriptManager.a.m_xh(a));
    }

    private /* synthetic */ Job createDailyScriptJob(RepeatableScript a) {
        ScriptManager a2;
        Comparable<Date> comparable = a.getTime();
        comparable = LocalTime.of(comparable.getHours(), comparable.getMinutes(), comparable.getSeconds());
        return a2.h.m_haa(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.F.m_ll((Script)a);
        }, (LocalTime)comparable);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(Integer a, String a2) {
        ScriptManager a3;
        ScriptManager scriptManager = a3;
        scriptManager.cancelScript(scriptManager.a.m_ph(a, a2).getId());
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        ScriptManager a2;
        if (a2.M.isLeader()) {
            RepeatableScript repeatableScript = a.getScript();
            E.info(c_sa.m_le((Object)"7!: >6AD3\u0005\u0015\u0000\u0017\r\u0015\u0003['\u001a\n\u0018\u0001\u0017!\r\u0001\u0015\u0010[\u0002\u0014\u0016[\u0017\u0018\u0016\u0012\u0014\u000f^[\u001f\u0006DS-?^[\u001f\u0006M"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            a2.cancelScriptInternal(repeatableScript);
            return;
        }
        E.debug(c_yca.m_le((Object)" \u0018 z\"\u0012/\u0013+\u0005Tw'0\u00008\u001c>\u00000N\u0014\u000f9\r2\u0002\u0012\u00182\u0000#N1\u0001%N$\r%\u0007'\u001amN,\u0013"), (Object)a.getScript().getId());
    }

    @Order(value=1)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ScriptManager a2;
        if (a2.M.isLeader()) {
            Integer n = a.getProject().getId();
            E.info(c_sa.m_le((Object)"7!: >6AD3\u0005\u0015\u0000\u0017\r\u0015\u0003[4\t\u000b\u0011\u0001\u0018\u0010?\u0001\u001a\u0007\u000f\r\r\u0005\u000f\u0001>\u0012\u001e\n\u000fD\u001d\u000b\tD\u000b\u0016\u0014\u000e\u001e\u0007\u000fD2 AD\u0000\u0019"), (Object)n);
            a2.cancelScriptsByProjectIdInternal(n);
            return;
        }
        E.debug(c_yca.m_le((Object)"\u0019!\u0019C\u001b+\u0016*\u0012<mN\u001e\t9\u0001%\u00079\tw>%\u0001=\u000b4\u001a\u0013\u000b6\r#\u0007!\u000f#\u000b\u0012\u00182\u0000#N1\u0001%N'\u001c8\u00042\r#N\u001e*mN,\u0013"), (Object)a.getProject().getId());
    }

    protected void scheduleScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_nga.m_jub(() -> {
            ScriptManager a2;
            a2.A.lock();
            try {
                Job job;
                ScriptManager scriptManager;
                block14: {
                    a2.cancelScriptInternal(a);
                    if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                        throw new c_uj("Project should be active to schedule script " + a.getName());
                    }
                    switch (c_yk.L[a.getType().ordinal()]) {
                        case 1: {
                            ScriptManager scriptManager2 = a2;
                            while (false) {
                            }
                            scriptManager = scriptManager2;
                            job = scriptManager2.createDailyScriptJob(a);
                            break block14;
                        }
                        case 2: {
                            ScriptManager scriptManager3 = a2;
                            scriptManager = scriptManager3;
                            job = scriptManager3.createPeriodicScriptJob(a);
                            break block14;
                        }
                        case 3: {
                            job = a2.createOnceScriptJob(a);
                            break;
                        }
                        case 4: {
                            return;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown schedule type of " + a.getType());
                        }
                    }
                    scriptManager = a2;
                }
                scriptManager.L.put(a.getId(), job);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.J.sadd(k, stringArray);
                return;
            }
            finally {
                a2.A.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        scriptManager.registerRemoteCallsWithClusterNode();
        scriptManager.M.addListener((ClusterNodeListener)a);
        E.info(c_sa.m_le((Object)"(\u0007\t\r\u000b\u00106\u0005\u0015\u0005\u001c\u0001\tD\u0012\n\u0012\u0010\u0012\u0005\u0017\r\u0001\u0001\u001fD\u001a\n\u001fD\t\u0001\u001c\r\b\u0010\u001e\u0016\u001e\u0000[\u0005\bD8\b\u000e\u0017\u000f\u0001\t*\u0014\u0000\u001e(\u0012\u0017\u000f\u0001\u0015\u0001\tJ"));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ScriptManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.M.addRemoteCall((short)301, (Object)a, ScriptManager.class.getDeclaredMethod(c_yca.m_le((Object)"$\r?\u000b3\u001b;\u000b\u0004\r%\u0007'\u001a\u001e\u0000#\u000b%\u00006\u0002"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.M.addRemoteCall((short)302, (Object)a, ScriptManager.class.getDeclaredMethod(c_sa.m_le((Object)"\u0018\u0005\u0015\u0007\u001e\b(\u0007\t\r\u000b\u00102\n\u000f\u0001\t\n\u001a\b"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.M.addRemoteCall((short)303, (Object)a, ScriptManager.class.getDeclaredMethod(c_yca.m_le((Object)"\t2\u001a\u0004\r%\u0007'\u001a\u0004\u001a6\u001a\"\u001d\u001e\u0000#\u000b%\u00006\u0002"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.M.addRemoteCall((short)304, (Object)a, ScriptManager.class.getDeclaredMethod(c_sa.m_le((Object)"\b\u0007\u0013\u0001\u001f\u0011\u0017\u0001(\u0007\t\r\u000b\u0010\b&\u00024\t\u000b\u0011\u0001\u0018\u00102\u00002\n\u000f\u0001\t\n\u001a\b"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.M.addRemoteCall((short)305, (Object)a, ScriptManager.class.getDeclaredMethod(c_yca.m_le((Object)"4\u000f9\r2\u0002\u0004\r%\u0007'\u001a$,.>%\u0001=\u000b4\u001a\u001e\n\u001e\u0000#\u000b%\u00006\u0002"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.M.addRemoteCall((short)306, (Object)a, ScriptManager.class.getDeclaredMethod(c_sa.m_le((Object)"\u001c\u0001\u000f7\u0018\u0016\u0012\u0014\u000f7\u000f\u0005\u000f\u0011\b\u0001\b&\u0002-\u001f\u00172\n\u000f\u0001\t\n\u001a\b"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.M.addRemoteCall((short)307, (Object)a, ScriptManager.class.getDeclaredMethod(c_yca.m_le((Object)"0\u000b#=4\u001c>\u001e#=#\u000f#\u001b$\u000b$,.>%\u0001=\u000b4\u001a\u001e\n\u001e\u0000#\u000b%\u00006\u0002"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(c_sa.m_le((Object)"=\u0005\u0012\b\u001e\u0000[\u0010\u0014D\t\u0001\u001c\r\b\u0010\u001e\u0016[7\u0018\u0016\u0012\u0014\u000f)\u001a\n\u001a\u0003\u001e\u0016[6+'[\t\u001e\u0010\u0013\u000b\u001f\u0017"), noSuchMethodException);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(Integer a) {
        ScriptManager a2;
        if (a2.M.isLeader()) {
            E.debug(c_yca.m_le((Object)"\u001b+\u0016*\u0012<mN\u0004\r?\u000b3\u001b;\u00079\tw\u000f;\u0002w\u001d4\u001c>\u001e#\u001dw\b8\u001cw\u001e%\u0001=\u000b4\u001aw\u0015*N;\u00014\u000f;\u0002.@"), (Object)a);
            a2.scheduleScriptsByProjectIdInternal(a);
            return;
        }
        E.debug(c_sa.m_le((Object)"*4*V(>%?!)^[6\u001e\u0015\u000e\u0001\b\u0010\u0012\n\u001cD\u0017\u0001\u001a\u0000\u001e\u0016[\u0010\u0014D\b\u0007\u0013\u0001\u001f\u0011\u0017\u0001[\u0005\u0017\b[\u0017\u0018\u0016\u0012\u0014\u000f\u0017[\u0002\u0014\u0016[\u0014\t\u000b\u0011\u0001\u0018\u0010[\u001f\u0006J"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.M.callLeaderMethod(Short.valueOf((short)304), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC schedule scripts for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<Integer, c_vj> getScriptStatuses(Integer a) {
        ScriptManager a2;
        if (a2.M.isLeader()) {
            E.debug(c_yca.m_le((Object)"\"\u0012/\u0013+\u0005Tw)2\u001a#\u00079\tw\u000f;\u0002w\u001d4\u001c>\u001e#N$\u001a6\u001a\"\u001d2\u001dw\b8\u001cw\u001e%\u0001=\u000b4\u001aw\u0015*N;\u00014\u000f;\u0002.@"), (Object)a);
            return a2.getScriptStatusesByProjectIdInternal(a);
        }
        E.debug(c_sa.m_le((Object)"*4*V(>%?!)^[6\u001e\u0015\u000e\u0001\b\u0010\u0012\n\u001cD\u0017\u0001\u001a\u0000\u001e\u0016[\u0002\u0014\u0016[\u0005\u0017\b[\u0017\u0018\u0016\u0012\u0014\u000fD\b\u0010\u001a\u0010\u000e\u0017\u001e\u0017[\u0002\u0014\u0016[\u0014\t\u000b\u0011\u0001\u0018\u0010[\u001f\u0006J"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.M.callLeaderMethod(Short.valueOf((short)307), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        ScriptManager a2;
        if (a2.M.isLeader()) {
            RepeatableScript repeatableScript = a.getScript();
            E.info(c_yca.m_le((Object)"\u001b+\u0016*\u0012<mN\u001f\u000f9\n;\u00079\tw<2\u001d4\u00062\n\"\u00022+!\u000b9\u001aw\b8\u001cw\u001d4\u001c>\u001e#Tw\u0015*N\u007f'\u0013Tw\u0015*G"), (Object)repeatableScript.getName(), (Object)repeatableScript.getId());
            if (a2.getScriptStatusInternal(repeatableScript.getId()) == c_vj.L) {
                a2.scheduleScriptInternal(repeatableScript.getId());
                return;
            }
        } else {
            E.debug(c_sa.m_le((Object)"*4*V(>%?!)^[-\u001c\n\u0014\u0016\u0012\n\u001cD)\u0001\b\u0007\u0013\u0001\u001f\u0011\u0017\u0001>\u0012\u001e\n\u000fD\u001d\u000b\tD\b\u0007\t\r\u000b\u0010AD\u0000\u0019"), (Object)a.getScript().getId());
        }
    }

    protected Map<Integer, c_vj> getScriptStatusesByIdsInternal(List<Integer> a) {
        ScriptManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    protected void cancelScriptInternal(RepeatableScript a) {
        ScriptManager a2;
        c_nga.m_jub(() -> {
            ScriptManager a2;
            a2.A.lock();
            try {
                Job job = (Job)a2.L.get(a.getId());
                if (job != null) {
                    a2.h.m_wfa(job);
                }
                ScriptManager scriptManager = a2;
                scriptManager.L.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                scriptManager.J.srem(k, stringArray);
                return;
            }
            finally {
                a2.A.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(Integer a) {
        ScriptManager a2;
        if (a2.M.isLeader()) {
            E.debug(c_yca.m_le((Object)"\u001b+\u0016*\u0012<mN\u0014\u000f9\r2\u0002;\u00079\tw\u000f;\u0002w\u001d4\u001c>\u001e#\u001dw\b8\u001cw\u001e%\u0001=\u000b4\u001aw\u0015*N;\u00014\u000f;\u0002.@"), (Object)a);
            a2.cancelScriptsByProjectIdInternal(a);
            return;
        }
        E.debug(c_sa.m_le((Object)"*4*V(>%?!)^[6\u001e\u0015\u000e\u0001\b\u0010\u0012\n\u001cD\u0017\u0001\u001a\u0000\u001e\u0016[\u0010\u0014D\u0018\u0005\u0015\u0007\u001e\b[\u0005\u0017\b[\u0017\u0018\u0016\u0012\u0014\u000f\u0017[\u0002\u0014\u0016[\u0014\t\u000b\u0011\u0001\u0018\u0010[\u001f\u0006J"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.M.callLeaderMethod(Short.valueOf((short)305), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC cancel scripts for project " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript a) {
        ScriptManager a2;
        return a2.h.m_fea(a.getProject(), a2.generateJobName(a), () -> {
            ScriptManager a2;
            a = Script.newBuilder((RepeatableScript)a).build();
            a2.F.m_ll((Script)a);
        }, Duration.ofMillis(a.getPeriod().intValue()), a.getOffset());
    }
}

