/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.restcontrollers;

import com.inscada.mono.animation.model.ScriptDto;
import com.inscada.mono.impexp.b.c_gh;
import com.inscada.mono.impexp.c.c_vg;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.z.c_ji;
import com.inscada.mono.script.enums.c_vj;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.services.ScriptManager;
import com.inscada.mono.script.services.c_dj;
import com.inscada.mono.script.services.c_kh;
import com.inscada.mono.shared.repositories.BaseInfluxRepository;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/scripts"})
public class ScriptController
extends ProjectBasedImportExportController {
    private final c_dj c;
    private final c_kh E;
    private final ScriptManager L;

    @GetMapping(value={"/{scriptId}/status"})
    public c_vj getScriptStatus(@PathVariable(value="scriptId") Integer a) {
        return this.L.getScriptStatus(a);
    }

    @GetMapping
    public Collection<RepeatableScript> getScripts(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.c.m_la();
        }
        return this.c.m_sa(a);
    }

    @PutMapping(value={"/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateScript(@PathVariable(value="scriptId") Integer scriptId, @Valid @RequestBody RepeatableScript a) {
        this.c.m_io(scriptId, a);
    }

    @GetMapping(value={"/summary"})
    public Collection<RepeatableScriptSummary> getScriptsSummary(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.c.m_he();
        }
        return this.c.m_dk(a);
    }

    @PostMapping(value={"/{scriptId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelScript(@PathVariable(value="scriptId") Integer a) {
        this.L.cancelScript(a);
    }

    @PostMapping(value={"/{scriptId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScript(@PathVariable(value="scriptId") Integer a) {
        this.L.scheduleScript(a);
    }

    @DeleteMapping(value={""}, params={"scriptIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteScriptsByIds(@RequestParam(value="scriptIds") Integer[] a) {
        this.c.m_td(List.of(a));
    }

    @PostMapping
    public ResponseEntity<RepeatableScript> createScript(@Valid @RequestBody RepeatableScript script, UriComponentsBuilder a) {
        script = this.c.m_oj(script);
        Object[] objectArray = new Object[1];
        objectArray[0] = script.getId();
        return ResponseEntity.created((URI)a.path(BaseInfluxRepository.m_le((Object)"V$\n<\u000b6\t+0;\u0004")).buildAndExpand(objectArray).toUri()).body((Object)script);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScripts(@RequestParam(value="projectId") Integer a) {
        this.L.scheduleScripts(a);
    }

    @DeleteMapping(value={"/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteScript(@PathVariable(value="scriptId") Integer a) {
        this.c.m_ga(a);
    }

    @PostMapping(value={"/runner"})
    public Object runScript(@RequestBody ScriptDto a) {
        return this.E.m_bo(a);
    }

    @PostMapping(value={"/unschedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unscheduleScripts(@RequestParam(value="projectId") Integer a) {
        this.L.cancelScripts(a);
    }

    @GetMapping(value={"/{scriptId}"})
    public RepeatableScript getScript(@PathVariable(value="scriptId") Integer a) {
        return this.c.m_ba(a);
    }

    public ScriptController(c_dj a, ScriptManager a2, c_kh a3, c_gh a4, c_ji a5) {
        ScriptController a6;
        ScriptController scriptController = a6;
        super(a4, EnumSet.of(c_vg.m), a5);
        a6.c = a;
        scriptController.L = a2;
        scriptController.E = a3;
    }

    @PatchMapping(value={"/{scriptId}/code"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateScriptCode(@PathVariable(value="scriptId") Integer scriptId, @RequestBody String a) {
        this.c.m_vn(scriptId, a);
    }

    @PostMapping(value={"/{scriptId}/run"})
    public Object runScript(@PathVariable(value="scriptId") Integer a) {
        return this.E.m_rd(a);
    }

    @GetMapping(value={"/status"})
    public Map<Integer, c_vj> getScriptStatuses(@RequestParam(value="scriptIds") Integer[] a) {
        return this.L.getScriptStatuses(List.of(a));
    }
}

