/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.restcontrollers;

import com.inscada.mono.impexp.b.c_gh;
import com.inscada.mono.impexp.c.c_vg;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.z.c_ji;
import com.inscada.mono.report.enums.c_fn;
import com.inscada.mono.report.model.DeviationReportVariable;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.report.model.ReportSubgroup;
import com.inscada.mono.report.model.ReportVariable;
import com.inscada.mono.report.services.ReportManager;
import com.inscada.mono.report.services.c_bh;
import com.inscada.mono.report.services.c_og;
import com.inscada.mono.settings.restcontrollers.LogoController;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/reports"})
public class ReportController
extends ProjectBasedImportExportController {
    private final c_og c;
    private final ReportManager E;
    private final c_bh L;

    @GetMapping(value={"/{reportId}/excelExport"})
    public ResponseEntity<byte[]> exportToExcel(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.c.m_wo(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = DeviationReportVariable.m_le((Object)"#?6*!#/.,?yk$\"..,*/.\u007fi\u0010.2$0?l3.8`");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(LogoController.m_le((Object)"\u0002\f/\u0017$\r5N\u0005\n2\u0013.\u0010(\u0017(\f/"), stringArray)).contentType(MediaType.APPLICATION_OCTET_STREAM).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @PostMapping(value={"/{reportId}/print"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void printReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.c.m_zv(reportId, startDate, endDate, false, a);
    }

    @PostMapping(value={"/cancel"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReports(@RequestParam(value="projectId") Integer a) {
        this.E.cancelReports(a);
    }

    @GetMapping
    public Collection<Report> getReports(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.L.m_la();
        }
        return this.L.m_sa(a);
    }

    @PutMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReport(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody Report a) {
        this.L.m_yu(reportId, a);
    }

    @GetMapping(value={"/{reportId}/preview"})
    public ResponseEntity<byte[]> previewReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.c.m_tt(reportId, startDate, endDate, (OutputStream)byteArrayOutputStream, false, a);
        String[] stringArray = new String[1];
        stringArray[0] = DeviationReportVariable.m_le((Object)"#?6*!#/.,?yk$\"..,*/.\u007fi0.2$0?l;&-`");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(LogoController.m_le((Object)"\u0002\f/\u0017$\r5N\u0005\n2\u0013.\u0010(\u0017(\f/"), stringArray)).contentType(MediaType.APPLICATION_PDF).contentLength((long)byteArrayOutputStream.size()).body((Object)byteArrayOutputStream.toByteArray());
    }

    @DeleteMapping(value={"/groups/subgroups"}, params={"subgroupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubgroupsByIds(@RequestParam(value="subgroupIds") Integer[] a) {
        this.L.m_ux(List.of(a));
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public Collection<ReportVariable> getReportVariables(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.L.m_iv(reportId, groupId, a);
    }

    public ReportController(c_bh a, ReportManager a2, c_og a3, c_gh a4, c_ji a5) {
        ReportController a6;
        ReportController reportController = a6;
        super(a4, EnumSet.of(c_vg.f), a5);
        a6.L = a;
        reportController.E = a2;
        reportController.c = a3;
    }

    @GetMapping(value={"/{reportId}"})
    public Report getReport(@PathVariable(value="reportId") Integer a) {
        return this.L.m_ba(a);
    }

    @DeleteMapping(value={"/{reportId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReport(@PathVariable(value="reportId") Integer a) {
        this.L.m_ga(a);
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables"})
    public ResponseEntity<ReportVariable> createReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportVariable reportVariable, UriComponentsBuilder a) {
        reportVariable = this.L.m_rs(reportId, groupId, subgroupId, reportVariable);
        Object[] objectArray = new Object[4];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = subgroupId;
        objectArray[3] = reportVariable.getId();
        return ResponseEntity.created((URI)a.path(LogoController.m_le((Object)"L:\u0011$\u0013.\u00115*%\u001en\u00043\f4\u00132L:\u00043\f4\u0013\b\u0007<L2\u0016#\u00043\f4\u00132L:\u00104\u0001&\u0011.\u00161*%\u001en\u0015 \u0011(\u0002#\u000f$\u0010n\u00187\u00023\n \u0001-\u0006\b\u0007<")).buildAndExpand(objectArray).toUri()).body((Object)reportVariable);
    }

    @GetMapping(value={"/statuses"})
    public Map<Integer, c_fn> getReportStatuses(@RequestParam(value="reportIds") Integer[] a) {
        return this.E.getReportStatuses(Arrays.asList(a));
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody ReportVariable a) {
        this.L.m_az(reportId, groupId, subgroupId, variableId, a);
    }

    @DeleteMapping(value={""}, params={"reportIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportsByIds(@RequestParam(value="reportIds") Integer[] a) {
        this.L.m_uc(List.of(a));
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    public ReportVariable getReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        return this.L.m_xo(reportId, groupId, subgroupId, a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    public ReportSubgroup getReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        return this.L.m_qz(reportId, groupId, a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public Collection<ReportSubgroup> getReportSubgroups(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.L.m_oz(reportId, a);
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @Valid @RequestBody ReportSubgroup a) {
        this.L.m_jp(reportId, groupId, subgroupId, a);
    }

    @GetMapping(value={"/{reportId}/status"})
    public c_fn getReportStatus(@PathVariable(value="reportId") Integer a) {
        return this.E.getReportStatus(a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariable(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer subgroupId, @PathVariable(value="variableId") Integer a) {
        this.L.m_uy(reportId, groupId, subgroupId, a);
    }

    @DeleteMapping(value={"/groups/subgroups/variables"}, params={"variableIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportVariablesByIds(@RequestParam(value="variableIds") Integer[] a) {
        this.L.m_nq(List.of(a));
    }

    @PostMapping(value={"/{reportId}/groups"})
    public ResponseEntity<ReportGroup> createReportGroup(@PathVariable(value="reportId") Integer reportId, @Valid @RequestBody ReportGroup reportGroup, UriComponentsBuilder a) {
        reportGroup = this.L.m_vw(reportId, reportGroup);
        Object[] objectArray = new Object[2];
        objectArray[0] = reportId;
        objectArray[1] = reportGroup.getId();
        return ResponseEntity.created((URI)a.path(DeviationReportVariable.m_le((Object)"d99';-96\u0002&6m,0$7;1d9,0$7;\u000b/?")).buildAndExpand(objectArray).toUri()).body((Object)reportGroup);
    }

    @PostMapping
    public ResponseEntity<Report> createReport(@Valid @RequestBody Report report, UriComponentsBuilder a) {
        report = this.L.m_hq(report);
        Object[] objectArray = new Object[1];
        objectArray[0] = report.getId();
        return ResponseEntity.created((URI)a.path(LogoController.m_le((Object)"n\u00183\u00061\f3\u0017\b\u0007<")).buildAndExpand(objectArray).toUri()).body((Object)report);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReports(@RequestParam(value="projectId") Integer a) {
        this.E.scheduleReports(a);
    }

    @PostMapping(value={"/{reportId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleReport(@PathVariable(value="reportId") Integer a) {
        this.E.scheduleReport(a);
    }

    @PutMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportGroup a) {
        this.L.m_ty(reportId, groupId, a);
    }

    @DeleteMapping(value={"/groups"}, params={"groupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroupsByIds(@RequestParam(value="groupIds") Integer[] a) {
        this.L.m_nz(List.of(a));
    }

    @PostMapping(value={"/{reportId}/groups/{groupId}/subgroups"})
    public ResponseEntity<ReportSubgroup> createReportSubgroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @Valid @RequestBody ReportSubgroup reportSubgroup, UriComponentsBuilder a) {
        reportSubgroup = this.L.m_hw(reportId, groupId, reportSubgroup);
        Object[] objectArray = new Object[3];
        objectArray[0] = reportId;
        objectArray[1] = groupId;
        objectArray[2] = reportSubgroup.getId();
        return ResponseEntity.created((URI)a.path(DeviationReportVariable.m_le((Object)"m00.2$0?\u000b/?d%9->28m0%9->2\u0002&6m87)%9->28m01> ,0$7;\u000b/?")).buildAndExpand(objectArray).toUri()).body((Object)reportSubgroup);
    }

    @GetMapping(value={"/{reportId}/groups"})
    public Collection<ReportGroup> getReportGroups(@PathVariable(value="reportId") Integer a) {
        return this.L.m_cx(a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        this.L.m_aq(reportId, a);
    }

    @DeleteMapping(value={"/{reportId}/groups/{groupId}/subgroups/{subgroupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteReportSubGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer groupId, @PathVariable(value="subgroupId") Integer a) {
        this.L.m_mt(reportId, groupId, a);
    }

    @PostMapping(value={"/{reportId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelReport(@PathVariable(value="reportId") Integer a) {
        this.E.cancelReport(a);
    }

    @GetMapping(value={"/{reportId}/groups/{groupId}"})
    public ReportGroup getReportGroup(@PathVariable(value="reportId") Integer reportId, @PathVariable(value="groupId") Integer a) {
        return this.L.m_lz(reportId, a);
    }

    @PostMapping(value={"/{reportId}/mail"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void mailReport(@PathVariable(value="reportId") Integer reportId, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="lang") String a) {
        this.c.m_pw(reportId, startDate, endDate, false, a);
    }
}

