/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.report.model.ReportVariable;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="report_subgroup")
@CheckAtLeastOneNotNull(fieldNames={"groupId", "reportGroup"})
public class ReportSubgroup
extends SpaceBaseModel {
    @NotBlank
    @Size(max=100)
    private String name;
    @NotNull
    @Min(value=1L)
    @Column(name="subgroup_order")
    private Short subgroupOrder;
    @Id
    @Column(name="report_subgroup_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="reportSubgroupSeq")
    @GenericGenerator(name="reportSubgroupSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="report_subgroup_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @JsonIgnore
    @OneToMany(mappedBy="reportSubgroup", orphanRemoval=true)
    private Set<ReportVariable> reportVariables;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="report_group_id")
    private ReportGroup reportGroup;
    @Column(name="report_group_id", updatable=false, insertable=false)
    private Integer groupId;

    public boolean equals(Object a) {
        ReportSubgroup a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof ReportSubgroup)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (ReportSubgroup)a;
        return a2.getName().equals(a.getName()) && a2.getGroupId().equals(a.getGroupId());
    }

    public void setReportGroup(ReportGroup a) {
        ReportSubgroup a2;
        ReportSubgroup reportSubgroup = a2;
        reportSubgroup.reportGroup = a;
        reportSubgroup.groupId = a != null ? a.getId() : null;
    }

    public void setReportVariables(Set<ReportVariable> a) {
        a.reportVariables = a;
    }

    public void setGroupId(Integer a) {
        a.groupId = a;
    }

    public Set<ReportVariable> getReportVariables() {
        ReportSubgroup a;
        return a.reportVariables;
    }

    public Integer getGroupId() {
        ReportSubgroup a;
        return a.groupId;
    }

    public void setSubgroupOrder(Short a) {
        a.subgroupOrder = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public Integer getId() {
        ReportSubgroup a;
        return a.id;
    }

    public Short getSubgroupOrder() {
        ReportSubgroup a;
        return a.subgroupOrder;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public ReportGroup getReportGroup() {
        ReportSubgroup a;
        return a.reportGroup;
    }

    public String getName() {
        ReportSubgroup a;
        return a.name;
    }

    public ReportSubgroup() {
        ReportSubgroup a;
        ReportSubgroup reportSubgroup = a;
        reportSubgroup.reportVariables = new HashSet();
    }

    public int hashCode() {
        ReportSubgroup a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getName();
        objectArray[2] = a.getGroupId();
        return Objects.hash(objectArray);
    }
}

