/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="jspdf_report")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class JsPdfReport
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @NotBlank
    @Size(max=100)
    private String name;
    @Id
    @Column(name="jspdf_report_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="jsPdfReportSeq")
    @GenericGenerator(name="jsPdfReportSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="jspdf_report_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Size(max=255)
    private String dsc;
    private String script;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public int hashCode() {
        JsPdfReport a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public Integer getId() {
        JsPdfReport a;
        return a.id;
    }

    public void setScript(String a) {
        a.script = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public Integer getProjectId() {
        JsPdfReport a;
        return a.projectId;
    }

    public JsPdfReport() {
        JsPdfReport a;
    }

    public boolean equals(Object a) {
        JsPdfReport a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof JsPdfReport)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (JsPdfReport)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setProject(Project a) {
        a.project = a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public String getName() {
        JsPdfReport a;
        return a.name;
    }

    public String getScript() {
        JsPdfReport a;
        return a.script;
    }

    public Project getProject() {
        JsPdfReport a;
        return a.project;
    }

    public String getDsc() {
        JsPdfReport a;
        return a.dsc;
    }
}

