/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.restcontrollers;

import com.inscada.mono.animation.messages.EvalAnimationMessage;
import com.inscada.mono.impexp.b.c_gh;
import com.inscada.mono.impexp.c.c_vg;
import com.inscada.mono.impexp.model.ImportResult;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.project.model.ProjectClone;
import com.inscada.mono.project.model.ProjectLocationDto;
import com.inscada.mono.project.model.ProjectStatus;
import com.inscada.mono.project.z.c_ag;
import com.inscada.mono.project.z.c_ji;
import com.inscada.mono.project.z.c_jm;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/projects"})
public class ProjectController
extends ProjectBasedImportExportController {
    private final c_ji L;
    private final c_ag E;
    private final c_jm L;

    @GetMapping
    public Collection<Project> getProjects(@RequestParam(name="isActive", required=false) Boolean a) {
        if (a == null) {
            return this.L.m_la();
        }
        return this.L.m_qo(a);
    }

    public ProjectController(c_ji a, c_jm a2, c_ag a3, c_gh a4) {
        ProjectController a5;
        ProjectController projectController = a5;
        super(a4, EnumSet.of(c_vg.E), a);
        a5.L = a;
        projectController.L = a2;
        projectController.E = a3;
    }

    @PutMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProject(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody Project a) {
        this.L.m_dw(projectId, a);
    }

    @PatchMapping(value={"/{projectId}/location"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateProjectLocation(@PathVariable(value="projectId") Integer projectId, @Valid @RequestBody ProjectLocationDto a) {
        this.L.m_ip(projectId, a.getLatitude(), a.getLongitude());
    }

    @PostMapping(value={"/clone"})
    public ImportResult cloneProject(@Valid @RequestBody ProjectClone projectClone, @RequestParam(name="includeProjectAttachments", required=false) Boolean a) throws IOException {
        projectClone.setIncludeProjectAttachments(a);
        return this.E.m_zw(projectClone);
    }

    @GetMapping(value={"/name"}, params={"name"})
    public Project getProject(@RequestParam(name="name") String a) {
        return this.L.m_je(a);
    }

    @PostMapping
    public ResponseEntity<Project> createProject(@Valid @RequestBody Project project, UriComponentsBuilder a) {
        project = this.L.m_oo(project);
        Object[] objectArray = new Object[1];
        objectArray[0] = project.getId();
        return ResponseEntity.created((URI)a.path(EvalAnimationMessage.m_le((Object)"w*(#7;=2,\u0018<,")).buildAndExpand(objectArray).toUri()).body((Object)project);
    }

    @GetMapping(value={"/{projectId}/status"})
    public ProjectStatus getStatus(@PathVariable(value="projectId") Integer a) {
        return this.L.m_vx(a);
    }

    @GetMapping(value={"/{projectId}"})
    public Project getProject(@PathVariable(value="projectId") Integer a) {
        return this.L.m_ba(a);
    }

    @DeleteMapping(value={"/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteProject(@PathVariable(value="projectId") Integer a) {
        this.L.m_ga(a);
    }
}

