/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.language.restcontrollers;

import com.inscada.mono.impexp.b.c_gh;
import com.inscada.mono.impexp.c.c_vg;
import com.inscada.mono.impexp.restcontrollers.ImportExportController;
import com.inscada.mono.job.z.c_lj;
import com.inscada.mono.language.model.Language;
import com.inscada.mono.language.model.LanguageFilter;
import com.inscada.mono.language.z.c_bm;
import com.inscada.mono.shared.b.c_tc;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/languages"})
public class LanguageController
extends ImportExportController {
    private final c_bm L;

    @GetMapping(params={"lang", "keys"})
    public Collection<Language> getLanguagesByLangAndKeys(@RequestParam(value="lang") String lang, @RequestParam(value="keys") String[] a) {
        return this.L.m_ria(lang, a);
    }

    @DeleteMapping(value={"/{languageId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteLanguage(@PathVariable(value="languageId") Integer a) {
        this.L.m_ga(a);
    }

    @GetMapping(value={"/pages"}, params={"key"})
    public Page<Language> findLanguagesByKey(@RequestParam(value="key") String key, Pageable a) {
        if (c_tc.m_al((String)key)) {
            return this.L.m_tga(key, a);
        }
        return this.L.m_ika(a);
    }

    @PostMapping(value={"/filter"})
    public Page<Language> findLanguagesByFilter(@RequestBody LanguageFilter languageFilter, Pageable a) {
        return this.L.m_ica(languageFilter, a);
    }

    @GetMapping(params={"lang", "key"})
    public Language getLanguageByLangAndKey(@RequestParam(value="lang") String lang, @RequestParam(value="key") String a) {
        return this.L.m_dha(lang, a);
    }

    @PutMapping(value={"/{languageId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateLanguage(@PathVariable(value="languageId") Integer languageId, @Valid @RequestBody Language a) {
        this.L.m_afa(languageId, a);
    }

    @GetMapping(value={"/langs"})
    public Collection<String> getLanguageDistinctLangs() {
        LanguageController a;
        return a.L.m_nia();
    }

    @GetMapping(params={"key"})
    public Collection<Language> getLanguagesByKey(@RequestParam(value="key") String a) {
        return this.L.m_saa(a);
    }

    @GetMapping(value={"/pages"})
    public Page<Language> findAll(Pageable a) {
        LanguageController a2;
        return a2.L.m_ika(a);
    }

    @GetMapping
    public Collection<Language> getLanguages() {
        LanguageController a;
        return a.L.m_la();
    }

    @DeleteMapping(value={""}, params={"languageIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteLanguagesByIds(@RequestParam(value="languageIds") Integer[] a) {
        this.L.m_uc(List.of(a));
    }

    public LanguageController(c_bm a, c_gh a2) {
        super(a2, EnumSet.of(c_vg.a));
        LanguageController a3;
        a3.L = a;
    }

    @GetMapping(params={"lang"})
    public Collection<Language> getLanguagesByLang(@RequestParam(value="lang") String a) {
        return this.L.m_lfa(a);
    }

    @PutMapping(value={"/bulk"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void upsert(@Valid @RequestBody Collection<Language> a) {
        this.L.m_xa(a);
    }

    @PostMapping
    public ResponseEntity<Language> createLanguage(@Valid @RequestBody Language language, UriComponentsBuilder a) {
        language = this.L.m_kka(language);
        Object[] objectArray = new Object[1];
        objectArray[0] = language.getId();
        return ResponseEntity.created((URI)a.path(c_lj.m_le((Object)"jv)l+j0l\"h\fi8")).buildAndExpand(objectArray).toUri()).body((Object)language);
    }

    @GetMapping(value={"/{languageId}"})
    public Language getLanguage(@PathVariable(value="languageId") Integer a) {
        return this.L.m_ba(a);
    }
}

