/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.faceplate.restcontrollers;

import com.inscada.mono.faceplate.model.Faceplate;
import com.inscada.mono.faceplate.model.FaceplateElement;
import com.inscada.mono.faceplate.model.FaceplatePlaceholder;
import com.inscada.mono.faceplate.z.c_rg;
import com.inscada.mono.impexp.b.c_gh;
import com.inscada.mono.impexp.c.c_vg;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.job.z.c_ko;
import com.inscada.mono.project.z.c_ji;
import com.inscada.mono.report.model.DeviationReportVariable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/faceplates"})
public class FaceplateController
extends ProjectBasedImportExportController {
    private final c_rg L;

    @GetMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    public FaceplatePlaceholder getFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        return this.L.m_qga(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}/elements"})
    public Collection<FaceplateElement> getFaceplateElements(@PathVariable(value="faceplateId") Integer a) {
        return this.L.m_nda(a);
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Faceplate> getFaceplatesByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.L.m_cga(projectId, a);
    }

    @GetMapping(value={"/{faceplateId}/svg"})
    public ResponseEntity<InputStreamResource> getFaceplateSvg(@PathVariable(value="faceplateId") Integer a) {
        a = this.L.m_ba(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(DeviationReportVariable.m_le((Object)"\u0001$,?'%6f\u0006\"1;-8+?+$,"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)c_ko.m_le((Object)"0a8k<#*z>'!a5"))).body((Object)byteArrayInputStream);
    }

    @PutMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer placeholderId, @Valid @RequestBody FaceplatePlaceholder a) {
        this.L.m_uha(faceplateId, placeholderId, a);
    }

    @PostMapping(value={"/{faceplateId}/placeholders"})
    public ResponseEntity<FaceplatePlaceholder> createFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplatePlaceholder faceplatePlaceholder, UriComponentsBuilder a) {
        faceplatePlaceholder = this.L.m_tfa(faceplateId, faceplatePlaceholder);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplatePlaceholder.getId();
        return ResponseEntity.created((URI)a.path(DeviationReportVariable.m_le((Object)"m0$*!.2'#?'\u0002&6m;.*!.*$./'91d9.../.,?\u000b/?")).buildAndExpand(objectArray).toUri()).body((Object)faceplatePlaceholder);
    }

    @PostMapping
    public ResponseEntity<Faceplate> createFaceplate(@Valid @RequestBody Faceplate faceplate, UriComponentsBuilder a) {
        faceplate = this.L.m_kia(faceplate);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplate.getId();
        return ResponseEntity.created((URI)a.path(c_ko.m_le((Object)"#\"j8o<|5m-i\u0010h$")).buildAndExpand(objectArray).toUri()).body((Object)faceplate);
    }

    @DeleteMapping(value={"/{faceplateId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElementsByIds(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(value="elementIds") Integer[] a) {
        this.L.m_ega(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}/elements/{elementId}"})
    public FaceplateElement getFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        return this.L.m_gka(faceplateId, a);
    }

    @GetMapping(value={"/{faceplateId}/placeholders"})
    public Collection<FaceplatePlaceholder> getFaceplatePlaceholders(@PathVariable(value="faceplateId") Integer a) {
        return this.L.m_kja(a);
    }

    @GetMapping(value={"/{faceplateId}"})
    public Faceplate getFaceplate(@PathVariable(value="faceplateId") Integer a) {
        return this.L.m_ba(a);
    }

    public FaceplateController(c_rg a, c_gh a2, c_ji a3) {
        super(a2, EnumSet.of(c_vg.g), a3);
        FaceplateController a4;
        a4.L = a;
    }

    @DeleteMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer a) {
        this.L.m_eia(faceplateId, a);
    }

    @PostMapping(value={"/{faceplateId}/clone"}, params={"name"})
    public ResponseEntity<Faceplate> cloneFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        faceplateId = this.L.m_yca(faceplateId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = faceplateId.getId();
        return ResponseEntity.created((URI)a.path(DeviationReportVariable.m_le((Object)"d9-#(';.*6.\u000b/?")).buildAndExpand(objectArray).toUri()).body((Object)faceplateId);
    }

    @GetMapping
    public Collection<Faceplate> getFaceplates(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.L.m_la();
        }
        return this.L.m_sa(a);
    }

    @PutMapping(value={"/{faceplateId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateSvg(@PathVariable(value="faceplateId") Integer faceplateId, @RequestBody String a) {
        this.L.m_iaa(faceplateId, a);
    }

    @PutMapping(value={"/{faceplateId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody FaceplateElement a) {
        this.L.m_lia(faceplateId, elementId, a);
    }

    @DeleteMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplate(@PathVariable(value="faceplateId") Integer a) {
        this.L.m_ga(a);
    }

    @PostMapping(value={"/{faceplateId}/elements"})
    public ResponseEntity<FaceplateElement> createFaceplateElement(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody FaceplateElement faceplateElement, UriComponentsBuilder a) {
        faceplateElement = this.L.m_ela(faceplateId, faceplateElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = faceplateId;
        objectArray[1] = faceplateElement.getId();
        return ResponseEntity.created((URI)a.path(c_ko.m_le((Object)"vw?m:i)`8x<E=qvi5i4i7x*#\"i5i4i7x\u0010h$")).buildAndExpand(objectArray).toUri()).body((Object)faceplateElement);
    }

    @DeleteMapping(value={"/{faceplateId}/placeholders/{placeholderId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaceplatePlaceholder(@PathVariable(value="faceplateId") Integer faceplateId, @PathVariable(value="placeholderId") Integer a) {
        this.L.m_wea(faceplateId, a);
    }

    @PutMapping(value={"/{faceplateId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFaceplate(@PathVariable(value="faceplateId") Integer faceplateId, @Valid @RequestBody Faceplate a) {
        this.L.m_yfa(faceplateId, a);
    }
}

