/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.faceplate.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.faceplate.model.FaceplateElement;
import com.inscada.mono.faceplate.model.FaceplatePlaceholder;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="faceplate")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Faceplate
extends SpaceBaseModel {
    @Size(max=255)
    private String dsc;
    @Id
    @Column(name="faceplate_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="faceplateSeq")
    @GenericGenerator(name="faceplateSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="faceplate_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Size(max=25)
    private String color;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @OneToMany(mappedBy="faceplate", orphanRemoval=true)
    private Set<FaceplatePlaceholder> faceplatePlaceholders;
    @NotBlank
    @Size(max=100)
    private String name;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @OneToMany(mappedBy="faceplate", orphanRemoval=true)
    private Set<FaceplateElement> faceplateElements;
    @NotBlank
    @Column(name="svg_content")
    private String svgContent;

    public Project getProject() {
        Faceplate a;
        return a.project;
    }

    public void addPlaceholder(FaceplatePlaceholder a) {
        Faceplate a2;
        Faceplate faceplate = a2;
        a.setFaceplate(faceplate);
        faceplate.faceplatePlaceholders.add(a);
    }

    public void setFaceplatePlaceholders(Set<FaceplatePlaceholder> a) {
        a.faceplatePlaceholders = a;
    }

    public String getName() {
        Faceplate a;
        return a.name;
    }

    public Faceplate() {
        Faceplate a;
        Faceplate faceplate = a;
        a.faceplateElements = new HashSet();
        faceplate.faceplatePlaceholders = new HashSet();
    }

    public Set<FaceplateElement> getFaceplateElements() {
        Faceplate a;
        return a.faceplateElements;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public Faceplate(String a, String a2, String a3, String a4, Project a5, Set<FaceplateElement> a6, Set<FaceplatePlaceholder> a7) {
        Faceplate a8;
        Faceplate faceplate = a8;
        Faceplate faceplate2 = a8;
        Faceplate faceplate3 = a8;
        Faceplate faceplate4 = a8;
        Faceplate faceplate5 = a8;
        faceplate4.faceplateElements = new HashSet();
        faceplate4.faceplatePlaceholders = new HashSet();
        faceplate4.name = a;
        faceplate3.dsc = a2;
        faceplate3.svgContent = a3;
        faceplate2.color = a4;
        faceplate2.project = a5;
        faceplate.faceplateElements = a6;
        faceplate.faceplatePlaceholders = a7;
    }

    public void addElement(FaceplateElement a) {
        Faceplate a2;
        Faceplate faceplate = a2;
        a.setFaceplate(faceplate);
        faceplate.faceplateElements.add(a);
    }

    public void removeElement(Integer a) {
        Faceplate a3;
        a3.faceplateElements.removeIf(a2 -> a2.getId().equals(a));
    }

    public void setProject(Project a) {
        Faceplate a2;
        Faceplate faceplate = a2;
        faceplate.project = a;
        faceplate.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Faceplate(Integer a, Integer a2, String a3, String a4, String a5, Project a6, String a7, Date a8, String a9, Date a10) {
        Faceplate a11;
        Faceplate faceplate = a11;
        Faceplate faceplate2 = a11;
        Faceplate faceplate3 = a11;
        Faceplate faceplate4 = a11;
        Faceplate faceplate5 = a11;
        Faceplate faceplate6 = a11;
        a11.faceplateElements = new HashSet();
        faceplate6.faceplatePlaceholders = new HashSet();
        faceplate5.id = a;
        faceplate5.projectId = a2;
        faceplate4.name = a3;
        faceplate4.dsc = a4;
        faceplate3.color = a5;
        faceplate3.project = a6;
        faceplate2.createdBy = a7;
        faceplate2.creationDate = a8;
        faceplate.lastModifiedBy = a9;
        faceplate.lastModifiedDate = a10;
    }

    public Integer getId() {
        Faceplate a;
        return a.id;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public String getSvgContent() {
        Faceplate a;
        return a.svgContent;
    }

    public void setName(String a) {
        a.name = a;
    }

    public String getDsc() {
        Faceplate a;
        return a.dsc;
    }

    public void setColor(String a) {
        a.color = a;
    }

    public void setFaceplateElements(Set<FaceplateElement> a) {
        a.faceplateElements = a;
    }

    public boolean equals(Object a) {
        Faceplate a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Faceplate)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Faceplate)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public String getColor() {
        Faceplate a;
        return a.color;
    }

    public Integer getProjectId() {
        Faceplate a;
        return a.projectId;
    }

    public int hashCode() {
        Faceplate a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setSvgContent(String a) {
        a.svgContent = a;
    }

    public Set<FaceplatePlaceholder> getFaceplatePlaceholders() {
        Faceplate a;
        return a.faceplatePlaceholders;
    }
}

