/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_nga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.cluster.z.c_hla;
import com.inscada.mono.communication.base.enums.c_lla;
import com.inscada.mono.communication.base.enums.c_via;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_gea;
import com.inscada.mono.communication.base.services.c_jba;
import com.inscada.mono.communication.base.services.c_qba;
import com.inscada.mono.communication.base.services.z.c_tf;
import com.inscada.mono.datatransfer.events.CancelEvent;
import com.inscada.mono.datatransfer.events.RescheduleEvent;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.c_ak;
import com.inscada.mono.datatransfer.services.c_hd;
import com.inscada.mono.datatransfer.z.c_yi;
import com.inscada.mono.job.b.c_yl;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.log.services.c_uh;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_uj;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener {
    private final JedisPooled f;
    private static final String C = "scheduledDataTransfers";
    private static final Logger d = LoggerFactory.getLogger(DataTransferManager.class);
    private final Map<Integer, Job> M;
    private final Lock a;
    public static final short h = 401;
    private final c_ak G;
    public static final short k = 405;
    public static final short J = 403;
    public static final short b = 407;
    private final c_jba m;
    private final c_yl i;
    private final c_qba g;
    private final c_uh K;
    private final ClusterOperations A;
    private final c_gea F;
    public static final short c = 404;
    public static final short E = 402;
    public static final short L = 406;

    protected void cancelDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.G.m_xh(a));
    }

    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date a, c_lla a2) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        calendar.setTime(a);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        Calendar calendar3 = (Calendar)calendar2.clone();
        switch (c_hd.L[a2.ordinal()]) {
            case 1: {
                Calendar calendar4 = calendar;
                while (false) {
                }
                calendar4.set(12, 0);
                return Pair.of((Object)calendar4.getTime(), (Object)a);
            }
            case 2: {
                calendar3.add(11, -1);
                Calendar calendar5 = calendar;
                calendar5.add(11, -2);
                calendar5.set(12, 0);
                return Pair.of((Object)calendar5.getTime(), (Object)calendar3.getTime());
            }
            case 3: {
                Calendar calendar6 = calendar;
                calendar6.set(11, 0);
                calendar6.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 4: {
                calendar3.add(5, -1);
                Calendar calendar7 = calendar;
                calendar.add(5, -2);
                calendar7.set(11, 0);
                calendar7.set(12, 0);
                return Pair.of((Object)calendar7.getTime(), (Object)calendar3.getTime());
            }
            case 5: {
                Calendar calendar8 = calendar;
                Calendar calendar9 = calendar;
                calendar9.set(7, calendar9.getFirstDayOfWeek());
                calendar8.set(11, 0);
                calendar8.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 6: {
                calendar3.add(3, -1);
                Calendar calendar10 = calendar;
                calendar.add(3, -2);
                Calendar calendar11 = calendar;
                calendar11.set(7, calendar11.getFirstDayOfWeek());
                calendar10.set(11, 0);
                calendar10.set(12, 0);
                return Pair.of((Object)calendar10.getTime(), (Object)calendar3.getTime());
            }
            case 7: {
                Calendar calendar12 = calendar;
                calendar.set(5, 1);
                calendar12.set(11, 0);
                calendar12.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 8: {
                calendar3.add(2, -1);
                Calendar calendar13 = calendar;
                Calendar calendar14 = calendar;
                calendar14.add(2, -2);
                calendar14.set(5, 1);
                calendar13.set(11, 0);
                calendar13.set(12, 0);
                return Pair.of((Object)calendar13.getTime(), (Object)calendar3.getTime());
            }
            case 9: {
                Calendar calendar15 = calendar;
                calendar.set(6, 1);
                calendar15.set(11, 0);
                calendar15.set(12, 0);
                return Pair.of((Object)calendar.getTime(), (Object)a);
            }
            case 10: {
                calendar3.add(1, -1);
                Calendar calendar16 = calendar;
                Calendar calendar17 = calendar;
                calendar17.add(1, -2);
                calendar17.set(6, 1);
                calendar16.set(11, 0);
                calendar16.set(12, 0);
                return Pair.of((Object)calendar16.getTime(), (Object)calendar3.getTime());
            }
        }
        throw new IllegalArgumentException(c_tf.m_le((Object)"5A\u0005W\u0010J\u0003[\u0005K@]\u0001A\u0007J@[\u0019_\u0005"));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.cancelDataTransfer(dataTransferManager.G.m_ph(a, a2).getId());
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, Double a2, VariableValue<?> a3) {
        DataTransferManager a4;
        return a4.isValueInThresholdRange(a, (VariableValue)new NumberVariableValue((Number)a2, new Date()), a3);
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        DataTransferManager a2;
        if (a2.A.isLeader()) {
            Integer n = a.getProject().getId();
            d.info(SetValueRequest.m_le((Object)"%$(%,3SA!\u0000\u0007\u0005\u0005\b\u0007\u0006I1\u001b\u000e\u0003\u0004\n\u0015-\u0004\b\u0002\u001d\b\u001f\u0000\u001d\u0004,\u0017\f\u000f\u001dA\u000f\u000e\u001bA\u0019\u0013\u0006\u000b\f\u0002\u001dA %SA\u0012\u001c"), (Object)n);
            a2.cancelDataTransfersByProjectIdInternal(n);
            return;
        }
        d.debug(c_tf.m_le((Object)"a/aMc%n$j2\u0015@f\u0007A\u000f]\tA\u0007\u000f0]\u000fE\u0005L\u0014k\u0005N\u0003[\tY\u0001[\u0005j\u0016J\u000e[@I\u000f]@_\u0012@\nJ\u0003[@f$\u0015@T\u001d"), (Object)a.getProject().getId());
    }

    public void notLeader() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        String string = dataTransferManager.A.getCurrentNode().getNodeId();
        d.info(SetValueRequest.m_le((Object)"%\b\u0015\b5\u001b\u0000\u0007\u0012\u000f\u0004\u001b,\b\u000f\b\u0006\f\u0013SA=\t\u0000\u0012I\u000f\u0006\u0005\fAA\u001a\u0014HI\b\u001aA'.I-&/.$;A=),A%$(%,3GA*\u0000\u0007\u0002\f\r\u0005\b\u0007\u0006I\u0000\u0005\rI\r\u0006\u0002\b\rI\u0005\b\u0015\bA\u001d\u0013\b\u000f\u001a\u0007\f\u0013I\u000b\u0006\u0003\u001aOGO"), (Object)string);
        dataTransferManager.a.lock();
        try {
            new ArrayList(a.M.keySet()).forEach(a2 -> {
                DataTransferManager a3;
                Job job = (Job)a3.M.get(a2);
                if (job != null) {
                    try {
                        d.info(c_tf.m_le((Object)"k\u0001[\u0001{\u0012N\u000e\\\u0006J\u0012b\u0001A\u0001H\u0005]@\u0007.@\u0014\u000f,J\u0001K\u0005]@T\u001d\u0006Z\u000f#N\u000eL\u0005C\fF\u000eH@C\u000fL\u0001C@E\u000fM@I\u000f]@K\u0001[\u0001\u000f\u0014]\u0001A\u0013I\u0005]@f$\u0015@T\u001d"), (Object)string, a2);
                        a3.i.m_wfa(job);
                        return;
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[4];
                        objectArray[0] = string;
                        objectArray[1] = a2;
                        objectArray[2] = exception.getMessage();
                        objectArray[3] = exception;
                        d.error(SetValueRequest.m_le((Object)"%\b\u0015\b5\u001b\u0000\u0007\u0012\u000f\u0004\u001b,\b\u000f\b\u0006\f\u0013II'\u000e\u001dA%\u0004\b\u0005\f\u0013I\u001a\u0014HSA,\u0013\u001b\u000e\u001bA\n\u0000\u0007\u0002\f\r\u0005\b\u0007\u0006I\r\u0006\u0002\b\rI\u000b\u0006\u0003I\u0007\u0006\u0013I\u0005\b\u0015\bA\u001d\u0013\b\u000f\u001a\u0007\f\u0013I(-A\u0012\u001cSA\u0012\u001c"), objectArray);
                    }
                }
            });
            a.M.clear();
            d.info(c_tf.m_le((Object)"k\u0001[\u0001{\u0012N\u000e\\\u0006J\u0012b\u0001A\u0001H\u0005]@\u0007.@\u0014\u000f,J\u0001K\u0005]@T\u001d\u0006Z\u000f!C\f\u000f\f@\u0003N\f\u000f\u0004N\u0014N@[\u0012N\u000e\\\u0006J\u0012\u000f\n@\u0002\\@G\u0001Y\u0005\u000f\u0002J\u0005A@]\u0005^\u0015J\u0013[\u0005K@[\u000f\u000f\u0003N\u000eL\u0005C@N\u000eK@L\fJ\u0001]\u0005K@I\u0012@\r\u000f\f@\u0003N\f\u000f\u0014]\u0001L\u000bF\u000eHN"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            d.error(SetValueRequest.m_le((Object)"-\u0000\u001d\u0000=\u0013\b\u000f\u001a\u0007\f\u0013$\u0000\u0007\u0000\u000e\u0004\u001bAA/\u0006\u0015I-\f\u0000\r\u0004\u001bA\u0012\u001c@[I$\u001b\u0013\u0006\u0013I\u0005\u001c\u0013\u0000\u000f\u000eA\u0019\u0013\u0006\u0002\f\u0012\u001aA\u0006\u0007I\u0002\b\u000f\n\u0004\u0005\r\u0000\u000f\u000eA\u0005\u000e\n\u0000\u0005A\r\u0000\u001d\u0000I\u0015\u001b\u0000\u0007\u0012\u000f\u0004\u001bA\u0003\u000e\u000b\u0012SA\u0012\u001c"), objectArray);
            return;
        }
        finally {
            a.a.unlock();
        }
    }

    public DataTransferManager(c_ak a, c_gea a2, c_qba a3, c_jba a4, c_yl a5, JedisPooled a6, c_uh a7, ClusterOperations a8) {
        DataTransferManager a9;
        DataTransferManager dataTransferManager = a9;
        DataTransferManager dataTransferManager2 = a9;
        DataTransferManager dataTransferManager3 = a9;
        DataTransferManager dataTransferManager4 = a9;
        DataTransferManager dataTransferManager5 = a9;
        a9.a = new ReentrantLock();
        dataTransferManager5.M = new ConcurrentHashMap();
        dataTransferManager4.G = a;
        dataTransferManager4.F = a2;
        dataTransferManager3.g = a3;
        dataTransferManager3.m = a4;
        dataTransferManager2.i = a5;
        dataTransferManager2.K = a7;
        dataTransferManager.f = a6;
        dataTransferManager.A = a8;
    }

    private /* synthetic */ void lambda$handleCurrentValues$8(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        a = (VariableValue)a.get(a5.getSourceVariableId());
        a2 = (VariableValue)a2.get(a5.getTargetVariableId());
        a3 = (Variable)a3.get(a5.getTargetVariableId());
        if (a != null && a3 != null && a6.isValueInThresholdRange(a5.getThreshold(), (VariableValue)a, (VariableValue)a2)) {
            a2 = new HashMap<String, Object>();
            a2.put(c_tf.m_le((Object)"\u0016N\fZ\u0005"), a.getValue());
            a4.put(a3.getName(), a2);
        }
    }

    protected c_yi getDataTransferStatusInternal(Integer a) {
        DataTransferManager a2;
        if (a2.M.containsKey(a)) {
            return c_yi.E;
        }
        return c_yi.c;
    }

    protected void cancelDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_nga.m_jub(() -> {
            DataTransferManager a2;
            a2.a.lock();
            try {
                Job job = (Job)a2.M.get(a.getId());
                if (job != null) {
                    a2.i.m_wfa(job);
                }
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.M.remove(a.getId());
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.f.srem(C, stringArray);
                return;
            }
            finally {
                a2.a.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    protected Map<Integer, c_yi> getDataTransferStatusesByIdsInternal(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            DataTransferManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.A.addRemoteCall((short)401, (Object)a, DataTransferManager.class.getDeclaredMethod(SetValueRequest.m_le((Object)"\u001a\u0002\u0001\u0004\r\u0014\u0005\u0004-\u0000\u001d\u0000=\u0013\b\u000f\u001a\u0007\f\u0013 \u000f\u001d\u0004\u001b\u000f\b\r"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.A.addRemoteCall((short)402, (Object)a, DataTransferManager.class.getDeclaredMethod(c_tf.m_le((Object)"L\u0001A\u0003J\fk\u0001[\u0001{\u0012N\u000e\\\u0006J\u0012f\u000e[\u0005]\u000eN\f"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.A.addRemoteCall((short)403, (Object)a, DataTransferManager.class.getDeclaredMethod(SetValueRequest.m_le((Object)"\u0006\f\u0015-\u0000\u001d\u0000=\u0013\b\u000f\u001a\u0007\f\u0013:\u0015\b\u0015\u001c\u0012 \u000f\u001d\u0004\u001b\u000f\b\r"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.A.addRemoteCall((short)404, (Object)a, DataTransferManager.class.getDeclaredMethod(c_tf.m_le((Object)"\\\u0003G\u0005K\u0015C\u0005k\u0001[\u0001{\u0012N\u000e\\\u0006J\u0012\\\"V0]\u000fE\u0005L\u0014f\u0004f\u000e[\u0005]\u000eN\f"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.A.addRemoteCall((short)405, (Object)a, DataTransferManager.class.getDeclaredMethod(SetValueRequest.m_le((Object)"\n\u0000\u0007\u0002\f\r-\u0000\u001d\u0000=\u0013\b\u000f\u001a\u0007\f\u0013\u001a#\u00101\u001b\u000e\u0003\u0004\n\u0015 \u0005 \u000f\u001d\u0004\u001b\u000f\b\r"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            a.A.addRemoteCall((short)406, (Object)a, DataTransferManager.class.getDeclaredMethod(c_tf.m_le((Object)"H\u0005[$N\u0014N4]\u0001A\u0013I\u0005]3[\u0001[\u0015\\\u0005\\\"V)K\u0013f\u000e[\u0005]\u000eN\f"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.A.addRemoteCall((short)407, (Object)a, DataTransferManager.class.getDeclaredMethod(SetValueRequest.m_le((Object)"\u000e\u0004\u001d%\b\u0015\b5\u001b\u0000\u0007\u0012\u000f\u0004\u001b2\u001d\u0000\u001d\u0014\u001a\u0004\u001a#\u00101\u001b\u000e\u0003\u0004\n\u0015 \u0005 \u000f\u001d\u0004\u001b\u000f\b\r"), classArray7));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(c_tf.m_le((Object)"i\u0001F\fJ\u0004\u000f\u0014@@]\u0005H\t\\\u0014J\u0012\u000f$N\u0014N4]\u0001A\u0013I\u0005]-N\u000eN\u0007J\u0012\u000f2\u007f#\u000f\rJ\u0014G\u000fK\u0013"), noSuchMethodException);
        }
    }

    protected void scheduleDataTransferInternal(DataTransfer a) {
        DataTransferManager a2;
        c_nga.m_jub(() -> {
            DataTransferManager a2;
            a2.a.lock();
            try {
                a2.cancelDataTransferInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_uj("Project should be active to schedule data transfer " + a.getName());
                }
                Object[] objectArray = new Object[1];
                objectArray[0] = a.getName();
                PeriodicJob periodicJob = a2.i.m_paa(a.getProject(), String.format(SetValueRequest.m_le((Object)"L\u0012I%\b\u0015\bA=\u0013\b\u000f\u001a\u0007\f\u0013"), objectArray), () -> {
                    DataTransferManager a2;
                    a2.transfer(a);
                }, Duration.ofMillis(a.getPeriod().intValue()));
                DataTransferManager dataTransferManager = a2;
                dataTransferManager.M.put(a.getId(), periodicJob);
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                dataTransferManager.f.sadd(C, stringArray);
                return;
            }
            finally {
                a2.a.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_lla a) {
        switch (c_hd.L[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + a);
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats a, c_via a2) {
        switch (c_hd.E[a2.ordinal()]) {
            case 1: {
                return a.getMinValue();
            }
            case 2: {
                return a.getMaxValue();
            }
            case 3: {
                return a.getAvgValue();
            }
            case 4: {
                return a.getSumValue();
            }
            case 5: {
                return a.getCountValue();
            }
            case 6: {
                return a.getFirstValue();
            }
            case 7: {
                return a.getLastValue();
            }
            case 8: {
                return a.getMaxDiffValue();
            }
            case 9: {
                return a.getLastFirstDiffValue();
            }
            case 10: {
                return a.getMiddleValue();
            }
            case 11: {
                return a.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + a2);
    }

    private /* synthetic */ void handleStatValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a3) {
        DataTransferManager a4;
        Object object = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a4.F.m_cva(object).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        object = a4.g.m_ckb((Integer[])object.toArray(Integer[]::new));
        Date date = new Date();
        a.stream().filter(arg_0 -> a4.lambda$handleStatValues$10(date, map, a3, (Map)object, arg_0)).collect(Collectors.groupingBy(a2 -> {
            DataTransferManager a3;
            return (Date)a3.calculateDateRange(date, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> a4.lambda$handleStatValues$15(date, map, (Map)object, a3, arg_0, arg_1));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_yi getDataTransferStatus(Integer a) {
        DataTransferManager a2;
        if (a2.A.isLeader()) {
            d.debug(SetValueRequest.m_le((Object)"%$(%,3SA.\u0004\u001d\u0015\u0000\u000f\u000eA\r\u0000\u001d\u0000I\u0015\u001b\u0000\u0007\u0012\u000f\u0004\u001bA\u001a\u0015\b\u0015\u001c\u0012I\u0007\u0006\u0013I(-[I\u001a\u0014A\u0005\u000e\n\u0000\u0005\r\u0010O"), (Object)a);
            return a2.getDataTransferStatusInternal(a);
        }
        d.debug(c_tf.m_le((Object)"a/aMc%n$j2\u0015@}\u0005^\u0015J\u0013[\tA\u0007\u000f\fJ\u0001K\u0005]@I\u000f]@K\u0001[\u0001\u000f\u0014]\u0001A\u0013I\u0005]@\\\u0014N\u0014Z\u0013\u000f\u0006@\u0012\u000f)kZ\u000f\u001bRN"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_yi)a2.A.callLeaderMethod(Short.valueOf((short)403), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get data transfer status for " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a, String a2) {
        DataTransferManager a3;
        DataTransferManager dataTransferManager = a3;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.G.m_ph(a, a2).getId());
    }

    private /* synthetic */ boolean isValueInThresholdRange(Double a, VariableValue<?> a2, VariableValue<?> a3) {
        double d;
        double d2;
        if (a == null || a3 == null) {
            return true;
        }
        if (!(a2 instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d3 = ((Number)a2.getValue()).doubleValue();
        double d4 = ((Number)a3.getValue()).doubleValue();
        return (d3 == 0.0 ? (d2 = Math.abs(d4 - d3)) : (d = Math.abs((d4 - d3) / d3 * 100.0))) >= a;
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.A.isLeader()) {
            d.debug(SetValueRequest.m_le((Object)"-, -$;[I\"\b\u000f\n\u0004\u0005\r\u0000\u000f\u000eA\b\r\u0005A\r\u0000\u001d\u0000I\u0015\u001b\u0000\u0007\u0012\u000f\u0004\u001b\u0012I\u0007\u0006\u0013I\u0011\u001b\u000e\u0003\u0004\n\u0015I\u001a\u0014A\u0005\u000e\n\u0000\u0005\r\u0010O"), (Object)a);
            a2.cancelDataTransfersByProjectIdInternal(a);
            return;
        }
        d.debug(c_tf.m_le((Object)"a/aMc%n$j2\u0015@}\u0005^\u0015J\u0013[\tA\u0007\u000f\fJ\u0001K\u0005]@[\u000f\u000f\u0003N\u000eL\u0005C@N\fC@K\u0001[\u0001\u000f\u0014]\u0001A\u0013I\u0005]\u0013\u000f\u0006@\u0012\u000f\u0010]\u000fE\u0005L\u0014\u000f\u001bRN"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.callLeaderMethod(Short.valueOf((short)405), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC cancel data transfers for project " + a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.A.addListener((ClusterNodeListener)a);
        d.info(SetValueRequest.m_le((Object)"-\u0000\u001d\u0000=\u0013\b\u000f\u001a\u0007\f\u0013$\u0000\u0007\u0000\u000e\u0004\u001bA\u0000\u000f\u0000\u0015\u0000\u0000\u0005\b\u0013\u0004\rA\b\u000f\rA\u001b\u0004\u000e\b\u001a\u0015\f\u0013\f\u0005I\u0000\u001aA*\r\u001c\u0012\u001d\u0004\u001b/\u0006\u0005\f-\u0000\u0012\u001d\u0004\u0007\u0004\u001bO"));
    }

    private /* synthetic */ void transfer(DataTransfer a) {
        DataTransferManager a2;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(a3 -> {
            if (a3.getCalcType() != null && a3.getRangeType() != null) {
                arrayList2.add(a3);
                return;
            }
            arrayList.add(a3);
        });
        HashMap hashMap = new HashMap();
        if (!arrayList.isEmpty()) {
            a2.handleCurrentValues(arrayList, hashMap);
        }
        if (!arrayList2.isEmpty()) {
            a2.handleStatValues(arrayList2, hashMap);
        }
        if (!hashMap.isEmpty()) {
            a2.g.m_klb(a.getProjectId(), hashMap);
        }
    }

    protected Map<Integer, c_yi> getDataTransferStatusesByProjectIdInternal(Integer a2) {
        DataTransferManager a3;
        if ((a2 = a3.G.m_qj((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(DataTransfer::getId, a -> {
            DataTransferManager a2;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.A.isLeader()) {
            d.debug(c_tf.m_le((Object)"c%n$j2\u0015@l\u0001A\u0003J\fC\tA\u0007\u000f\u0004N\u0014N@[\u0012N\u000e\\\u0006J\u0012\u000f\u001bR@C\u000fL\u0001C\fVN"), (Object)a);
            a2.cancelDataTransferInternal(a);
            return;
        }
        d.debug(SetValueRequest.m_le((Object)"/&/D-, -$;[I3\f\u0010\u001c\u0004\u001a\u0015\u0000\u000f\u000eA\u0005\u0004\b\u0005\f\u0013I\u0015\u0006A\n\u0000\u0007\u0002\f\rI\u0005\b\u0015\bA\u001d\u0013\b\u000f\u001a\u0007\f\u0013I\u001a\u0014O"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.callLeaderMethod(Short.valueOf((short)402), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC cancel data transfer " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(c_tf.m_le((Object)"K\u0001[\u0001\u0002\u0014]\u0001A\u0013I\u0005]ZC\u0001\\\u0014\u0002\u0003N\fLM[\tB\u0005\u0015\u0016N\u0012F\u0001M\fJZ\n\u0004\u0015E\\Z\n\u0013"), objectArray);
    }

    @TransactionalEventListener(value={RescheduleEvent.class})
    public void handleRescheduleEvent(RescheduleEvent a) {
        DataTransferManager a2;
        if (a2.A.isLeader()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            d.info(SetValueRequest.m_le((Object)"-, -$;[I)\b\u000f\r\r\u0000\u000f\u000eA;\u0004\u001a\u0002\u0001\u0004\r\u0014\u0005\u0004,\u0017\f\u000f\u001dA\u000f\u000e\u001bA\r\u0000\u001d\u0000I\u0015\u001b\u0000\u0007\u0012\u000f\u0004\u001b[I\u001a\u0014AA(-[I\u001a\u0014H"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            if (a2.getDataTransferStatusInternal(dataTransfer.getId()) == c_yi.E) {
                a2.scheduleDataTransferInternal(dataTransfer.getId());
                return;
            }
        } else {
            d.debug(c_tf.m_le((Object)"a/aMc%n$j2\u0015@f\u0007A\u000f]\tA\u0007\u000f2J\u0013L\bJ\u0004Z\fJ%Y\u0005A\u0014\u000f\u0006@\u0012\u000f\u0004N\u0014N@[\u0012N\u000e\\\u0006J\u0012\u0015@T\u001d"), (Object)a.getDataTransfer().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(Integer a) {
        DataTransferManager a2;
        if (a2.A.isLeader()) {
            d.debug(c_tf.m_le((Object)",j!k%}Z\u000f3L\bJ\u0004Z\fF\u000eH@N\fC@K\u0001[\u0001\u000f\u0014]\u0001A\u0013I\u0005]\u0013\u000f\u0006@\u0012\u000f\u0010]\u000fE\u0005L\u0014\u000f\u001bR@C\u000fL\u0001C\fVN"), (Object)a);
            a2.scheduleDataTransfersByProjectIdInternal(a);
            return;
        }
        d.debug(SetValueRequest.m_le((Object)"'.'L%$(%,3SA;\u0004\u0018\u0014\f\u0012\u001d\b\u0007\u0006I\r\f\u0000\r\u0004\u001bA\u001d\u000eI\u0012\n\t\f\u0005\u001c\r\fA\b\r\u0005A\r\u0000\u001d\u0000I\u0015\u001b\u0000\u0007\u0012\u000f\u0004\u001b\u0012I\u0007\u0006\u0013I\u0011\u001b\u000e\u0003\u0004\n\u0015I\u001a\u0014O"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.callLeaderMethod(Short.valueOf((short)404), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC schedule data transfers for project " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={CancelEvent.class})
    public void handleCancelEvent(CancelEvent a) {
        DataTransferManager a2;
        if (a2.A.isLeader()) {
            DataTransfer dataTransfer = a.getDataTransfer();
            d.info(c_tf.m_le((Object)",j!k%}Z\u000f(N\u000eK\fF\u000eH@l\u0001A\u0003J\fj\u0016J\u000e[@I\u000f]@K\u0001[\u0001\u000f\u0014]\u0001A\u0013I\u0005]Z\u000f\u001bR@\u0007)kZ\u000f\u001bRI"), (Object)dataTransfer.getName(), (Object)dataTransfer.getId());
            a2.cancelDataTransferInternal(dataTransfer);
            return;
        }
        d.debug(SetValueRequest.m_le((Object)"'.'L%$(%,3SA \u0006\u0007\u000e\u001b\b\u0007\u0006I\"\b\u000f\n\u0004\u0005$\u001f\u0004\u0007\u0015I\u0007\u0006\u0013I\u0005\b\u0015\bA\u001d\u0013\b\u000f\u001a\u0007\f\u0013SA\u0012\u001c"), (Object)a.getDataTransfer().getId());
    }

    protected void cancelDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.G.m_qj((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> a, Map<String, Map<String, Object>> a2) {
        DataTransferManager a3;
        Object object = (Integer[])a.stream().map(DataTransferDetail::getSourceVariableId).toArray(Integer[]::new);
        Object object2 = a.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map = a3.F.m_cva(object2).stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        DataTransferManager dataTransferManager = a3;
        object = dataTransferManager.g.m_ckb(object);
        object2 = dataTransferManager.g.m_ckb((Integer[])object2.toArray(Integer[]::new));
        a.forEach(arg_0 -> a3.lambda$handleCurrentValues$8((Map)object, (Map)object2, map, a2, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        String string = dataTransferManager.A.getCurrentNode().getNodeId();
        d.info(c_tf.m_le((Object)"k\u0001[\u0001{\u0012N\u000e\\\u0006J\u0012b\u0001A\u0001H\u0005]Z\u000f4G\t\\@A\u000fK\u0005\u000fHT\u001d\u0006@G\u0001\\@M\u0005L\u000fB\u0005\u000f\u0014G\u0005\u000f,j!k%}N\u000f2J\u0013[\u000f]\tA\u0007\u000f\u0013L\bJ\u0004Z\fJ\u0004\u000f\u0004N\u0014N@[\u0012N\u000e\\\u0006J\u0012\\N\u0001N"), (Object)string);
        dataTransferManager.a.lock();
        try {
            Set set = a2.f.smembers(C).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                d.info(SetValueRequest.m_le((Object)"%\b\u0015\b5\u001b\u0000\u0007\u0012\u000f\u0004\u001b,\b\u000f\b\u0006\f\u0013II%\u0004\b\u0005\f\u0013I\u001a\u0014HSA'\u000eI\u0012\n\t\f\u0005\u001c\r\f\u0005I\u0005\b\u0015\bA\u001d\u0013\b\u000f\u001a\u0007\f\u0013\u001aA\u000f\u000e\u001c\u000f\rA\u0000\u000fI3\f\u0005\u0000\u0012I\u0015\u0006A\u001b\u0004\u001a\u0015\u0006\u0013\fO"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            d.info(c_tf.m_le((Object)"$N\u0014N4]\u0001A\u0013I\u0005]-N\u000eN\u0007J\u0012\u000fHc\u0005N\u0004J\u0012\u000f\u001bRI\u0015@i\u000fZ\u000eK@T\u001d\u000f\u0013L\bJ\u0004Z\fJ\u0004\u000f\u0004N\u0014N@[\u0012N\u000e\\\u0006J\u0012\u000f)k\u0013\u000f\tA@}\u0005K\t\\@[\u000f\u000f\u0012J\u0013[\u000f]\u0005\u0015@T\u001d"), objectArray);
            ArrayList arrayList = new ArrayList(a2.G.m_xk(set));
            d.info(SetValueRequest.m_le((Object)"%\b\u0015\b5\u001b\u0000\u0007\u0012\u000f\u0004\u001b,\b\u000f\b\u0006\f\u0013II%\u0004\b\u0005\f\u0013I\u001a\u0014HSA(\u0015\u001d\u0004\u0004\u0011\u001d\b\u0007\u0006I\u0015\u0006A\u001b\u0004\u001a\u0015\u0006\u0013\fA\u0012\u001cI\u0005\b\u0015\bA\u001d\u0013\b\u000f\u001a\u0007\f\u0013\u001aO"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                DataTransferManager a2;
                String string = a2.A.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    d.info(c_tf.m_le((Object)"$N\u0014N4]\u0001A\u0013I\u0005]-N\u000eN\u0007J\u0012\u000fHc\u0005N\u0004J\u0012\u000f\u001bRI\u0015@}\u0005\\\u0014@\u0012F\u000eH@K\u0001[\u0001\u000f\u0014]\u0001A\u0013I\u0005]Z\u000f\u001bR@\u0007)kZ\u000f\u001bRI"), objectArray);
                    a2.scheduleDataTransferInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.K.m_pga(a.getProject()).m_g("Data Transfer Restore (Leader " + string + ")", String.format(SetValueRequest.m_le((Object)"L\u0012II %SAL\u0005@A\u000f\u0000\u0000\r\f\u0005I\u0015\u0006A\u001b\u0004\u001a\u0015\u0006\u0013\fOI\"\b\u0014\u001a\u0004SAL\u0012"), objectArray));
                    try {
                        d.warn(c_tf.m_le((Object)"$N\u0014N4]\u0001A\u0013I\u0005]-N\u000eN\u0007J\u0012\u000fHc\u0005N\u0004J\u0012\u000f\u001bRI\u0015@n\u0014[\u0005B\u0010[\tA\u0007\u000f\u0014@@L\u0001A\u0003J\f\u000f\u0004N\u0014N@[\u0012N\u000e\\\u0006J\u0012\u000f\u001bR@N\u0006[\u0005]@]\u0005\\\u0014@\u0012N\u0014F\u000fA@I\u0001F\fZ\u0012JN"), (Object)string, (Object)a.getId());
                        a2.cancelDataTransferInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        d.error(SetValueRequest.m_le((Object)"-\u0000\u001d\u0000=\u0013\b\u000f\u001a\u0007\f\u0013$\u0000\u0007\u0000\u000e\u0004\u001bAA-\f\u0000\r\u0004\u001bA\u0012\u001c@[I'\b\b\u0005\u0004\rA\u001d\u000eI\u0002\b\u000f\n\u0004\u0005A\r\u0000\u001d\u0000I\u0015\u001b\u0000\u0007\u0012\u000f\u0004\u001bA\u0012\u001cI\u0000\u000f\u0015\f\u0013I\u0013\f\u0012\u001d\u000e\u001b\u0000\u001d\b\u0006\u000fI\u0007\b\b\u0005\u0014\u001b\u0004SA\u0012\u001c"), objectArray2);
                        return;
                    }
                }
            });
            d.info(c_tf.m_le((Object)"k\u0001[\u0001{\u0012N\u000e\\\u0006J\u0012b\u0001A\u0001H\u0005]@\u0007,J\u0001K\u0005]@T\u001d\u0006Z\u000f&F\u000eF\u0013G\u0005K@K\u0001[\u0001\u000f\u0014]\u0001A\u0013I\u0005]@]\u0005\\\u0014@\u0012N\u0014F\u000fA@_\u0012@\u0003J\u0013\\N"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            d.error(SetValueRequest.m_le((Object)"%\b\u0015\b5\u001b\u0000\u0007\u0012\u000f\u0004\u001b,\b\u000f\b\u0006\f\u0013II%\u0004\b\u0005\f\u0013I\u001a\u0014HSA,\u0013\u001b\u000e\u001bA\r\u0014\u001b\b\u0007\u0006I\u0005\b\u0015\bA\u001d\u0013\b\u000f\u001a\u0007\f\u0013I\u0013\f\u0012\u001d\u000e\u001b\u0000\u001d\b\u0006\u000fI\u0011\u001b\u000e\n\u0004\u001a\u0012SA\u0012\u001c"), objectArray);
            return;
        }
        finally {
            a2.a.unlock();
        }
    }

    private /* synthetic */ boolean lambda$handleStatValues$10(Date a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        DataTransferManager a6;
        DataTransferManager dataTransferManager = a6;
        String string = dataTransferManager.buildStatCacheKey(a5);
        if (!dataTransferManager.shouldRecalculateStats(a5, a, string = dataTransferManager.f.get(string))) {
            a6.updateVariableWithCachedValue(string, a5, a2, a3, a4);
            return false;
        }
        return true;
    }

    protected void scheduleDataTransferInternal(Integer a) {
        DataTransferManager a2;
        DataTransferManager dataTransferManager = a2;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.G.m_efa(a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_yi> getDataTransferStatuses(List<Integer> a) {
        DataTransferManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.A.isLeader()) {
            d.debug(c_tf.m_le((Object)",j!k%}Z\u000f'J\u0014[\tA\u0007\u000f\u0004N\u0014N@[\u0012N\u000e\\\u0006J\u0012\u000f\u0013[\u0001[\u0015\\\u0005\\@I\u000f]@T\u001d\u000f)k\u0013\u000f\f@\u0003N\fC\u0019\u0015@T\u001d"), (Object)a.size(), a);
            return a2.getDataTransferStatusesByIdsInternal(a);
        }
        d.debug(SetValueRequest.m_le((Object)"/&/D-, -$;[I3\f\u0010\u001c\u0004\u001a\u0015\u0000\u000f\u000eA\u0005\u0004\b\u0005\f\u0013I\u0007\u0006\u0013I\u0005\b\u0015\bA\u001d\u0013\b\u000f\u001a\u0007\f\u0013I\u0012\u001d\u0000\u001d\u0014\u001a\u0004\u001aA\u000f\u000e\u001bA\u0012\u001cI(-\u0012SA\u0012\u001c"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.A.callLeaderMethod(Short.valueOf((short)406), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_tf.m_le((Object)"L"))), (Throwable)exception);
        }
    }

    protected void scheduleDataTransfersByProjectIdInternal(Integer a) {
        DataTransferManager a2;
        if ((a = a2.G.m_mga((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail a, Date a2, String a3) {
        Date date;
        int n;
        boolean bl;
        DataTransferManager a4;
        if (a3 == null) {
            return true;
        }
        a3 = Calendar.getInstance();
        String string = a4.f.get(a4.buildStatLastCalcTimeKey(a));
        if (string == null) {
            return true;
        }
        ((Calendar)a3).setTimeInMillis(Long.parseLong(string));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(a2);
        boolean bl2 = false;
        switch (c_hd.L[a.getRangeType().ordinal()]) {
            case 1: 
            case 2: {
                bl = bl2 = ((Calendar)a3).get(11) != calendar.get(11);
                break;
            }
            case 3: 
            case 4: {
                bl = bl2 = ((Calendar)a3).get(6) != calendar.get(6);
                break;
            }
            case 5: 
            case 6: {
                bl = bl2 = ((Calendar)a3).get(3) != calendar.get(3);
                break;
            }
            case 7: 
            case 8: {
                bl = bl2 = ((Calendar)a3).get(2) != calendar.get(2);
                break;
            }
            case 9: 
            case 10: {
                bl2 = ((Calendar)a3).get(1) != calendar.get(1);
            }
            default: {
                bl = bl2;
            }
        }
        if (bl) {
            DataTransferManager dataTransferManager = a4;
            String string2 = dataTransferManager.buildStatCacheKey(a);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey(a);
            String[] stringArray = new String[2];
            stringArray[0] = string2;
            stringArray[1] = string3;
            dataTransferManager.f.del(stringArray);
            return true;
        }
        if (!a.getRangeType().toString().startsWith(SetValueRequest.m_le((Object)"\"\u001c\u0013\u001b\u0004\u0007\u0015"))) {
            return false;
        }
        switch (c_hd.L[a.getRangeType().ordinal()]) {
            case 1: {
                n = 5;
                date = a2;
                break;
            }
            case 3: {
                n = 5;
                date = a2;
                break;
            }
            case 5: {
                n = 60;
                date = a2;
                break;
            }
            case 7: {
                n = 720;
                date = a2;
                break;
            }
            case 9: {
                n = 720;
                date = a2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected range type: " + a.getRangeType());
            }
        }
        long l = date.getTime();
        long l2 = Long.parseLong(string);
        return l - l2 >= (long)(n * 60 * 1000);
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail a) {
        Object[] objectArray = new Object[3];
        objectArray[0] = a.getSourceVariableId();
        objectArray[1] = a.getRangeType();
        objectArray[2] = a.getCalcType();
        return String.format(c_tf.m_le((Object)"\u0004N\u0014NM[\u0012N\u000e\\\u0006J\u0012\u0015\u0013[\u0001[\u0013\u0015\u0016N\u0012F\u0001M\fJZ\n\u0004\u0015E\\Z\n\u0013"), objectArray);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<Integer, c_yi> getDataTransferStatuses(Integer a) {
        DataTransferManager a2;
        if (a2.A.isLeader()) {
            d.debug(SetValueRequest.m_le((Object)"%$(%,3SA.\u0004\u001d\u0015\u0000\u000f\u000eA\b\r\u0005A\r\u0000\u001d\u0000I\u0015\u001b\u0000\u0007\u0012\u000f\u0004\u001bA\u001a\u0015\b\u0015\u001c\u0012\f\u0012I\u0007\u0006\u0013I\u0011\u001b\u000e\u0003\u0004\n\u0015I\u001a\u0014A\u0005\u000e\n\u0000\u0005\r\u0010O"), (Object)a);
            return a2.getDataTransferStatusesByProjectIdInternal(a);
        }
        d.debug(c_tf.m_le((Object)"a/aMc%n$j2\u0015@}\u0005^\u0015J\u0013[\tA\u0007\u000f\fJ\u0001K\u0005]@I\u000f]@N\fC@K\u0001[\u0001\u000f\u0014]\u0001A\u0013I\u0005]@\\\u0014N\u0014Z\u0013J\u0013\u000f\u0006@\u0012\u000f\u0010]\u000fE\u0005L\u0014\u000f\u001bRN"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.A.callLeaderMethod(Short.valueOf((short)407), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get statuses for project" + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(Integer a) {
        DataTransferManager a2;
        if (a2.A.isLeader()) {
            d.debug(SetValueRequest.m_le((Object)"%$(%,3SA:\u0002\u0001\u0004\r\u0014\u0005\b\u0007\u0006I\u0005\b\u0015\bA\u001d\u0013\b\u000f\u001a\u0007\f\u0013I\u001a\u0014A\u0005\u000e\n\u0000\u0005\r\u0010O"), (Object)a);
            a2.scheduleDataTransferInternal(a);
            return;
        }
        d.debug(c_tf.m_le((Object)".`.\u0002,j!k%}Z\u000f2J\u0011Z\u0005\\\u0014F\u000eH@C\u0005N\u0004J\u0012\u000f\u0014@@\\\u0003G\u0005K\u0015C\u0005\u000f\u0004N\u0014N@[\u0012N\u000e\\\u0006J\u0012\u000f\u001bRN"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.A.callLeaderMethod(Short.valueOf((short)401), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC schedule data transfer " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void updateVariableWithCachedValue(String a, DataTransferDetail a2, Map<Integer, Variable<?, ?, ?>> a3, Map<String, Map<String, Object>> a4, Map<Integer, VariableValue<?>> a5) {
        if ((a3 = a3.get(a2.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = Double.parseDouble((String)a);
            a = a5.get(a2.getTargetVariableId());
            if (a6.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), a)) {
                a = new HashMap<String, Double>();
                a.put(SetValueRequest.m_le((Object)"\u0017\b\r\u001c\u0004"), d);
                a4.put(a3.getName(), (Map<String, Object>)a);
            }
        }
    }

    private /* synthetic */ void lambda$handleStatValues$15(Date a, Map a2, Map a3, Map a4, Date a5, List a6) {
        DataTransferManager a7;
        Integer[] integerArray = (Integer[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(Integer[]::new);
        c_via[] c_viaArray = (c_via[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_via[]::new);
        a = a7.m.m_ttb(integerArray, a5, (Date)a, c_viaArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableIdAsInt, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$14((Map)a, a2, a3, a4, arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_yi getDataTransferStatus(Integer a, String a2) {
        DataTransferManager a3;
        if ((a = a3.G.m_sf(a, a2)) == null) {
            return c_yi.c;
        }
        return a3.getDataTransferStatus(a.getId());
    }

    private /* synthetic */ void lambda$handleStatValues$14(Map a, Map a2, Map a3, Map a4, DataTransferDetail a5) {
        if ((a = (LoggedVariableValueStats)a.get(a5.getSourceVariableId())) != null && (a2 = (Variable)a2.get(a5.getTargetVariableId())) != null) {
            DataTransferManager a6;
            double d = a6.extractValue((LoggedVariableValueStats)a, a5.getCalcType());
            a = (VariableValue)a3.get(a5.getTargetVariableId());
            DataTransferManager dataTransferManager = a6;
            a3 = dataTransferManager.buildStatCacheKey(a5);
            String string = dataTransferManager.buildStatLastCalcTimeKey(a5);
            int n = dataTransferManager.getMaxTTLForRangeType(a5.getRangeType());
            dataTransferManager.f.setex((String)a3, (long)n, String.valueOf(d));
            a6.f.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager.isValueInThresholdRange(a5.getThreshold(), Double.valueOf(d), (VariableValue)a)) {
                a = new HashMap<String, Double>();
                a.put(c_tf.m_le((Object)"\u0016N\fZ\u0005"), d);
                a4.put(a2.getName(), a);
            }
        }
    }
}

