/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.restcontrollers;

import com.inscada.mono.animation.messages.AnimationResultsMessage;
import com.inscada.mono.communication.protocols.iec61850.model.Node;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.services.DataTransferManager;
import com.inscada.mono.datatransfer.services.c_ak;
import com.inscada.mono.datatransfer.z.c_yi;
import com.inscada.mono.impexp.b.c_gh;
import com.inscada.mono.impexp.c.c_vg;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.z.c_ji;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/datatransfer"})
public class DataTransferController
extends ProjectBasedImportExportController {
    private final DataTransferManager E;
    private final c_ak L;

    @DeleteMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        this.L.m_rda(dataTransferId, a);
    }

    @GetMapping(value={"/{dataTransferId}/status"})
    public c_yi getDataTransferStatus(@PathVariable(value="dataTransferId") Integer a) {
        return this.E.getDataTransferStatus(a);
    }

    @PostMapping(value={"/schedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.E.scheduleDataTransfers(a);
    }

    @GetMapping(value={"/status"})
    public Map<Integer, c_yi> getDataTransferStatuses(@RequestParam(value="dataTransferIds") Integer[] a) {
        return this.E.getDataTransferStatuses(Arrays.asList(a));
    }

    @PostMapping(value={"/unschedule"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void unscheduleDataTransfers(@RequestParam(value="projectId") Integer a) {
        this.E.cancelDataTransfers(a);
    }

    @PutMapping(value={"/{dataTransferId}/details/{detailId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer detailId, @Valid @RequestBody DataTransferDetail a) {
        this.L.m_kca(dataTransferId, detailId, a);
    }

    @PostMapping
    public ResponseEntity<DataTransfer> createDataTransfer(@Valid @RequestBody DataTransfer dataTransfer, UriComponentsBuilder a) {
        dataTransfer = this.L.m_ida(dataTransfer);
        Object[] objectArray = new Object[1];
        objectArray[0] = dataTransfer.getId();
        return ResponseEntity.created((URI)a.path(AnimationResultsMessage.m_le((Object)"W;\u001c!\f!,2\u0019.\u000b&\u001d21$\u0005")).buildAndExpand(objectArray).toUri()).body((Object)dataTransfer);
    }

    @DeleteMapping(value={""}, params={"dataTransferIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfersByIds(@RequestParam(value="dataTransferIds") Integer[] a) {
        this.L.m_dga(List.of(a));
    }

    @GetMapping
    public Collection<DataTransfer> getDataTransfers(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.L.m_la();
        }
        return this.L.m_sa(a);
    }

    @PostMapping(value={"/{dataTransferId}/cancel"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelScript(@PathVariable(value="dataTransferId") Integer a) {
        this.E.cancelDataTransfer(a);
    }

    @DeleteMapping(value={"/details"}, params={"dataTransferDetailIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransferDetailsByIds(@RequestParam(value="dataTransferDetailIds") Integer[] a) {
        this.L.m_zba(List.of(a));
    }

    @GetMapping(value={"/{dataTransferId}"})
    public DataTransfer getDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        return this.L.m_ba(a);
    }

    @DeleteMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataTransfer(@PathVariable(value="dataTransferId") Integer a) {
        this.L.m_ga(a);
    }

    @PostMapping(value={"/{dataTransferId}/schedule"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void scheduleScript(@PathVariable(value="dataTransferId") Integer a) {
        this.E.scheduleDataTransfer(a);
    }

    @PutMapping(value={"/{dataTransferId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDataTransfer(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransfer a) {
        this.L.m_lba(dataTransferId, a);
    }

    @GetMapping(value={"/{dataTransferId}/details"})
    public Collection<DataTransferDetail> getDetails(@PathVariable(value="dataTransferId") Integer a) {
        return this.L.m_oca(a);
    }

    @PostMapping(value={"/{dataTransferId}/details"})
    public ResponseEntity<DataTransferDetail> createDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @Valid @RequestBody DataTransferDetail dataTransferDetail, UriComponentsBuilder a) {
        dataTransferDetail = this.L.m_aja(dataTransferId, dataTransferDetail);
        Object[] objectArray = new Object[2];
        objectArray[0] = dataTransferId;
        objectArray[1] = dataTransferDetail.getId();
        return ResponseEntity.created((URI)a.path(Node.m_le((Object)"h\u0015#\u000f3\u000f\u0013\u001c&\u00004\b\"\u001c\u000e\n:A#\u000b3\u000f.\u00024A<\n\"\u001a&\u0007+'#\u0013")).buildAndExpand(objectArray).toUri()).body((Object)dataTransferDetail);
    }

    @GetMapping(value={"/{dataTransferId}/details/{detailId}"})
    public DataTransferDetail getDetail(@PathVariable(value="dataTransferId") Integer dataTransferId, @PathVariable(value="detailId") Integer a) {
        return this.L.m_mca(dataTransferId, a);
    }

    public DataTransferController(c_ak a, DataTransferManager a2, c_gh a3, c_ji a4) {
        DataTransferController a5;
        DataTransferController dataTransferController = a5;
        super(a3, EnumSet.of(c_vg.G), a4);
        dataTransferController.L = a;
        dataTransferController.E = a2;
    }
}

