/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datasource.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="custom_datasource")
@Inheritance(strategy=InheritanceType.JOINED)
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public abstract class CustomDatasource
extends SpaceBaseModel {
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    private String username;
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @NotBlank
    private String url;
    private String password;
    @Size(max=255)
    private String dsc;
    @Id
    @Column(name="custom_datasource_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="customDatasourceSeq")
    @GenericGenerator(name="customDatasourceSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="custom_datasource_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;

    public void setId(Integer a) {
        a.id = a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public String getName() {
        CustomDatasource a;
        return a.name;
    }

    public void setProject(Project a) {
        CustomDatasource a2;
        CustomDatasource customDatasource = a2;
        customDatasource.project = a;
        customDatasource.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public int hashCode() {
        CustomDatasource a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setPassword(String a) {
        a.password = a;
    }

    public void setUrl(String a) {
        a.url = a;
    }

    public String getDsc() {
        CustomDatasource a;
        return a.dsc;
    }

    public String getUsername() {
        CustomDatasource a;
        return a.username;
    }

    public Project getProject() {
        CustomDatasource a;
        return a.project;
    }

    public String getUrl() {
        CustomDatasource a;
        return a.url;
    }

    public Integer getProjectId() {
        CustomDatasource a;
        return a.projectId;
    }

    public void setUsername(String a) {
        a.username = a;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public CustomDatasource() {
        CustomDatasource a;
    }

    public String getPassword() {
        CustomDatasource a;
        return a.password;
    }

    public Integer getId() {
        CustomDatasource a;
        return a.id;
    }

    public boolean equals(Object a) {
        CustomDatasource a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof CustomDatasource)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (CustomDatasource)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }
}

