/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.inscada.mono.auth.security.UnauthorizedEntryPoint;
import com.inscada.mono.auth.security.filters.AuthTokenAuthenticationFilter;
import com.inscada.mono.auth.security.filters.OtpCodeValidationFilter;
import com.inscada.mono.auth.security.filters.RefreshTokenFilter;
import com.inscada.mono.auth.security.handlers.ForbiddenAccessDeniedHandler;
import com.inscada.mono.auth.security.handlers.LoggingAuthenticationFailureHandler;
import com.inscada.mono.auth.security.handlers.LoggingLogoutSuccessHandler;
import com.inscada.mono.auth.security.handlers.OtpCodeAuthenticationSuccessHandler;
import com.inscada.mono.auth.security.handlers.TokenClearingLogoutHandler;
import com.inscada.mono.auth.security.handlers.UsernamePasswordAuthenticationSuccessHandler;
import com.inscada.mono.auth.security.model.AuthDetails;
import com.inscada.mono.auth.security.providers.AuthTokenAuthenticationProvider;
import com.inscada.mono.auth.security.providers.LimitingUsernamePasswordAuthenticationProvider;
import com.inscada.mono.auth.security.providers.OtpCodeAuthenticationProvider;
import com.inscada.mono.auth.services.AuthTokenService;
import com.inscada.mono.auth.services.c_kja;
import com.inscada.mono.auth.services.z.t.c_cla;
import com.inscada.mono.cluster.filter.ReadOnlyFilter;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.config.c_ih;
import com.inscada.mono.datasource.influxdb.restcontrollers.CustomInfluxDBDatabaseController;
import com.inscada.mono.user.repositories.UserRepository;
import com.inscada.mono.user.z.c_ka;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    private final AuthTokenService g;
    private final UserRepository K;
    private final ClusterOperations A;
    private final c_kja F;
    private final c_cla c;
    private final ObjectMapper E;
    private final c_ka L;

    @Bean
    public AuthenticationEntryPoint unauthorizedEntryPoint() {
        SecurityConfig a;
        return new UnauthorizedEntryPoint(a.E);
    }

    @Bean
    public LogoutHandler logoutHandler() {
        SecurityConfig a;
        return new TokenClearingLogoutHandler(a.g);
    }

    @Bean
    public LoggingAuthenticationFailureHandler loggingAuthenticationFailureHandler() {
        SecurityConfig a;
        return new LoggingAuthenticationFailureHandler(a.F, a.unauthorizedEntryPoint());
    }

    @Bean
    public OtpCodeAuthenticationSuccessHandler otpCodeAuthenticationSuccessHandler() {
        SecurityConfig a;
        SecurityConfig securityConfig = a;
        return new OtpCodeAuthenticationSuccessHandler(securityConfig.g, securityConfig.F, a.E);
    }

    protected void configure(HttpSecurity a) throws Exception {
        SecurityConfig a2;
        String[] stringArray = new String[16];
        stringArray[0] = CustomInfluxDBDatabaseController.m_le((Object)"?l}dw`c*:/");
        stringArray[1] = c_ih.m_le((Object)"\u0014\u0000N\u0005R\u000eHN\u0011K");
        stringArray[2] = CustomInfluxDBDatabaseController.m_le((Object)"?iygc*:/");
        stringArray[3] = c_ih.m_le((Object)"\u0014\fB\u0000K\u0011\u0015\u0002H\u0012");
        stringArray[4] = CustomInfluxDBDatabaseController.m_le((Object)"*}|qu`+zv");
        stringArray[5] = c_ih.m_le((Object)"\u0014\u0007Z\u0017R\u0002T\u000f\u0015\bX\u000e");
        stringArray[6] = CustomInfluxDBDatabaseController.m_le((Object)"*ykt`h+xq}i");
        stringArray[7] = c_ih.m_le((Object)"N");
        stringArray[8] = CustomInfluxDBDatabaseController.m_le((Object)"?d`l?mui|j");
        stringArray[9] = c_ih.m_le((Object)"\u0014\u0000K\b\u0014\u0017^\u0013H\bT\u000f");
        stringArray[10] = CustomInfluxDBDatabaseController.m_le((Object)"*quy*|jwl~*c`dqykwv");
        stringArray[11] = c_ih.m_le((Object)"NZ\u0011RNX\rN\u0012O\u0004INW\u0004Z\u0005^\u0013");
        stringArray[12] = CustomInfluxDBDatabaseController.m_le((Object)"*f6?d`l=a\u007ffc*:/");
        stringArray[13] = c_ih.m_le((Object)"\u0014\u0012L\u0000\\\u0006^\u0013\u0016\u0013^\u0012T\u0014I\u0002^\u0012");
        stringArray[14] = CustomInfluxDBDatabaseController.m_le((Object)"*crqbw`b(b`cjews`c*:/");
        stringArray[15] = c_ih.m_le((Object)"\u0014\u0012L\u0000\\\u0006^\u0013\u0016\u0014RN\u0011K");
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)a.authorizeRequests().antMatchers(stringArray)).permitAll().anyRequest()).authenticated().and()).cors().configurationSource(a2.corsConfigurationSource()).and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).logout().addLogoutHandler(a2.logoutHandler()).logoutSuccessHandler((LogoutSuccessHandler)a2.logoutSuccessHandler()).and()).headers().frameOptions().disable().and()).exceptionHandling().authenticationEntryPoint(a2.unauthorizedEntryPoint()).accessDeniedHandler(a2.forbiddenAccessDeniedHandler());
        AuthTokenAuthenticationFilter authTokenAuthenticationFilter = new AuthTokenAuthenticationFilter(a2.authenticationManagerBean());
        SecurityConfig securityConfig = a2;
        RefreshTokenFilter refreshTokenFilter = new RefreshTokenFilter(securityConfig.g, securityConfig.E);
        ReadOnlyFilter readOnlyFilter = new ReadOnlyFilter(a2.A);
        UsernamePasswordAuthenticationFilter usernamePasswordAuthenticationFilter = new UsernamePasswordAuthenticationFilter();
        usernamePasswordAuthenticationFilter.setAuthenticationDetailsSource(AuthDetails::new);
        OtpCodeValidationFilter otpCodeValidationFilter = new OtpCodeValidationFilter();
        UsernamePasswordAuthenticationFilter usernamePasswordAuthenticationFilter2 = usernamePasswordAuthenticationFilter;
        SecurityConfig securityConfig2 = a2;
        SecurityConfig securityConfig3 = a2;
        usernamePasswordAuthenticationFilter.setAuthenticationManager(a2.authenticationManagerBean());
        otpCodeValidationFilter.setAuthenticationManager(securityConfig3.authenticationManagerBean());
        usernamePasswordAuthenticationFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)securityConfig3.usernamePasswordAuthenticationSuccessHandler());
        otpCodeValidationFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)securityConfig2.otpCodeAuthenticationSuccessHandler());
        usernamePasswordAuthenticationFilter2.setAuthenticationFailureHandler((AuthenticationFailureHandler)securityConfig2.loggingAuthenticationFailureHandler());
        otpCodeValidationFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)a2.loggingAuthenticationFailureHandler());
        a.addFilter((Filter)usernamePasswordAuthenticationFilter2).addFilterBefore((Filter)authTokenAuthenticationFilter, LogoutFilter.class).addFilterBefore((Filter)refreshTokenFilter, LogoutFilter.class).addFilterAfter((Filter)otpCodeValidationFilter, UsernamePasswordAuthenticationFilter.class).addFilterAfter((Filter)readOnlyFilter, OtpCodeValidationFilter.class);
    }

    public SecurityConfig(c_kja a, c_ka a2, AuthTokenService a3, c_cla a4, ClusterOperations a5, UserRepository a6, ObjectMapper a7) {
        SecurityConfig a8;
        SecurityConfig securityConfig = a8;
        SecurityConfig securityConfig2 = a8;
        SecurityConfig securityConfig3 = a8;
        a8.F = a;
        securityConfig3.L = a2;
        securityConfig3.g = a3;
        securityConfig2.c = a4;
        securityConfig2.A = a5;
        securityConfig.K = a6;
        securityConfig.E = a7;
    }

    @Bean
    @Qualifier(value="otpCodeAuthenticationProvider")
    public AuthenticationProvider otpCodeAuthenticationProvider() {
        SecurityConfig a;
        SecurityConfig securityConfig = a;
        return new OtpCodeAuthenticationProvider(securityConfig.c, securityConfig.F, a.K);
    }

    @Bean
    @Qualifier(value="authTokenAuthenticationProvider")
    public AuthenticationProvider authTokenAuthenticationProvider() {
        SecurityConfig a;
        SecurityConfig securityConfig = a;
        return new AuthTokenAuthenticationProvider(securityConfig.F, securityConfig.g, a.K);
    }

    private /* synthetic */ CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration corsConfiguration;
        CorsConfiguration corsConfiguration2 = corsConfiguration = new CorsConfiguration();
        corsConfiguration.applyPermitDefaultValues();
        CorsConfiguration corsConfiguration3 = corsConfiguration;
        CorsConfiguration corsConfiguration4 = corsConfiguration;
        CorsConfiguration corsConfiguration5 = corsConfiguration;
        corsConfiguration5.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration5.addAllowedMethod(HttpMethod.PUT);
        corsConfiguration5.addAllowedMethod(HttpMethod.PATCH);
        corsConfiguration5.addAllowedMethod(HttpMethod.DELETE);
        corsConfiguration5.addAllowedMethod(HttpMethod.OPTIONS);
        corsConfiguration4.addExposedHeader("Location");
        corsConfiguration4.addExposedHeader("X-Auth-Token");
        corsConfiguration3.addExposedHeader(CustomInfluxDBDatabaseController.m_le((Object)"F\u007fkd`~q=Ayv`jcldl\u007fk"));
        corsConfiguration3.setAllowedOrigins(List.of(c_ih.m_le((Object)"K")));
        corsConfiguration2.setAllowedHeaders(List.of(CustomInfluxDBDatabaseController.m_le((Object)"/")));
        String[] stringArray = new String[6];
        stringArray[0] = c_ih.m_le((Object)"&~5");
        stringArray[1] = CustomInfluxDBDatabaseController.m_le((Object)"@JCQ");
        stringArray[2] = c_ih.m_le((Object)"1n5");
        stringArray[3] = CustomInfluxDBDatabaseController.m_le((Object)"T@\\@D@");
        stringArray[4] = c_ih.m_le((Object)"1z5x)");
        stringArray[5] = CustomInfluxDBDatabaseController.m_le((Object)"J@QYJ^V");
        corsConfiguration2.setAllowedMethods(Arrays.asList(stringArray));
        corsConfiguration.setExposedHeaders(List.of(c_ih.m_le((Object)"K")));
        UrlBasedCorsConfigurationSource urlBasedCorsConfigurationSource = new UrlBasedCorsConfigurationSource();
        urlBasedCorsConfigurationSource.registerCorsConfiguration(CustomInfluxDBDatabaseController.m_le((Object)"*:/"), corsConfiguration);
        return urlBasedCorsConfigurationSource;
    }

    @Bean
    public LoggingLogoutSuccessHandler logoutSuccessHandler() {
        SecurityConfig a;
        return new LoggingLogoutSuccessHandler(a.F);
    }

    @Bean
    public AccessDeniedHandler forbiddenAccessDeniedHandler() {
        SecurityConfig a;
        return new ForbiddenAccessDeniedHandler(a.E);
    }

    @Bean
    @Qualifier(value="limitingUsernamePasswordAuthenticationProvider")
    public AuthenticationProvider limitingUsernamePasswordAuthenticationProvider() {
        SecurityConfig a;
        SecurityConfig securityConfig = a;
        return new LimitingUsernamePasswordAuthenticationProvider(securityConfig.F, securityConfig.L);
    }

    protected void configure(AuthenticationManagerBuilder a) {
        SecurityConfig a2;
        a.authenticationProvider(a2.authTokenAuthenticationProvider()).authenticationProvider(a2.limitingUsernamePasswordAuthenticationProvider()).authenticationProvider(a2.otpCodeAuthenticationProvider());
    }

    @Bean
    public UsernamePasswordAuthenticationSuccessHandler usernamePasswordAuthenticationSuccessHandler() {
        SecurityConfig a;
        SecurityConfig securityConfig = a;
        SecurityConfig securityConfig2 = a;
        return new UsernamePasswordAuthenticationSuccessHandler(securityConfig.g, securityConfig.F, securityConfig2.c, securityConfig2.E);
    }
}

