/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.FrameSummary;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.restcontrollers.ConnectionManagementController;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.base.template.model.VariableTemplate;
import com.inscada.mono.communication.base.template.z.c_ul;
import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class TemplateController<TDeviceTemplate extends DeviceTemplate<TFrameTemplate>, TFrameTemplate extends FrameTemplate<TDeviceTemplate, TVariableTemplate>, TVariableTemplate extends VariableTemplate<TFrameTemplate, TDeviceTemplate>, TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TTemplateService extends c_ul<TDeviceTemplate, TFrameTemplate, TVariableTemplate, TConnection, TDevice, TFrame, TVariable>> {
    private final TTemplateService L;

    @DeleteMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="deviceId") Integer a) {
        this.L.m_yra(a);
    }

    @GetMapping(value={"/devices/{deviceId}"})
    public TDeviceTemplate getDevice(@PathVariable(value="deviceId") Integer a) {
        return (TDeviceTemplate)this.L.m_aqa(a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public Collection<TVariableTemplate> getVariables(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return this.L.m_hna(deviceId, a);
    }

    @GetMapping(value={"/devices"})
    public Collection<TDeviceTemplate> getDevices() {
        TemplateController a;
        return a.L.m_nsa();
    }

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrameTemplate a) {
        this.L.m_xta(deviceId, frameId, a);
    }

    public TemplateController(TTemplateService a) {
        TemplateController a2;
        a2.L = a;
    }

    @PostMapping(value={"/devices"})
    public ResponseEntity<TDeviceTemplate> createDevice(@Valid @RequestBody TDeviceTemplate device, UriComponentsBuilder a) {
        device = this.L.m_iua(device);
        Object[] objectArray = new Object[1];
        objectArray[0] = device.getId();
        return ResponseEntity.created((URI)a.path(ConnectionManagementController.m_le((Object)"\u0015D_VSC_S\u0015[^ELIYEsDG")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @PutMapping(value={"/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDeviceTemplate a) {
        this.L.m_wva(deviceId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    public TFrameTemplate getFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrameTemplate)this.L.m_mpa(deviceId, a);
    }

    @PutMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer variableId, @Valid @RequestBody TVariableTemplate a) {
        this.L.m_sna(deviceId, frameId, variableId, a);
    }

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.L.m_npa(deviceId, a);
    }

    @DeleteMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        this.L.m_wsa(deviceId, frameId, a);
    }

    @PostMapping(value={"/devices/{deviceId}/frames/{frameId}/variables"})
    public ResponseEntity<TVariableTemplate> createVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TVariableTemplate variable, UriComponentsBuilder a) {
        variable = this.L.m_pta(deviceId, frameId, variable);
        Object[] objectArray = new Object[3];
        objectArray[0] = deviceId;
        objectArray[1] = frameId;
        objectArray[2] = variable.getId();
        return ResponseEntity.created((URI)a.path(FrameSummary.m_le((Object)"7?}-q8}(7 |>n2{>Q?et~)y6}(7 ~)y6}\u0012|&7-y)q:z7}(7 n:j2y9t>Q?e")).buildAndExpand(objectArray).toUri()).body(variable);
    }

    @PostMapping(value={"/devices/{deviceId}/frames"})
    public ResponseEntity<TFrameTemplate> createFrame(@PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrameTemplate frame, UriComponentsBuilder a) {
        frame = this.L.m_yoa(deviceId, frame);
        Object[] objectArray = new Object[2];
        objectArray[0] = deviceId;
        objectArray[1] = frame.getId();
        return ResponseEntity.created((URI)a.path(ConnectionManagementController.m_le((Object)"\u000f^ELIYEI\u000fAD_VSC_i^]\u0015FHAWEI\u000fAFHAWEsDG")).buildAndExpand(objectArray).toUri()).body(frame);
    }

    @GetMapping(value={"/devices/{deviceId}/frames/{frameId}/variables/{variableId}"})
    public TVariableTemplate getVariable(@PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @PathVariable(value="variableId") Integer a) {
        return (TVariableTemplate)this.L.m_sqa(deviceId, frameId, a);
    }

    @GetMapping(value={"/devices/{deviceId}/frames"})
    public Collection<TFrameTemplate> getFrames(@PathVariable(value="deviceId") Integer a) {
        return this.L.m_zra(a);
    }
}

