/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.repositories.VariableRepository;
import com.inscada.mono.communication.base.services.c_jd;
import com.inscada.mono.communication.protocols.mqtt.model.MqttSetValueRequestSummary;
import com.inscada.mono.expression.z.c_be;
import com.inscada.mono.job.model.JobDto;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.z.c_ji;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_fc;
import com.inscada.mono.shared.exceptions.c_mc;
import com.inscada.mono.shared.exceptions.c_mf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@EnableSpaceFilter
public abstract class c_wi<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>> {
    protected final c_ji K;
    protected final VariableRepository<TVariable> A;
    protected final ApplicationEventPublisher F;
    protected final c_jd<TConnection, TDevice, TFrame> c;
    protected static final String[] E;
    protected final c_be L;

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_sa(Integer a) {
        c_wi a2;
        if ((a = a2.A.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_cva(List<Integer> a) {
        c_wi a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyList();
        }
        return a2.A.findAllById(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_hqa(Integer a, String a2) {
        c_wi a3;
        Variable variable = a3.m_ka(a, a2);
        if (variable == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_mc(String.format(MqttSetValueRequestSummary.m_le((Object)"|HX@KKFL\nGE]\nOE\\DM\u0010\tZ[ECOJ^\tCM\u0010\t\u000fM\u0006\tDHGL\u0010\t\u000fZ"), objectArray));
        }
        return (TVariable)variable;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_fqa(VariableFilter a, Pageable a2) {
        c_wi a3;
        return a3.A.findVariablesByFilter(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE') and hasAuthority('UPDATE_VARIABLE')")
    public void m_gma(TVariable a, boolean a2) {
        Variable variable;
        c_wi a3;
        TVariable TVariable = a;
        a3.m_kwa(TVariable);
        if ((TVariable.getId() != null ? (variable = a3.m_ba(a.getId())) : (variable = a3.m_ka(a.getProjectId(), a.getName()))) != null) {
            a3.m_qua(a, variable, a2);
            return;
        }
        a3.m_sma(a, a2);
    }

    protected void m_kwa(TVariable a) {
        c_wi a2;
        if (a.getProject() == null) {
            TVariable TVariable = a;
            TVariable.setProject(a2.K.m_yc(TVariable.getProjectId()));
        }
        if (a.getFrame() == null) {
            TVariable TVariable = a;
            TVariable.setFrame(a2.c.m_uva(TVariable.getFrameId()));
        }
        if (a.getValueExpression() == null && a.getValueExpressionId() != null) {
            TVariable TVariable = a;
            TVariable.setValueExpression(a2.L.m_yc(TVariable.getValueExpressionId()));
        }
        if (a.getLogExpression() == null && a.getLogExpressionId() != null) {
            TVariable TVariable = a;
            TVariable.setLogExpression(a2.L.m_yc(TVariable.getLogExpressionId()));
        }
    }

    public void m_bpa(TVariable a) {
        c_wi a2;
        c_wi c_wi2 = a2;
        c_wi2.m_kwa(a);
        c_wi2.m_esa(a);
    }

    public Long m_aua() {
        c_wi a;
        return a.A.count();
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_yqa(VariableFilter a2) {
        c_wi a3;
        c_wi c_wi2 = a3;
        c_wi2.A.deleteAllByFilter(a2);
        c_wi2.c.m_sa(a2.getProjectId()).forEach(a -> {
            c_wi a2;
            a2.F.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_VARIABLE')")
    public void m_yva(Integer a, TVariable a2) {
        c_wi a3;
        c_wi c_wi2 = a3;
        a = c_wi2.m_yc(a);
        c_wi2.m_qua(a2, (Variable)a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_ka(Integer a, String a2) {
        c_wi a3;
        return (TVariable)a3.A.findOneByProjectIdAndName(a, a2);
    }

    private /* synthetic */ TVariable m_sma(TVariable a, boolean a2) {
        c_wi a3;
        c_wi c_wi2 = a3;
        c_wi2.m_bpa(a);
        Variable variable = (Variable)c_wi2.A.save(a);
        if (a2) {
            a3.F.publishEvent((ApplicationEvent)new RestartEvent((Object)a3, a.getConnection()));
        }
        return (TVariable)variable;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_aa(Integer a2) {
        if (a2 != null) {
            c_wi a3;
            c_wi c_wi2 = a3;
            c_wi2.A.deleteByProjectId(a2);
            c_wi2.c.m_sa(a2).forEach(a -> {
                c_wi a2;
                a2.F.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
            });
        }
    }

    static {
        String[] stringArray = new String[7];
        stringArray[0] = JobDto.m_le((Object)"{+");
        stringArray[1] = MqttSetValueRequestSummary.m_le((Object)"ZZHIL");
        stringArray[2] = JobDto.m_le((Object)"?` x*q;");
        stringArray[3] = MqttSetValueRequestSummary.m_le((Object)"JXLK]OMhP");
        stringArray[4] = JobDto.m_le((Object)"q=w.f&}!V.f*");
        stringArray[5] = MqttSetValueRequestSummary.m_le((Object)"FHY]gFN@L@OMhP");
        stringArray[6] = JobDto.m_le((Object)"~.a;_ v&t&w+V.f*");
        E = stringArray;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_ba(Integer a) {
        c_wi a2;
        return (TVariable)((Variable)a2.A.findById((Object)a).orElse(null));
    }

    public c_wi(c_ji a, c_jd<TConnection, TDevice, TFrame> a2, c_be a3, VariableRepository<TVariable> a4, ApplicationEventPublisher a5) {
        c_wi a6;
        c_wi c_wi2 = a6;
        c_wi c_wi3 = a6;
        a6.K = a;
        c_wi3.c = a2;
        c_wi3.L = a3;
        c_wi2.A = a4;
        c_wi2.F = a5;
    }

    protected void m_esa(TVariable a) {
        if (!a.getConnection().getProject().equals((Object)a.getProject())) {
            throw new c_mf(MqttSetValueRequestSummary.m_le((Object)"l[KDO\tHLFFDNY\t^F\nHDF^AO[\nYXF@LI]"));
        }
    }

    @Order(value=5)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_jl(ProjectDeleteEvent a) {
        c_wi a2;
        a2.m_aa(a.getProject().getId());
    }

    private /* synthetic */ void m_qua(TVariable a, TVariable a2, boolean a3) {
        c_wi a4;
        TVariable TVariable = a2;
        c_wi c_wi2 = a4;
        c_wi2.m_kwa(a);
        Connection connection = TVariable.getConnection();
        BeanUtils.copyProperties(a, a2, (String[])E);
        c_wi2.m_esa(TVariable);
        a = a2.getConnection();
        if (a3) {
            a4.F.publishEvent((ApplicationEvent)new RestartEvent((Object)a4, connection));
            if (!a.getId().equals(connection.getId())) {
                a4.F.publishEvent((ApplicationEvent)new RestartEvent((Object)a4, a));
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_mma(Integer a, String[] a2) {
        c_wi a3;
        if (a2 == null || a2.length == 0) {
            return Collections.emptyList();
        }
        if ((a = a3.A.findByProjectIdAndNameIn((Integer)a, a2)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_uta(List<Integer> a2) {
        c_wi a3;
        c_wi c_wi2 = a3;
        a2 = c_wi2.m_cva(a2);
        c_wi2.A.deleteInBatch(a2);
        a2.stream().map(Variable::getConnection).distinct().forEach(a -> {
            c_wi a2;
            a2.F.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
        });
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_VARIABLE')")
    public void m_ga(Integer a) {
        c_wi a2;
        if ((a = a2.m_ba(a)) != null) {
            if (a.getSourceVariableDataTransferDetails() != null && !a.getSourceVariableDataTransferDetails().isEmpty()) {
                throw new c_fc(JobDto.m_le((Object)"\u0019s={.p#wov*~*f&}!2)s&~*va2\u000bs;sof=s!a)w=2+w;s&~ow7{<f<"));
            }
            if (a.getTargetVariableDataTransferDetails() != null && !a.getTargetVariableDataTransferDetails().isEmpty()) {
                throw new c_fc(MqttSetValueRequestSummary.m_le((Object)"\u007fK[CHHEO\tNLFL^@EG\nOK@FLN\u0007\nmK]K\t^[KGYOO[\nMO]K@F\tOQCZ^Z"));
            }
            c_wi c_wi2 = a2;
            c_wi2.A.delete((Object)a);
            c_wi2.F.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a.getConnection()));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_pqa(Integer a) {
        c_wi a2;
        if ((a = a2.A.findByFrameId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE') and hasAuthority('UPDATE_VARIABLE')")
    public void m_gj(Collection<TVariable> a2, boolean a3) {
        c_wi a4;
        a2.forEach(arg_0 -> a4.m_kwa(arg_0));
        Object object = a2.stream().map(Variable::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.A.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(Variable::getProjectId, Collectors.mapping(Variable::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_wi a2;
            return a2.A.findByProjectIdAndNameIn((Integer)a.getKey(), (String[])((Set)a.getValue()).stream().toArray(String[]::new)).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(Variable::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        HashSet<Connection> hashSet = new HashSet<Connection>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Variable variable = (Variable)a2.next();
            if ((variable.getId() != null ? (Variable)map.get(variable.getId()) : (Variable)object.get(ImmutablePair.of((Object)variable.getProjectId(), (Object)variable.getName()))) != null) {
                Variable variable2;
                Variable variable3 = variable2;
                Connection connection = variable3.getConnection();
                Variable variable4 = variable;
                BeanUtils.copyProperties((Object)variable4, (Object)variable2, (String[])E);
                a4.m_esa(variable4);
                Connection connection2 = variable3.getConnection();
                if (connection.getId() != null) {
                    hashSet.add(connection);
                }
                if (connection2.getId() != null && !connection2.getId().equals(connection.getId())) {
                    hashSet.add(connection2);
                }
                arrayList.add(variable2);
                continue;
            }
            a4.m_esa(variable);
            arrayList.add(variable);
            hashSet.add(variable.getConnection());
        }
        a4.A.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_wi a2;
                a2.F.publishEvent((ApplicationEvent)new RestartEvent((Object)a2, a));
            });
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_uma(Integer a, String a2, String a3, String a4) {
        c_wi a5;
        if ((a = a5.A.findVariablesByFrameName((Integer)a, a2, a3, a4)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Collection<TVariable> m_la() {
        c_wi a;
        return a.A.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_ika(Pageable a) {
        c_wi a2;
        return a2.A.findAll(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public Page<TVariable> m_boa(Integer a, Pageable a2) {
        c_wi a3;
        return a3.A.findByProjectId(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_VARIABLE')")
    public TVariable m_pva(TVariable a) {
        c_wi a2;
        return (TVariable)a2.m_sma(a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_VARIABLE')")
    public TVariable m_yc(Integer a) {
        c_wi a2;
        Variable variable = a2.m_ba(a);
        if (variable == null) {
            throw new c_mc("Variable not found with id of " + a);
        }
        return (TVariable)variable;
    }
}

