/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_bda;
import com.inscada.mono.communication.base.services.c_fe;
import com.inscada.mono.communication.base.services.c_jba;
import com.inscada.mono.communication.base.services.c_qba;
import com.inscada.mono.communication.protocols.dnp3.c_jja;
import com.inscada.mono.communication.protocols.dnp3.c_kia;
import com.inscada.mono.communication.protocols.dnp3.model.Dnp3Connection;
import com.inscada.mono.communication.protocols.ethernet_ip.c_dja;
import com.inscada.mono.communication.protocols.ethernet_ip.model.EthernetIpConnection;
import com.inscada.mono.communication.protocols.fatek.c_yba;
import com.inscada.mono.communication.protocols.fatek.model.FatekConnection;
import com.inscada.mono.communication.protocols.iec104.c_kea;
import com.inscada.mono.communication.protocols.iec104.c_wia;
import com.inscada.mono.communication.protocols.iec104.model.Iec104Connection;
import com.inscada.mono.communication.protocols.iec61850.c_oq;
import com.inscada.mono.communication.protocols.iec61850.c_wt;
import com.inscada.mono.communication.protocols.iec61850.model.Iec61850Connection;
import com.inscada.mono.communication.protocols.local.c_iw;
import com.inscada.mono.communication.protocols.local.model.LocalConnection;
import com.inscada.mono.communication.protocols.modbus.c_fu;
import com.inscada.mono.communication.protocols.modbus.c_qo;
import com.inscada.mono.communication.protocols.modbus.c_rt;
import com.inscada.mono.communication.protocols.modbus.c_tr;
import com.inscada.mono.communication.protocols.modbus.model.ModbusConnection;
import com.inscada.mono.communication.protocols.mqtt.c_qt;
import com.inscada.mono.communication.protocols.mqtt.model.MqttConnection;
import com.inscada.mono.communication.protocols.opcda.c_by;
import com.inscada.mono.communication.protocols.opcda.model.OpcDaConnection;
import com.inscada.mono.communication.protocols.opcua.c_lw;
import com.inscada.mono.communication.protocols.opcua.c_nv;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaConnection;
import com.inscada.mono.communication.protocols.s7.c_sg;
import com.inscada.mono.communication.protocols.s7.model.S7Connection;
import com.inscada.mono.job.b.c_yl;
import com.inscada.mono.log.services.c_uh;
import com.inscada.mono.script.services.c_kh;
import com.inscada.mono.system.z.c_ab;
import com.inscada.mono.user.z.c_ta;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import redis.clients.jedis.JedisPooled;

@Configuration
public class ConnectorFactory<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ApplicationContextAware {
    private ApplicationContext E;
    private final Map<Integer, c_fe<C, V>> L;

    void stopAllLocalConnectors() {
        ConnectorFactory a;
        new ArrayList(a.L.keySet()).forEach(a3 -> {
            ConnectorFactory a2;
            c_fe c_fe2 = (c_fe)a2.L.get(a3);
            if (c_fe2 != null) {
                try {
                    c_fe2.m_kdb();
                    a2.L.remove(a3, c_fe2);
                    return;
                }
                catch (Exception a3) {
                    // empty catch block
                }
            }
        });
    }

    boolean hasConnector(Integer a) {
        ConnectorFactory a2;
        return a2.L.containsKey(a);
    }

    c_fe<C, V> getConnector(Integer a) {
        ConnectorFactory a2;
        return (c_fe)a2.L.get(a);
    }

    public ConnectorFactory() {
        ConnectorFactory a;
        ConnectorFactory connectorFactory = a;
        connectorFactory.L = new ConcurrentHashMap();
    }

    void removeConnector(Integer a, c_fe<C, V> a2) {
        ConnectorFactory a3;
        a3.L.remove(a, a2);
    }

    @Bean
    @Scope(value="prototype")
    c_fe<C, V> connector(Connection<?> a) {
        ConnectorFactory a2;
        c_yl c_yl2 = (c_yl)a2.getBean(c_yl.class);
        c_kh c_kh2 = (c_kh)a2.getBean(c_kh.class);
        c_uh c_uh2 = (c_uh)a2.getBean(c_uh.class);
        c_qba c_qba2 = (c_qba)a2.getBean(c_qba.class);
        c_jba c_jba2 = (c_jba)a2.getBean(c_jba.class);
        c_ab c_ab2 = (c_ab)a2.getBean(c_ab.class);
        JedisPooled jedisPooled = (JedisPooled)a2.getBean(JedisPooled.class);
        switch (c_bda.L[a.getProtocol().ordinal()]) {
            case 1: {
                c_fu c_fu2 = new c_fu(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (ModbusConnection)a, false);
                return c_fu2;
            }
            case 2: {
                c_rt c_rt2 = new c_rt(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, jedisPooled, (ModbusConnection)a, false);
                return c_rt2;
            }
            case 3: {
                c_qo c_qo2 = new c_qo(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (ModbusConnection)a);
                return c_qo2;
            }
            case 4: {
                c_tr c_tr2 = new c_tr(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, jedisPooled, (ModbusConnection)a);
                return c_tr2;
            }
            case 5: {
                c_fu c_fu3 = new c_fu(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (ModbusConnection)a, true);
                return c_fu3;
            }
            case 6: {
                c_rt c_rt3 = new c_rt(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, jedisPooled, (ModbusConnection)a, true);
                return c_rt3;
            }
            case 7: {
                c_jja c_jja2 = new c_jja(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (Dnp3Connection)a);
                return c_jja2;
            }
            case 8: {
                c_kia c_kia2 = new c_kia(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, c_ab2, (Dnp3Connection)a);
                return c_kia2;
            }
            case 9: {
                c_wia c_wia2 = new c_wia(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (Iec104Connection)a);
                return c_wia2;
            }
            case 10: {
                c_kea c_kea2 = new c_kea(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (Iec104Connection)a);
                return c_kea2;
            }
            case 11: {
                c_sg c_sg2 = new c_sg(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (S7Connection)a);
                return c_sg2;
            }
            case 12: {
                c_by c_by2 = new c_by(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (OpcDaConnection)a);
                return c_by2;
            }
            case 13: {
                c_qt c_qt2 = new c_qt(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (MqttConnection)a);
                return c_qt2;
            }
            case 14: {
                c_iw c_iw2 = new c_iw(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (LocalConnection)a);
                return c_iw2;
            }
            case 15: {
                c_dja c_dja2 = new c_dja(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (EthernetIpConnection)a);
                return c_dja2;
            }
            case 16: {
                c_nv c_nv2 = new c_nv(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (OpcUaConnection)a);
                return c_nv2;
            }
            case 17: {
                c_lw c_lw2 = new c_lw(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (OpcUaConnection)a);
                return c_lw2;
            }
            case 18: 
            case 19: {
                c_yba c_yba2 = new c_yba(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (FatekConnection)a);
                return c_yba2;
            }
            case 20: {
                c_wt c_wt2 = new c_wt(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (Iec61850Connection)a);
                return c_wt2;
            }
            case 21: {
                c_oq c_oq2 = new c_oq(c_yl2, c_kh2, c_uh2, c_qba2, c_jba2, (Iec61850Connection)a);
                return c_oq2;
            }
        }
        throw new IllegalArgumentException("Unsupported protocol: " + a.getProtocol());
    }

    c_fe<C, V> provideConnector(Connection<?> a) {
        ConnectorFactory a3;
        return a3.L.computeIfAbsent(a.getId(), a2 -> {
            ConnectorFactory a3;
            return a3.connector(a);
        });
    }

    private /* synthetic */ <T> T getBean(Class<T> a) {
        ConnectorFactory a2;
        if (a2.E == null) {
            throw new IllegalStateException(c_ta.m_le((Object)"=2\f.\u0015!\u001d6\u0015-\u0012\u0001\u0013,\b'\u00046\\*\u001d1\\,\u00136\\ \u0019'\u0012b\u000f'\bb\u0013,\\\u0001\u0013,\u0012'\u001f6\u00130:#\u001f6\u00130\u0005l\\\u0016\u0014+\u000fb\t1\t#\u0010.\u0005b\u0011'\u001d,\u000fb?-\u0012,\u0019!\b-\u000e\u0004\u001d!\b-\u000e;\\+\u000fb\u0012-\bb\u001e'\u0015,\u001bb\u0011#\u0012#\u001b'\u0018b\u001e;\\\u0011\f0\u0015,\u001bb\u001f-\u000e0\u0019!\b.\u0005b\u00130\\+\u000fb\u001e'\u0015,\u001bb\t1\u0019&\\ \u0019$\u00130\u0019b\b*\u0019b\u001f-\u00126\u0019:\bb\u00151\\$\t.\u0010;\\+\u0012+\b+\u001d.\u00158\u0019&R"));
        }
        return (T)a2.E.getBean(a);
    }

    public void setApplicationContext(ApplicationContext a) throws BeansException {
        a.E = a;
    }
}

