/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_nga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.cluster.z.c_hla;
import com.inscada.mono.communication.base.enums.c_mfa;
import com.inscada.mono.communication.base.events.DeleteEvent;
import com.inscada.mono.communication.base.events.RestartEvent;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.ConnectorFactory;
import com.inscada.mono.communication.base.services.c_fe;
import com.inscada.mono.communication.base.services.c_jea;
import com.inscada.mono.communication.base.services.c_k;
import com.inscada.mono.communication.protocols.mqtt.model.MqttMessage;
import com.inscada.mono.config.AuditConfig;
import com.inscada.mono.license.services.c_wd;
import com.inscada.mono.log.services.c_uh;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_mc;
import com.inscada.mono.shared.exceptions.c_uj;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener {
    public static final short f = 204;
    public static final short C = 202;
    public static final short d = 203;
    public static final short M = 206;
    private final c_jea a;
    private final c_wd h;
    private final JedisPooled G;
    private final ClusterOperations k;
    private final ConnectorFactory<C, V> J;
    private static final Logger b = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short m = 207;
    public static final short i = 201;
    public static final short g = 209;
    private final c_uh K;
    public static final short A = 210;
    private static final String F = "activeConnections";
    public static final short c = 208;
    private final Lock E;
    public static final short L = 205;

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(Integer a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            b.debug(MqttMessage.m_le((Object)"\u0005}\b|\fjs\u0018\u001aL&H9Q'_iY%Ti[&V']*L W'Ki^&JiH;W#]*LiC4\u0018%W*Y%T0\u0016"), (Object)a);
            a2.stopConnectionsByProjectIdInternal(a);
            return;
        }
        b.debug(AuditConfig.m_le((Object)"a2aPc8n9j/\u0015]}\u0018^\bJ\u000e[\u0014A\u001a\u000f\u0011J\u001cK\u0018]][\u0012\u000f\u000e[\u0012_]N\u0011C]L\u0012A\u0013J\u001e[\u0014@\u0013\\]I\u0012]]_\u000f@\u0017J\u001e[]T\u0000\u0001"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.k.callLeaderMethod(Short.valueOf((short)207), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC stop connections for project " + a, (Throwable)exception);
        }
    }

    protected void stopConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.a.m_qj((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    protected void stopConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.stopConnectionInternal(connectionManager.a.m_xh(a));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.stopConnection(connectionManager.a.m_cac(a, a2).getId());
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.k.addListener((ClusterNodeListener)a);
        b.info(MqttMessage.m_le((Object)"\nW'V,[=Q&V\u0004Y'Y.];\u0018 V L Y%Q3]-\u0018(V-\u0018;].Q:L,J,\\iY:\u0018\nT<K=];v&\\,t K=]'];\u0016"));
    }

    protected void startConnectionsByProjectIdInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.a.m_mga((Integer)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.startConnectionInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_mfa> getConnectionStatuses(Integer[] a) {
        ConnectionManager a2;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.k.isLeader()) {
            b.debug(AuditConfig.m_le((Object)"c8n9j/\u0015]h\u0018[\tF\u0013H]L\u0012A\u0013J\u001e[\u0014@\u0013\u000f\u000e[\u001c[\b\\\u0018\\]I\u0012]]T\u0000\u000f4k\u000e\u000f\u0011@\u001eN\u0011C\u0004\u0001"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal(a);
        }
        b.debug(MqttMessage.m_le((Object)"v\u0006vdt\fy\r}\u001b\u0002ij,I<]:L V.\u0018%](\\,Ji^&Ji[&V']*L W'\u0018:L(L<K,Ki^&JiC4\u0018\u0000|:\u0016"), (Object)a.length);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.k.callLeaderMethod(Short.valueOf((short)209), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get connection statuses for IDs " + Arrays.toString((Object[])a), (Throwable)exception);
        }
    }

    protected void startConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_nga.m_jub(() -> {
            ConnectionManager a2;
            a2.E.lock();
            try {
                a2.stopConnectionInternal(a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_uj("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.h.m_uja();
                connectionManager.J.provideConnector(a).m_zya();
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                connectionManager.G.sadd(F, stringArray);
                return;
            }
            finally {
                a2.E.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            b.debug(MqttMessage.m_le((Object)"t\fy\r}\u001b\u0002ik=Y;L V.\u0018*W'V,[=Q&ViC4\u0018%W*Y%T0\u0016"), (Object)a);
            a2.startConnectionInternal(a);
            return;
        }
        b.debug(AuditConfig.m_le((Object)"a2aPc8n9j/\u0015]}\u0018^\bJ\u000e[\u0014A\u001a\u000f\u0011J\u001cK\u0018]][\u0012\u000f\u000e[\u001c]\t\u000f\u001e@\u0013A\u0018L\tF\u0012A]T\u0000\u0001"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.k.callLeaderMethod(Short.valueOf((short)201), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC start connection " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            ConnectionManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.k.addRemoteCall((short)201, (Object)a, ConnectionManager.class.getDeclaredMethod(AuditConfig.m_le((Object)"\\\tN\u000f[>@\u0013A\u0018L\tF\u0012A4A\tJ\u000fA\u001cC"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.k.addRemoteCall((short)202, (Object)a, ConnectionManager.class.getDeclaredMethod(MqttMessage.m_le((Object)":L&H\nW'V,[=Q&V\u0000V=];V(T"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.k.addRemoteCall((short)203, (Object)a, ConnectionManager.class.getDeclaredMethod(AuditConfig.m_le((Object)"H\u0018[>@\u0013A\u0018L\tF\u0012A.[\u001c[\b\\4A\tJ\u000fA\u001cC"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = SetValueRequest.class;
            a.k.addRemoteCall((short)204, (Object)a, ConnectionManager.class.getDeclaredMethod(MqttMessage.m_le((Object)":]=n(J Y+T,n(T<]\u0000V=];V(T"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Collection.class;
            a.k.addRemoteCall((short)205, (Object)a, ConnectionManager.class.getDeclaredMethod(AuditConfig.m_le((Object)"\\\u0018[+N\u000fF\u001cM\u0011J+N\u0011Z\u0018\\4A\tJ\u000fA\u001cC"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.k.addRemoteCall((short)206, (Object)a, ConnectionManager.class.getDeclaredMethod(MqttMessage.m_le((Object)"K=Y;L\nW'V,[=Q&V:z0h;W#]*L\u0000\\\u0000V=];V(T"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = Integer.class;
            a.k.addRemoteCall((short)207, (Object)a, ConnectionManager.class.getDeclaredMethod(AuditConfig.m_le((Object)"\u000e[\u0012_>@\u0013A\u0018L\tF\u0012A\u000em\u0004\u007f\u000f@\u0017J\u001e[4K4A\tJ\u000fA\u001cC"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.k.addRemoteCall((short)208, (Object)a, ConnectionManager.class.getDeclaredMethod(MqttMessage.m_le((Object)".]={&V']*L W'k=Y=M:]:z0h;W#]*L\u0000\\\u0000V=];V(T"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer[].class;
            a.k.addRemoteCall((short)209, (Object)a, ConnectionManager.class.getDeclaredMethod(AuditConfig.m_le((Object)"\u001aJ\tl\u0012A\u0013J\u001e[\u0014@\u0013|\tN\tZ\u000eJ\u000em\u0004f\u0019\\4A\tJ\u000fA\u001cC"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = Integer.class;
            a.k.addRemoteCall((short)210, (Object)a, ConnectionManager.class.getDeclaredMethod(MqttMessage.m_le((Object)"+J&O:]\nW'V,[=Q&V\u0000V=];V(T"), classArray10));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(AuditConfig.m_le((Object)";N\u0014C\u0018K][\u0012\u000f\u000fJ\u001aF\u000e[\u0018]]l\u0012A\u0013J\u001e[\u0014@\u0013b\u001cA\u001cH\u0018]]}-l]B\u0018[\u0015@\u0019\\"), noSuchMethodException);
        }
    }

    protected Map<Integer, c_mfa> getConnectionStatusesByProjectIdInternal(Integer a2) {
        ConnectionManager a3;
        if ((a2 = a3.a.m_qj((Integer)a2)) == null || a2.isEmpty()) {
            return Collections.emptyMap();
        }
        return a2.stream().collect(Collectors.toMap(Connection::getId, a -> {
            ConnectionManager a2;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> a22) {
        ConnectionManager a3;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, AuditConfig.m_le((Object)".J\ty\u001cC\bJ/J\fZ\u0018\\\t\u000f\u001eN\u0013A\u0012[]M\u0018\u000f\u0013Z\u0011C")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), MqttMessage.m_le((Object)"\nW'V,[=Q&V\u0000\\iQ'\u0018\u001a]=n(T<]\u001b]8M,K=\u0018*Y'V&LiZ,\u0018'M%T")));
        if (a3.k.isLeader()) {
            b.debug(MqttMessage.m_le((Object)"t\fy\r}\u001b\u0002ik,L=Q'_iC4\u0018?Y;Q(Z%]iN(T<]:\u0018%W*Y%T0\u0016"), (Object)a22.size());
            a3.setVariableValuesInternal(a22);
            return;
        }
        b.debug(AuditConfig.m_le((Object)"3`3\u00021j<k8}G\u000f/J\fZ\u0018\\\tF\u0013H]C\u0018N\u0019J\u000f\u000f\t@]\\\u0018[]T\u0000\u000f\u000bN\u000fF\u001cM\u0011J]Y\u001cC\bJ\u000e\u0001"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<SetValueRequest<V>>(a22);
            a3.k.callLeaderMethod(Short.valueOf((short)205), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new c_hla(MqttMessage.m_le((Object)"~(Q%]-\u0018=Wij\u0019{iK,LiN(J Y+T,\u0018?Y%M,K"), (Throwable)a22);
        }
    }

    public ConnectionManager(c_jea a, c_wd a2, c_uh a3, ConnectorFactory<C, V> a4, JedisPooled a5, ClusterOperations a6) {
        ConnectionManager a7;
        ConnectionManager connectionManager = a7;
        ConnectionManager connectionManager2 = a7;
        ConnectionManager connectionManager3 = a7;
        ConnectionManager connectionManager4 = a7;
        connectionManager4.E = new ReentrantLock();
        connectionManager3.a = a;
        connectionManager3.h = a2;
        connectionManager2.K = a3;
        connectionManager2.J = a4;
        connectionManager.G = a5;
        connectionManager.k = a6;
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            Integer n = a.getProject().getId();
            b.info(AuditConfig.m_le((Object)"1j<k8}G\u000f5N\u0013K\u0011F\u0013H]\u007f\u000f@\u0017J\u001e[9J\u001cL\tF\u000bN\tJ8Y\u0018A\t\u000f\u001b@\u000f\u000f\r]\u0012E\u0018L\t\u000f4kG\u000f\u0006R"), (Object)n);
            a2.stopConnectionsByProjectIdInternal(n);
            return;
        }
        b.debug(MqttMessage.m_le((Object)"\u0007w\u0007\u0015\u0005}\b|\fjs\u0018\u0000_'W;Q'_ih;W#]*L\r]([=Q?Y=]\fN,V=\u0018/W;\u00189J&R,[=\u0018\u0000|s\u00182E"), (Object)a.getProject().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(Integer a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            b.debug(AuditConfig.m_le((Object)"1j<k8}G\u000f-J\u000fI\u0012]\u0010F\u0013H]M\u000f@\n\\\u0018\u000f\u0012_\u0018]\u001c[\u0014@\u0013\u000f\u001b@\u000f\u000f\u001e@\u0013A\u0018L\tF\u0012A]T\u0000\u000f\u0011@\u001eN\u0011C\u0004\u0001"), (Object)a);
            return a2.browseConnectionInternal(a);
        }
        b.debug(MqttMessage.m_le((Object)"\u0007w\u0007\u0015\u0005}\b|\fjs\u0018\u001b]8M,K=Q'_iT,Y-];\u0018=WiH,J/W;UiZ;W>K,\u0018&H,J(L W'\u0018/W;\u0018*W'V,[=Q&ViC4\u0016"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return a2.k.callLeaderMethod(Short.valueOf((short)210), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC browse connection " + a, (Throwable)exception);
        }
    }

    protected Map<Integer, c_mfa> getConnectionStatusesByIdsInternal(Integer[] a2) {
        ConnectionManager a3;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> a3.getConnectionStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_mfa getConnectionStatus(Integer a, String a2) {
        ConnectionManager a3;
        if ((a = a3.a.m_sf(a, a2)) == null) {
            return c_mfa.c;
        }
        return a3.getConnectionStatus(a.getId());
    }

    protected void startConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        connectionManager.startConnectionInternal(connectionManager.a.m_efa(a));
    }

    @TransactionalEventListener(value={RestartEvent.class})
    public void handleRestartEvent(RestartEvent a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            Connection connection = a.getConnection();
            b.info(AuditConfig.m_le((Object)"c8n9j/\u0015]g\u001cA\u0019C\u0014A\u001a\u000f/J\u000e[\u001c]\tj\u000bJ\u0013[]I\u0012]]L\u0012A\u0013J\u001e[\u0014@\u0013\u0015]T\u0000\u000fUf9\u0015]T\u0000\u0006"), (Object)connection.getName(), (Object)connection.getId());
            a2.E.lock();
            try {
                if (a2.getConnectionStatusInternal(connection.getId()) == c_mfa.L) {
                    a2.startConnectionInternal(connection.getId());
                }
                return;
            }
            finally {
                a2.E.unlock();
            }
        }
        b.debug(MqttMessage.m_le((Object)"\u0007w\u0007\u0015\u0005}\b|\fjs\u0018\u0000_'W;Q'_ij,K=Y;L\fN,V=\u0018/W;\u0018*W'V,[=Q&Vs\u00182E"), (Object)a.getConnection().getId());
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(Integer a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            b.debug(AuditConfig.m_le((Object)"c8n9j/\u0015]|\t@\r_\u0014A\u001a\u000f\u001e@\u0013A\u0018L\tF\u0012A]T\u0000\u000f\u0011@\u001eN\u0011C\u0004\u0001"), (Object)a);
            a2.stopConnectionInternal(a);
            return;
        }
        b.debug(MqttMessage.m_le((Object)"\u0007w\u0007\u0015\u0005}\b|\fjs\u0018\u001b]8M,K=Q'_iT,Y-];\u0018=WiK=W9\u0018*W'V,[=Q&ViC4\u0016"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.k.callLeaderMethod(Short.valueOf((short)202), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC stop connection " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<Integer, c_mfa> getConnectionStatuses(Integer a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            b.debug(AuditConfig.m_le((Object)"c8n9j/\u0015]h\u0018[\tF\u0013H]N\u0011C]L\u0012A\u0013J\u001e[\u0014@\u0013\u000f\u000e[\u001c[\b\\\u0018\\]I\u0012]]_\u000f@\u0017J\u001e[]T\u0000\u000f\u0011@\u001eN\u0011C\u0004\u0001"), (Object)a);
            return a2.getConnectionStatusesByProjectIdInternal(a);
        }
        b.debug(MqttMessage.m_le((Object)"v\u0006vdt\fy\r}\u001b\u0002ij,I<]:L V.\u0018%](\\,Ji^&JiY%Ti[&V']*L W'\u0018:L(L<K,Ki^&JiH;W#]*LiC4\u0016"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.k.callLeaderMethod(Short.valueOf((short)208), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get connection statuses for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(Integer a, String a2) {
        ConnectionManager a3;
        ConnectionManager connectionManager = a3;
        connectionManager.startConnection(connectionManager.a.m_cac(a, a2).getId());
    }

    protected Object browseConnectionInternal(Integer a) {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        Connection connection = connectionManager.a.m_xh(a);
        return c_nga.m_wub(() -> {
            ConnectionManager a2;
            if ((a = a2.J.getConnector(a)) instanceof c_k) {
                return ((c_k)a).m_wa();
            }
            throw new RuntimeException(MqttMessage.m_le((Object)"\u000bJ&O:]iW9];Y=Q&ViV&LiK<H9W;L,\\"));
        }, (OwnedSpaceBaseModel)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager a2;
        ConnectionManager connectionManager = a2;
        String string = connectionManager.k.getCurrentNode().getNodeId();
        b.info(AuditConfig.m_le((Object)">@\u0013A\u0018L\tF\u0012A0N\u0013N\u001aJ\u000f\u0015]{\u0015F\u000e\u000f\u0013@\u0019J]\u0007\u0006RT\u000f\u0015N\u000e\u000f\u001fJ\u001e@\u0010J][\u0015J]c8n9j/\u0001]}\u0018\\\t@\u000fF\u0013H]N\u001e[\u0014Y\u0018\u000f\u001e@\u0013A\u0018L\tF\u0012A\u000e\u0001S\u0001"), (Object)string);
        connectionManager.E.lock();
        try {
            Set set = a2.G.smembers(F).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                b.info(MqttMessage.m_le((Object)"{&V']*L W'u(V(_,Ji\u0010\u0005](\\,JiC4\u0011s\u0018\u0007WiY*L N,\u0018*W'V,[=Q&V:\u0018/W<V-\u0018 Vij,\\ KiL&\u0018;]:L&J,\u0016"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            b.info(AuditConfig.m_le((Object)"l\u0012A\u0013J\u001e[\u0014@\u0013b\u001cA\u001cH\u0018]]\u00071J\u001cK\u0018]]T\u0000\u0006G\u000f;@\bA\u0019\u000f\u0006R]N\u001e[\u0014Y\u0018\u000f\u001e@\u0013A\u0018L\tF\u0012A]f9\\]F\u0013\u000f/J\u0019F\u000e\u000f\t@]]\u0018\\\t@\u000fJG\u000f\u0006R"), objectArray);
            ArrayList arrayList = new ArrayList(a2.a.m_uwb(set));
            b.info(MqttMessage.m_le((Object)"\nW'V,[=Q&V\u0004Y'Y.];\u0018at,Y-];\u00182E`\u0002iy=L,U9L V.\u0018=WiJ,K=W;]iC4\u0018*W'V,[=Q&V:\u0016"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                ConnectionManager a2;
                String string = a2.k.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    b.info(MqttMessage.m_le((Object)"\nW'V,[=Q&V\u0004Y'Y.];\u0018at,Y-];\u00182E`\u0002ij,K=W;Q'_i[&V']*L W'\u0002iC4\u0018aq\r\u0002iC4\u0011"), objectArray);
                    a2.startConnectionInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.K.m_pga(a.getProject()).m_g("Connection Restore (Leader " + string + ")", String.format(AuditConfig.m_le((Object)"X\\]\u00074kG\u000fXKT\u000f\u001bN\u0014C\u0018K][\u0012\u000f\u000fJ\u000e[\u0012]\u0018\u0001]l\u001cZ\u000eJG\u000fX\\"), objectArray));
                    try {
                        b.warn(MqttMessage.m_le((Object)"\nW'V,[=Q&V\u0004Y'Y.];\u0018at,Y-];\u00182E`\u0002iy=L,U9L V.\u0018=WiK=W9\u0018*W'V,[=Q&ViC4\u0018(^=];\u0018;]:L&J(L W'\u0018/Y T<J,\u0016"), (Object)string, (Object)a.getId());
                        a2.stopConnectionInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        b.error(AuditConfig.m_le((Object)"l\u0012A\u0013J\u001e[\u0014@\u0013b\u001cA\u001cH\u0018]]\u00071J\u001cK\u0018]]T\u0000\u0006G\u000f;N\u0014C\u0018K][\u0012\u000f\u000e[\u0012_]L\u0012A\u0013J\u001e[\u0014@\u0013\u000f\u0006R]N\u001b[\u0018]]]\u0018\\\t@\u000fN\tF\u0012A]I\u001cF\u0011Z\u000fJG\u000f\u0006R"), objectArray2);
                        return;
                    }
                }
            });
            b.info(AuditConfig.m_le((Object)"l\u0012A\u0013J\u001e[\u0014@\u0013b\u001cA\u001cH\u0018]]\u00071J\u001cK\u0018]]T\u0000\u0006G\u000f;F\u0013F\u000eG\u0018K]L\u0012A\u0013J\u001e[\u0014@\u0013\u000f\u000fJ\u000e[\u0012]\u001c[\u0014@\u0013\u000f\r]\u0012L\u0018\\\u000e\u0001"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            b.error(MqttMessage.m_le((Object)"\nW'V,[=Q&V\u0004Y'Y.];\u0018at,Y-];\u00182E`\u0002i};J&Ji\\<J V.\u0018*W'V,[=Q&ViJ,K=W;Y=Q&ViH;W*]:Ks\u00182E"), objectArray);
            return;
        }
        finally {
            a2.E.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> a) {
        ConnectionManager a2;
        Objects.requireNonNull(a, AuditConfig.m_le((Object)".J\ty\u001cC\bJ/J\fZ\u0018\\\t\u000f\u001eN\u0013A\u0012[]M\u0018\u000f\u0013Z\u0011C"));
        Objects.requireNonNull(a.getConnectionId(), MqttMessage.m_le((Object)"\nW'V,[=Q&V\u0000\\iQ'\u0018\u001a]=n(T<]\u001b]8M,K=\u0018*Y'V&LiZ,\u0018'M%T"));
        if (a2.k.isLeader()) {
            b.debug(AuditConfig.m_le((Object)"1j<k8}G\u000f.J\t[\u0014A\u001a\u000f\u000bN\u000fF\u001cM\u0011J]Y\u001cC\bJ]I\u0012]]L\u0012A\u0013J\u001e[\u0014@\u0013\u000f\u0006R]C\u0012L\u001cC\u0011VG\u000f\u0006R"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        b.debug(MqttMessage.m_le((Object)"v\u0006vdt\fy\r}\u001b\u0002ij,I<]:L V.\u0018%](\\,JiL&\u0018:]=\u0018?Y;Q(Z%]iN(T<]i^&Ji[&V']*L W'\u00182Es\u00182E"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.k.callLeaderMethod(Short.valueOf((short)204), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    protected c_mfa getConnectionStatusInternal(Integer a) {
        ConnectionManager a2;
        if ((a = a2.J.getConnector(a)) != null && a.m_jya()) {
            return c_mfa.L;
        }
        return c_mfa.c;
    }

    protected void setVariableValueInternal(SetValueRequest<V> a) {
        ConnectionManager a2;
        c_fe c_fe2 = a2.J.getConnector(a.getConnectionId());
        if (c_fe2 == null) {
            throw new c_mc("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_fe2.m_jxa(a);
    }

    protected void stopConnectionInternal(Connection<?> a) {
        ConnectionManager a2;
        c_nga.m_jub(() -> {
            ConnectionManager a2;
            a2.E.lock();
            try {
                c_fe c_fe2 = a2.J.getConnector(a.getId());
                if (c_fe2 != null) {
                    c_fe2.m_kdb();
                    a2.J.removeConnector(a.getId(), c_fe2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.G.srem(F, stringArray);
                return;
            }
            finally {
                a2.E.unlock();
            }
        }, a);
    }

    public void notLeader() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        String string = connectionManager.k.getCurrentNode().getNodeId();
        b.info(AuditConfig.m_le((Object)"l\u0012A\u0013J\u001e[\u0014@\u0013b\u001cA\u001cH\u0018]G\u000f)G\u0014\\]A\u0012K\u0018\u000fUT\u0000\u0006]F\u000e\u000f3`]c2a:j/\u000f)g8\u000f1j<k8}S\u000f.[\u0012_\rF\u0013H]N\u0011C]C\u0012L\u001cC]L\u0012A\u0013J\u001e[\u0012]\u000e\u0001S\u0001"), (Object)string);
        connectionManager.E.lock();
        try {
            a.J.stopAllLocalConnectors();
            b.info(MqttMessage.m_le((Object)"\nW'V,[=Q&V\u0004Y'Y.];\u0018av&Lit,Y-];\u00182E`\u0002iy%TiT&[(Ti[&V']*L&J:\u0018!Y?]iZ,]'\u0018;]8M,K=]-\u0018=WiK=W9\u0018(V-\u0018*T,Y;]-\u0018/J&UiT&[(TiL;Y*S V.\u0016"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            b.error(AuditConfig.m_le((Object)">@\u0013A\u0018L\tF\u0012A0N\u0013N\u001aJ\u000f\u000fUa\u0012[]c\u0018N\u0019J\u000f\u000f\u0006RT\u0015]j\u000f]\u0012]]K\b]\u0014A\u001a\u000f\r]\u0012L\u0018\\\u000e\u000f\u0012I]\\\t@\r_\u0014A\u001a\u000f\u0011@\u001eN\u0011\u000f\u001e@\u0013A\u0018L\t@\u000f\\G\u000f\u0006R"), objectArray);
            return;
        }
        finally {
            a.E.unlock();
        }
    }

    @TransactionalEventListener(value={DeleteEvent.class})
    public void handleDeleteEvent(DeleteEvent a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            Connection connection = a.getConnection();
            b.info(AuditConfig.m_le((Object)"1j<k8}G\u000f5N\u0013K\u0011F\u0013H]k\u0018C\u0018[\u0018j\u000bJ\u0013[]I\u0012]]L\u0012A\u0013J\u001e[\u0014@\u0013\u0015]T\u0000\u000fUf9\u0015]T\u0000\u0006"), (Object)connection.getName(), (Object)connection.getId());
            a2.stopConnectionInternal(connection);
            return;
        }
        b.debug(MqttMessage.m_le((Object)"v\u0006vdt\fy\r}\u001b\u0002iq.V&J V.\u0018\r]%]=]\fN,V=\u0018/W;\u0018*W'V,[=Q&Vs\u00182E"), (Object)a.getConnection().getId());
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(Integer a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            b.debug(AuditConfig.m_le((Object)"1j<k8}G\u000f.[\u001c]\tF\u0013H]N\u0011C]L\u0012A\u0013J\u001e[\u0014@\u0013\\]I\u0012]]_\u000f@\u0017J\u001e[]T\u0000\u000f\u0011@\u001eN\u0011C\u0004\u0001"), (Object)a);
            a2.startConnectionsByProjectIdInternal(a);
            return;
        }
        b.debug(MqttMessage.m_le((Object)"\u0007w\u0007\u0015\u0005}\b|\fjs\u0018\u001b]8M,K=Q'_iT,Y-];\u0018=WiK=Y;LiY%Ti[&V']*L W'Ki^&JiH;W#]*LiC4\u0016"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.k.callLeaderMethod(Short.valueOf((short)206), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC start connections for project " + a, (Throwable)exception);
        }
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> a3) {
        ConnectionManager a4;
        a3.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((a, a2) -> {
            ConnectionManager a3;
            if ((a = a3.J.getConnector(a)) != null) {
                a.m_rxa(a2);
            }
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_mfa getConnectionStatus(Integer a) {
        ConnectionManager a2;
        if (a2.k.isLeader()) {
            b.debug(AuditConfig.m_le((Object)"c8n9j/\u0015]h\u0018[\tF\u0013H]L\u0012A\u0013J\u001e[\u0014@\u0013\u000f\u000e[\u001c[\b\\]I\u0012]]T\u0000\u000f\u0011@\u001eN\u0011C\u0004\u0001"), (Object)a);
            return a2.getConnectionStatusInternal(a);
        }
        b.debug(MqttMessage.m_le((Object)"v\u0006vdt\fy\r}\u001b\u0002ij,I<]:L V.\u0018%](\\,Ji^&Ji[&V']*L W'\u0018:L(L<Ki^&JiC4\u0016"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_mfa)a2.k.callLeaderMethod(Short.valueOf((short)203), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get connection status for " + a, (Throwable)exception);
        }
    }
}

