/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.communication.base.enums.c_via;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueDto;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_jba;
import com.inscada.mono.communication.base.services.c_qba;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/variables"})
public class VariableValueController {
    private final c_qba E;
    private final c_jba L;

    @GetMapping(value={"/loggedValues/stats/hourly/pages"})
    public Page<LoggedVariableValueStats> getLoggedHourlyVariableValueStatsInPages(@RequestParam(value="variableIds") Integer[] variableIds, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, Pageable a) {
        return this.L.m_nnb(variableIds, startDate, endDate, a, new c_via[0]);
    }

    @GetMapping(value={"/loggedValues"})
    public Collection<LoggedVariableValueDto> getLoggedVariableValues(@RequestParam(value="variableIds") Integer[] variableIds, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date a) {
        return this.L.m_dpb(variableIds, startDate, a);
    }

    @GetMapping(value={"/loggedValues/stats/daily/pages"})
    public Page<LoggedVariableValueStats> getLoggedDailyVariableValueStatsInPages(@RequestParam(value="variableIds") Integer[] variableIds, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, Pageable a) {
        return this.L.m_lsb(variableIds, startDate, endDate, a, new c_via[0]);
    }

    @GetMapping(value={"/values"}, params={"projectId", "names"})
    public Map<String, VariableValue<?>> getVariableValuesByProjectIdAndNames(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="names") String[] a) {
        return this.E.m_ijb(projectId, a);
    }

    @GetMapping(value={"/loggedValues/stats/daily"})
    public Collection<LoggedVariableValueStats> getLoggedDailyVariableValueStats(@RequestParam(value="variableIds") Integer[] variableIds, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date a) {
        return this.L.m_knb(variableIds, startDate, a, new c_via[0]);
    }

    @GetMapping(value={"/values"}, params={"projectId"})
    public Map<Integer, VariableValue<?>> getVariableValuesByProjectId(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.E.m_gsb();
        }
        return this.E.m_zjb(a);
    }

    public static String m_le(Object a) {
        a = (String)a;
        int n = ((String)a).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (2 ^ 5) << 3 ^ (2 ^ 5);
        int cfr_ignored_0 = 5 << 4 ^ 3;
        int n4 = n2;
        int n5 = (2 ^ 5) << 4 ^ 5 << 1;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @GetMapping(value={"/loggedValues/stats/daily"}, params={"projectId", "names", "startDate", "endDate"})
    public Map<String, List<LoggedVariableValueStats>> getLoggedDailyVariableValueStatsByProjectIdAndNames(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="names") String[] names, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date a) {
        return this.L.m_gmb(projectId, names, startDate, a, new c_via[0]);
    }

    @GetMapping(value={"/loggedValues/stats"})
    public Collection<LoggedVariableValueStats> getLoggedVariableValueStats(@RequestParam(value="variableIds") Integer[] variableIds, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, @RequestParam(value="interval", required=false) Integer a) {
        if (a == null) {
            return this.L.m_ttb(variableIds, startDate, endDate, new c_via[0]);
        }
        return this.L.m_mkb(variableIds, startDate, endDate, a, new c_via[0]);
    }

    @GetMapping(value={"/loggedValues/stats/hourly"}, params={"variableIds", "startDate", "endDate"})
    public Collection<LoggedVariableValueStats> getLoggedHourlyVariableValueStats(@RequestParam(value="variableIds") Integer[] variableIds, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date a) {
        return this.L.m_iob(variableIds, startDate, a, new c_via[0]);
    }

    @GetMapping(value={"/{variableId}/value"})
    public VariableValue<?> getVariableValue(@PathVariable(value="variableId") Integer a) {
        return this.E.m_gpb(a);
    }

    @GetMapping(value={"/values"}, params={"variableIds"})
    public Map<Integer, VariableValue<?>> getVariableValues(@RequestParam(value="variableIds") Integer[] a) {
        return this.E.m_ckb(a);
    }

    @PostMapping(value={"/{variableId}/value"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setVariableValue(@PathVariable(value="variableId") Integer variableId, @RequestBody Map<String, Object> a) {
        this.E.m_mtb(variableId, a);
    }

    @GetMapping(value={"/loggedValues/stats/hourly"}, params={"projectId", "names", "startDate", "endDate"})
    public Map<String, List<LoggedVariableValueStats>> getLoggedHourlyVariableValueStatsByProjectIdAndNames(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="names") String[] names, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date a) {
        return this.L.m_wob(projectId, names, startDate, a, new c_via[0]);
    }

    @PostMapping(value={"/value"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setVariableValue(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String name, @RequestBody Map<String, Object> a) {
        this.E.m_rnb(projectId, name, a);
    }

    @GetMapping(value={"/values"}, params={"frameId"})
    public Map<Integer, VariableValue<?>> getVariableValuesByFrameId(@RequestParam(value="frameId") Integer a) {
        return this.E.m_isb(a);
    }

    public VariableValueController(c_qba a, c_jba a2) {
        VariableValueController a3;
        VariableValueController variableValueController = a3;
        variableValueController.E = a;
        variableValueController.L = a2;
    }

    @GetMapping(value={"/loggedValues/pages"})
    public Page<LoggedVariableValueDto> getLoggedVariableValuesInPages(@RequestParam(value="variableIds") Integer[] variableIds, @RequestParam(value="startDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startDate, @RequestParam(value="endDate") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endDate, Pageable a) {
        return this.L.m_kqb(variableIds, startDate, endDate, a);
    }

    @GetMapping(value={"/value"})
    public VariableValue<?> getVariableValue(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.E.m_oob(projectId, a);
    }
}

