/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.alarm.model.FiredAlarmList;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_jd;
import com.inscada.mono.communication.base.template.model.DeviceGenerationRequest;
import com.inscada.mono.communication.base.template.z.c_ul;
import com.inscada.mono.config.AuditConfig;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ConnectionController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TConnectionService extends c_jd<TConnection, TDevice, TFrame>, TTemplateService extends c_ul> {
    protected final TTemplateService E;
    protected final TConnectionService L;

    @DeleteMapping(value={"/devices"}, params={"deviceIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevicesByIds(@RequestParam(value="deviceIds") Integer[] a) {
        this.L.m_ssa(List.of(a));
    }

    @GetMapping(value={"/{connectionId}"})
    public TConnection getConnection(@PathVariable(value="connectionId") Integer a) {
        return (TConnection)this.L.m_ba(a);
    }

    @GetMapping
    public Collection<TConnection> getConnections(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.L.m_la();
        }
        return this.L.m_sa(a);
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        this.L.m_lra(connectionId, a);
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TDevice a) {
        this.L.m_sua(connectionId, deviceId, a, Boolean.valueOf(true));
    }

    @GetMapping(value={"/frame/{frameId}"})
    public TFrame getFrameById(@PathVariable(value="frameId") Integer a) {
        return (TFrame)this.L.m_kpa(a);
    }

    @DeleteMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnection(@PathVariable(value="connectionId") Integer a) {
        this.L.m_ga(a);
    }

    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        this.L.m_kma(connectionId, deviceId, a);
    }

    @PostMapping
    public ResponseEntity<TConnection> createConnection(@Valid @RequestBody TConnection connection, UriComponentsBuilder a) {
        connection = this.L.m_loa(connection);
        Object[] objectArray = new Object[1];
        objectArray[0] = connection.getId();
        return ResponseEntity.created((URI)a.path(AuditConfig.m_le((Object)"\u0000\u0006L\u0012A\u0013J\u001e[\u0014@\u0013f\u0019R")).buildAndExpand(objectArray).toUri()).body(connection);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}"})
    public TDevice getDevice(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.L.m_rpa(connectionId, a);
    }

    @GetMapping(value={"/frames"})
    public Collection<TFrame> getFrames(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.L.m_wwa();
        }
        return this.L.m_gta(a);
    }

    @DeleteMapping(value={""}, params={"connectionIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnectionsByIds(@RequestParam(value="connectionIds") Integer[] a) {
        this.L.m_hsa(List.of(a));
    }

    @DeleteMapping(value={"/frames"}, params={"frameIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFramesByIds(@RequestParam(value="frameIds") Integer[] a) {
        this.L.m_wpa(List.of(a));
    }

    @PostMapping(value={"/{connectionId}/devices/generate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void generateFromTemplate(@PathVariable(value="connectionId") Integer connectionId, @RequestBody DeviceGenerationRequest a) {
        this.E.m_dva(connectionId, a);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    public TFrame getFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer a) {
        return (TFrame)this.L.m_xla(connectionId, deviceId, a);
    }

    public static String m_le(Object a) {
        a = (String)a;
        int n = ((String)a).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (3 ^ 5) << 3 ^ (3 ^ 5);
        int cfr_ignored_0 = (3 ^ 5) << 4 ^ (2 ^ 5);
        int n4 = n2;
        int n5 = 1 << 3 ^ (2 ^ 5);
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @PutMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @PathVariable(value="frameId") Integer frameId, @Valid @RequestBody TFrame a) {
        this.L.m_wla(connectionId, deviceId, frameId, a, Boolean.valueOf(true));
    }

    protected ConnectionController(TConnectionService a, TTemplateService a2) {
        ConnectionController a3;
        ConnectionController connectionController = a3;
        connectionController.L = a;
        connectionController.E = a2;
    }

    @GetMapping(value={"/devices"})
    public Collection<TDevice> getDevicesByProjectId(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.L.m_nsa();
        }
        return this.L.m_dma(a);
    }

    @PutMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConnection(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TConnection a) {
        this.L.m_xma(connectionId, a);
    }

    @PostMapping(value={"/{connectionId}/devices"})
    public ResponseEntity<TDevice> createDevice(@PathVariable(value="connectionId") Integer connectionId, @Valid @RequestBody TDevice device, UriComponentsBuilder a) {
        device = this.L.m_xoa(connectionId, device, Boolean.valueOf(true));
        Object[] objectArray = new Object[2];
        objectArray[0] = connectionId;
        objectArray[1] = device.getId();
        return ResponseEntity.created((URI)a.path(FiredAlarmList.m_le((Object)"WK\u001b_\u0016^\u001dS\fY\u0017^1T\u0005\u001f\u001cU\u000eY\u001bU\u000b\u001f\u0003T\u001dF\u0011S\u001dy\u001cM")).buildAndExpand(objectArray).toUri()).body(device);
    }

    @GetMapping(value={"/{connectionId}/devices"})
    public Collection<TDevice> getDevices(@PathVariable(value="connectionId") Integer a) {
        return this.L.m_rna(a);
    }

    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public Collection<TFrame> getFrames(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer a) {
        return this.L.m_ora(connectionId, a);
    }

    @GetMapping(value={"/device/{deviceId}"})
    public TDevice getDeviceById(@PathVariable(value="deviceId") Integer a) {
        return (TDevice)this.L.m_eoa(a);
    }

    @PostMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public ResponseEntity<TFrame> createFrame(@PathVariable(value="connectionId") Integer connectionId, @PathVariable(value="deviceId") Integer deviceId, @Valid @RequestBody TFrame frame, UriComponentsBuilder a) {
        frame = this.L.m_qna(connectionId, deviceId, frame, Boolean.valueOf(true));
        Object[] objectArray = new Object[3];
        objectArray[0] = connectionId;
        objectArray[1] = deviceId;
        objectArray[2] = frame.getId();
        return ResponseEntity.created((URI)a.path(AuditConfig.m_le((Object)"\u0000\u0006L\u0012A\u0013J\u001e[\u0014@\u0013f\u0019RRK\u0018Y\u0014L\u0018\\RT\u0019J\u000bF\u001eJ4K\u0000\u0000\u001b]\u001cB\u0018\\RT\u001b]\u001cB\u0018f\u0019R")).buildAndExpand(objectArray).toUri()).body(frame);
    }
}

