/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.repositories;

import com.inscada.mono.communication.base.enums.c_via;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.repositories.LoggedVariableValueRepository;
import com.inscada.mono.config.InfluxDBProperties;
import com.inscada.mono.datasource.sql.model.metadata.FunctionMetadata;
import com.inscada.mono.job.restcontrollers.JobController;
import com.inscada.mono.shared.aspects.SetNodeId;
import com.inscada.mono.shared.aspects.SetSpaceId;
import com.inscada.mono.shared.repositories.BaseInfluxRepository;
import com.inscada.mono.space.c_ic;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BoundParameterQuery;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.impl.InfluxDBResultMapper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class LoggedVariableValueRepository
extends BaseInfluxRepository {
    private final InfluxDBResultMapper loggedVariableValueStatsMapper;
    private final LoggedVariableValueMapper loggedVariableValueMapper;

    public void save(@SetSpaceId @SetNodeId LoggedVariableValue a4) {
        Point.Builder builder = Point.measurement((String)this.getMeasurementName()).time(a4.getTime().toEpochMilli(), TimeUnit.MILLISECONDS).tag(FunctionMetadata.m_le((Object)"-x'r\u001c~'"), a4.getNodeId()).tag("space_id", a4.getSpaceId()).tag(JobController.m_le((Object)"\u001c\b\u000e\u001b\n"), a4.getSpace()).tag(FunctionMetadata.m_le((Object)"g1x)r c\u001c~'"), a4.getProjectId()).tag(JobController.m_le((Object)"\u001f\n\u0000\u0012\n\u001b\u001b"), a4.getProject()).tag(FunctionMetadata.m_le((Object)"5v1~\"u/r\u001c~'"), a4.getVariableId()).tag(JobController.m_le((Object)"\u0016\u000e\u0015\n"), a4.getName()).addField(FunctionMetadata.m_le((Object)"5v/b&"), (Number)a4.getValue());
        if (a4.getTextValue() != null) {
            builder.addField(JobController.m_le((Object)"\f\n\u0000\u001b'\u0019\u0019\u0003\r\n"), a4.getTextValue());
        }
        if (a4.getFlags() != null && !a4.getFlags().isEmpty()) {
            a4.getFlags().forEach((a2, a3) -> builder.addField(a2 + "_flag", a3.booleanValue()));
        }
        if (a4.getExtras() != null && !a4.getExtras().isEmpty()) {
            builder.fields(a4.getExtras().entrySet().stream().collect(Collectors.toMap(a -> (String)a.getKey() + "_extra", a -> a.getValue())));
        }
        this.influxDB.write(this.getDBName(), this.getRPName(), builder.build());
    }

    public Collection<LoggedVariableValueStats> getLoggedDailyVariableValueStats(Integer[] a, Date a2, Date a3, c_via ... a4) {
        LoggedVariableValueRepository a5;
        Calendar calendar;
        if (a == null || ((Integer[])a).length == 0) {
            return Collections.emptyList();
        }
        Calendar calendar2 = calendar = Calendar.getInstance(TimeZone.getTimeZone(FunctionMetadata.m_le((Object)"\u0016C\u0000")));
        Calendar calendar3 = calendar;
        calendar3.setTime(a2);
        int n = calendar2.get(11);
        int n2 = calendar3.get(12);
        int n3 = calendar2.get(13);
        a4 = a5.createSelectStatsQueryString((c_via[])a4);
        Object[] objectArray = new Object[2];
        objectArray[0] = a5.getRPName();
        objectArray[1] = a5.getMeasurementName();
        ((StringBuilder)a4).append(String.format(JobController.m_le((Object)"\t\n\u0000\u0015O]\u001cVJ\u000bO"), objectArray));
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)"`+r1rcd3v r\u001c~'7~7gd3v r\nsc"));
        ((StringBuilder)a4).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u001b\u0011\u0002\u001dOFRXK\u000b\u001b\u0019\u001d\f+\u0019\u001b\u001dO\u0019\u0001\u001cO\f\u0006\u0015\nXSXK\u001d\u0001\u001c+\u0019\u001b\u001dO"));
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)"\"y'75v1~\"u/r\u001c~'7~ic")).append(a5.getVariableIdsParam((Integer[])a)).append(JobController.m_le((Object)"O"));
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = n;
        objectArray2[1] = n2;
        objectArray2[2] = n3;
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)"p1x6gcu:75v1~\"u/r\u001c~';c5-v.ra;c")).append(String.format(JobController.m_le((Object)"\f\u0006\u0015\nP^\u001cCXJ\u001c\u0007]\u000b\u0015J\u001c\u001cQO"), objectArray2));
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)",e'r17!ncc*z&7'r0tc"));
        a = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)a4).toString()).forDatabase(a5.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), JobController.m_le((Object)"<\b\u000e\u001b\nX\u001c\u0010\u0000\r\u0003\u001cO\u001a\nX\u001f\n\n\u000b\n\u0016\u001b")).getId().toString());
        a.bind(FunctionMetadata.m_le((Object)"0c\"e7S\"c&"), (Object)a2.toInstant());
        a.bind(JobController.m_le((Object)"\n\u0016\u000b<\u000e\f\n"), (Object)a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a5;
        return loggedVariableValueRepository.loggedVariableValueStatsMapper.toPOJO(loggedVariableValueRepository.influxDB.query((Query)a.create()), LoggedVariableValueStats.class);
    }

    private /* synthetic */ String getVariableIdsParam(Integer[] a) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FunctionMetadata.m_le((Object)"lIk"));
        int n2 = a.length;
        int n3 = n = 0;
        while (n3 < n2) {
            Integer n4 = a[n];
            stringBuilder.append(n4.toString()).append(JobController.m_le((Object)"\u0013"));
            n3 = ++n;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        if (stringBuilder2.charAt(stringBuilder2.length() - 1) == '|') {
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.deleteCharAt(stringBuilder3.length() - 1);
        }
        StringBuilder stringBuilder4 = stringBuilder;
        stringBuilder4.append(FunctionMetadata.m_le((Object)"j3l"));
        return stringBuilder4.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ StringBuilder createSelectStatsQueryString(c_via ... a2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (a2 == null || a2.length == 0) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(JobController.m_le((Object)"\u000b\n\u0014\n\u001b\u001bX\u0002\u0011\u0001P\u0019\u0019\u0003\r\nQO\u0019\u001cX\u0002\u0011\u0001'\u0019\u0019\u0003\r\nTO\u0015\u000e\u0000G\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u0015\u000e\u00000\u000e\u000e\u0014\u001a\u001dCX\u001c\r\u0002P\u0019\u0019\u0003\r\nQO\u0019\u001cX\u001c\r\u0002'\u0019\u0019\u0003\r\nTO\u001b\u0000\r\u0001\fG\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u001b\u0000\r\u0001\f0\u000e\u000e\u0014\u001a\u001dCX\t\u0011\u001d\u000b\u001bP\u0019\u0019\u0003\r\nQO\u0019\u001cX\t\u0011\u001d\u000b\u001b'\u0019\u0019\u0003\r\nTO\u0014\u000e\u000b\u001bP\u0019\u0019\u0003\r\nQO\u0019\u001cX\u0003\u0019\u001c\f0\u000e\u000e\u0014\u001a\u001dCX\u0002\u001d\u000e\u0016G\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u0019\u0019\u001f0\u000e\u000e\u0014\u001a\u001dCX\u0002\u0019\u0017P\u0019\u0019\u0003\r\nQB\u0015\u0006\u0016G\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u0015\u000e\u00000\u001c\u0006\u001e\t'\u0019\u0019\u0003\r\nTO\u0014\u000e\u000b\u001bP\u0019\u0019\u0003\r\nQB\u001e\u0006\n\u001c\fG\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u0014\u000e\u000b\u001b'\t\u0011\u001d\u000b\u001b'\u000b\u0011\t\u001e0\u000e\u000e\u0014\u001a\u001dCX\u001f\u001d\u001d\u001b\n\u0016\u001b\u0011\u0003\u001dG\u000e\u000e\u0014\u001a\u001dCXZHFX\u000e\u000bO\u0015\u0006\u001c\u000b\u0014\n'\u0019\u0019\u0003\r\nTO\u0015\n\u001c\u0006\u0019\u0001P\u0019\u0019\u0003\r\nQO\u0019\u001cX\u0002\u001d\u000b\u0011\u000e\u00160\u000e\u000e\u0014\u001a\u001dO"));
            return stringBuilder2;
        }
        stringBuilder.append(FunctionMetadata.m_le((Object)"0r/r cc"));
        int n2 = a2.length;
        int n3 = n = 0;
        while (n3 < n2) {
            c_via c_via2 = a2[n];
            switch (1.$SwitchMap$com$inscada$mono$communication$base$enums$VariableStatCalculationType[c_via2.ordinal()]) {
                case 1: {
                    stringBuilder.append(JobController.m_le((Object)"\u0002\u0011\u0001P\u0019\u0019\u0003\r\nQO\u0019\u001cX\u0002\u0011\u0001'\u0019\u0019\u0003\r\nTO"));
                    break;
                }
                case 2: {
                    stringBuilder.append(FunctionMetadata.m_le((Object)".v;?5v/b&>cv07.v;H5v/b&;c"));
                    break;
                }
                case 3: {
                    stringBuilder.append(JobController.m_le((Object)"\u0015\n\u0019\u0001P\u0019\u0019\u0003\r\nQO\u0019\u001cX\u000e\u000e\b'\u0019\u0019\u0003\r\nTO"));
                    break;
                }
                case 4: {
                    stringBuilder.append(FunctionMetadata.m_le((Object)"0b.?5v/b&>cv070b.H5v/b&;c"));
                    break;
                }
                case 5: {
                    stringBuilder.append(JobController.m_le((Object)"\f\u0017\u001a\u0016\u001bP\u0019\u0019\u0003\r\nQO\u0019\u001cX\f\u0017\u001a\u0016\u001b'\u0019\u0019\u0003\r\nTO"));
                    break;
                }
                case 6: {
                    stringBuilder.append(FunctionMetadata.m_le((Object)"%~1d7?5v/b&>cv07%~1d7H5v/b&;c"));
                    break;
                }
                case 7: {
                    stringBuilder.append(JobController.m_le((Object)"\u0003\u0019\u001c\fG\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u0014\u000e\u000b\u001b'\u0019\u0019\u0003\r\nTO"));
                    break;
                }
                case 8: {
                    stringBuilder.append(FunctionMetadata.m_le((Object)".v;?5v/b&>nz*yka\"{6rj7\"dcz\"o\u001cs*q%H5v/b&;c"));
                    break;
                }
                case 9: {
                    stringBuilder.append(JobController.m_le((Object)"\u0003\u0019\u001c\fG\u000e\u000e\u0014\u001a\u001dFU\t\u0011\u001d\u000b\u001bP\u0019\u0019\u0003\r\nQO\u0019\u001cX\u0003\u0019\u001c\f0\u001e\u0006\n\u001c\f0\u001c\u0006\u001e\t'\u0019\u0019\u0003\r\nTO"));
                    break;
                }
                case 10: {
                    stringBuilder.append(FunctionMetadata.m_le((Object)"3r1t&y7~/rka\"{6ro7v'j7\"dcz*s'{&H5v/b&;c"));
                    break;
                }
                case 11: {
                    stringBuilder.append(JobController.m_le((Object)"\u0002\u001d\u000b\u0011\u000e\u0016G\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u0015\n\u001c\u0006\u0019\u0001'\u0019\u0019\u0003\r\nTO"));
                    break;
                }
            }
            n3 = ++n;
        }
        int a2 = stringBuilder.lastIndexOf(FunctionMetadata.m_le((Object)"o"));
        if (a2 != -1) {
            stringBuilder.deleteCharAt(a2);
        }
        return stringBuilder;
    }

    public Collection<LoggedVariableValueStats> getLoggedVariableValueStatsByInterval(Integer[] a, Date a2, Date a3, Integer a4, c_via ... a5) {
        LoggedVariableValueRepository a6;
        Calendar calendar;
        if (a == null || ((Integer[])a).length == 0) {
            return Collections.emptyList();
        }
        Calendar calendar2 = calendar = Calendar.getInstance(TimeZone.getTimeZone(JobController.m_le((Object)":,,")));
        Calendar calendar3 = calendar;
        calendar3.setTime(a2);
        int n = calendar2.get(11);
        int n2 = calendar3.get(12);
        int n3 = calendar2.get(13);
        a5 = a6.createSelectStatsQueryString((c_via[])a5);
        Object[] objectArray = new Object[2];
        objectArray[0] = a6.getRPName();
        objectArray[1] = a6.getMeasurementName();
        ((StringBuilder)a5).append(String.format(FunctionMetadata.m_le((Object)"%e,zc209fdc"), objectArray));
        ((StringBuilder)a5).append(JobController.m_le((Object)"\u000f\u0007\u001d\u001d\u001dO\u000b\u001f\u0019\f\u001d0\u0011\u000bXRXK\u000b\u001f\u0019\f\u001d&\u001cO"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"\"y'77~.rc)~7gd7v1c\u0007v7rcv-scc*z&7\u007f7gr-s\u0007v7rc"));
        ((StringBuilder)a5).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bXR\u0006O")).append(a6.getVariableIdsParam((Integer[])a)).append(FunctionMetadata.m_le((Object)"c"));
        Object[] objectArray2 = new Object[4];
        objectArray2[0] = a4;
        objectArray2[1] = n;
        objectArray2[2] = n2;
        objectArray2[3] = n3;
        ((StringBuilder)a5).append(JobController.m_le((Object)"\u001f\u001d\u0017\u001a\bO\u001a\u0016X\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bTOZ\u0001\u0019\u0002\u001dMTO")).append(String.format(FunctionMetadata.m_le((Object)"c*z&?fs.do7fs+2'zfs0>c"), objectArray2));
        ((StringBuilder)a5).append(JobController.m_le((Object)"\u0000\n\u000b\u001d\u001dX\r\u0001O\f\u0006\u0015\nX\u000b\u001d\u001c\u001bO"));
        a = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)a5).toString()).forDatabase(a6.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), FunctionMetadata.m_le((Object)"\u0010g\"t&70\u007f,b/scu&73e&d&y7")).getId().toString());
        a.bind(JobController.m_le((Object)"\u001c\f\u000e\n\u001b<\u000e\f\n"), (Object)a2.toInstant());
        a.bind(FunctionMetadata.m_le((Object)"&y'S\"c&"), (Object)a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a6;
        return loggedVariableValueRepository.loggedVariableValueStatsMapper.toPOJO(loggedVariableValueRepository.influxDB.query((Query)a.create()), LoggedVariableValueStats.class);
    }

    public LoggedVariableValueRepository(@Qualifier(value="influxDB") InfluxDB influxDB, InfluxDBProperties a) {
        super(influxDB, a);
        LoggedVariableValueRepository loggedVariableValueRepository = this;
        this.loggedVariableValueMapper = new LoggedVariableValueMapper(this);
        loggedVariableValueRepository.loggedVariableValueStatsMapper = new InfluxDBResultMapper();
    }

    public String getMeasurementName() {
        return JobController.m_le((Object)"\u000e\u000e\n\u0006\u0019\r\u0014\n'\u0019\u0019\u0003\r\n");
    }

    public Collection<LoggedVariableValue> getLoggedVariableValues(Integer[] a, Date a2, Date a3) {
        LoggedVariableValueRepository a4;
        if (a == null || ((Integer[])a).length == 0) {
            return Collections.emptyList();
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = a4.getRPName();
        objectArray[1] = a4.getMeasurementName();
        a = BoundParameterQuery.QueryBuilder.newQuery((String)(String.format(FunctionMetadata.m_le((Object)"0r/r cc=cq1x.7fdm20"), objectArray) + " where space_id = $spaceId and time >= $startDate and time < $endDate and variable_id =~ " + a4.getVariableIdsParam((Integer[])a) + " order by time desc")).forDatabase(a4.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), JobController.m_le((Object)"<\b\u000e\u001b\nX\u001c\u0010\u0000\r\u0003\u001cO\u001a\nX\u001f\n\n\u000b\n\u0016\u001b")).getId().toString());
        a.bind(FunctionMetadata.m_le((Object)"0c\"e7S\"c&"), (Object)a2.toInstant());
        a.bind(JobController.m_le((Object)"\n\u0016\u000b<\u000e\f\n"), (Object)a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a4;
        return loggedVariableValueRepository.loggedVariableValueMapper.to(loggedVariableValueRepository.influxDB.query((Query)a.create()));
    }

    public Page<LoggedVariableValue> getLoggedVariableValues(Integer[] a, Date a2, Date a3, Pageable a4) {
        LoggedVariableValueRepository a5;
        if (a == null || ((Integer[])a).length == 0) {
            return new PageImpl(Collections.emptyList());
        }
        Object object = a4.getSort().getOrderFor(FunctionMetadata.m_le((Object)"s7c.")) != null && a4.getSort().getOrderFor(JobController.m_le((Object)"\u001c\u001b\f\u0002")).isAscending() ? FunctionMetadata.m_le((Object)"\"d ") : JobController.m_le((Object)"\u001c\n\u000b\f");
        Object[] objectArray = new Object[2];
        objectArray[0] = a5.getRPName();
        objectArray[1] = a5.getMeasurementName();
        object = String.format(FunctionMetadata.m_le((Object)"d&{&t77i7%e,zc209fdc"), objectArray) + " where space_id = $spaceId and time >= $startDate and time < $endDate and variable_id =~ " + a5.getVariableIdsParam((Integer[])a) + " order by time " + (String)object + " limit " + a4.getPageSize() + " offset " + a4.getOffset();
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = a5.getRPName();
        objectArray2[1] = a5.getMeasurementName();
        a = String.format(JobController.m_le((Object)"\u001c\u001d\u0003\u001d\f\fO\u001b\u0000\r\u0001\fG\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u001b\u0000\r\u0001\f0\u000e\u000e\u0014\u001a\u001dCX\f\u0017\u001a\u0016\u001bP\u001b\u001d\u0017\f0\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u001b\u0000\r\u0001\f0\f\n\u0000\u001b'\u0019\u0019\u0003\r\nX\t\n\u0000\u0015O]\u001cVJ\u000bO"), objectArray2) + " where space_id = $spaceId and time >= $startDate and time < $endDate and variable_id =~ " + a5.getVariableIdsParam((Integer[])a);
        object = BoundParameterQuery.QueryBuilder.newQuery((String)object).forDatabase(a5.getDBName());
        object.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), FunctionMetadata.m_le((Object)"\u0010g\"t&70\u007f,b/scu&73e&d&y7")).getId().toString());
        object.bind(JobController.m_le((Object)"\u001c\f\u000e\n\u001b<\u000e\f\n"), (Object)((Date)a2).toInstant());
        object.bind(FunctionMetadata.m_le((Object)"&y'S\"c&"), (Object)a3.toInstant());
        a = BoundParameterQuery.QueryBuilder.newQuery((String)a).forDatabase(a5.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), JobController.m_le((Object)"<\b\u000e\u001b\nX\u001c\u0010\u0000\r\u0003\u001cO\u001a\nX\u001f\n\n\u000b\n\u0016\u001b")).getId().toString());
        a.bind(FunctionMetadata.m_le((Object)"0c\"e7S\"c&"), (Object)((Date)a2).toInstant());
        a.bind(JobController.m_le((Object)"\n\u0016\u000b<\u000e\f\n"), (Object)a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a5;
        a = loggedVariableValueRepository.runCountQuery((BoundParameterQuery.QueryBuilder)a);
        a2 = loggedVariableValueRepository.loggedVariableValueMapper.to(a5.influxDB.query((Query)object.create()));
        return new PageImpl((List)a2, a4, ((Double)a).longValue());
    }

    public Page<LoggedVariableValueStats> getLoggedHourlyVariableValueStats(Integer[] a, Date a2, Date a3, Pageable a4, c_via ... a5) {
        LoggedVariableValueRepository a6;
        Calendar calendar;
        if (a == null || ((Integer[])a).length == 0) {
            return new PageImpl(Collections.emptyList());
        }
        Calendar calendar2 = calendar = Calendar.getInstance(TimeZone.getTimeZone(FunctionMetadata.m_le((Object)"\u0016C\u0000")));
        Calendar calendar3 = calendar;
        calendar3.setTime((Date)a2);
        int n = calendar2.get(11);
        int n2 = calendar3.get(12);
        int n3 = calendar2.get(13);
        CharSequence charSequence = a4.getSort().getOrderFor(JobController.m_le((Object)"\u001c\u001b\f\u0002")) != null && a4.getSort().getOrderFor(FunctionMetadata.m_le((Object)"s7c.")).isAscending() ? JobController.m_le((Object)"\u000e\u000b\f") : FunctionMetadata.m_le((Object)"s&d ");
        a5 = a6.createSelectStatsQueryString((c_via[])a5);
        Object[] objectArray = new Object[2];
        objectArray[0] = a6.getRPName();
        objectArray[1] = a6.getMeasurementName();
        ((StringBuilder)a5).append(String.format(JobController.m_le((Object)"\t\n\u0000\u0015O]\u001cVJ\u000bO"), objectArray));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"`+r1rcd3v r\u001c~'7~7gd3v r\nsc"));
        ((StringBuilder)a5).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u001b\u0011\u0002\u001dOFRXK\u000b\u001b\u0019\u001d\f+\u0019\u001b\u001dO\u0019\u0001\u001cO\f\u0006\u0015\nXSXK\u001d\u0001\u001c+\u0019\u001b\u001dO"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"\"y'75v1~\"u/r\u001c~'7~ic")).append(a6.getVariableIdsParam((Integer[])a)).append(JobController.m_le((Object)"O"));
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = n;
        objectArray2[1] = n2;
        objectArray2[2] = n3;
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"p1x6gcu:75v1~\"u/r\u001c~';c5-v.ra;c")).append(String.format(JobController.m_le((Object)"\f\u0006\u0015\nP^\u0010CXJ\u001c\u0007]\u000b\u0015J\u001c\u001cQO"), objectArray2));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"x1s&ecu:77~.rc")).append((String)charSequence).append(JobController.m_le((Object)"O"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"{*z*cc")).append(a4.getPageSize()).append(JobController.m_le((Object)"O"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)",q%d&cc")).append(a4.getOffset()).append(JobController.m_le((Object)"O"));
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(FunctionMetadata.m_le((Object)"0r/r cct,b-ckq*e0c\u001ca\"{6rj7%e,zc?c"));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u001c\u001d\u0003\u001d\f\fO\u001e\u0006\n\u001c\fG\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u001e\u0006\n\u001c\f0\u000e\u000e\u0014\u001a\u001dO"));
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = a6.getRPName();
        objectArray3[1] = a6.getMeasurementName();
        ((StringBuilder)charSequence).append(String.format(FunctionMetadata.m_le((Object)"%e,zc209fdc"), objectArray3));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u000f\u0007\u001d\u001d\u001dO\u000b\u001f\u0019\f\u001d0\u0011\u000bXRXK\u000b\u001f\u0019\f\u001d&\u001cO"));
        ((StringBuilder)charSequence).append(FunctionMetadata.m_le((Object)"\"y'77~.rc)~7gd7v1c\u0007v7rcv-scc*z&7\u007f7gr-s\u0007v7rc"));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bXR\u0006O")).append(a6.getVariableIdsParam((Integer[])a)).append(FunctionMetadata.m_le((Object)"c"));
        Object[] objectArray4 = new Object[3];
        objectArray4[0] = n;
        objectArray4[1] = n2;
        objectArray4[2] = n3;
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u001f\u001d\u0017\u001a\bO\u001a\u0016X\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bTOZ\u0001\u0019\u0002\u001dMTO")).append(String.format(FunctionMetadata.m_le((Object)"c*z&?r\u007fo7fs+2'zfs0>c"), objectArray4));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"F"));
        a = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)a5).toString()).forDatabase(a6.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), FunctionMetadata.m_le((Object)"\u0010g\"t&70\u007f,b/scu&73e&d&y7")).getId().toString());
        a.bind(JobController.m_le((Object)"\u001c\f\u000e\n\u001b<\u000e\f\n"), (Object)((Date)a2).toInstant());
        a.bind(FunctionMetadata.m_le((Object)"&y'S\"c&"), (Object)a3.toInstant());
        a5 = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)charSequence).toString()).forDatabase(a6.getDBName());
        a5.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), JobController.m_le((Object)"<\b\u000e\u001b\nX\u001c\u0010\u0000\r\u0003\u001cO\u001a\nX\u001f\n\n\u000b\n\u0016\u001b")).getId().toString());
        a5.bind(FunctionMetadata.m_le((Object)"0c\"e7S\"c&"), (Object)((Date)a2).toInstant());
        a5.bind(JobController.m_le((Object)"\n\u0016\u000b<\u000e\f\n"), (Object)a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a6;
        a2 = loggedVariableValueRepository.runCountQuery((BoundParameterQuery.QueryBuilder)a5);
        a = loggedVariableValueRepository.loggedVariableValueStatsMapper.toPOJO(a6.influxDB.query((Query)a.create()), LoggedVariableValueStats.class);
        return new PageImpl((List)a, a4, ((Double)a2).longValue());
    }

    public Page<LoggedVariableValueStats> getLoggedDailyVariableValueStats(Integer[] a, Date a2, Date a3, Pageable a4, c_via ... a5) {
        LoggedVariableValueRepository a6;
        Calendar calendar;
        if (a == null || ((Integer[])a).length == 0) {
            return new PageImpl(Collections.emptyList());
        }
        Calendar calendar2 = calendar = Calendar.getInstance(TimeZone.getTimeZone(FunctionMetadata.m_le((Object)"\u0016C\u0000")));
        Calendar calendar3 = calendar;
        calendar3.setTime((Date)a2);
        int n = calendar2.get(11);
        int n2 = calendar3.get(12);
        int n3 = calendar2.get(13);
        CharSequence charSequence = a4.getSort().getOrderFor(JobController.m_le((Object)"\u001c\u001b\f\u0002")) != null && a4.getSort().getOrderFor(FunctionMetadata.m_le((Object)"s7c.")).isAscending() ? JobController.m_le((Object)"\u000e\u000b\f") : FunctionMetadata.m_le((Object)"s&d ");
        a5 = a6.createSelectStatsQueryString((c_via[])a5);
        Object[] objectArray = new Object[2];
        objectArray[0] = a6.getRPName();
        objectArray[1] = a6.getMeasurementName();
        ((StringBuilder)a5).append(String.format(JobController.m_le((Object)"\t\n\u0000\u0015O]\u001cVJ\u000bO"), objectArray));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"`+r1rcd3v r\u001c~'7~7gd3v r\nsc"));
        ((StringBuilder)a5).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u001b\u0011\u0002\u001dOFRXK\u000b\u001b\u0019\u001d\f+\u0019\u001b\u001dO\u0019\u0001\u001cO\f\u0006\u0015\nXSXK\u001d\u0001\u001c+\u0019\u001b\u001dO"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"\"y'75v1~\"u/r\u001c~'7~ic")).append(a6.getVariableIdsParam((Integer[])a)).append(JobController.m_le((Object)"O"));
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = n;
        objectArray2[1] = n2;
        objectArray2[2] = n3;
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"p1x6gcu:75v1~\"u/r\u001c~';c5-v.ra;c")).append(String.format(JobController.m_le((Object)"\f\u0006\u0015\nP^\u001cCXJ\u001c\u0007]\u000b\u0015J\u001c\u001cQO"), objectArray2));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"x1s&ecu:77~.rc")).append((String)charSequence).append(JobController.m_le((Object)"O"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"{*z*cc")).append(a4.getPageSize()).append(JobController.m_le((Object)"O"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)",q%d&cc")).append(a4.getOffset()).append(JobController.m_le((Object)"O"));
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(FunctionMetadata.m_le((Object)"0r/r cct,b-ckq*e0c\u001ca\"{6rj7%e,zc?c"));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u001c\u001d\u0003\u001d\f\fO\u001e\u0006\n\u001c\fG\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u001e\u0006\n\u001c\f0\u000e\u000e\u0014\u001a\u001dO"));
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = a6.getRPName();
        objectArray3[1] = a6.getMeasurementName();
        ((StringBuilder)charSequence).append(String.format(FunctionMetadata.m_le((Object)"%e,zc209fdc"), objectArray3));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u000f\u0007\u001d\u001d\u001dO\u000b\u001f\u0019\f\u001d0\u0011\u000bXRXK\u000b\u001f\u0019\f\u001d&\u001cO"));
        ((StringBuilder)charSequence).append(FunctionMetadata.m_le((Object)"\"y'77~.rc)~7gd7v1c\u0007v7rcv-scc*z&7\u007f7gr-s\u0007v7rc"));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bXR\u0006O")).append(a6.getVariableIdsParam((Integer[])a)).append(FunctionMetadata.m_le((Object)"c"));
        Object[] objectArray4 = new Object[3];
        objectArray4[0] = n;
        objectArray4[1] = n2;
        objectArray4[2] = n3;
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u001f\u001d\u0017\u001a\bO\u001a\u0016X\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bTOZ\u0001\u0019\u0002\u001dMTO")).append(String.format(FunctionMetadata.m_le((Object)"c*z&?rso7fs+2'zfs0>c"), objectArray4));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"F"));
        a = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)a5).toString()).forDatabase(a6.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), FunctionMetadata.m_le((Object)"\u0010g\"t&70\u007f,b/scu&73e&d&y7")).getId().toString());
        a.bind(JobController.m_le((Object)"\u001c\f\u000e\n\u001b<\u000e\f\n"), (Object)((Date)a2).toInstant());
        a.bind(FunctionMetadata.m_le((Object)"&y'S\"c&"), (Object)a3.toInstant());
        a5 = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)charSequence).toString()).forDatabase(a6.getDBName());
        a5.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), JobController.m_le((Object)"<\b\u000e\u001b\nX\u001c\u0010\u0000\r\u0003\u001cO\u001a\nX\u001f\n\n\u000b\n\u0016\u001b")).getId().toString());
        a5.bind(FunctionMetadata.m_le((Object)"0c\"e7S\"c&"), (Object)((Date)a2).toInstant());
        a5.bind(JobController.m_le((Object)"\n\u0016\u000b<\u000e\f\n"), (Object)a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a6;
        a2 = loggedVariableValueRepository.runCountQuery((BoundParameterQuery.QueryBuilder)a5);
        a = loggedVariableValueRepository.loggedVariableValueStatsMapper.toPOJO(a6.influxDB.query((Query)a.create()), LoggedVariableValueStats.class);
        return new PageImpl((List)a, a4, ((Double)a2).longValue());
    }

    public Collection<LoggedVariableValueStats> getLoggedVariableValueStats(Integer[] a, Date a2, Date a3, c_via ... a4) {
        LoggedVariableValueRepository a5;
        if (a == null || ((Integer[])a).length == 0) {
            return Collections.emptyList();
        }
        a4 = a5.createSelectStatsQueryString((c_via[])a4);
        Object[] objectArray = new Object[2];
        objectArray[0] = a5.getRPName();
        objectArray[1] = a5.getMeasurementName();
        ((StringBuilder)a4).append(String.format(FunctionMetadata.m_le((Object)"%e,zc209fdc"), objectArray));
        ((StringBuilder)a4).append(JobController.m_le((Object)"\u000f\u0007\u001d\u001d\u001dO\u000b\u001f\u0019\f\u001d0\u0011\u000bXRXK\u000b\u001f\u0019\f\u001d&\u001cO"));
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)"\"y'77~.rc)~7gd7v1c\u0007v7rcv-scc*z&7\u007f7gr-s\u0007v7rc"));
        ((StringBuilder)a4).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bXR\u0006O")).append(a5.getVariableIdsParam((Integer[])a)).append(FunctionMetadata.m_le((Object)"c"));
        ((StringBuilder)a4).append(JobController.m_le((Object)"\b\n\u0000\r\u001fX\r\u0001O\u000e\u000e\n\u0006\u0019\r\u0014\n'\u0006\u001cCXM\u0016\u000e\u0015\nZO"));
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)",e'r17!ncc*z&7'r0tc"));
        a = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)a4).toString()).forDatabase(a5.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), JobController.m_le((Object)"<\b\u000e\u001b\nX\u001c\u0010\u0000\r\u0003\u001cO\u001a\nX\u001f\n\n\u000b\n\u0016\u001b")).getId().toString());
        a.bind(FunctionMetadata.m_le((Object)"0c\"e7S\"c&"), (Object)a2.toInstant());
        a.bind(JobController.m_le((Object)"\n\u0016\u000b<\u000e\f\n"), (Object)a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a5;
        return loggedVariableValueRepository.loggedVariableValueStatsMapper.toPOJO(loggedVariableValueRepository.influxDB.query((Query)a.create()), LoggedVariableValueStats.class);
    }

    public Page<LoggedVariableValueStats> getLoggedVariableValueStatsByInterval(Integer[] a, Date a2, Date a3, Integer a4, Pageable a5, c_via ... a6) {
        LoggedVariableValueRepository a7;
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance(TimeZone.getTimeZone(FunctionMetadata.m_le((Object)"\u0016C\u0000")));
        Calendar calendar3 = calendar;
        calendar3.setTime((Date)a2);
        int n = calendar2.get(11);
        int n2 = calendar3.get(12);
        int n3 = calendar2.get(13);
        CharSequence charSequence = a5.getSort().getOrderFor(JobController.m_le((Object)"\u001c\u001b\f\u0002")) != null && a5.getSort().getOrderFor(FunctionMetadata.m_le((Object)"s7c.")).isAscending() ? JobController.m_le((Object)"\u000e\u000b\f") : FunctionMetadata.m_le((Object)"s&d ");
        a6 = a7.createSelectStatsQueryString((c_via[])a6);
        Object[] objectArray = new Object[2];
        objectArray[0] = a7.getRPName();
        objectArray[1] = a7.getMeasurementName();
        ((StringBuilder)a6).append(String.format(JobController.m_le((Object)"\t\n\u0000\u0015O]\u001cVJ\u000bO"), objectArray));
        ((StringBuilder)a6).append(FunctionMetadata.m_le((Object)"`+r1rcd3v r\u001c~'7~7gd3v r\nsc"));
        ((StringBuilder)a6).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u001b\u0011\u0002\u001dOFRXK\u000b\u001b\u0019\u001d\f+\u0019\u001b\u001dO\u0019\u0001\u001cO\f\u0006\u0015\nXSXK\u001d\u0001\u001c+\u0019\u001b\u001dO"));
        ((StringBuilder)a6).append(FunctionMetadata.m_le((Object)"\"y'75v1~\"u/r\u001c~'7~ic")).append(a7.getVariableIdsParam((Integer[])a)).append(JobController.m_le((Object)"O"));
        Object[] objectArray2 = new Object[4];
        objectArray2[0] = a4;
        objectArray2[1] = n;
        objectArray2[2] = n2;
        objectArray2[3] = n3;
        ((StringBuilder)a6).append(FunctionMetadata.m_le((Object)"p1x6gcu:75v1~\"u/r\u001c~';c5-v.ra;c")).append(String.format(JobController.m_le((Object)"\f\u0006\u0015\nPJ\u001c\u0002\u000bCXJ\u001c\u0007]\u000b\u0015J\u001c\u001cQO"), objectArray2));
        ((StringBuilder)a6).append(FunctionMetadata.m_le((Object)"x1s&ecu:77~.rc")).append((String)charSequence).append(JobController.m_le((Object)"O"));
        ((StringBuilder)a6).append(FunctionMetadata.m_le((Object)"{*z*cc")).append(a5.getPageSize()).append(JobController.m_le((Object)"O"));
        ((StringBuilder)a6).append(FunctionMetadata.m_le((Object)",q%d&cc")).append(a5.getOffset()).append(JobController.m_le((Object)"O"));
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(FunctionMetadata.m_le((Object)"0r/r cct,b-ckq*e0c\u001ca\"{6rj7%e,zc?c"));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u001c\u001d\u0003\u001d\f\fO\u001e\u0006\n\u001c\fG\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u001e\u0006\n\u001c\f0\u000e\u000e\u0014\u001a\u001dO"));
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = a7.getRPName();
        objectArray3[1] = a7.getMeasurementName();
        ((StringBuilder)charSequence).append(String.format(FunctionMetadata.m_le((Object)"%e,zc209fdc"), objectArray3));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u000f\u0007\u001d\u001d\u001dO\u000b\u001f\u0019\f\u001d0\u0011\u000bXRXK\u000b\u001f\u0019\f\u001d&\u001cO"));
        ((StringBuilder)charSequence).append(FunctionMetadata.m_le((Object)"\"y'77~.rc)~7gd7v1c\u0007v7rcv-scc*z&7\u007f7gr-s\u0007v7rc"));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bXR\u0006O")).append(a7.getVariableIdsParam((Integer[])a)).append(FunctionMetadata.m_le((Object)"c"));
        Object[] objectArray4 = new Object[4];
        objectArray4[0] = a4;
        objectArray4[1] = n;
        objectArray4[2] = n2;
        objectArray4[3] = n3;
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u001f\u001d\u0017\u001a\bO\u001a\u0016X\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bTOZ\u0001\u0019\u0002\u001dMTO")).append(String.format(FunctionMetadata.m_le((Object)"c*z&?fs.do7fs+2'zfs0>c"), objectArray4));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"F"));
        a = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)a6).toString()).forDatabase(a7.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), FunctionMetadata.m_le((Object)"\u0010g\"t&70\u007f,b/scu&73e&d&y7")).getId().toString());
        a.bind(JobController.m_le((Object)"\u001c\f\u000e\n\u001b<\u000e\f\n"), (Object)((Date)a2).toInstant());
        a.bind(FunctionMetadata.m_le((Object)"&y'S\"c&"), (Object)a3.toInstant());
        a4 = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)charSequence).toString()).forDatabase(a7.getDBName());
        a4.bind("spaceId", Objects.requireNonNull(c_ic.m_ck(), JobController.m_le((Object)"<\b\u000e\u001b\nX\u001c\u0010\u0000\r\u0003\u001cO\u001a\nX\u001f\n\n\u000b\n\u0016\u001b")).getId().toString());
        a4.bind(FunctionMetadata.m_le((Object)"0c\"e7S\"c&"), ((Date)a2).toInstant());
        a4.bind(JobController.m_le((Object)"\n\u0016\u000b<\u000e\f\n"), a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a7;
        a2 = loggedVariableValueRepository.runCountQuery((BoundParameterQuery.QueryBuilder)a4);
        a = loggedVariableValueRepository.loggedVariableValueStatsMapper.toPOJO(a7.influxDB.query((Query)a.create()), LoggedVariableValueStats.class);
        return new PageImpl((List)a, a5, ((Double)a2).longValue());
    }

    public Collection<LoggedVariableValueStats> getLoggedHourlyVariableValueStats(Integer[] a, Date a2, Date a3, c_via ... a4) {
        LoggedVariableValueRepository a5;
        Calendar calendar;
        if (a == null || ((Integer[])a).length == 0) {
            return Collections.emptyList();
        }
        Calendar calendar2 = calendar = Calendar.getInstance(TimeZone.getTimeZone(FunctionMetadata.m_le((Object)"\u0016C\u0000")));
        Calendar calendar3 = calendar;
        calendar3.setTime(a2);
        int n = calendar2.get(11);
        int n2 = calendar3.get(12);
        int n3 = calendar2.get(13);
        a4 = a5.createSelectStatsQueryString((c_via[])a4);
        Object[] objectArray = new Object[2];
        objectArray[0] = a5.getRPName();
        objectArray[1] = a5.getMeasurementName();
        ((StringBuilder)a4).append(String.format(JobController.m_le((Object)"\t\n\u0000\u0015O]\u001cVJ\u000bO"), objectArray));
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)"`+r1rcd3v r\u001c~'7~7gd3v r\nsc"));
        ((StringBuilder)a4).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u001b\u0011\u0002\u001dOFRXK\u000b\u001b\u0019\u001d\f+\u0019\u001b\u001dO\u0019\u0001\u001cO\f\u0006\u0015\nXSXK\u001d\u0001\u001c+\u0019\u001b\u001dO"));
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)"\"y'75v1~\"u/r\u001c~'7~ic")).append(a5.getVariableIdsParam((Integer[])a)).append(JobController.m_le((Object)"O"));
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = n;
        objectArray2[1] = n2;
        objectArray2[2] = n3;
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)"p1x6gcu:75v1~\"u/r\u001c~';c5-v.ra;c")).append(String.format(JobController.m_le((Object)"\f\u0006\u0015\nP^\u0010CXJ\u001c\u0007]\u000b\u0015J\u001c\u001cQO"), objectArray2));
        ((StringBuilder)a4).append(FunctionMetadata.m_le((Object)",e'r17!ncc*z&7'r0tc"));
        a = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)a4).toString()).forDatabase(a5.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), JobController.m_le((Object)"<\b\u000e\u001b\nX\u001c\u0010\u0000\r\u0003\u001cO\u001a\nX\u001f\n\n\u000b\n\u0016\u001b")).getId().toString());
        a.bind(FunctionMetadata.m_le((Object)"0c\"e7S\"c&"), (Object)a2.toInstant());
        a.bind(JobController.m_le((Object)"\n\u0016\u000b<\u000e\f\n"), (Object)a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a5;
        return loggedVariableValueRepository.loggedVariableValueStatsMapper.toPOJO(loggedVariableValueRepository.influxDB.query((Query)a.create()), LoggedVariableValueStats.class);
    }

    private /* synthetic */ Double runCountQuery(BoundParameterQuery.QueryBuilder a) {
        LoggedVariableValueRepository a2;
        if ((a = ((QueryResult.Result)a2.influxDB.query((Query)a.create()).getResults().get(0)).getSeries()) == null) {
            return 0.0;
        }
        double d = ((List)((QueryResult.Series)a.get(0)).getValues().get(0)).get(1) != null ? (Double)((List)((QueryResult.Series)a.get(0)).getValues().get(0)).get(1) : 0.0;
        double d2 = ((List)((QueryResult.Series)a.get(0)).getValues().get(0)).size() > 2 && ((List)((QueryResult.Series)a.get(0)).getValues().get(0)).get(2) != null ? (Double)((List)((QueryResult.Series)a.get(0)).getValues().get(0)).get(2) : 0.0;
        return d + d2;
    }

    public Page<LoggedVariableValueStats> getLoggedVariableValueStats(Integer[] a, Date a2, Date a3, Pageable a4, c_via ... a5) {
        LoggedVariableValueRepository a6;
        CharSequence charSequence = a4.getSort().getOrderFor(FunctionMetadata.m_le((Object)"s7c.")) != null && a4.getSort().getOrderFor(JobController.m_le((Object)"\u001c\u001b\f\u0002")).isAscending() ? FunctionMetadata.m_le((Object)"\"d ") : JobController.m_le((Object)"\u001c\n\u000b\f");
        a5 = a6.createSelectStatsQueryString((c_via[])a5);
        Object[] objectArray = new Object[2];
        objectArray[0] = a6.getRPName();
        objectArray[1] = a6.getMeasurementName();
        ((StringBuilder)a5).append(String.format(FunctionMetadata.m_le((Object)"%e,zc209fdc"), objectArray));
        ((StringBuilder)a5).append(JobController.m_le((Object)"\u000f\u0007\u001d\u001d\u001dO\u000b\u001f\u0019\f\u001d0\u0011\u000bXRXK\u000b\u001f\u0019\f\u001d&\u001cO"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"\"y'77~.rc)~7gd7v1c\u0007v7rcv-scc*z&7\u007f7gr-s\u0007v7rc"));
        ((StringBuilder)a5).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bXR\u0006O")).append(a6.getVariableIdsParam((Integer[])a)).append(FunctionMetadata.m_le((Object)"c"));
        ((StringBuilder)a5).append(JobController.m_le((Object)"\b\n\u0000\r\u001fX\r\u0001O\u000e\u000e\n\u0006\u0019\r\u0014\n'\u0006\u001cCXM\u0016\u000e\u0015\nZO"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"x1s&ecu:77~.rc")).append((String)charSequence).append(JobController.m_le((Object)"O"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)"{*z*cc")).append(a4.getPageSize()).append(JobController.m_le((Object)"O"));
        ((StringBuilder)a5).append(FunctionMetadata.m_le((Object)",q%d&cc")).append(a4.getOffset()).append(JobController.m_le((Object)"O"));
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(FunctionMetadata.m_le((Object)"0r/r cct,b-ckq*e0c\u001ca\"{6rj7%e,zc?c"));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u001c\u001d\u0003\u001d\f\fO\u001e\u0006\n\u001c\fG\u000e\u000e\u0014\u001a\u001dFX\u000e\u000bO\u001e\u0006\n\u001c\f0\u000e\u000e\u0014\u001a\u001dO"));
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = a6.getRPName();
        objectArray2[1] = a6.getMeasurementName();
        ((StringBuilder)charSequence).append(String.format(FunctionMetadata.m_le((Object)"%e,zc209fdc"), objectArray2));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u000f\u0007\u001d\u001d\u001dO\u000b\u001f\u0019\f\u001d0\u0011\u000bXRXK\u000b\u001f\u0019\f\u001d&\u001cO"));
        ((StringBuilder)charSequence).append(FunctionMetadata.m_le((Object)"\"y'77~.rc)~7gd7v1c\u0007v7rcv-scc*z&7\u007f7gr-s\u0007v7rc"));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\u000e\u0016\u000bX\u0019\u0019\u001d\u0011\u000e\u001a\u0003\u001d0\u0011\u000bXR\u0006O")).append(a6.getVariableIdsParam((Integer[])a)).append(FunctionMetadata.m_le((Object)"c"));
        ((StringBuilder)charSequence).append(JobController.m_le((Object)"\b\n\u0000\r\u001fX\r\u0001O\u000e\u000e\n\u0006\u0019\r\u0014\n'\u0006\u001cCXM\u0016\u000e\u0015\nZO"));
        ((StringBuilder)charSequence).append(FunctionMetadata.m_le((Object)"j"));
        a = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)a5).toString()).forDatabase(a6.getDBName());
        a.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), JobController.m_le((Object)"<\b\u000e\u001b\nX\u001c\u0010\u0000\r\u0003\u001cO\u001a\nX\u001f\n\n\u000b\n\u0016\u001b")).getId().toString());
        a.bind(FunctionMetadata.m_le((Object)"0c\"e7S\"c&"), (Object)((Date)a2).toInstant());
        a.bind(JobController.m_le((Object)"\n\u0016\u000b<\u000e\f\n"), (Object)a3.toInstant());
        a5 = BoundParameterQuery.QueryBuilder.newQuery((String)((StringBuilder)charSequence).toString()).forDatabase(a6.getDBName());
        a5.bind("spaceId", (Object)Objects.requireNonNull(c_ic.m_ck(), FunctionMetadata.m_le((Object)"\u0010g\"t&70\u007f,b/scu&73e&d&y7")).getId().toString());
        a5.bind(JobController.m_le((Object)"\u001c\f\u000e\n\u001b<\u000e\f\n"), (Object)((Date)a2).toInstant());
        a5.bind(FunctionMetadata.m_le((Object)"&y'S\"c&"), (Object)a3.toInstant());
        LoggedVariableValueRepository loggedVariableValueRepository = a6;
        a2 = loggedVariableValueRepository.runCountQuery((BoundParameterQuery.QueryBuilder)a5);
        a = loggedVariableValueRepository.loggedVariableValueStatsMapper.toPOJO(a6.influxDB.query((Query)a.create()), LoggedVariableValueStats.class);
        return new PageImpl((List)a, a4, ((Double)a2).longValue());
    }
}

