/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.enums.c_ela;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="connection")
@Inheritance(strategy=InheritanceType.JOINED)
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Connection<TDevice extends Device<?, ?>>
extends OwnedSpaceBaseModel {
    @Size(max=255)
    protected String dsc;
    @NotBlank
    @Size(max=50)
    protected String ip;
    @Column(name="project_id", insertable=false, updatable=false)
    protected Integer projectId;
    @NotBlank
    @Size(max=100)
    protected String name;
    @NotNull
    protected c_ela protocol;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    protected Project project;
    @NotNull
    @Min(value=0L)
    @Max(value=65535L)
    protected Integer port;
    @Id
    @Column(name="conn_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="connectionSeq")
    @GenericGenerator(name="connectionSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="connection_seq"), @Parameter(name="increment_size", value="100")})
    protected Integer id;
    @JsonIgnore
    @OneToMany(mappedBy="connection", orphanRemoval=true, targetEntity=Device.class)
    protected Set<TDevice> devices;

    public Connection() {
        Connection a;
        Connection connection = a;
        connection.devices = new HashSet();
    }

    public void setProtocol(c_ela a) {
        a.protocol = a;
    }

    public void setIp(String a) {
        a.ip = a;
    }

    public int hashCode() {
        Connection a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public Integer getId() {
        Connection a;
        return a.id;
    }

    public Set<TDevice> getDevices() {
        Connection a;
        return a.devices;
    }

    public boolean equals(Object a) {
        Connection a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Connection)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Connection)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public void setPort(Integer a) {
        a.port = a;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public Integer getProjectId() {
        Connection a;
        return a.projectId;
    }

    public String getDsc() {
        Connection a;
        return a.dsc;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public Integer getPort() {
        Connection a;
        return a.port;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public c_ela getProtocol() {
        Connection a;
        return a.protocol;
    }

    public Project getProject() {
        Connection a;
        return a.project;
    }

    public String getIp() {
        Connection a;
        return a.ip;
    }

    public String getName() {
        Connection a;
        return a.name;
    }

    public void setProject(Project a) {
        Connection a2;
        Connection connection = a2;
        connection.project = a;
        connection.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setDevices(Set<TDevice> a) {
        a.devices = a;
    }
}

