/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.auth.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.inscada.mono.auth.enums.c_uia;
import com.inscada.mono.auth.events.RevokeEvent;
import com.inscada.mono.auth.model.AuthSecret;
import com.inscada.mono.auth.model.AuthToken;
import com.inscada.mono.auth.repositories.AuthSecretRepository;
import com.inscada.mono.auth.security.model.AuthDetails;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.report.model.DeviationReportVariable;
import com.inscada.mono.shared.exceptions.c_mc;
import com.inscada.mono.user.model.User;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.security.Key;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPooled;

@Service
public class AuthTokenService
implements ClusterNodeListener {
    @Value(value="${ins.accessToken.duration}")
    private long d;
    private static final String M = "user_tokens:";
    private final SecretKey a;
    private final AuthSecretRepository h;
    private static final long G = 15L;
    private final ApplicationEventPublisher k;
    private static final String J = "authtoken:";
    private static final Logger b = LoggerFactory.getLogger(AuthTokenService.class);
    private static final long m = 5L;
    @Value(value="${ins.refreshToken.duration}")
    private long i;
    private final JedisPooled g;
    private volatile ScheduledFuture<?> K;
    @Value(value="${ins.jwt.secret}")
    private String A;
    private final ClusterOperations F;
    private final ScheduledExecutorService c;
    public static final short E = 10;
    private final ObjectMapper L;

    private /* synthetic */ Map<c_uia, AuthToken> generateAndStoreTokens(String a, String a2) {
        AuthTokenService a3;
        AuthTokenService authTokenService = a3;
        AuthToken authToken = authTokenService.generateAndStoreToken(a, (String)a2, c_uia.L);
        a = authTokenService.generateAndStoreToken(a, (String)a2, c_uia.c);
        Object object = a2 = new EnumMap<c_uia, AuthToken>(c_uia.class);
        a2.put((c_uia)c_uia.L, authToken);
        object.put(c_uia.c, a);
        return object;
    }

    private /* synthetic */ Date toDate(LocalDateTime a) {
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        return Date.from(a.toInstant(zoneOffset));
    }

    public AuthToken validate(String a) {
        AuthTokenService a2;
        String string = J + a;
        String string2 = a2.g.get(string);
        if (string2 == null) {
            throw new c_mc(DeviationReportVariable.m_le((Object)"\u001f- '%b%-?b-->,/b$0k'32\"0.&"));
        }
        try {
            string2 = (AuthToken)a2.L.readValue(string2, AuthToken.class);
        }
        catch (IOException iOException) {
            a2.g.del(string);
            throw new RuntimeException(AuthDetails.m_le((Object)"\u000bM$@(HmX\"\f)I>I?E,@$V(\f9C&I#\f)M9M"), iOException);
        }
        try {
            Jwts.parserBuilder().setSigningKey((Key)a2.a).build().parseClaimsJws(a);
            return string2;
        }
        catch (JwtException jwtException) {
            String string3 = string2;
            a2.deleteTokenFromRedis(a, string3.getUserId());
            if (string3.getType() == c_uia.c) {
                a2.revokeByTokenData((AuthToken)string2);
            }
            throw jwtException;
        }
    }

    private /* synthetic */ void revokeByTokenData(AuthToken a2) {
        AuthTokenService a3;
        if (a2 == null || a2.getUserId() == null) {
            return;
        }
        String string = M + a2.getUserId();
        Collection<Object> collection = a3.g.smembers(string);
        if (collection != null && !collection.isEmpty() && !(collection = collection.stream().map(a -> J + a).collect(Collectors.toList())).isEmpty()) {
            a3.g.del(collection.toArray(new String[0]));
        }
        a3.g.del(string);
        a3.k.publishEvent((ApplicationEvent)new RevokeEvent((Object)a3, a2.getUsername()));
    }

    protected Map<c_uia, AuthToken> createTokensOnLeader(Integer a, String a2) {
        AuthTokenService a3;
        return a3.generateAndStoreTokens(a.toString(), a2);
    }

    private /* synthetic */ void stopCleanupJob() {
        AuthTokenService a;
        if (a.K != null) {
            b.info(DeviationReportVariable.m_le((Object)"\u0011?-;2\",,b?- '%b(..#%7;b!-)l"));
            a.K.cancel(false);
            a.K = null;
        }
    }

    public void leader() {
        AuthTokenService a;
        b.info(AuthDetails.m_le((Object)"\u0019D$_mB\"H(\f%M>\f/I.C ImX%Im`\bm\ti\u001f\u0002m\u007f9M?X$B*\f9C&I#\f.@(M#Y=\f'C/\u0002"));
        a.startCleanupJob();
    }

    public void revoke(User a2) {
        AuthTokenService a3;
        String string = M + a2.getId();
        Collection<Object> collection = a3.g.smembers(string);
        if (collection != null && !collection.isEmpty() && !(collection = collection.stream().map(a -> J + a).collect(Collectors.toList())).isEmpty()) {
            a3.g.del(collection.toArray(new String[0]));
        }
        a3.g.del(string);
        a3.k.publishEvent((ApplicationEvent)new RevokeEvent((Object)a3, a2.getUsername()));
    }

    public AuthTokenService(AuthSecretRepository a, JedisPooled a2, ObjectMapper a3, ApplicationEventPublisher a4, ClusterOperations a5) {
        AuthTokenService a6;
        AuthTokenService authTokenService = a6;
        AuthTokenService authTokenService2 = a6;
        a6.c = Executors.newSingleThreadScheduledExecutor();
        a6.h = a;
        authTokenService2.g = a2;
        authTokenService2.L = a3;
        a6.k = a4;
        authTokenService.F = a5;
        authTokenService.a = a6.initSecretKey();
    }

    private /* synthetic */ SecretKey initSecretKey() {
        Object object;
        String string;
        AuthTokenService a;
        if (a.A != null && !a.A.isBlank()) {
            b.info(DeviationReportVariable.m_le((Object)"\u001e1\",,b\u0001\u0015\u001fb\n7?*.,?+(#?+$,k\u0011.!9'?b-0$/k!$,-+,79'/b;0$2.0?;d'%4\"0$,&'%6k4*0\"#)..l"));
            string = a.A;
        } else {
            b.warn(AuthDetails.m_le((Object)"f\u001axmm8X%I#X$O,X$C#\f\u001eI.^(Xm\u0004(\u0002*\u0002a\fjE#_cF:Xc_(O?I9\u000bm\\?C=I?X4\u0005mE>\f#C9\f.C#J$K8^(Hc\f\u000bM!@$B*\f/M.GmX\"\f)M9M/M>Im@\"C&Y=\u0002"));
            object = a.h.findFirstByOrderByIdAsc();
            if (object == null) {
                b.error(DeviationReportVariable.m_le((Object)"\u0001\u0019\u000b\u001f\u000b\b\u0003\u0007xk\u0003>6#b8'(0.6k,$6k$$7%&k+%b/#?#)#8'k'\"6#'9c"));
                throw new c_mc(AuthDetails.m_le((Object)"m8X%\f>I.^(XmB\"XmJ\"Y#HmE#\f(B;E?C#A(B9\f\"^mH,X,N,_(\u0002"));
            }
            string = object.getAuthSecretValue();
            b.info(DeviationReportVariable.m_le((Object)"\u001e1\",,b\u0001\u0015\u001fb\n7?*.,?+(#?+$,k\u0011.!9'?b-0$/k&*6* *1.l"));
        }
        try {
            object = Base64.getDecoder().decode(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(AuthDetails.m_le((Object)"\u0007{\u0019\f\fY9D(B9E.M9E\"Bm\u007f(O?I9\f$_mB\"XmZ,@$Hmn,_(\u001ay\u0002"), illegalArgumentException);
        }
        if (((AuthSecret)object).length < 64) {
            b.error(DeviationReportVariable.m_le((Object)"\b\u0010\u0002\u0016\u0002\u0001\n\u000eqb\u0001\u0015\u001fb\n7?*.,?+(#?+$,k\u0011.!9'?b\"1k6$-k1#-96k$$0k\n\u0018wzpkj&786k .bu\u007fkt\u007fb);?'8b*$?'9b/'(-/+%%blk\u0006.!$&.&k..,,6#xk96b);?'8l"), (Object)((AuthSecret)object).length);
            throw new IllegalStateException(AuthDetails.m_le((Object)"f\u001axmm8X%I#X$O,X$C#\f\u001eI.^(XmE>\f9C\"\f>D\"^9\f+C?\f\u0005\u007fx\u001d\u007f\u0002"));
        }
        Object object2 = object;
        return new SecretKeySpec((byte[])object2, 0, ((AuthSecret)object2).length, DeviationReportVariable.m_le((Object)"\u0003/*!\u0018\n\nwzp"));
    }

    private /* synthetic */ void startCleanupJob() {
        AuthTokenService a;
        if (a.K != null && !a.K.isDone()) {
            b.warn(AuthDetails.m_le((Object)"x\"G(BmO!I,B8\\mF\"NmE>\f,@?I,H4\f?Y#B$B*\u0002me*B\"^$B*\f>X,^9\f?I<Y(_9\u0002"));
            return;
        }
        b.info(DeviationReportVariable.m_le((Object)"\u00186*0?+%%k6$).,k!''*,>2k($ k5\"6#b*,k+%6.0=#'b$$k96b&+%7?'8l"), (Object)5L);
        a.K = a.c.scheduleWithFixedDelay(() -> {
            try {
                AuthTokenService a;
                Set set = a.g.keys(DeviationReportVariable.m_le((Object)"78'9\u001d?- '%1qh"));
                for (String string : set) {
                    for (String string2 : a.g.smembers(string)) {
                        String string3 = J + string2;
                        if (a.g.exists(string3)) continue;
                        String[] stringArray = new String[1];
                        stringArray[0] = string2;
                        a.g.srem(string, stringArray);
                    }
                }
            }
            catch (Exception exception) {
                b.error(AuthDetails.m_le((Object)"\u0019C&I#\f.@(M#Y=\f'C/\f+M$@(H"), (Throwable)exception);
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }

    private /* synthetic */ AuthToken generateAndStoreToken(String a, String a2, c_uia a3) {
        LocalDateTime localDateTime;
        long l;
        AuthTokenService a4;
        Object object = LocalDateTime.now();
        if (a3 == c_uia.L) {
            l = TimeUnit.MINUTES.toSeconds(a4.d);
            localDateTime = object;
        } else {
            l = TimeUnit.DAYS.toSeconds(a4.i);
            localDateTime = object;
        }
        Object object2 = localDateTime.plusSeconds(l);
        object = Jwts.builder().setSubject(a2).setIssuedAt(a4.toDate((LocalDateTime)object)).setExpiration(a4.toDate((LocalDateTime)object2)).claim(AuthDetails.m_le((Object)"Y$H"), (Object)a).claim(DeviationReportVariable.m_le((Object)"622"), (Object)a3.name()).signWith((Key)a4.a, SignatureAlgorithm.HS512).compact();
        object2 = J + (String)object;
        Object object3 = new AuthToken(a, a2, a3, Long.valueOf(l));
        try {
            AuthTokenService authTokenService = a4;
            object3 = authTokenService.L.writeValueAsString(object3);
            authTokenService.g.setex((String)object2, l, (String)object3);
            object2 = M + a;
            String[] stringArray = new String[1];
            stringArray[0] = object;
            a4.g.sadd((String)object2, stringArray);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException(AuthDetails.m_le((Object)"\u000bM$@(HmX\"\f>X\"^(\f9C&I#\f)Y(\f9Cm_(^$M!E7M9E\"BmI?^\"^"), jsonProcessingException);
        }
        object3 = new AuthToken(a, a2, a3, Long.valueOf(l));
        object3.setTokenValue((String)object);
        return object3;
    }

    public Map<c_uia, AuthToken> create(User a3) {
        AuthTokenService a2;
        if (a2.F.isLeader()) {
            return a2.createTokensOnLeader(a3.getId(), a3.getUsername());
        }
        b.debug(DeviationReportVariable.m_le((Object)"\r-'.$5.0k,$&.b/''',#?+%%k6$).,k!9'*6\"-%b?-k..#/'9b--9b>1.0qb0?"), (Object)a3.getUsername());
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3.getId();
            objectArray[1] = a3.getUsername();
            return (Map)a2.F.callLeaderMethod(Short.valueOf((short)10), objectArray);
        }
        catch (Exception a3) {
            throw new RuntimeException(AuthDetails.m_le((Object)"j,E!I)\f9CmO?I,X(\f9C&I#\f;E,\f\u001f|\u000e\f.M!@mX\"\f!I,H(^"), a3);
        }
    }

    private /* synthetic */ void deleteTokenFromRedis(String a, String a2) {
        AuthTokenService a3;
        if (a == null) {
            return;
        }
        String string = J + a;
        a3.g.del(string);
        if (a2 != null) {
            a2 = M + (String)a2;
            String[] stringArray = new String[1];
            stringArray[0] = a;
            a3.g.srem((String)a2, stringArray);
        }
    }

    @PreDestroy
    public void shutdownCleanupJob() {
        AuthTokenService a;
        a.c.shutdown();
        try {
            if (!a.c.awaitTermination(10L, TimeUnit.SECONDS)) {
                a.c.shutdownNow();
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            a.c.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private /* synthetic */ void expireTokenInRedis(String a, long a2) {
        AuthTokenService a3;
        if (a == null) {
            return;
        }
        a = J + (String)a;
        a3.g.expire((String)a, a2);
    }

    public void notLeader() {
        AuthTokenService a;
        b.info(DeviationReportVariable.m_le((Object)"\u001f*\"1k,$&.b\"1k#k\u0004\u0004\u000e\u0007\r\u001c\u0007\u0019lk\u0011?-;2\",,b?- '%b(..#%7;b!-)l"));
        a.stopCleanupJob();
    }

    @PostConstruct
    public void initialize() throws NoSuchMethodException {
        AuthTokenService a;
        Class[] classArray = new Class[2];
        classArray[0] = Integer.class;
        classArray[1] = String.class;
        a.F.addRemoteCall((short)10, (Object)a, AuthTokenService.class.getDeclaredMethod(AuthDetails.m_le((Object)".^(M9I\u0019C&I#_\u0002B\u0001I,H(^"), classArray));
        a.F.addListener((ClusterNodeListener)a);
    }

    public Map<c_uia, AuthToken> refresh(String a) {
        EnumMap<c_uia, AuthToken> enumMap;
        AuthTokenService a2;
        AuthToken authToken = a2.validate(a);
        if (authToken.getType() != c_uia.c) {
            throw new IllegalArgumentException(DeviationReportVariable.m_le((Object)"\u000b%4*.\"&k6$).,k622.b--9b9'-0.1#b$2.0*6\"-%l"));
        }
        AuthTokenService authTokenService = a2;
        authTokenService.expireTokenInRedis(a, 15L);
        a = authTokenService.generateAndStoreToken(authToken.getUserId(), authToken.getUsername(), c_uia.L);
        authToken = a2.generateAndStoreToken(authToken.getUserId(), authToken.getUsername(), c_uia.c);
        EnumMap<c_uia, AuthToken> enumMap2 = enumMap = new EnumMap<c_uia, AuthToken>(c_uia.class);
        enumMap.put(c_uia.L, (AuthToken)a);
        enumMap2.put(c_uia.c, authToken);
        return enumMap2;
    }
}

