/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.auth.security.model;

import com.inscada.mono.auth.security.model.AuthDetails;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.model.User;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class AuthenticationResponseToken
extends PreAuthenticatedAuthenticationToken {
    private final Space activeSpace;
    private final Set<String> spaces;
    private final Set<String> roleNames;
    private final Set<String> menus;

    public String getRemoteAddress() {
        AuthenticationResponseToken a;
        return ((AuthDetails)a.getDetails()).getRemoteAddress();
    }

    public String getName() {
        AuthenticationResponseToken a;
        return a.getUser().getUsername();
    }

    public Set<String> getSpaces() {
        AuthenticationResponseToken a;
        return a.spaces;
    }

    public Space getActiveSpace() {
        AuthenticationResponseToken a;
        return a.activeSpace;
    }

    public AuthenticationResponseToken(User a, Object a2, Space a3, Object a4) {
        AuthenticationResponseToken a5;
        User user = a;
        super((Object)user, a2, (Collection)user.getAuthorities());
        a5.activeSpace = a3;
        AuthenticationResponseToken authenticationResponseToken = a5;
        a5.spaces = Collections.unmodifiableSet(new HashSet(a.getSpaceNames()));
        a5.roleNames = Collections.unmodifiableSet(new HashSet(a.getRoleNames()));
        a5.menus = Collections.unmodifiableSet(new HashSet(a.getMenus()));
        a5.setDetails(a4);
    }

    public User getUser() {
        AuthenticationResponseToken a;
        return (User)a.getPrincipal();
    }

    public Set<String> getFlatAuthorities() {
        AuthenticationResponseToken a;
        return a.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
    }

    public Set<String> getRoleNames() {
        AuthenticationResponseToken a;
        return a.roleNames;
    }

    public Set<String> getMenus() {
        AuthenticationResponseToken a;
        return a.menus;
    }
}

