/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.restcontrollers;

import com.inscada.mono.animation.enums.c_ica;
import com.inscada.mono.animation.messages.EvalAnimationMessage;
import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.animation.model.AnimationElement;
import com.inscada.mono.animation.model.AnimationScript;
import com.inscada.mono.animation.model.RunAnimScriptDto;
import com.inscada.mono.animation.z.c_lda;
import com.inscada.mono.animation.z.c_qaa;
import com.inscada.mono.impexp.b.c_gh;
import com.inscada.mono.impexp.c.c_vg;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.z.c_ji;
import com.inscada.mono.search.repositories.SearchRepository;
import com.inscada.mono.user.model.ResetPasswordToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/animations"})
public class AnimationController
extends ProjectBasedImportExportController {
    private final c_qaa E;
    private final c_lda L;

    @GetMapping(value={"/{animationId}/svg"})
    public ResponseEntity<InputStreamResource> getAnimationSvg(@PathVariable(value="animationId") Integer a) {
        a = this.E.m_yc(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(ResetPasswordToken.m_le((Object)"?i\u0012r\u0019h\b+8o\u000fv\u0013u\u0015r\u0015i\u0012"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)SearchRepository.m_le((Object)"q\u001ey\u0014}\\k\u0005\u007fX`\u001et"))).body((Object)byteArrayInputStream);
    }

    @DeleteMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        this.E.m_fdc(animationId, a);
    }

    @GetMapping(value={"/{animationId}"})
    public Animation getAnimation(@PathVariable(value="animationId") Integer a) {
        return this.E.m_ba(a);
    }

    @PostMapping(value={"/{animationId}/elements"})
    public ResponseEntity<AnimationElement> createAnimationElement(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationElement animationElement, UriComponentsBuilder a) {
        animationElement = this.E.m_qcc(animationId, animationElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationElement.getId();
        return ResponseEntity.created((URI)a.path(ResetPasswordToken.m_le((Object)"S}\u001dh\u0015k\u001dr\u0015i\u0012O\u0018{Sc\u0010c\u0011c\u0012r\u000f)\u0007c\u0010c\u0011c\u0012r5b\u0001")).buildAndExpand(objectArray).toUri()).body((Object)animationElement);
    }

    @MessageMapping(value={"/eval-animation"})
    public void animationResultMessage(@Payload EvalAnimationMessage evalAnimationMessage, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.L.m_akc(evalAnimationMessage, a.getName(), sessionId);
    }

    @GetMapping(value={"/{animationId}/scripts"})
    public Collection<AnimationScript> getAnimationScripts(@PathVariable(value="animationId") Integer a) {
        return this.E.m_eec(a);
    }

    @DeleteMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        this.E.m_eia(animationId, a);
    }

    @GetMapping(value={"/{animationId}/elements"})
    public Collection<AnimationElement> getAnimationElements(@PathVariable(value="animationId") Integer a) {
        return this.E.m_nda(a);
    }

    @PutMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer scriptId, @Valid @RequestBody AnimationScript a) {
        this.E.m_yyb(animationId, scriptId, a);
    }

    @GetMapping(value={"/project"}, params={"projectName", "name"})
    public Animation getAnimationByProjectName(@RequestParam(name="projectName") String projectName, @RequestParam(name="name") String a) {
        return this.E.m_ldc(projectName, a);
    }

    @PutMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimation(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody Animation a) {
        this.E.m_axb(animationId, a);
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Animation> getAnimationsByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.E.m_cga(projectId, a);
    }

    @GetMapping(value={"/project/{projectId}"}, params={"name"})
    public Animation getAnimationByProjectId(@PathVariable(value="projectId") Integer projectId, @RequestParam(name="name") String a) {
        return this.E.m_sf(projectId, a);
    }

    @PutMapping(value={"/{animationId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationSvg(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.E.m_iaa(animationId, a);
    }

    @PostMapping(value={"/{animationId}/clone"}, params={"name"})
    public ResponseEntity<Animation> cloneAnimation(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        animationId = this.E.m_yca(animationId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = animationId.getId();
        return ResponseEntity.created((URI)a.path(SearchRepository.m_le((Object)"\\c\u0012v\u001au\u0012l\u001aw\u001dQ\u0017e")).buildAndExpand(objectArray).toUri()).body((Object)animationId);
    }

    @GetMapping(value={"/{animationId}/elements/{elementId}"})
    public AnimationElement getAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        return this.E.m_gka(animationId, a);
    }

    @PutMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody AnimationElement a) {
        this.E.m_txb(animationId, elementId, a);
    }

    @PostMapping
    public ResponseEntity<Animation> createAnimation(@Valid @RequestBody Animation animation, UriComponentsBuilder a) {
        animation = this.E.m_oec(animation);
        Object[] objectArray = new Object[1];
        objectArray[0] = animation.getId();
        return ResponseEntity.created((URI)a.path(ResetPasswordToken.m_le((Object)")\u0007g\u0012o\u0011g\bo\u0013h5b\u0001")).buildAndExpand(objectArray).toUri()).body((Object)animation);
    }

    @DeleteMapping(value={"/{animationId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElementsByIds(@PathVariable(value="animationId") Integer animationId, @RequestParam(value="elementIds") Integer[] a) {
        this.E.m_mwb(animationId, a);
    }

    @PostMapping(value={"/{animationId}/scripts"})
    public ResponseEntity<AnimationScript> createAnimationScript(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationScript animationScript, UriComponentsBuilder a) {
        animationScript = this.E.m_pec(animationId, animationScript);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationScript.getId();
        return ResponseEntity.created((URI)a.path(SearchRepository.m_le((Object)"7\by\u001dq\u001ey\u0007q\u001cv:|\u000e7\u0000{\u0001q\u0003l\u00007\bk\u0010j\u001ah\u0007Q\u0017e")).buildAndExpand(objectArray).toUri()).body((Object)animationScript);
    }

    @GetMapping(value={"/{animationId}/scripts/{scriptId}"})
    public AnimationScript getAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        return this.E.m_oxb(animationId, a);
    }

    @DeleteMapping(value={"/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="elementId") Integer a) {
        this.E.m_kec(a);
    }

    @MessageMapping(value={"/run-animation-script"})
    public void runAnimationScript(@Payload RunAnimScriptDto runAnimScriptDto, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.L.m_hic(runAnimScriptDto, a.getName(), sessionId);
    }

    @PutMapping(value={"/{animationId}/placeholders"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updatePlaceholders(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.E.m_dwb(animationId, a);
    }

    public AnimationController(c_qaa a, c_lda a2, c_gh a3, c_ji a4) {
        AnimationController a5;
        AnimationController animationController = a5;
        super(a3, EnumSet.of(c_vg.A), a4);
        animationController.E = a;
        animationController.L = a2;
    }

    @DeleteMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimation(@PathVariable(value="animationId") Integer a) {
        this.E.m_ga(a);
    }

    @GetMapping
    public Collection<Animation> getAnimations(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.E.m_la();
        }
        return this.E.m_sa(a);
    }

    @GetMapping(value={"/name/elements"}, params={"name", "type"})
    public AnimationElement getAnimationElementByNameAndType(@RequestParam(name="name") String name, @RequestParam(name="type") c_ica a) {
        return this.E.m_dcc(name, a);
    }

    @GetMapping(value={"/{animationId}/elements"}, params={"type"})
    public Collection<AnimationElement> getAnimationElementsByType(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="type") c_ica a) {
        return this.E.m_hcc(animationId, a);
    }
}

