/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.animation.model.AnimationElement;
import com.inscada.mono.animation.model.AnimationScript;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="animation")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Animation
extends SpaceBaseModel {
    @OneToMany(mappedBy="animation", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<AnimationScript> animationScripts;
    @NotNull
    @Column(name="main_flag")
    private Boolean mainFlag;
    @Column(name="post_anim_code")
    private String postAnimCode;
    @Size(max=255)
    private String dsc;
    @Size(max=7)
    private String color;
    @JsonIgnore
    @OneToMany(mappedBy="animation", orphanRemoval=true)
    private Set<AnimationElement> animationElements;
    private String alignment;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @NotBlank
    @Column(name="svg_content")
    private String svgContent;
    private String configs;
    @NotNull
    @Min(value=1L)
    @Column(name="play_order")
    private Short playOrder;
    private String placeholders;
    @NotNull
    @Min(value=100L)
    private Integer duration;
    @Id
    @Column(name="animation_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="animationSeq")
    @GenericGenerator(name="animationSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="animation_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Column(name="pre_anim_code")
    private String preAnimCode;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @NotBlank
    @Size(max=100)
    private String name;
    @Column(name="anim_join_id")
    private Integer animJoinId;

    public void setColor(String a) {
        a.color = a;
    }

    public String getSvgContent() {
        Animation a;
        return a.svgContent;
    }

    public Boolean getMainFlag() {
        Animation a;
        return a.mainFlag;
    }

    public void setDuration(Integer a) {
        a.duration = a;
    }

    public void setPlayOrder(Short a) {
        a.playOrder = a;
    }

    public Integer getAnimJoinId() {
        Animation a;
        return a.animJoinId;
    }

    public Project getProject() {
        Animation a;
        return a.project;
    }

    public String getPlaceholders() {
        Animation a;
        return a.placeholders;
    }

    public void removeScript(Integer a) {
        Animation a3;
        a3.animationScripts.removeIf(a2 -> a2.getId().equals(a));
    }

    public void setAnimationScripts(Set<AnimationScript> a) {
        a.animationScripts = a;
    }

    public void setPreAnimCode(String a) {
        a.preAnimCode = a;
    }

    public void addElement(AnimationElement a) {
        Animation a2;
        Animation animation = a2;
        a.setAnimation(animation);
        animation.animationElements.add(a);
    }

    public String getAlignment() {
        Animation a;
        return a.alignment;
    }

    public Integer getProjectId() {
        Animation a;
        return a.projectId;
    }

    public Animation(Integer a, Integer a2, String a3, String a4, String a5, Integer a6, Short a7, Boolean a8, String a9, String a10, Integer a11, String a12, String a13, Project a14, String a15, Date a16, String a17, Date a18) {
        Animation a19;
        Animation animation = a19;
        Animation animation2 = a19;
        Animation animation3 = a19;
        Animation animation4 = a19;
        Animation animation5 = a19;
        Animation animation6 = a19;
        Animation animation7 = a19;
        Animation animation8 = a19;
        Animation animation9 = a19;
        Animation animation10 = a19;
        a19.animationElements = new HashSet();
        animation10.animationScripts = new HashSet();
        animation9.id = a;
        animation9.projectId = a2;
        animation8.name = a3;
        animation8.dsc = a4;
        animation7.color = a5;
        animation7.duration = a6;
        animation6.playOrder = a7;
        animation6.mainFlag = a8;
        animation5.preAnimCode = a9;
        animation5.postAnimCode = a10;
        animation4.animJoinId = a11;
        animation4.configs = a12;
        animation3.alignment = a13;
        animation3.project = a14;
        animation2.createdBy = a15;
        animation2.creationDate = a16;
        animation.lastModifiedBy = a17;
        animation.lastModifiedDate = a18;
    }

    public String getConfigs() {
        Animation a;
        return a.configs;
    }

    public String getDsc() {
        Animation a;
        return a.dsc;
    }

    public Integer getDuration() {
        Animation a;
        return a.duration;
    }

    public String getName() {
        Animation a;
        return a.name;
    }

    public void setAnimJoinId(Integer a) {
        a.animJoinId = a;
    }

    public void setAnimationElements(Set<AnimationElement> a) {
        a.animationElements = a;
    }

    public void setSvgContent(String a) {
        a.svgContent = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public void setProject(Project a) {
        Animation a2;
        Animation animation = a2;
        animation.project = a;
        animation.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Animation() {
        Animation a;
        Animation animation = a;
        a.animationElements = new HashSet();
        animation.animationScripts = new HashSet();
    }

    public boolean equals(Object a) {
        Animation a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Animation)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Animation)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public Short getPlayOrder() {
        Animation a;
        return a.playOrder;
    }

    public Set<AnimationElement> getAnimationElements() {
        Animation a;
        return a.animationElements;
    }

    public String getColor() {
        Animation a;
        return a.color;
    }

    public String getPostAnimCode() {
        Animation a;
        return a.postAnimCode;
    }

    public Integer getId() {
        Animation a;
        return a.id;
    }

    public Animation(String a, String a2, String a3, String a4, Integer a5, Short a6, Boolean a7, String a8, String a9, Integer a10, String a11, String a12, String a13, Project a14, Set<AnimationElement> a15, Set<AnimationScript> a16) {
        Animation a17;
        Animation animation = a17;
        Animation animation2 = a17;
        Animation animation3 = a17;
        Animation animation4 = a17;
        Animation animation5 = a17;
        Animation animation6 = a17;
        Animation animation7 = a17;
        Animation animation8 = a17;
        Animation animation9 = a17;
        a17.animationElements = new HashSet();
        animation9.animationScripts = new HashSet();
        animation8.name = a;
        animation8.dsc = a2;
        animation7.svgContent = a3;
        animation7.color = a4;
        animation6.duration = a5;
        animation6.playOrder = a6;
        animation5.mainFlag = a7;
        animation5.preAnimCode = a8;
        animation4.postAnimCode = a9;
        animation4.animJoinId = a10;
        animation3.configs = a11;
        animation3.alignment = a12;
        animation2.placeholders = a13;
        animation2.project = a14;
        animation.animationScripts = a16;
        animation.animationElements = a15;
    }

    public Set<AnimationScript> getAnimationScripts() {
        Animation a;
        return a.animationScripts;
    }

    public void setConfigs(String a) {
        a.configs = a;
    }

    public void addScript(AnimationScript a) {
        Animation a2;
        a2.animationScripts.add(a);
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public void setPlaceholders(String a) {
        a.placeholders = a;
    }

    public void setPostAnimCode(String a) {
        a.postAnimCode = a;
    }

    public void setMainFlag(Boolean a) {
        a.mainFlag = a;
    }

    public void setAlignment(String a) {
        a.alignment = a;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void removeElement(Integer a) {
        Animation a3;
        a3.animationElements.removeIf(a2 -> a2.getId().equals(a));
    }

    public String getPreAnimCode() {
        Animation a;
        return a.preAnimCode;
    }

    public int hashCode() {
        Animation a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }
}

