/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.model.AnalogAlarm;
import com.inscada.mono.alarm.model.DigitalAlarm;
import com.inscada.mono.alarm.repositories.AlarmRepository;
import com.inscada.mono.alarm.services.c_naa;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_gea;
import com.inscada.mono.datasource.influxdb.restcontrollers.CustomInfluxDBDatabaseController;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.z.c_ji;
import com.inscada.mono.script.services.c_jf;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_mc;
import com.inscada.mono.shared.exceptions.c_mf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@EnableSpaceFilter
public abstract class c_xja<T extends Alarm> {
    protected final ApplicationEventPublisher K;
    protected final c_naa A;
    protected final AlarmRepository<T> F;
    protected final c_ji c;
    protected final c_gea E;
    protected static final String[] L;

    protected void m_jkc(T a) {
        AnalogAlarm analogAlarm;
        if (!a.getGroup().getProject().equals((Object)a.getProject())) {
            throw new c_mf(CustomInfluxDBDatabaseController.m_le((Object)"Qiqw}%ww\u007fp`%`w\u007foufd%qkt%qiqw}%`w\u007foufd%}pcq0hqqsm"));
        }
        if (a.getOnTimeVariable() != null && !a.getOnTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_mf(c_jf.m_le((Object)"\fa,\u007f -=\u007f\"g(n9-,c)-;l?d,o!hm}?b'h.ym`8~9- l9n%"));
        }
        if (a.getOffTimeVariable() != null && !a.getOffTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_mf(CustomInfluxDBDatabaseController.m_le((Object)"D|dbh0ubjz`sq0d~a0sqwydriu%`w\u007foufd%}pcq0hqqsm"));
        }
        if (a instanceof DigitalAlarm) {
            DigitalAlarm digitalAlarm = (DigitalAlarm)a;
            if (!digitalAlarm.getVariableA().getProject().equals((Object)a.getProject())) {
                throw new c_mf(c_jf.m_le((Object)"\fa,\u007f -=\u007f\"g(n9-,c)-;l?d,o!hm}?b'h.ym`8~9- l9n%"));
            }
            if (digitalAlarm.getVariableB() != null && !digitalAlarm.getVariableB().getProject().equals((Object)a.getProject())) {
                throw new c_mf(CustomInfluxDBDatabaseController.m_le((Object)"D|dbh0ubjz`sq0d~a0sqwydriu%`w\u007foufd%}pcq0hqqsm"));
            }
        } else if (a instanceof AnalogAlarm && !(analogAlarm = (AnalogAlarm)a).getVariable().getProject().equals((Object)a.getProject())) {
            throw new c_mf(c_jf.m_le((Object)"\fa,\u007f -=\u007f\"g(n9-,c)-;l?d,o!hm}?b'h.ym`8~9- l9n%"));
        }
    }

    @Order(value=3)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_jl(ProjectDeleteEvent a) {
        c_xja a2;
        a2.m_aa(a.getProject().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_zqc(Integer a) {
        c_xja a2;
        return a2.F.findByGroupIdAndIsActiveTrue(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_ph(Integer a, String a2) {
        c_xja a3;
        Alarm alarm = a3.m_sf(a, a2);
        if (alarm == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_mc(String.format(CustomInfluxDBDatabaseController.m_le((Object)"D|dbh0k\u007fq0c\u007fp~a*%`w\u007foufd%ya*%5a<%~d}`*%5v"), objectArray));
        }
        return (T)alarm;
    }

    @DisableSpaceFilter
    public T m_gic(Integer a) {
        c_xja a2;
        return (T)((Alarm)a2.F.findById((Object)a).orElse(null));
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_aa(Integer a) {
        if (a != null) {
            c_xja a2;
            a2.F.deleteByProjectId(a);
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_agc(T a, boolean a2) {
        Alarm alarm;
        c_xja a3;
        T t = a;
        a3.m_ojc(t);
        if ((t.getId() != null ? (alarm = a3.m_ba(a.getId())) : (alarm = a3.m_sf(a.getProjectId(), a.getName()))) != null) {
            a3.m_knc(a, alarm, a2);
            return;
        }
        c_xja c_xja2 = a3;
        c_xja2.m_jkc(a);
        c_xja2.F.save(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_skc(Integer a, String a2) {
        c_xja a3;
        return a3.F.findByGroupName(a, a2);
    }

    public void m_ync(T a) {
        c_xja a2;
        c_xja c_xja2 = a2;
        c_xja2.m_ojc(a);
        c_xja2.m_jkc(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM')")
    public void m_ngc(Integer a, T a2) {
        c_xja a3;
        c_xja c_xja2 = a3;
        a = c_xja2.m_yc(a);
        c_xja2.m_knc(a2, (Alarm)a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_la() {
        c_xja a;
        return a.F.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<String> m_okc(Integer a) {
        c_xja a2;
        return a2.F.findDistinctPartsByProjectId(a);
    }

    protected c_xja(c_ji a, c_naa a2, AlarmRepository<T> a3, c_gea a4, ApplicationEventPublisher a5) {
        c_xja a6;
        c_xja c_xja2 = a6;
        c_xja c_xja3 = a6;
        a6.c = a;
        c_xja3.A = a2;
        c_xja3.F = a3;
        c_xja2.E = a4;
        c_xja2.K = a5;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_rq(List<T> a2, boolean a3) {
        c_xja a4;
        a2.forEach(arg_0 -> a4.m_ojc(arg_0));
        Object object = a2.stream().map(Alarm::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.F.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(Alarm::getProjectId, Collectors.mapping(Alarm::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_xja a2;
            return a2.F.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(Alarm::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<Alarm> arrayList = new ArrayList<Alarm>();
        HashSet<Alarm> hashSet = new HashSet<Alarm>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Alarm alarm = (Alarm)a2.next();
            if ((alarm.getId() != null ? (Alarm)map.get(alarm.getId()) : (Alarm)object.get(ImmutablePair.of((Object)alarm.getProjectId(), (Object)alarm.getName()))) != null) {
                Alarm alarm2;
                Alarm alarm3 = alarm2;
                a4.m_knc(alarm, alarm3, false);
                hashSet.add(alarm3);
                arrayList.add(alarm2);
                continue;
            }
            a4.m_jkc(alarm);
            arrayList.add(alarm);
        }
        a4.F.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_xja a2;
                a2.K.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a2, a));
            });
        }
    }

    @DisableSpaceFilter
    public Collection<T> m_qj(Integer a) {
        c_xja a2;
        return a2.F.findByProjectId(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_sf(Integer a, String a2) {
        c_xja a3;
        return (T)a3.F.findOneByProjectIdAndName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_yc(Integer a) {
        c_xja a2;
        Alarm alarm = a2.m_ba(a);
        if (alarm == null) {
            throw new c_mc("Alarm not found with id of " + a);
        }
        return (T)alarm;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_ga(Integer a) {
        c_xja a2;
        if ((a = a2.m_ba(a)) != null) {
            c_xja c_xja2 = a2;
            c_xja2.F.delete((Object)a);
            c_xja2.K.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, (Alarm)a));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_lnc(List<Integer> a2) {
        c_xja a3;
        c_xja c_xja2 = a3;
        a2 = c_xja2.m_llc(a2);
        c_xja2.F.deleteInBatch(a2);
        a2.forEach(a -> {
            c_xja a2;
            a2.K.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, a));
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_ulc(Integer a, String[] a2) {
        c_xja a3;
        return a3.F.findByProjectIdAndNameIn(a, Arrays.stream(a2).collect(Collectors.toSet()));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_nqc(AlarmFilter a, Pageable a2) {
        c_xja a3;
        return a3.F.findAlarmsByFilter(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_boa(Integer a, Pageable a2) {
        c_xja a3;
        return a3.F.findByProjectId(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_ika(Pageable a) {
        c_xja a2;
        return a2.F.findAll(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_ALARM')")
    public T m_pgc(T a) {
        c_xja a2;
        c_xja c_xja2 = a2;
        c_xja2.m_ync(a);
        a = (Alarm)c_xja2.F.save(a);
        a2.K.publishEvent((ApplicationEvent)new AlarmAddEvent((Object)a2, a));
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_llc(Collection<Integer> a) {
        c_xja a2;
        return a2.F.findAllById(a);
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = c_jf.m_le((Object)"d)");
        stringArray[1] = CustomInfluxDBDatabaseController.m_le((Object)"v`ds`");
        stringArray[2] = c_jf.m_le((Object)"=\u007f\"g(n9");
        stringArray[3] = CustomInfluxDBDatabaseController.m_le((Object)"bbjeu");
        stringArray[4] = c_jf.m_le((Object)".\u007f(l9h)O4");
        stringArray[5] = CustomInfluxDBDatabaseController.m_le((Object)"swuddl\u007fkTdd`");
        stringArray[6] = c_jf.m_le((Object)"a,~9@\"i$k$h)O4");
        stringArray[7] = CustomInfluxDBDatabaseController.m_le((Object)"|dcq]jtlvluaTdd`");
        L = stringArray;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_ba(Integer a) {
        c_xja a2;
        return (T)((Alarm)a2.F.findById((Object)a).orElse(null));
    }

    protected void m_ojc(T a) {
        Variable variable;
        c_xja a2;
        if (a.getProject() == null) {
            T t = a;
            t.setProject(a2.c.m_yc(t.getProjectId()));
        }
        if (a.getGroup() == null) {
            T t = a;
            t.setGroup(a2.A.m_yc(t.getGroupId()));
        }
        if (a.getOnTimeVariable() == null && a.getOnTimeVariableId() != null) {
            variable = a2.E.m_yc(a.getOnTimeVariableId());
            a.setOnTimeVariable(variable);
        }
        if (a.getOffTimeVariable() == null && a.getOffTimeVariableId() != null) {
            variable = a2.E.m_yc(a.getOffTimeVariableId());
            a.setOffTimeVariable(variable);
        }
        if (a instanceof DigitalAlarm) {
            Variable variable2;
            variable = (DigitalAlarm)a;
            if (variable.getVariableA() == null) {
                variable2 = a2.E.m_yc(variable.getVariableAId());
                variable.setVariableA(variable2);
            }
            if (variable.getVariableB() == null && variable.getVariableBId() != null) {
                variable2 = a2.E.m_yc(variable.getVariableBId());
                variable.setVariableB(variable2);
                return;
            }
        } else if (a instanceof AnalogAlarm && (variable = (AnalogAlarm)a).getVariable() == null) {
            Variable variable3 = a2.E.m_yc(variable.getVariableId());
            variable.setVariable(variable3);
        }
    }

    private /* synthetic */ void m_knc(T a, T a2, boolean a3) {
        c_xja a4;
        if (!a.getClass().equals(a2.getClass())) {
            throw new c_mf(c_jf.m_le((Object)"L!l?`my4}(~m~%b8a)-/hm~,`("));
        }
        T t = a2;
        a4.m_ojc(a);
        BeanUtils.copyProperties(a, t, (String[])L);
        a4.m_jkc(t);
        if (a3) {
            a4.K.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a4, a2));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_sa(Integer a) {
        c_xja a2;
        return a2.F.findByProjectId(a);
    }
}

