/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.events.AlarmGroupChangeEvent;
import com.inscada.mono.alarm.events.AlarmGroupDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.FiredAlarmFilter;
import com.inscada.mono.alarm.services.c_cha;
import com.inscada.mono.alarm.services.c_fja;
import com.inscada.mono.alarm.services.c_naa;
import com.inscada.mono.alarm.services.c_vja;
import com.inscada.mono.alarm.z.c_gia;
import com.inscada.mono.auth.c_nga;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.ClusterOperations;
import com.inscada.mono.cluster.z.c_hla;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.log.services.c_uh;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_uj;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener {
    private static final Logger C = LoggerFactory.getLogger(AlarmManager.class);
    public static final short d = 109;
    private static final String M = "activeAlarmGroups";
    public static final short a = 107;
    private final c_uh h;
    private final c_fja G;
    private final JedisPooled k;
    private final ClusterOperations J;
    private final c_naa b;
    public static final short m = 102;
    public static final short i = 101;
    public static final short g = 104;
    private final c_cha K;
    public static final short A = 106;
    public static final short F = 105;
    public static final short c = 108;
    public static final short E = 103;
    private final Lock L;

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_gia> getAlarmGroupStatuses(Integer a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.debug(SetValueRequest.m_le((Object)"%$(%,3SA.\u0004\u001d\u0015\u0000\u000f\u000eA\b\r\u0005A\b\r\b\u0013\u0004A\u000e\u0013\u0006\u0014\u0019A\u001a\u0015\b\u0015\u001c\u0012\f\u0012I\u0007\u0006\u0013I\u0011\u001b\u000e\u0003\u0004\n\u0015I\u001a\u0014A\u0005\u000e\n\u0000\u0005\r\u0010O"), (Object)a);
            return a2.getAlarmGroupStatusesByProjectIdInternal(a);
        }
        C.debug(FiredAlarmFilter.m_le((Object)"\u0006o\u0006\r\u0004e\td\rrr\u0000\u001aE9U-S<I&GhL-A,E:\u0000.O:\u0000)L$\u0000)L)R%\u0000/R'U8\u0000;T)T=S-ShF'RhP:O\"E+Th[5\u000e"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.J.callLeaderMethod(Short.valueOf((short)106), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get alarm group statuses for project " + a, (Throwable)exception);
        }
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.b.m_qj((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.debug(SetValueRequest.m_le((Object)"-, -$;[I%\f\u0000\n\u0015\u0000\u0017\b\u0015\u0000\u000f\u000eA\b\r\u0005A\b\r\b\u0013\u0004A\u000e\u0013\u0006\u0014\u0019\u0012I\u0007\u0006\u0013I\u0011\u001b\u000e\u0003\u0004\n\u0015I\u001a\u0014A\u0005\u000e\n\u0000\u0005\r\u0010O"), (Object)a);
            a2.deactivateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        C.debug(FiredAlarmFilter.m_le((Object)"\u0006o\u0006\r\u0004e\td\rrr\u0000\u001aE9U-S<I&GhL-A,E:\u0000<OhD-A+T!V)T-\u0000)L$\u0000)L)R%\u0000/R'U8ShF'RhP:O\"E+Th[5\u000e"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.callLeaderMethod(Short.valueOf((short)109), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC deactivate alarm groups for project " + a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.J.addListener((ClusterNodeListener)a);
        C.info(SetValueRequest.m_le((Object)" \u0005\u0000\u001b\f$\u0000\u0007\u0000\u000e\u0004\u001bA\u0000\u000f\u0000\u0015\u0000\u0000\u0005\b\u0013\u0004\rA\b\u000f\rA\u001b\u0004\u000e\b\u001a\u0015\f\u0013\f\u0005I\u0000\u001aA*\r\u001c\u0012\u001d\u0004\u001b/\u0006\u0005\f-\u0000\u0012\u001d\u0004\u0007\u0004\u001bO"));
    }

    protected void activateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.b.m_qj((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.deactivateAlarmGroup(alarmManager.b.m_ph(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_gia getAlarmGroupStatus(Integer a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.debug(FiredAlarmFilter.m_le((Object)"\u0004e\td\rrr\u0000\u000fE<T!N/\u0000)L)R%\u0000/R'U8\u0000;T)T=ShF'Rh[5\u0000$O+A$L1\u000e"), (Object)a);
            return a2.getAlarmGroupStatusInternal(a);
        }
        C.debug(SetValueRequest.m_le((Object)"'.'L%$(%,3SA;\u0004\u0018\u0014\f\u0012\u001d\b\u0007\u0006I\r\f\u0000\r\u0004\u001bA\u000f\u000e\u001bA\b\r\b\u0013\u0004A\u000e\u0013\u0006\u0014\u0019A\u001a\u0015\b\u0015\u001c\u0012I\u0007\u0006\u0013I\u001a\u0014O"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_gia)a2.J.callLeaderMethod(Short.valueOf((short)104), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get alarm group status for " + a, (Throwable)exception);
        }
    }

    protected Map<Integer, c_gia> getAlarmStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.G.m_qj((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Alarm::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    protected void deactivateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.b.m_xh(a));
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.activateAlarmGroup(alarmManager.b.m_ph(a, a2).getId());
    }

    protected c_gia getAlarmStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmStatusInternal(alarmManager.G.m_gic(a));
    }

    @TransactionalEventListener(value={AlarmDeleteEvent.class})
    public void handleAlarmDeleteEvent(AlarmDeleteEvent a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            Alarm alarm = a.getAlarm();
            C.info(FiredAlarmFilter.m_le((Object)"\u0004e\td\rrr\u0000\u0000A&D$I&Gha$A:M\fE$E<E\rV-N<\u0000.O:\u0000)L)R%\u0000\u0001dr\u00003]d\u0000\u000fR'U8\u0000\u0001dr\u00003]"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_vja c_vja2 = a2.K.m_enc(alarm.getGroupId());
            if (c_vja2 != null && c_vja2.m_bmc()) {
                c_vja2.m_xmc(alarm);
                return;
            }
        } else {
            C.debug(SetValueRequest.m_le((Object)"'.'L%$(%,3SA \u0006\u0007\u000e\u001b\b\u0007\u0006I \u0005\u0000\u001b\f-\u0004\u0005\u0004\u001d\u0004,\u0017\f\u000f\u001dA\u000f\u000e\u001bA\b\r\b\u0013\u0004A %SA\u0012\u001c"), (Object)a.getAlarm().getId());
        }
    }

    protected Map<Integer, c_gia> getAlarmStatusesInternal(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_gia> getAlarmStatuses(Integer a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.debug(FiredAlarmFilter.m_le((Object)"\u0004e\td\rrr\u0000\u000fE<T!N/\u0000)L$\u0000)L)R%\u0000;T)T=S-ShF'RhP:O\"E+Th[5\u0000$O+A$L1\u000e"), (Object)a);
            return a2.getAlarmStatusesByProjectIdInternal(a);
        }
        C.debug(SetValueRequest.m_le((Object)"'.'L%$(%,3SA;\u0004\u0018\u0014\f\u0012\u001d\b\u0007\u0006I\r\f\u0000\r\u0004\u001bA\u000f\u000e\u001bA\b\r\u0005A\b\r\b\u0013\u0004A\u001a\u0015\b\u0015\u001c\u0012\f\u0012I\u0007\u0006\u0013I\u0011\u001b\u000e\u0003\u0004\n\u0015I\u001a\u0014O"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.J.callLeaderMethod(Short.valueOf((short)105), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get alarm statuses for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_gia getAlarmGroupStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.b.m_sf(a, a2)) == null) {
            return c_gia.L;
        }
        return a3.getAlarmGroupStatus(a.getId());
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.info(FiredAlarmFilter.m_le((Object)"\u0004e\td\rrr\u0000\u0000A&D$I&Ghp:O\"E+T\fE)C<I>A<E\rV-N<\u0000.O:\u00008R'J-C<\u0000\u0001dr\u00003]"), (Object)a.getProject().getId());
            a2.deactivateAlarmGroupsByProjectIdInternal(a.getProject().getId());
            return;
        }
        C.debug(SetValueRequest.m_le((Object)"'.'L%$(%,3SA \u0006\u0007\u000e\u001b\b\u0007\u0006I1\u001b\u000e\u0003\u0004\n\u0015-\u0004\b\u0002\u001d\b\u001f\u0000\u001d\u0004,\u0017\f\u000f\u001dA\u000f\u000e\u001bA\u0019\u0013\u0006\u000b\f\u0002\u001dA %SA\u0012\u001c"), (Object)a.getProject().getId());
    }

    @TransactionalEventListener(value={AlarmChangeEvent.class})
    public void handleAlarmChangeEvent(AlarmChangeEvent a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            Alarm alarm = a.getAlarm();
            C.info(FiredAlarmFilter.m_le((Object)"\u0004e\td\rrr\u0000\u0000A&D$I&Gha$A:M\u000bH)N/E\rV-N<\u0000.O:\u0000)L)R%\u0000\u0001dr\u00003]d\u0000\u000fR'U8\u0000\u0001dr\u00003]"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_vja c_vja2 = a2.K.m_enc(alarm.getGroupId());
            if (c_vja2 != null && c_vja2.m_bmc()) {
                if (Boolean.TRUE.equals(alarm.getIsActive())) {
                    c_vja2.m_bic(alarm);
                    return;
                }
                c_vja2.m_xmc(alarm);
                return;
            }
        } else {
            C.debug(SetValueRequest.m_le((Object)"'.'L%$(%,3SA \u0006\u0007\u000e\u001b\b\u0007\u0006I \u0005\u0000\u001b\f*\t\b\u000f\u000e\u0004,\u0017\f\u000f\u001dA\u000f\u000e\u001bA\b\r\b\u0013\u0004A %SA\u0012\u001c"), (Object)a.getAlarm().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.debug(FiredAlarmFilter.m_le((Object)"\u0004e\td\rrr\u0000\tC<I>A<I&GhA$A:MhG:O=Ph[5\u0000$O+A$L1\u000e"), (Object)a);
            a2.activateAlarmGroupInternal(a);
            return;
        }
        C.debug(SetValueRequest.m_le((Object)"/&/D-, -$;[I3\f\u0010\u001c\u0004\u001a\u0015\u0000\u000f\u000eA\u0005\u0004\b\u0005\f\u0013I\u0015\u0006A\b\u0002\u001d\b\u001f\u0000\u001d\u0004I\u0000\u0005\u0000\u001b\fI\u0006\u001b\u000e\u001c\u0011I\u001a\u0014O"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.callLeaderMethod(Short.valueOf((short)101), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC activate alarm group " + a, (Throwable)exception);
        }
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_nga.m_jub(() -> {
            AlarmManager a2;
            a2.L.lock();
            try {
                c_vja c_vja2 = a2.K.m_enc(a.getId());
                if (c_vja2 != null) {
                    c_vja2.m_xxa();
                    a2.K.m_mnc(a.getId(), c_vja2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.k.srem(M, stringArray);
                return;
            }
            finally {
                a2.L.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    protected c_gia getAlarmGroupStatusInternal(AlarmGroup a) {
        AlarmManager a2;
        if (a == null) {
            return c_gia.L;
        }
        if ((a = a2.K.m_enc(a.getId())) != null && a.m_bmc()) {
            return c_gia.E;
        }
        return c_gia.L;
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            AlarmManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.J.addRemoteCall((short)101, (Object)a, AlarmManager.class.getDeclaredMethod(FiredAlarmFilter.m_le((Object)")C<I>A<E\tL)R%g:O=P\u0001N<E:N)L"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.J.addRemoteCall((short)102, (Object)a, AlarmManager.class.getDeclaredMethod(SetValueRequest.m_le((Object)"\r\u0004\b\u0002\u001d\b\u001f\u0000\u001d\u0004(\r\b\u0013\u0004&\u001b\u000e\u001c\u0011 \u000f\u001d\u0004\u001b\u000f\b\r"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.J.addRemoteCall((short)103, (Object)a, AlarmManager.class.getDeclaredMethod(FiredAlarmFilter.m_le((Object)"/E<a$A:M\u001bT)T=S\u0001N<E:N)L"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.J.addRemoteCall((short)104, (Object)a, AlarmManager.class.getDeclaredMethod(SetValueRequest.m_le((Object)"\u0006\f\u0015(\r\b\u0013\u0004&\u001b\u000e\u001c\u0011:\u0015\b\u0015\u001c\u0012 \u000f\u001d\u0004\u001b\u000f\b\r"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.J.addRemoteCall((short)105, (Object)a, AlarmManager.class.getDeclaredMethod(FiredAlarmFilter.m_le((Object)"G-T\tL)R%s<A<U;E;b1p:O\"E+T\u0001D\u0001N<E:N)L"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.J.addRemoteCall((short)106, (Object)a, AlarmManager.class.getDeclaredMethod(SetValueRequest.m_le((Object)"\u000e\u0004\u001d \u0005\u0000\u001b\f.\u0013\u0006\u0014\u00192\u001d\u0000\u001d\u0014\u001a\u0004\u001a#\u00101\u001b\u000e\u0003\u0004\n\u0015 \u0005 \u000f\u001d\u0004\u001b\u000f\b\r"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            a.J.addRemoteCall((short)107, (Object)a, AlarmManager.class.getDeclaredMethod(FiredAlarmFilter.m_le((Object)"/E<a$A:M\u001bT)T=S-S\u0001N<E:N)L"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.J.addRemoteCall((short)108, (Object)a, AlarmManager.class.getDeclaredMethod(SetValueRequest.m_le((Object)"\b\u0002\u001d\b\u001f\u0000\u001d\u0004(\r\b\u0013\u0004&\u001b\u000e\u001c\u0011\u001a#\u00101\u001b\u000e\u0003\u0004\n\u0015 \u0005 \u000f\u001d\u0004\u001b\u000f\b\r"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer.class;
            a.J.addRemoteCall((short)109, (Object)a, AlarmManager.class.getDeclaredMethod(FiredAlarmFilter.m_le((Object)",E)C<I>A<E\tL)R%g:O=P;b1p:O\"E+T\u0001D\u0001N<E:N)L"), classArray9));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(SetValueRequest.m_le((Object)"'\b\b\u0005\u0004\rA\u001d\u000eI\u0013\f\u0006\u0000\u0012\u001d\u0004\u001bA(\r\b\u0013\u0004,\b\u000f\b\u0006\f\u0013I39\"I\f\f\u0015\u0001\u000e\r\u0012"), noSuchMethodException);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_gia getAlarmStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.G.m_sf(a, a2)) == null) {
            return c_gia.L;
        }
        return a3.getAlarmStatus(a.getId());
    }

    @TransactionalEventListener(value={AlarmGroupChangeEvent.class})
    public void handleAlarmGroupChangeEvent(AlarmGroupChangeEvent a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.info(FiredAlarmFilter.m_le((Object)"l\ra\fe\u001a\u001ahh)N,L!N/\u0000\tL)R%g:O=P\u000bH)N/E\rV-N<\u0000.O:\u0000/R'U8\u0000\u0001dr\u00003]"), (Object)a.getAlarmGroup().getId());
            a2.L.lock();
            try {
                Integer n = a.getAlarmGroup().getId();
                if (a2.getAlarmGroupStatusInternal(n) == c_gia.E) {
                    AlarmManager alarmManager = a2;
                    alarmManager.deactivateAlarmGroupInternal(n);
                    alarmManager.activateAlarmGroupInternal(n);
                }
                return;
            }
            finally {
                a2.L.unlock();
            }
        }
        C.debug(SetValueRequest.m_le((Object)"/&/D-, -$;[I(\u000e\u000f\u0006\u0013\u0000\u000f\u000eA(\r\b\u0013\u0004&\u001b\u000e\u001c\u0011*\t\b\u000f\u000e\u0004,\u0017\f\u000f\u001dA\u000f\u000e\u001bA\u000e\u0013\u0006\u0014\u0019A %SA\u0012\u001c"), (Object)a.getAlarmGroup().getId());
    }

    protected Map<Integer, c_gia> getAlarmGroupStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.b.m_qj((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroup::getId, arg_0 -> a2.getAlarmGroupStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_gia> getAlarmStatuses(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.J.isLeader()) {
            C.debug(FiredAlarmFilter.m_le((Object)"l\ra\fe\u001a\u001ahg-T<I&GhA$A:MhS<A<U;E;\u0000.O:\u00003]hi\fShL'C)L$Yr\u00003]"), (Object)a.size(), a);
            return a2.getAlarmStatusesInternal(a);
        }
        C.debug(SetValueRequest.m_le((Object)"/&/D-, -$;[I3\f\u0010\u001c\u0004\u001a\u0015\u0000\u000f\u000eA\u0005\u0004\b\u0005\f\u0013I\u0007\u0006\u0013I\u0000\u0005\u0000\u001b\fI\u0012\u001d\u0000\u001d\u0014\u001a\u0004\u001aA\u000f\u000e\u001bA\u0012\u001cI(-\u0012SA\u0012\u001c"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.J.callLeaderMethod(Short.valueOf((short)107), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get alarm statuses for IDs " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.debug(FiredAlarmFilter.m_le((Object)"l\ra\fe\u001a\u001aha+T!V)T!N/\u0000)L$\u0000)L)R%\u0000/R'U8ShF'RhP:O\"E+Th[5\u0000$O+A$L1\u000e"), (Object)a);
            a2.activateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        C.debug(SetValueRequest.m_le((Object)"'.'L%$(%,3SA;\u0004\u0018\u0014\f\u0012\u001d\b\u0007\u0006I\r\f\u0000\r\u0004\u001bA\u001d\u000eI\u0000\n\u0015\u0000\u0017\b\u0015\fA\b\r\u0005A\b\r\b\u0013\u0004A\u000e\u0013\u0006\u0014\u0019\u0012I\u0007\u0006\u0013I\u0011\u001b\u000e\u0003\u0004\n\u0015I\u001a\u0014O"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.callLeaderMethod(Short.valueOf((short)108), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC activate alarm groups for project " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmGroupDeleteEvent.class})
    public void handleAlarmGroupDeleteEvent(AlarmGroupDeleteEvent a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.info(FiredAlarmFilter.m_le((Object)"l\ra\fe\u001a\u001ahh)N,L!N/\u0000\tL)R%g:O=P\fE$E<E\rV-N<\u0000.O:\u0000/R'U8\u0000\u0001dr\u00003]"), (Object)a.getAlarmGroup().getId());
            a2.deactivateAlarmGroupInternal(a.getAlarmGroup().getId());
            return;
        }
        C.debug(SetValueRequest.m_le((Object)"/&/D-, -$;[I(\u000e\u000f\u0006\u0013\u0000\u000f\u000eA(\r\b\u0013\u0004&\u001b\u000e\u001c\u0011-\u0004\u0005\u0004\u001d\u0004,\u0017\f\u000f\u001dA\u000f\u000e\u001bA\u000e\u0013\u0006\u0014\u0019A %SA\u0012\u001c"), (Object)a.getAlarmGroup().getId());
    }

    @TransactionalEventListener(value={AlarmAddEvent.class})
    public void handleAlarmAddEvent(AlarmAddEvent a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            c_vja c_vja2;
            Alarm alarm = a.getAlarm();
            C.info(FiredAlarmFilter.m_le((Object)"l\ra\fe\u001a\u001ahh)N,L!N/\u0000\tL)R%a,D\rV-N<\u0000.O:\u0000)L)R%\u0000\u0001dr\u00003]d\u0000\u000fR'U8\u0000\u0001dr\u00003]"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            if (Boolean.TRUE.equals(alarm.getIsActive()) && (c_vja2 = a2.K.m_enc(alarm.getGroupId())) != null && c_vja2.m_bmc()) {
                c_vja2.m_bic(alarm);
                return;
            }
        } else {
            C.debug(SetValueRequest.m_le((Object)"/&/D-, -$;[I(\u000e\u000f\u0006\u0013\u0000\u000f\u000eA(\r\b\u0013\u0004 \r\u0005,\u0017\f\u000f\u001dA\u000f\u000e\u001bA\b\r\b\u0013\u0004A %SA\u0012\u001c"), (Object)a.getAlarm().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_gia getAlarmStatus(Integer a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.debug(FiredAlarmFilter.m_le((Object)"\u0004e\td\rrr\u0000\u000fE<T!N/\u0000)L)R%\u0000;T)T=ShF'Rh[5\u0000$O+A$L1\u000e"), (Object)a);
            return a2.getAlarmStatusInternal(a);
        }
        C.debug(SetValueRequest.m_le((Object)"'.'L%$(%,3SA;\u0004\u0018\u0014\f\u0012\u001d\b\u0007\u0006I\r\f\u0000\r\u0004\u001bA\u000f\u000e\u001bA\b\r\b\u0013\u0004A\u001a\u0015\b\u0015\u001c\u0012I\u0007\u0006\u0013I\u001a\u0014O"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_gia)a2.J.callLeaderMethod(Short.valueOf((short)103), objectArray);
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC get alarm status for " + a, (Throwable)exception);
        }
    }

    protected c_gia getAlarmGroupStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmGroupStatusInternal(alarmManager.b.m_gic(a));
    }

    public AlarmManager(c_fja a, c_naa a2, c_cha a3, c_uh a4, JedisPooled a5, ClusterOperations a6) {
        AlarmManager a7;
        AlarmManager alarmManager = a7;
        AlarmManager alarmManager2 = a7;
        AlarmManager alarmManager3 = a7;
        AlarmManager alarmManager4 = a7;
        alarmManager4.L = new ReentrantLock();
        alarmManager3.G = a;
        alarmManager3.b = a2;
        alarmManager2.K = a3;
        alarmManager2.h = a4;
        alarmManager.k = a5;
        alarmManager.J = a6;
    }

    protected c_gia getAlarmStatusInternal(Alarm a) {
        AlarmManager a2;
        if (a == null) {
            return c_gia.L;
        }
        c_vja c_vja2 = a2.K.m_enc(a.getGroup().getId());
        if (c_vja2 != null && c_vja2.m_bmc() && c_vja2.m_gmc(a.getId())) {
            return c_gia.E;
        }
        return c_gia.L;
    }

    public void notLeader() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        String string = alarmManager.J.getCurrentNode().getNodeId();
        C.info(FiredAlarmFilter.m_le((Object)"\tL)R%m)N)G-Rr\u0000\u001cH!ShN'D-\u0000`[5\thI;\u0000\u0006ohl\u0007n\u000fe\u001a\u0000\u001ch\r\u0000\u0004e\td\rrf\u0000\u001bT'P8I&GhA$LhL'C)LhA$A:MhI&S8E+T'R;\u000ef\u000e"), (Object)string);
        alarmManager.L.lock();
        try {
            a.K.m_uqc();
            C.info(SetValueRequest.m_le((Object)" \u0005\u0000\u001b\f$\u0000\u0007\u0000\u000e\u0004\u001bAA/\u0006\u0015I-\f\u0000\r\u0004\u001bA\u0012\u001c@[I \u0005\rI\r\u0006\u0002\b\rI\u0000\u0005\u0000\u001b\fI\b\u0007\u0012\u0019\u0004\n\u0015\u0000\u000e\u0007A\u001d\u0000\u001a\n\u001aA\u0001\u0000\u001f\u0004I\u0003\f\u0004\u0007A\u001b\u0004\u0018\u0014\f\u0012\u001d\u0004\rA\u001d\u000eI\u0012\u001d\u000e\u0019O"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            C.error(FiredAlarmFilter.m_le((Object)"a$A:M\u0005A&A/E:\u0000`n'Thl-A,E:\u00003]a\u001ahe:R'RhD=R!N/\u00008R'C-S;\u0000'FhS<O8P!N/\u0000$O+A$\u0000)L)R%\u0000!N;P-C<O:Sr\u00003]"), objectArray);
            return;
        }
        finally {
            a.L.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.J.isLeader()) {
            C.debug(SetValueRequest.m_le((Object)"%$(%,3SA-\u0004\b\u0002\u001d\b\u001f\u0000\u001d\b\u0007\u0006I\u0000\u0005\u0000\u001b\fI\u0006\u001b\u000e\u001c\u0011I\u001a\u0014A\u0005\u000e\n\u0000\u0005\r\u0010O"), (Object)a);
            a2.deactivateAlarmGroupInternal(a);
            return;
        }
        C.debug(FiredAlarmFilter.m_le((Object)"n\u0007nel\ra\fe\u001a\u001ahr-Q=E;T!N/\u0000$E)D-RhT'\u0000,E)C<I>A<EhA$A:MhG:O=Ph[5\u000e"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.J.callLeaderMethod(Short.valueOf((short)102), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_hla("Failed to RPC deactivate alarm group " + a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_nga.m_jub(() -> {
            AlarmManager a2;
            a2.L.lock();
            try {
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_uj("Project should be active to start alarm group " + a.getName());
                }
                c_vja c_vja2 = a2.K.m_jlc(a);
                c_vja2.m_zeb();
                if (c_vja2.m_bmc()) {
                    String[] stringArray = new String[1];
                    stringArray[0] = a.getId().toString();
                    a2.k.sadd(M, stringArray);
                }
                return;
            }
            finally {
                a2.L.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    protected void activateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.activateAlarmGroupInternal(alarmManager.b.m_xh(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        String string = alarmManager.J.getCurrentNode().getNodeId();
        C.info(SetValueRequest.m_le((Object)"(\r\b\u0013\u0004,\b\u000f\b\u0006\f\u0013SA=\t\u0000\u0012I\u000f\u0006\u0005\fAA\u001a\u0014HI\t\b\u0012I\u0003\f\u0002\u0006\f\fA\u001d\t\fA%$(%,3GA;\u0004\u001a\u0015\u0006\u0013\u0000\u000f\u000eA\b\u0002\u001d\b\u001f\u0004I\u0000\u0005\u0000\u001b\f\u001aOGO"), (Object)string);
        alarmManager.L.lock();
        try {
            Set set = a2.k.smembers(M).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                C.info(FiredAlarmFilter.m_le((Object)"a$A:M\u0005A&A/E:\u0000`l-A,E:\u00003]a\u001ahn'\u0000)C<I>EhA$A:MhG:O=P;\u0000.O=N,\u0000!Nhr-D!ShT'\u0000:E;T'R-\u000e"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            C.info(SetValueRequest.m_le((Object)" \u0005\u0000\u001b\f$\u0000\u0007\u0000\u000e\u0004\u001bAA-\f\u0000\r\u0004\u001bA\u0012\u001c@[I'\u0006\u0014\u0007\u0005I\u001a\u0014A\b\u0002\u001d\b\u001f\u0004I\u0000\u0005\u0000\u001b\fI\u0006\u001b\u000e\u001c\u0011I(-\u0012I\b\u0007A;\u0004\r\b\u001aA\u001d\u000eI\u0013\f\u0012\u001d\u000e\u001b\u0004SA\u0012\u001c"), objectArray);
            ArrayList arrayList = new ArrayList(a2.b.m_fkc(set));
            C.info(FiredAlarmFilter.m_le((Object)"\tL)R%m)N)G-Rh\b\u0004E)D-Rh[5\tr\u0000\tT<E%P<I&GhT'\u0000:E;T'R-\u00003]hA$A:MhG:O=P;\u000e"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                AlarmManager a2;
                String string = a2.J.getCurrentNode().getNodeId();
                try {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = string;
                    objectArray[1] = a.getName();
                    objectArray[2] = a.getId();
                    C.info(FiredAlarmFilter.m_le((Object)"\tL)R%m)N)G-Rh\b\u0004E)D-Rh[5\tr\u0000\u001aE;T'R!N/\u0000)L)R%\u0000/R'U8\u001ah[5\u0000`i\f\u001ah[5\t"), objectArray);
                    a2.activateAlarmGroupInternal(a);
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a.getName();
                    objectArray[1] = a.getId();
                    objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
                    a2.h.m_pga(a.getProject()).m_g("Alarm Group Restore (Leader " + string + ")", String.format(SetValueRequest.m_le((Object)"L\u0012II %SAL\u0005@A\u000f\u0000\u0000\r\f\u0005I\u0015\u0006A\u001b\u0004\u001a\u0015\u0006\u0013\fOI\"\b\u0014\u001a\u0004SAL\u0012"), objectArray));
                    try {
                        C.warn(FiredAlarmFilter.m_le((Object)"\tL)R%m)N)G-Rh\b\u0004E)D-Rh[5\tr\u0000\tT<E%P<I&GhT'\u0000,E)C<I>A<EhA$A:MhG:O=Ph[5\u0000)F<E:\u0000:E;T'R)T!O&\u0000.A!L=R-\u000e"), (Object)string, (Object)a.getId());
                        a2.deactivateAlarmGroupInternal(a);
                        return;
                    }
                    catch (Exception exception2) {
                        Object[] objectArray2 = new Object[4];
                        objectArray2[0] = string;
                        objectArray2[1] = a.getId();
                        objectArray2[2] = exception2.getMessage();
                        objectArray2[3] = exception2;
                        C.error(SetValueRequest.m_le((Object)" \u0005\u0000\u001b\f$\u0000\u0007\u0000\u000e\u0004\u001bAA-\f\u0000\r\u0004\u001bA\u0012\u001c@[I'\b\b\u0005\u0004\rA\u001d\u000eI\u0005\f\u0000\n\u0015\u0000\u0017\b\u0015\fA\b\r\b\u0013\u0004A\u000e\u0013\u0006\u0014\u0019A\u0012\u001cI\u0000\u000f\u0015\f\u0013I\u0013\f\u0012\u001d\u000e\u001b\u0000\u001d\b\u0006\u000fI\u0007\b\b\u0005\u0014\u001b\u0004SA\u0012\u001c"), objectArray2);
                        return;
                    }
                }
            });
            C.info(SetValueRequest.m_le((Object)" \u0005\u0000\u001b\f$\u0000\u0007\u0000\u000e\u0004\u001bAA-\f\u0000\r\u0004\u001bA\u0012\u001c@[I'\u0000\u000f\u0000\u0012\u0001\u0004\rA\b\r\b\u0013\u0004A\u001b\u0004\u001a\u0015\u0006\u0013\b\u0015\u0000\u000e\u0007A\u0019\u0013\u0006\u0002\f\u0012\u001aO"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            C.error(FiredAlarmFilter.m_le((Object)"\tL)R%m)N)G-Rh\b\u0004E)D-Rh[5\tr\u0000\rR:O:\u0000,U:I&GhA$A:MhR-S<O:A<I'NhP:O+E;Sr\u00003]"), objectArray);
            return;
        }
        finally {
            a2.L.unlock();
        }
    }
}

