/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.restcontrollers;

import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.services.AlarmManager;
import com.inscada.mono.alarm.services.c_naa;
import com.inscada.mono.alarm.z.c_gia;
import com.inscada.mono.impexp.b.c_gh;
import com.inscada.mono.impexp.c.c_vg;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.project.z.c_ji;
import com.inscada.mono.space.c_zc;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/alarms/groups"})
public class AlarmGroupController
extends ProjectBasedImportExportController {
    private final AlarmManager E;
    private final c_naa L;

    @GetMapping(value={"/status"}, params={"projectId", "name"})
    public c_gia getAlarmGroupStatus(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.E.getAlarmGroupStatus(projectId, a);
    }

    @GetMapping(value={"/{groupId}"})
    public AlarmGroup getAlarmGroup(@PathVariable(value="groupId") Integer a) {
        return this.L.m_ba(a);
    }

    @PostMapping(value={"/{groupId}/deactivate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.E.deactivateAlarmGroup(a);
    }

    @GetMapping(value={"/status"}, params={"projectId"})
    public Map<Integer, c_gia> getAlarmGroupStatuses(@RequestParam(value="projectId") Integer a) {
        return this.E.getAlarmGroupStatuses(a);
    }

    @PostMapping(value={"/deactivate"}, params={"projectId", "name"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroup(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        this.E.deactivateAlarmGroup(projectId, a);
    }

    @PostMapping
    public ResponseEntity<AlarmGroup> createAlarmGroup(@Valid @RequestBody AlarmGroup alarmGroup, UriComponentsBuilder a) {
        alarmGroup = this.L.m_ekc(alarmGroup);
        Object[] objectArray = new Object[1];
        objectArray[0] = alarmGroup.getId();
        return ResponseEntity.created((URI)a.path(c_zc.m_le((Object)"\r\u0017E\u001eM\u0019R%F\u0011")).buildAndExpand(objectArray).toUri()).body((Object)alarmGroup);
    }

    @PostMapping(value={"/activate"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroups(@RequestParam(value="projectId") Integer a) {
        this.E.activateAlarmGroups(a);
    }

    @DeleteMapping(value={"/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.L.m_ga(a);
    }

    @PostMapping(value={"/activate"}, params={"projectId", "name"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroup(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        this.E.activateAlarmGroup(projectId, a);
    }

    @PutMapping(value={"/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAlarmGroup(@PathVariable(value="groupId") Integer groupId, @Valid @RequestBody AlarmGroup a) {
        this.L.m_ckc(groupId, a);
    }

    @GetMapping(value={"/{alarmGroupId}/status"})
    public c_gia getAlarmGroupStatus(@PathVariable(value="alarmGroupId") Integer a) {
        return this.E.getAlarmGroupStatus(a);
    }

    @PostMapping(value={"/deactivate"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroups(@RequestParam(value="projectId") Integer a) {
        this.E.deactivateAlarmGroups(a);
    }

    public AlarmGroupController(c_naa a, AlarmManager a2, c_gh a3, c_ji a4) {
        AlarmGroupController a5;
        AlarmGroupController alarmGroupController = a5;
        super(a3, EnumSet.of(c_vg.M), a4);
        alarmGroupController.L = a;
        alarmGroupController.E = a2;
    }

    @DeleteMapping(value={"/multi"}, params={"groupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmGroupsByIds(@RequestParam(value="groupIds") Integer[] a) {
        this.L.m_wpc(List.of(a));
    }

    @PostMapping(value={"/{groupId}/activate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.E.activateAlarmGroup(a);
    }

    @GetMapping
    public Collection<AlarmGroup> getAlarmGroups(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.L.m_la();
        }
        return this.L.m_sa(a);
    }
}

